/*
 * Decompiled with CFR 0.152.
 */
package com.bigdata.rdf.sparql.ast;

import com.bigdata.bop.BOp;
import com.bigdata.bop.IBindingSet;
import com.bigdata.bop.IVariable;
import com.bigdata.rdf.sparql.ast.ASTBase;
import com.bigdata.rdf.sparql.ast.FilterNode;
import com.bigdata.rdf.sparql.ast.GroupMemberNodeBase;
import com.bigdata.rdf.sparql.ast.IBindingProducerNode;
import com.bigdata.rdf.sparql.ast.IJoinNode;
import com.bigdata.rdf.sparql.ast.IReorderableNode;
import com.bigdata.rdf.sparql.ast.StaticAnalysis;
import com.bigdata.rdf.sparql.ast.optimizers.StaticOptimizer;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class BindingsClause
extends GroupMemberNodeBase<BindingsClause>
implements IBindingProducerNode,
IJoinNode,
IReorderableNode {
    private static final long serialVersionUID = 1L;

    public BindingsClause(BindingsClause bindings) {
        super(bindings);
    }

    public BindingsClause(BOp[] args, Map<String, Object> anns) {
        super(args, anns);
    }

    public BindingsClause(LinkedHashSet<IVariable<?>> declaredVars, List<IBindingSet> bindingSets) {
        super(NOARGS, new HashMap<String, Object>(2));
        if (declaredVars == null) {
            throw new IllegalArgumentException();
        }
        if (bindingSets == null) {
            throw new IllegalArgumentException();
        }
        this.setDeclaredVariables(declaredVars);
        this.setBindingSets(bindingSets);
    }

    public final int getDeclaredVariableCount() {
        return this.getDeclaredVariables().size();
    }

    public final LinkedHashSet<IVariable<?>> getDeclaredVariables() {
        return (LinkedHashSet)this.getProperty("declaredVars");
    }

    public final void setDeclaredVariables(LinkedHashSet<IVariable<?>> declaredVars) {
        this.setProperty("declaredVars", declaredVars);
    }

    public final LinkedHashSet<IVariable<?>> getDefinitelyProducedBindings() {
        return (LinkedHashSet)this.getProperty("definitelyProducedVars");
    }

    public final int getBindingSetsCount() {
        List<IBindingSet> bindingSets = this.getBindingSets();
        if (bindingSets == null) {
            return 0;
        }
        return bindingSets.size();
    }

    public final List<IBindingSet> getBindingSets() {
        return (List)this.getProperty("bindingSets");
    }

    public final void setBindingSets(List<IBindingSet> bindingSets) {
        this.setProperty("bindingSets", bindingSets);
        LinkedHashSet definitelyProducedVars = new LinkedHashSet();
        if (!bindingSets.isEmpty()) {
            definitelyProducedVars.addAll(this.getDeclaredVariables());
            for (IBindingSet bs : bindingSets) {
                if (definitelyProducedVars.isEmpty()) break;
                Iterator it = definitelyProducedVars.iterator();
                while (it.hasNext()) {
                    IVariable var = (IVariable)it.next();
                    if (bs.isBound(var)) continue;
                    it.remove();
                }
            }
        }
        this.setProperty("definitelyProducedVars", definitelyProducedVars);
    }

    @Override
    public String toString(int indent) {
        LinkedHashSet<IVariable<?>> declaredVars = this.getDeclaredVariables();
        List<IBindingSet> bindingSets = this.getBindingSets();
        String s = BindingsClause.indent(indent);
        String s1 = BindingsClause.indent(indent + 1);
        StringBuilder sb = new StringBuilder();
        sb.append("\n");
        sb.append(s);
        sb.append("BindingsClause");
        for (IVariable iVariable : declaredVars) {
            sb.append(" ?");
            sb.append(iVariable.getName());
        }
        sb.append("\n");
        sb.append(s);
        sb.append("{");
        if (bindingSets.size() <= 10) {
            for (IBindingSet iBindingSet : bindingSets) {
                sb.append("\n");
                sb.append(s1);
                sb.append(iBindingSet.toString());
            }
        } else {
            sb.append("\n");
            sb.append(s1);
            sb.append("[ count=" + bindingSets.size() + " ]");
        }
        sb.append("\n");
        sb.append(s);
        sb.append("}");
        return sb.toString();
    }

    @Override
    public final List<FilterNode> getAttachedJoinFilters() {
        List filters = (List)this.getProperty("filters");
        if (filters == null) {
            return Collections.emptyList();
        }
        return Collections.unmodifiableList(filters);
    }

    @Override
    public final void setAttachedJoinFilters(List<FilterNode> filters) {
        this.setProperty("filters", filters);
    }

    @Override
    public boolean isOptional() {
        return false;
    }

    @Override
    public boolean isMinus() {
        return false;
    }

    @Override
    public Set<IVariable<?>> getRequiredBound(StaticAnalysis sa) {
        return new HashSet();
    }

    @Override
    public Set<IVariable<?>> getDesiredBound(StaticAnalysis sa) {
        return new HashSet();
    }

    @Override
    public boolean isReorderable() {
        return true;
    }

    @Override
    public long getEstimatedCardinality(StaticOptimizer opt) {
        return this.getBindingSetsCount();
    }

    public static interface Annotations
    extends ASTBase.Annotations,
    IJoinNode.Annotations {
        public static final String DECLARED_VARS = "declaredVars";
        public static final String DEFINITELY_PRODUCED_VARS = "definitelyProducedVars";
        public static final String BINDING_SETS = "bindingSets";
    }
}

