/*
 * Decompiled with CFR 0.152.
 */
package com.bigdata.rdf.sparql.ast;

import cern.colt.Arrays;
import com.bigdata.bop.IValueExpression;
import com.bigdata.bop.IVariable;
import com.bigdata.rdf.internal.IV;
import com.bigdata.rdf.internal.constraints.INeedsMaterialization;
import com.bigdata.rdf.sparql.ast.StaticAnalysis;
import java.io.Serializable;
import java.util.LinkedHashSet;
import java.util.Set;

public class ComputedMaterializationRequirement
implements INeedsMaterialization,
Serializable {
    private static final long serialVersionUID = 1L;
    private final INeedsMaterialization.Requirement requirement;
    private final Set<IVariable<IV>> varsToMaterialize;

    public String toString() {
        return "{requirement=" + (Object)((Object)this.requirement) + ", vars=" + Arrays.toString(this.varsToMaterialize.toArray()) + "}";
    }

    public ComputedMaterializationRequirement(INeedsMaterialization.Requirement requirement, Set<IVariable<IV>> varsToMaterialize) {
        this.requirement = requirement;
        this.varsToMaterialize = varsToMaterialize;
    }

    public ComputedMaterializationRequirement(IValueExpression<?> ve) {
        this.varsToMaterialize = new LinkedHashSet<IVariable<IV>>();
        this.requirement = StaticAnalysis.gatherVarsToMaterialize(ve, this.varsToMaterialize);
    }

    @Override
    public INeedsMaterialization.Requirement getRequirement() {
        return this.requirement;
    }

    public Set<IVariable<IV>> getVarsToMaterialize() {
        return this.varsToMaterialize;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ComputedMaterializationRequirement)) {
            return false;
        }
        ComputedMaterializationRequirement t = (ComputedMaterializationRequirement)o;
        if (this.requirement != t.requirement) {
            return false;
        }
        return this.varsToMaterialize.equals(t.varsToMaterialize);
    }
}

