/*
 * Decompiled with CFR 0.152.
 */
package com.bigdata.rdf.sparql.ast;

import com.bigdata.bop.IVariable;
import com.bigdata.rdf.sparql.ast.FilterNode;
import com.bigdata.rdf.sparql.ast.GraphPatternGroup;
import com.bigdata.rdf.sparql.ast.IGroupMemberNode;
import com.bigdata.rdf.sparql.ast.IJoinNode;
import com.bigdata.rdf.sparql.ast.StaticAnalysis;
import com.bigdata.rdf.sparql.ast.optimizers.ASTHashJoinOptimizer;
import java.util.Arrays;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.Set;
import org.apache.log4j.Logger;

public class JoinSetUtil {
    private static final Logger log = Logger.getLogger(ASTHashJoinOptimizer.class);
    public final GraphPatternGroup<IGroupMemberNode> group;
    public final Set<IVariable<?>> knownBound;
    public final Set<IVariable<?>> eventuallyBoundVars;
    public final IJoinNode[] requiredJoins;
    public final int requiredJoinCount;
    public final Set<FilterNode> preFilters;
    public final Set<FilterNode> joinFilters;
    public final Set<FilterNode> postFilters;
    public final Set<IVariable<?>>[] vars;
    public final int[][] canJoin;
    public final int[] directJoinCount;
    public final Set<VertexJoinSet> directJoinSets;

    public JoinSetUtil(StaticAnalysis sa, Set<IVariable<?>> knownBound, GraphPatternGroup<IGroupMemberNode> group) {
        this.group = group;
        if (knownBound == null) {
            knownBound = new LinkedHashSet();
        }
        this.knownBound = knownBound;
        LinkedList<IJoinNode> list = new LinkedList<IJoinNode>();
        for (IGroupMemberNode m : group) {
            IJoinNode j;
            if (!(m instanceof IJoinNode) || (j = (IJoinNode)((Object)m)).isOptional()) continue;
            list.add(j);
        }
        this.requiredJoinCount = list.size();
        this.requiredJoins = list.toArray(new IJoinNode[this.requiredJoinCount]);
        this.eventuallyBoundVars = new LinkedHashSet();
        this.vars = new Set[this.requiredJoinCount];
        for (int i = 0; i < this.requiredJoinCount; ++i) {
            IJoinNode j = this.requiredJoins[i];
            Set<IVariable<?>> tmp = sa.getSpannedVariables(j, new LinkedHashSet());
            tmp.addAll(knownBound);
            this.vars[i] = tmp;
            this.eventuallyBoundVars.addAll(this.vars[i]);
        }
        this.preFilters = new LinkedHashSet<FilterNode>();
        this.joinFilters = new LinkedHashSet<FilterNode>();
        this.postFilters = new LinkedHashSet<FilterNode>();
        for (IGroupMemberNode m : group) {
            if (!(m instanceof FilterNode)) continue;
            FilterNode f = (FilterNode)m;
            if (sa.isFullyBound(f, knownBound)) {
                this.preFilters.add(f);
                continue;
            }
            if (sa.isFullyBound(f, this.eventuallyBoundVars)) {
                this.joinFilters.add(f);
                continue;
            }
            this.postFilters.add(f);
        }
        this.canJoin = new int[this.requiredJoinCount][this.requiredJoinCount];
        this.directJoinCount = new int[this.requiredJoinCount];
        for (int i = 0; i < this.requiredJoinCount; ++i) {
            for (int j = i + 1; j < this.requiredJoinCount; ++j) {
                HashSet sharedVars = new HashSet();
                sharedVars.addAll(this.vars[i]);
                sharedVars.retainAll(this.vars[j]);
                this.canJoin[i][j] = sharedVars.size();
                if (this.canJoin[i][j] <= 0) continue;
                int n = i;
                this.directJoinCount[n] = this.directJoinCount[n] + 1;
                int n2 = j;
                this.directJoinCount[n2] = this.directJoinCount[n2] + 1;
            }
        }
        if (log.isDebugEnabled()) {
            log.debug("\ncanJoin:\n" + JoinSetUtil.toString(this.canJoin));
            log.debug("\ndirectJoinCount:\n" + Arrays.toString(this.directJoinCount));
        }
        this.directJoinSets = this.calcDirectJoinSets();
    }

    private Set<VertexJoinSet> calcDirectJoinSets() {
        LinkedHashSet<VertexJoinSet> joinSets = new LinkedHashSet<VertexJoinSet>();
        LinkedHashSet<Integer> used = new LinkedHashSet<Integer>();
        for (int i = 0; i < this.requiredJoinCount; ++i) {
            if (used.contains(i)) continue;
            VertexJoinSet joinSet = new VertexJoinSet();
            joinSet.vertices.add(i);
            used.add(i);
            joinSet.joinvars.addAll(this.vars[i]);
            this.expandJoinSet(i, joinSet.vertices, used, joinSet.joinvars);
            joinSets.add(joinSet);
            if (!log.isInfoEnabled()) continue;
            log.info("joinSet: " + joinSet.vertices + " on " + joinSet.joinvars);
        }
        assert (used.size() == this.requiredJoinCount) : "used=" + used + ", but requiredJoinCount=" + this.requiredJoinCount;
        return joinSets;
    }

    private void expandJoinSet(int i, Set<Integer> joinSet, Set<Integer> used, Set<IVariable<?>> joinvars) {
        for (int j = 0; j < this.requiredJoinCount; ++j) {
            if (i == j || used.contains(j) || (i >= j || this.canJoin[i][j] <= 0) && (i <= j || this.canJoin[j][i] <= 0)) continue;
            joinSet.add(j);
            used.add(j);
            joinvars.addAll(this.vars[j]);
            this.expandJoinSet(j, joinSet, used, joinvars);
        }
    }

    private static String toString(int[][] data) {
        StringBuilder sb = new StringBuilder();
        int n = data.length;
        for (int i = 0; i < n; ++i) {
            for (int j = 0; j < n; ++j) {
                if (j <= i) {
                    sb.append("-");
                } else {
                    sb.append(data[i][j]);
                }
                sb.append(" ");
            }
            sb.append("\n");
        }
        return sb.toString();
    }

    public static class VertexJoinSet {
        public final Set<Integer> vertices;
        public final Set<IVariable<?>> joinvars;

        public VertexJoinSet() {
            this.vertices = new LinkedHashSet<Integer>();
            this.joinvars = new LinkedHashSet();
        }

        public VertexJoinSet(Set<Integer> vertices, Set<IVariable<?>> joinvars) {
            this.vertices = vertices;
            this.joinvars = joinvars;
        }

        public String toString() {
            return this.getClass().getSimpleName() + "{vertices=" + this.vertices + ",joinvars=" + this.joinvars + "}";
        }

        public int hashCode() {
            return this.vertices.hashCode();
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof VertexJoinSet)) {
                return false;
            }
            VertexJoinSet t = (VertexJoinSet)o;
            if (!this.vertices.equals(t.vertices)) {
                return false;
            }
            return this.joinvars.equals(t.joinvars);
        }
    }
}

