/*
 * Decompiled with CFR 0.152.
 */
package com.bigdata.rdf.sparql.ast;

import com.bigdata.bop.IVariable;
import com.bigdata.rdf.sparql.ast.FilterNode;
import com.bigdata.rdf.sparql.ast.IBindingProducerNode;
import com.bigdata.rdf.sparql.ast.IJoinNode;
import com.bigdata.rdf.sparql.ast.QueryRoot;
import com.bigdata.rdf.sparql.ast.StaticAnalysis;
import com.bigdata.rdf.sparql.ast.StaticAnalysisBase;
import com.bigdata.rdf.sparql.ast.eval.IEvaluationContext;
import java.util.Arrays;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.Set;
import org.apache.log4j.Logger;

public abstract class StaticAnalysis_CanJoin
extends StaticAnalysisBase {
    private static final Logger log = Logger.getLogger(StaticAnalysis.class);

    public StaticAnalysis_CanJoin(QueryRoot queryRoot, IEvaluationContext evaluationContext) {
        super(queryRoot, evaluationContext);
    }

    public boolean canJoin(IJoinNode p1, IJoinNode p2) {
        boolean canJoin;
        if (p1 == null) {
            throw new IllegalArgumentException();
        }
        if (p2 == null) {
            throw new IllegalArgumentException();
        }
        Set<IVariable<IVariable<?>>> set1 = this.getSpannedVariables(p1, false, new LinkedHashSet());
        Set<IVariable<?>> set2 = this.getSpannedVariables(p2, false, new LinkedHashSet());
        set1.retainAll(set2);
        boolean nothingShared = set1.isEmpty();
        boolean bl = canJoin = !nothingShared;
        if (log.isDebugEnabled()) {
            if (!nothingShared) {
                log.debug("No directly shared variables: p1=" + p1 + ", p2=" + p2);
            } else {
                log.debug("Can join: sharedVars=" + set1);
            }
        }
        return canJoin;
    }

    public boolean canJoinUsingConstraints(IJoinNode[] path, IJoinNode vertex, FilterNode[] constraints) {
        FilterNode[] vertexConstraints;
        if (path == null) {
            throw new IllegalArgumentException();
        }
        if (vertex == null) {
            throw new IllegalArgumentException();
        }
        if (path.length == 0) {
            throw new IllegalArgumentException();
        }
        for (IJoinNode p : path) {
            if (p == null) {
                throw new IllegalArgumentException();
            }
            if (vertex != p) continue;
            throw new IllegalArgumentException();
        }
        LinkedHashSet knownBound = new LinkedHashSet();
        for (IJoinNode p : path) {
            this.getSpannedVariables(p, false, knownBound);
        }
        Set<IVariable<IVariable<?>>> vset = this.getSpannedVariables(vertex, new LinkedHashSet());
        vset.retainAll(knownBound);
        if (!vset.isEmpty()) {
            if (log.isDebugEnabled()) {
                log.debug("Can join: sharedVars=" + vset + ", path=" + Arrays.toString(path) + ", vertex=" + vertex);
            }
            return true;
        }
        if (constraints == null) {
            if (log.isDebugEnabled()) {
                log.debug("No directly shared variable: path=" + Arrays.toString(path) + ", vertex=" + vertex);
            }
            return false;
        }
        IJoinNode[] newPath = new IJoinNode[path.length + 1];
        System.arraycopy(path, 0, newPath, 0, path.length);
        newPath[path.length] = vertex;
        FilterNode[][] constraintRunArray = this.getJoinGraphConstraints(newPath, constraints, null, true);
        for (FilterNode c : vertexConstraints = constraintRunArray[path.length]) {
            Set<IVariable<IVariable<?>>> vset2 = this.getSpannedVariables(c, true, new LinkedHashSet());
            vset2.retainAll(knownBound);
            if (vset2.isEmpty()) continue;
            if (log.isDebugEnabled()) {
                log.debug("Can join: sharedVars=" + vset2 + ", path=" + Arrays.toString(path) + ", vertex=" + vertex + ", constraint=" + c);
            }
            return true;
        }
        if (log.isDebugEnabled()) {
            log.debug("No shared variable: path=" + Arrays.toString(path) + ", vertex=" + vertex + ", constraints=" + Arrays.toString(constraints));
        }
        return false;
    }

    public FilterNode[][] getJoinGraphConstraints(IJoinNode[] path, FilterNode[] joinGraphConstraints, Set<IVariable<?>> boundVars, boolean pathIsComplete) {
        if (path == null) {
            throw new IllegalArgumentException();
        }
        if (path.length == 0) {
            throw new IllegalArgumentException();
        }
        if (boundVars == null) {
            boundVars = new LinkedHashSet();
        }
        FilterNode[][] ret = new FilterNode[path.length][];
        LinkedHashSet<FilterNode> used = new LinkedHashSet<FilterNode>();
        for (int i = 0; i < path.length; ++i) {
            IJoinNode p = path[i];
            if (p == null) {
                throw new IllegalArgumentException();
            }
            LinkedList<FilterNode> constraints = new LinkedList<FilterNode>();
            this.getDefinitelyProducedBindings(p, boundVars, true);
            if (joinGraphConstraints != null) {
                for (FilterNode c : joinGraphConstraints) {
                    if (c == null) {
                        throw new IllegalArgumentException();
                    }
                    if (used.contains(c)) continue;
                    boolean attach = false;
                    if (pathIsComplete && i == path.length - 1) {
                        attach = true;
                    } else {
                        boolean allVarsBound;
                        Set<IVariable<IVariable<?>>> vset = this.getSpannedVariables(c, true, new LinkedHashSet());
                        vset.removeAll(boundVars);
                        attach = allVarsBound = vset.isEmpty();
                    }
                    if (!attach) continue;
                    used.add(c);
                    if (log.isDebugEnabled()) {
                        log.debug("Constraint attached at index " + i + " of " + path.length + ", constraint=" + c);
                    }
                    constraints.add(c);
                }
            }
            ret[i] = constraints.toArray(new FilterNode[constraints.size()]);
        }
        return ret;
    }

    public abstract Set<IVariable<?>> getDefinitelyProducedBindings(IBindingProducerNode var1, Set<IVariable<?>> var2, boolean var3);
}

