/*
 * Decompiled with CFR 0.152.
 */
package com.bigdata.rdf.sparql.ast;

import com.bigdata.bop.BOp;
import com.bigdata.bop.IValueExpression;
import com.bigdata.bop.IVariable;
import com.bigdata.bop.Var;
import com.bigdata.rdf.internal.IV;
import com.bigdata.rdf.sparql.ast.TermNode;
import com.bigdata.rdf.sparql.ast.ValueExpressionNode;
import java.util.Map;

public class VarNode
extends TermNode {
    private static final long serialVersionUID = 2368082533964951789L;

    public VarNode(VarNode op) {
        super(op);
    }

    public VarNode(BOp[] args, Map<String, Object> anns) {
        super(args, anns);
    }

    public VarNode(String var) {
        this(Var.var(var));
    }

    public VarNode(IVariable<IV> var) {
        super(new BOp[]{var}, null);
    }

    public boolean isAnonymous() {
        return this.getProperty("anon", false);
    }

    public void setAnonymous(boolean anonymous) {
        this.setProperty("anon", anonymous);
        ((Var)this.getValueExpression()).setAnonymous(anonymous);
    }

    public boolean isSolutionSet() {
        return this.getProperty("solutionSet", false);
    }

    public void setSolutionSet(boolean solutionSet) {
        this.setProperty("solutionSet", solutionSet);
    }

    public boolean isWildcard() {
        return this.getValueExpression().isWildcard();
    }

    @Override
    public IVariable<IV> getValueExpression() {
        return (IVariable)super.getValueExpression();
    }

    @Override
    public void setValueExpression(IValueExpression<? extends IV> ve) {
        this.setArg(0, ve);
    }

    @Override
    public String toString() {
        return "VarNode(" + this.getValueExpression() + ")" + (this.isAnonymous() ? "[anonymous]" : "") + (this.isSolutionSet() ? "[solutionSet]" : "");
    }

    public static VarNode freshVarNode() {
        return new VarNode((IVariable<IV>)Var.var());
    }

    public static interface Annotations
    extends ValueExpressionNode.Annotations {
        public static final String ANONYMOUS = "anon";
        public static final boolean DEFAULT_ANONYMOUS = false;
        public static final String SOLUTION_SET = "solutionSet";
        public static final boolean DEFAULT_SOLUTION_SET = false;
    }
}

