/*
 * Decompiled with CFR 0.152.
 */
package com.bigdata.rdf.sparql.ast.cache;

import com.bigdata.bop.engine.QueryEngine;
import com.bigdata.rdf.sparql.ast.cache.CacheConnectionImpl;
import com.bigdata.rdf.sparql.ast.cache.ICacheConnection;
import java.util.WeakHashMap;
import org.apache.log4j.Logger;

public class CacheConnectionFactory {
    private static final Logger log = Logger.getLogger(CacheConnectionFactory.class);
    private static WeakHashMap<QueryEngine, ICacheConnection> instanceCache = new WeakHashMap();

    public static ICacheConnection getExistingCacheConnection(QueryEngine queryEngine) {
        return instanceCache.get(queryEngine);
    }

    public static ICacheConnection getCacheConnection(QueryEngine queryEngine) {
        if (queryEngine == null) {
            throw new IllegalArgumentException();
        }
        return null;
    }

    private static ICacheConnection newCacheConnection(QueryEngine queryEngine) {
        if (log.isInfoEnabled()) {
            log.info("Initiallizing: " + queryEngine);
        }
        CacheConnectionImpl cache = new CacheConnectionImpl(queryEngine);
        cache.init();
        return cache;
    }

    public static int getCacheCount() {
        return instanceCache.size();
    }
}

