/*
 * Decompiled with CFR 0.152.
 */
package com.bigdata.rdf.sparql.ast.cache;

import com.bigdata.bop.IVariable;
import com.bigdata.rdf.model.BigdataValue;
import info.aduna.iteration.CloseableIteration;
import java.util.Set;
import org.apache.log4j.Logger;
import org.openrdf.query.Binding;
import org.openrdf.query.BindingSet;
import org.openrdf.query.QueryEvaluationException;

public class DescribeBindingsCollector
implements CloseableIteration<BindingSet, QueryEvaluationException> {
    private static final transient Logger log = Logger.getLogger(DescribeBindingsCollector.class);
    private final IVariable<?>[] originalVars;
    private final Set<BigdataValue> describedResources;
    private final CloseableIteration<BindingSet, QueryEvaluationException> src;
    private boolean open = true;

    public DescribeBindingsCollector(Set<IVariable<?>> originalVars, Set<BigdataValue> describedResources, CloseableIteration<BindingSet, QueryEvaluationException> src) {
        if (originalVars == null) {
            throw new IllegalArgumentException();
        }
        if (originalVars.isEmpty()) {
            throw new IllegalArgumentException();
        }
        if (describedResources == null) {
            throw new IllegalArgumentException();
        }
        if (src == null) {
            throw new IllegalArgumentException();
        }
        this.originalVars = originalVars.toArray(new IVariable[originalVars.size()]);
        this.describedResources = describedResources;
        this.src = src;
    }

    @Override
    public void close() throws QueryEvaluationException {
        this.open = false;
    }

    @Override
    public boolean hasNext() throws QueryEvaluationException {
        if (!this.src.hasNext()) {
            this.close();
            return false;
        }
        return true;
    }

    @Override
    public BindingSet next() throws QueryEvaluationException {
        if (!this.open) {
            throw new QueryEvaluationException("Closed");
        }
        BindingSet bs = (BindingSet)this.src.next();
        for (IVariable<?> var : this.originalVars) {
            BigdataValue boundValue;
            Binding binding = bs.getBinding(var.getName());
            if (binding == null || (boundValue = (BigdataValue)binding.getValue()) == null || !this.describedResources.add(boundValue) || !log.isInfoEnabled()) continue;
            log.info("Will describe: var=" + var + ",boundValue=" + boundValue);
        }
        return bs;
    }

    @Override
    public void remove() throws QueryEvaluationException {
        throw new UnsupportedOperationException();
    }
}

