/*
 * Decompiled with CFR 0.152.
 */
package com.bigdata.rdf.sparql.ast.eval;

import com.bigdata.bop.BOp;
import com.bigdata.bop.BOpBase;
import com.bigdata.bop.BOpEvaluationContext;
import com.bigdata.bop.Constant;
import com.bigdata.bop.CoreBaseBOp;
import com.bigdata.bop.IConstraint;
import com.bigdata.bop.IPredicate;
import com.bigdata.bop.IVariable;
import com.bigdata.bop.IVariableOrConstant;
import com.bigdata.bop.NV;
import com.bigdata.bop.NamedSolutionSetRefUtility;
import com.bigdata.bop.PipelineOp;
import com.bigdata.bop.ap.Predicate;
import com.bigdata.bop.ap.filter.BOpFilterBase;
import com.bigdata.bop.ap.filter.DistinctFilter;
import com.bigdata.bop.cost.ScanCostReport;
import com.bigdata.bop.cost.SubqueryCostReport;
import com.bigdata.bop.join.AccessPathJoinAnnotations;
import com.bigdata.bop.join.DistinctTermScanOp;
import com.bigdata.bop.join.FastRangeCountOp;
import com.bigdata.bop.join.HTreeHashJoinAnnotations;
import com.bigdata.bop.join.HTreeHashJoinOp;
import com.bigdata.bop.join.HashJoinAnnotations;
import com.bigdata.bop.join.JVMHashJoinOp;
import com.bigdata.bop.join.JoinAnnotations;
import com.bigdata.bop.join.PipelineJoin;
import com.bigdata.bop.rdf.filter.NativeDistinctFilter;
import com.bigdata.bop.rdf.filter.StripContextFilter;
import com.bigdata.bop.rdf.join.DataSetJoin;
import com.bigdata.rdf.internal.IV;
import com.bigdata.rdf.internal.VTE;
import com.bigdata.rdf.internal.impl.TermId;
import com.bigdata.rdf.sparql.ast.DatasetNode;
import com.bigdata.rdf.sparql.ast.VarNode;
import com.bigdata.rdf.sparql.ast.eval.AST2BOpBase;
import com.bigdata.rdf.sparql.ast.eval.AST2BOpContext;
import com.bigdata.rdf.sparql.ast.eval.AST2BOpFilters;
import com.bigdata.rdf.sparql.ast.eval.DGExpander;
import com.bigdata.rdf.sparql.ast.eval.DataSetSummary;
import com.bigdata.rdf.spo.ISPO;
import com.bigdata.rdf.spo.InGraphHashSetFilter;
import com.bigdata.rdf.spo.SPOKeyOrder;
import com.bigdata.relation.IRelation;
import com.bigdata.relation.accesspath.AccessPath;
import com.bigdata.relation.accesspath.ElementFilter;
import com.bigdata.relation.rule.EmptyAccessPathExpander;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.apache.log4j.Logger;
import org.openrdf.query.algebra.StatementPattern;

public class AST2BOpJoins
extends AST2BOpFilters {
    private static final Logger log = Logger.getLogger(AST2BOpFilters.class);

    protected AST2BOpJoins() {
    }

    public static PipelineOp join(PipelineOp left, Predicate pred, Set<IVariable<?>> doneSet, Collection<IConstraint> constraints, Long cutoffLimit, Properties queryHints, AST2BOpContext ctx) {
        LinkedHashMap<IConstraint, Set<IVariable<IV>>> needsMaterialization;
        block9: {
            LinkedList<NV> anns;
            block8: {
                int joinId = ctx.nextId();
                anns = new LinkedList<NV>();
                anns.add(new NV(BOp.Annotations.BOP_ID, joinId));
                needsMaterialization = new LinkedHashMap<IConstraint, Set<IVariable<IV>>>();
                anns.add(new NV(JoinAnnotations.CONSTRAINTS, AST2BOpJoins.getJoinConstraints2(constraints, needsMaterialization, cutoffLimit == null)));
                anns.add(new NV(AST2BOpBase.Annotations.SIMPLE_JOIN, needsMaterialization.isEmpty()));
                StatementPattern.Scope scope = (StatementPattern.Scope)((Object)((BOpBase)pred).getProperty(AST2BOpBase.Annotations.SCOPE));
                boolean quads = ((CoreBaseBOp)pred).getProperty(AST2BOpBase.Annotations.QUADS, false);
                VarNode distinctTermScanVar = (VarNode)((BOpBase)pred).getProperty("distinctTermScanVar");
                VarNode fastRangeCountVar = (VarNode)((BOpBase)pred).getProperty("fastRangeCountVar");
                DatasetNode dataset = (DatasetNode)((BOpBase)pred).getProperty(AST2BOpBase.Annotations.DATASET);
                pred = ((Predicate)pred).clearAnnotations(new String[]{AST2BOpBase.Annotations.SCOPE, AST2BOpBase.Annotations.QUADS, AST2BOpBase.Annotations.DATASET, "distinctTermScanVar", "fastRangeCountVar"});
                if (fastRangeCountVar != null) {
                    left = AST2BOpJoins.fastRangeCountJoin(left, anns, (Predicate)pred, dataset, cutoffLimit, fastRangeCountVar, queryHints, ctx);
                    return left;
                }
                if (distinctTermScanVar != null) {
                    left = AST2BOpJoins.distinctTermScanJoin(left, anns, (Predicate)pred, dataset, cutoffLimit, distinctTermScanVar, queryHints, ctx);
                    return left;
                }
                if (!quads) break block8;
                assert (((BOpBase)pred).getProperty(IPredicate.Annotations.ACCESS_PATH_EXPANDER) == null);
                switch (scope) {
                    case NAMED_CONTEXTS: {
                        left = AST2BOpJoins.namedGraphJoin(left, anns, pred, dataset, cutoffLimit, queryHints, ctx);
                        break block9;
                    }
                    case DEFAULT_CONTEXTS: {
                        left = AST2BOpJoins.defaultGraphJoin(left, anns, pred, dataset, cutoffLimit, queryHints, ctx);
                        break block9;
                    }
                    default: {
                        throw new AssertionError();
                    }
                }
            }
            left = AST2BOpJoins.triplesModeJoin(left, anns, pred, cutoffLimit, queryHints, ctx);
        }
        if (needsMaterialization.isEmpty()) {
            return left;
        }
        left = cutoffLimit != null ? AST2BOpJoins.addNonConditionalMaterializationSteps(left, doneSet, needsMaterialization, cutoffLimit, queryHints, ctx) : AST2BOpJoins.addMaterializationSteps3(left, doneSet, needsMaterialization, queryHints, ctx);
        return left;
    }

    private static PipelineOp distinctTermScanJoin(PipelineOp left, List<NV> anns, Predicate pred, DatasetNode dataset, Long cutoffLimitIsIgnored, VarNode distinctTermScanVar, Properties queryHints, AST2BOpContext ctx) {
        IVariableOrConstant distinctVar = distinctTermScanVar.getValueExpression();
        anns.add(new NV(DistinctTermScanOp.Annotations.DISTINCT_VAR, distinctVar));
        Constant mockConst = new Constant(TermId.mockIV(VTE.URI));
        Predicate<ISPO> mockPred = pred.asBound((IVariable<?>)distinctVar, mockConst);
        SPOKeyOrder keyOrder = SPOKeyOrder.getKeyOrder(mockPred, ctx.isQuads() ? 4 : 3);
        pred = (Predicate)pred.setProperty(IPredicate.Annotations.KEY_ORDER, keyOrder);
        anns.add(new NV(PipelineJoin.Annotations.PREDICATE, pred));
        return AST2BOpJoins.applyQueryHints(new DistinctTermScanOp(AST2BOpJoins.leftOrEmpty(left), NV.asMap(anns.toArray(new NV[anns.size()]))), queryHints, ctx);
    }

    private static PipelineOp fastRangeCountJoin(PipelineOp left, List<NV> anns, Predicate pred, DatasetNode dataset, Long cutoffLimitIsIgnored, VarNode fastRangeCountVar, Properties queryHints, AST2BOpContext ctx) {
        if (ctx.gpuEvaluation != null && pred.getProperty("evaluateOnGPU", false).booleanValue()) {
            return ctx.gpuEvaluation.fastRangeCountJoin(left, anns, pred, dataset, cutoffLimitIsIgnored, fastRangeCountVar, queryHints, ctx);
        }
        anns.add(new NV(FastRangeCountOp.Annotations.COUNT_VAR, fastRangeCountVar.getValueExpression()));
        anns.add(new NV(PipelineJoin.Annotations.PREDICATE, pred));
        return AST2BOpJoins.applyQueryHints(new FastRangeCountOp(AST2BOpJoins.leftOrEmpty(left), NV.asMap(anns.toArray(new NV[anns.size()]))), queryHints, ctx);
    }

    private static PipelineOp triplesModeJoin(PipelineOp left, List<NV> anns, Predicate<?> pred, Long cutoffLimit, Properties queryHints, AST2BOpContext ctx) {
        boolean scaleOut = ctx.isCluster();
        if (scaleOut && !ctx.remoteAPs) {
            anns.add(new NV(Predicate.Annotations.EVALUATION_CONTEXT, (Object)BOpEvaluationContext.SHARDED));
            pred = (Predicate)pred.setProperty(Predicate.Annotations.REMOTE_ACCESS_PATH, false);
        } else {
            anns.add(new NV(Predicate.Annotations.EVALUATION_CONTEXT, (Object)BOpEvaluationContext.ANY));
        }
        anns.add(new NV(PipelineJoin.Annotations.PREDICATE, pred));
        return AST2BOpJoins.newJoin(left, anns, false, null, cutoffLimit, queryHints, ctx);
    }

    private static PipelineOp namedGraphJoin(PipelineOp left, List<NV> anns, Predicate<?> pred, DatasetNode dataset, Long cutoffLimit, Properties queryHints, AST2BOpContext ctx) {
        boolean scanAndFilter;
        boolean scaleOut = ctx.isCluster();
        if (scaleOut && !ctx.remoteAPs) {
            anns.add(new NV(Predicate.Annotations.EVALUATION_CONTEXT, (Object)BOpEvaluationContext.SHARDED));
            pred = (Predicate)pred.setProperty(Predicate.Annotations.REMOTE_ACCESS_PATH, false);
        } else {
            anns.add(new NV(Predicate.Annotations.EVALUATION_CONTEXT, (Object)BOpEvaluationContext.ANY));
        }
        if (dataset == null || dataset.getNamedGraphs() == null) {
            anns.add(new NV(PipelineJoin.Annotations.PREDICATE, pred));
            return AST2BOpJoins.newJoin(left, anns, false, null, cutoffLimit, queryHints, ctx);
        }
        if (pred.get(3).isConstant()) {
            anns.add(new NV(PipelineJoin.Annotations.PREDICATE, pred));
            return AST2BOpJoins.newJoin(left, anns, false, null, cutoffLimit, queryHints, ctx);
        }
        DataSetSummary summary = dataset.getNamedGraphs();
        anns.add(new NV(AST2BOpBase.Annotations.NKNOWN, summary.nknown));
        if (summary.nknown == 0) {
            pred = (Predicate)pred.setUnboundProperty(IPredicate.Annotations.ACCESS_PATH_EXPANDER, EmptyAccessPathExpander.INSTANCE);
            anns.add(new NV(PipelineJoin.Annotations.PREDICATE, pred));
            return AST2BOpJoins.newJoin(left, anns, false, summary, cutoffLimit, queryHints, ctx);
        }
        if (summary.nknown == 1) {
            pred = pred.asBound((IVariable)pred.get(3), new Constant<IV>((IVariable)pred.get(3), summary.firstContext));
            anns.add(new NV(PipelineJoin.Annotations.PREDICATE, pred));
            return AST2BOpJoins.newJoin(left, anns, false, summary, cutoffLimit, queryHints, ctx);
        }
        int accessPathSampleLimit = pred.getProperty("accessPathSampleLimit", ctx.accessPathSampleLimit);
        boolean estimateCosts = accessPathSampleLimit >= 0;
        IRelation r = ctx.context.getRelation(pred);
        if (estimateCosts) {
            ScanCostReport scanCostReport = ((AccessPath)ctx.context.getAccessPath(r, (Predicate)pred.setProperty(IPredicate.Annotations.REMOTE_ACCESS_PATH, true))).estimateCost();
            anns.add(new NV(AST2BOpBase.Annotations.COST_SCAN, scanCostReport));
            SubqueryCostReport subqueryCostReport = summary.estimateSubqueryCost(ctx.context, accessPathSampleLimit, (Predicate)pred.setProperty(IPredicate.Annotations.REMOTE_ACCESS_PATH, true));
            anns.add(new NV(AST2BOpBase.Annotations.COST_SUBQUERY, subqueryCostReport));
            scanAndFilter = subqueryCostReport == null || scanCostReport.cost < subqueryCostReport.cost;
        } else {
            Object scanCostReport = null;
            Object subqueryCostReport = null;
            scanAndFilter = pred.getProperty("accessPathScanAndFilter", ctx.accessPathScanAndFilter);
        }
        if (scanAndFilter) {
            InGraphHashSetFilter test = new InGraphHashSetFilter(summary.nknown, summary.graphs);
            pred = pred.addIndexLocalFilter(ElementFilter.newInstance(test));
            anns.add(new NV(PipelineJoin.Annotations.PREDICATE, pred));
            return AST2BOpJoins.newJoin(left, anns, false, summary, cutoffLimit, queryHints, ctx);
        }
        IVariable var = (IVariable)pred.get(3);
        left = new DataSetJoin(AST2BOpJoins.leftOrEmpty(left), new NV(DataSetJoin.Annotations.VAR, var), new NV(DataSetJoin.Annotations.BOP_ID, ctx.nextId()), new NV(DataSetJoin.Annotations.GRAPHS, summary.getGraphs()));
        anns.add(new NV(PipelineJoin.Annotations.PREDICATE, pred));
        return AST2BOpJoins.newJoin(left, anns, false, summary, cutoffLimit, queryHints, ctx);
    }

    private static PipelineOp defaultGraphJoin(PipelineOp left, List<NV> anns, Predicate<?> pred, DatasetNode dataset, Long cutoffLimit, Properties queryHints, AST2BOpContext ctx) {
        DataSetSummary summary = dataset == null ? null : dataset.getDefaultGraphs();
        boolean scaleOut = ctx.isCluster();
        if (dataset != null && summary == null) {
            pred = pred.addAccessPathFilter(StripContextFilter.newInstance());
            anns.add(new NV(PipelineJoin.Annotations.PREDICATE, pred));
            return AST2BOpJoins.newJoin(left, anns, ctx.defaultGraphDistinctFilter, summary, cutoffLimit, queryHints, ctx);
        }
        if (summary != null && summary.nknown == 0) {
            pred = (Predicate)pred.setUnboundProperty(IPredicate.Annotations.ACCESS_PATH_EXPANDER, EmptyAccessPathExpander.INSTANCE);
            anns.add(new NV(PipelineJoin.Annotations.PREDICATE, pred));
            return AST2BOpJoins.newJoin(left, anns, false, summary, cutoffLimit, queryHints, ctx);
        }
        if (summary != null && summary.nknown == 1) {
            pred = pred.asBound((IVariable)pred.get(3), new Constant<IV>(summary.firstContext));
            if (scaleOut && !ctx.remoteAPs) {
                anns.add(new NV(Predicate.Annotations.EVALUATION_CONTEXT, (Object)BOpEvaluationContext.SHARDED));
                pred = (Predicate)pred.setProperty(Predicate.Annotations.REMOTE_ACCESS_PATH, false);
            }
            pred = pred.addAccessPathFilter(StripContextFilter.newInstance());
            anns.add(new NV(PipelineJoin.Annotations.PREDICATE, pred));
            return AST2BOpJoins.newJoin(left, anns, false, summary, cutoffLimit, queryHints, ctx);
        }
        int accessPathSampleLimit = pred.getProperty("accessPathSampleLimit", ctx.accessPathSampleLimit);
        boolean estimateCosts = accessPathSampleLimit >= 0;
        Object scanCostReport = null;
        Object subqueryCostReport = null;
        boolean scanAndFilter = true;
        if (scanAndFilter) {
            if (dataset != null) {
                InGraphHashSetFilter test = new InGraphHashSetFilter(summary.nknown, summary.graphs);
                pred = pred.addIndexLocalFilter(ElementFilter.newInstance(test));
            }
            pred = pred.addAccessPathFilter(StripContextFilter.newInstance());
            if (scaleOut) {
                anns.add(new NV(Predicate.Annotations.EVALUATION_CONTEXT, (Object)BOpEvaluationContext.ANY));
                pred = (Predicate)pred.setProperty(Predicate.Annotations.REMOTE_ACCESS_PATH, true);
            } else {
                anns.add(new NV(Predicate.Annotations.EVALUATION_CONTEXT, (Object)BOpEvaluationContext.ANY));
            }
            anns.add(new NV(PipelineJoin.Annotations.PREDICATE, pred));
            return AST2BOpJoins.newJoin(left, anns, ctx.defaultGraphDistinctFilter, summary, cutoffLimit, queryHints, ctx);
        }
        boolean dataSetJoin = false;
        long estimatedRangeCount = subqueryCostReport.rangeCount;
        boolean maxParallel = true;
        pred = (Predicate)pred.setUnboundProperty(IPredicate.Annotations.ACCESS_PATH_EXPANDER, new DGExpander(1, summary.getGraphs(), estimatedRangeCount));
        pred = pred.addAccessPathFilter(StripContextFilter.newInstance());
        if (scaleOut) {
            anns.add(new NV(Predicate.Annotations.EVALUATION_CONTEXT, (Object)BOpEvaluationContext.ANY));
            pred = (Predicate)pred.setProperty(Predicate.Annotations.REMOTE_ACCESS_PATH, true);
        } else {
            anns.add(new NV(Predicate.Annotations.EVALUATION_CONTEXT, (Object)BOpEvaluationContext.ANY));
        }
        anns.add(new NV(PipelineJoin.Annotations.PREDICATE, pred));
        return AST2BOpJoins.newJoin(left, anns, ctx.defaultGraphDistinctFilter, summary, cutoffLimit, queryHints, ctx);
    }

    private static BOpFilterBase newDistinctFilter(AST2BOpContext ctx, Predicate<?> pred, DataSetSummary summary, boolean hashJoin) {
        boolean nativeDistinct;
        boolean bl = nativeDistinct = hashJoin && ctx.nativeDistinctSPO;
        if (nativeDistinct) {
            Long rangeCount = (Long)pred.getProperty(AST2BOpBase.Annotations.ESTIMATED_CARDINALITY);
            if (rangeCount != null) {
                if (rangeCount < ctx.nativeDistinctSPOThreshold) {
                    nativeDistinct = false;
                }
            } else {
                log.warn("No rangeCount? : " + pred);
            }
        }
        if (nativeDistinct) {
            SPOKeyOrder indexKeyOrder = SPOKeyOrder.getKeyOrder(pred, 4);
            return NativeDistinctFilter.newInstance(indexKeyOrder);
        }
        return DistinctFilter.newInstance();
    }

    private static PipelineOp newJoin(PipelineOp left, List<NV> anns, boolean defaultGraphFilter, DataSetSummary summary, Long cutoffLimit, Properties queryHints, AST2BOpContext ctx) {
        boolean hashJoin;
        Map<String, Object> map = NV.asMap(anns.toArray(new NV[anns.size()]));
        Predicate pred = (Predicate)map.get(AccessPathJoinAnnotations.PREDICATE);
        boolean bl = hashJoin = cutoffLimit == null && pred.getProperty("hashJoin", false) != false;
        if (cutoffLimit != null) {
            boolean simpleJoin = (Boolean)map.get(AST2BOpBase.Annotations.SIMPLE_JOIN) != false;
            map.put(PipelineJoin.Annotations.REORDER_SOLUTIONS, Boolean.FALSE);
            map.put(PipelineOp.Annotations.MAX_PARALLEL, 1);
            map.put(PipelineJoin.Annotations.MAX_PARALLEL_CHUNKS, 0);
            map.put(PipelineJoin.Annotations.COALESCE_DUPLICATE_ACCESS_PATHS, Boolean.FALSE);
            map.put(PipelineJoin.Annotations.REORDER_ACCESS_PATHS, Boolean.FALSE);
            if (simpleJoin) {
                map.put(PipelineJoin.Annotations.LIMIT, (long)cutoffLimit);
                map.put(PipelineJoin.Annotations.SHARED_STATE, Boolean.TRUE);
                map.put(PipelineJoin.Annotations.EVALUATION_CONTEXT, (Object)BOpEvaluationContext.CONTROLLER);
            } else {
                map.put(PipelineJoin.Annotations.SHARED_STATE, Boolean.TRUE);
            }
        }
        if (defaultGraphFilter) {
            pred = pred.addAccessPathFilter(AST2BOpJoins.newDistinctFilter(ctx, pred, summary, hashJoin));
            map.put(AccessPathJoinAnnotations.PREDICATE, pred);
        }
        if (hashJoin) {
            boolean useHTree = ctx.nativeHashJoins;
            IVariable[] joinVars = (IVariable[])pred.getRequiredProperty(HashJoinAnnotations.JOIN_VARS);
            map.put(HashJoinAnnotations.JOIN_VARS, joinVars);
            map.put("namedSetRef", NamedSolutionSetRefUtility.newInstance(null, "--namedSet-" + ctx.nextId(), joinVars));
            BOpEvaluationContext evaluationContext = (BOpEvaluationContext)((Object)map.get(BOp.Annotations.EVALUATION_CONTEXT));
            if (evaluationContext == null) {
                evaluationContext = BOpEvaluationContext.CONTROLLER;
            } else if (evaluationContext == BOpEvaluationContext.ANY) {
                evaluationContext = BOpEvaluationContext.CONTROLLER;
            }
            if (evaluationContext == BOpEvaluationContext.CONTROLLER) {
                map.put(PipelineOp.Annotations.SHARED_STATE, true);
            }
            map.put(BOp.Annotations.EVALUATION_CONTEXT, (Object)evaluationContext);
            map.put(PipelineOp.Annotations.MAX_PARALLEL, 1);
            if (useHTree) {
                map.put(PipelineOp.Annotations.MAX_MEMORY, Long.MAX_VALUE);
                map.put(PipelineOp.Annotations.LAST_PASS, true);
                map.put(HTreeHashJoinAnnotations.RELATION_NAME, pred.getRequiredProperty(Predicate.Annotations.RELATION_NAME));
                left = new HTreeHashJoinOp(AST2BOpJoins.leftOrEmpty(left), map);
            } else {
                map.put(PipelineOp.Annotations.PIPELINED, false);
                left = new JVMHashJoinOp(AST2BOpJoins.leftOrEmpty(left), map);
            }
        } else {
            left = new PipelineJoin(AST2BOpJoins.leftOrEmpty(left), map);
        }
        left = AST2BOpJoins.applyQueryHints(left, queryHints, ctx);
        return left;
    }
}

