/*
 * Decompiled with CFR 0.152.
 */
package com.bigdata.rdf.sparql.ast.eval;

import com.bigdata.bop.BOp;
import com.bigdata.bop.BOpEvaluationContext;
import com.bigdata.bop.BOpIdFactory;
import com.bigdata.bop.BOpUtility;
import com.bigdata.bop.BadBOpIdTypeException;
import com.bigdata.bop.Constant;
import com.bigdata.bop.DuplicateBOpIdException;
import com.bigdata.bop.IBindingSet;
import com.bigdata.bop.IConstraint;
import com.bigdata.bop.IPredicate;
import com.bigdata.bop.IVariable;
import com.bigdata.bop.NV;
import com.bigdata.bop.NoBOpIdException;
import com.bigdata.bop.PipelineOp;
import com.bigdata.bop.Var;
import com.bigdata.bop.ap.Predicate;
import com.bigdata.bop.ap.SampleIndex;
import com.bigdata.bop.engine.AbstractRunningQuery;
import com.bigdata.bop.engine.QueryEngine;
import com.bigdata.bop.join.JoinAnnotations;
import com.bigdata.bop.join.PipelineJoin;
import com.bigdata.bop.join.PipelineJoinStats;
import com.bigdata.bop.joinGraph.PartitionedJoinGroup;
import com.bigdata.bop.joinGraph.rto.EdgeSample;
import com.bigdata.bop.joinGraph.rto.EstimateEnum;
import com.bigdata.bop.joinGraph.rto.JoinGraph;
import com.bigdata.bop.joinGraph.rto.Path;
import com.bigdata.bop.joinGraph.rto.SampleBase;
import com.bigdata.bop.solutions.SliceOp;
import com.bigdata.rdf.internal.IV;
import com.bigdata.rdf.internal.impl.literal.XSDNumericIV;
import com.bigdata.rdf.sparql.ast.ASTContainer;
import com.bigdata.rdf.sparql.ast.IGroupMemberNode;
import com.bigdata.rdf.sparql.ast.JoinGroupNode;
import com.bigdata.rdf.sparql.ast.QueryHints;
import com.bigdata.rdf.sparql.ast.StatementPatternNode;
import com.bigdata.rdf.sparql.ast.eval.AST2BOpBase;
import com.bigdata.rdf.sparql.ast.eval.AST2BOpContext;
import com.bigdata.rdf.sparql.ast.eval.AST2BOpJoins;
import com.bigdata.rdf.sparql.ast.eval.AST2BOpUtility;
import com.bigdata.rdf.sparql.ast.eval.OutOfOrderEvaluationException;
import com.bigdata.rdf.store.AbstractTripleStore;
import com.bigdata.service.IBigdataFederation;
import com.bigdata.striterator.Dechunkerator;
import com.bigdata.util.NT;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.log4j.Logger;

public class AST2BOpRTO
extends AST2BOpJoins {
    public static final transient Logger log = Logger.getLogger(AST2BOpRTO.class);
    private static final int RTO_MIN_JOINS = 3;
    private static final boolean onlySimpleJoins = false;
    private static final boolean onlyRequiredJoins = true;
    private static final boolean onlySPs = true;
    static final boolean runAllJoinsAsComplexJoins = false;
    private static final boolean failOutOfOrderEvaluation = true;
    private static final boolean checkQueryPlans = false;

    protected static PipelineOp convertRTOJoinGraph(PipelineOp left, JoinGroupNode joinGroup, Set<IVariable<?>> doneSet, AST2BOpContext ctx, AtomicInteger start) {
        StatementPatternNode sp;
        boolean optional;
        IGroupMemberNode child;
        Set<IVariable<?>> doneSetIn = Collections.unmodifiableSet(doneSet);
        int arity = joinGroup.arity();
        JoinGroupNode rtoJoinGroup = new JoinGroupNode();
        rtoJoinGroup.setQueryHints(joinGroup.getQueryHints());
        LinkedList<Predicate> preds = new LinkedList<Predicate>();
        LinkedList<IConstraint> constraints = new LinkedList<IConstraint>();
        int naccepted = 0;
        LinkedHashSet doneSetTmp = new LinkedHashSet(doneSet);
        for (int i = start.get(); i < arity && (child = (IGroupMemberNode)joinGroup.get(i)) instanceof StatementPatternNode && !(optional = (sp = (StatementPatternNode)child).isOptional()); ++i) {
            List<IConstraint> attachedConstraints = AST2BOpRTO.getJoinConstraints(sp);
            LinkedHashMap<IConstraint, Set<IVariable<IV>>> needsMaterialization = new LinkedHashMap<IConstraint, Set<IVariable<IV>>>();
            AST2BOpRTO.getJoinConstraints(attachedConstraints, needsMaterialization);
            sp = (StatementPatternNode)sp.clone();
            rtoJoinGroup.addChild(sp);
            ++naccepted;
            Predicate pred = AST2BOpUtility.toPredicate(sp, ctx);
            preds.add(pred);
            sp.setProperty("PredicateId", pred.getId());
            if (attachedConstraints == null) continue;
            constraints.addAll(attachedConstraints);
        }
        if (naccepted < 3) {
            return left;
        }
        doneSet.addAll(doneSetTmp);
        SampleIndex.SampleType sampleType = joinGroup.getProperty("RTO-sampleType", QueryHints.DEFAULT_RTO_SAMPLE_TYPE);
        int limit = joinGroup.getProperty("RTO-limit", 100);
        int nedges = joinGroup.getProperty("RTO-nedges", 1);
        left = new JoinGraph(AST2BOpRTO.leftOrEmpty(left), new NV(BOp.Annotations.BOP_ID, ctx.nextId()), new NV(BOp.Annotations.EVALUATION_CONTEXT, (Object)BOpEvaluationContext.CONTROLLER), new NV(BOp.Annotations.CONTROLLER, true), new NV(JoinGraph.Annotations.VERTICES, preds.toArray(new Predicate[preds.size()])), new NV(JoinGraph.Annotations.CONSTRAINTS, constraints.toArray(new IConstraint[constraints.size()])), new NV(JoinGraph.Annotations.JOIN_GROUP, rtoJoinGroup), new NV(JoinGraph.Annotations.LIMIT, limit), new NV(JoinGraph.Annotations.NEDGES, nedges), new NV(JoinGraph.Annotations.SAMPLE_TYPE, sampleType.name()), new NV(JoinGraph.Annotations.DONE_SET, doneSetIn), new NV(JoinGraph.Annotations.NT, new NT(ctx.getNamespace(), ctx.getTimestamp())));
        start.addAndGet(naccepted);
        return left;
    }

    public static PipelineOp compileJoinGraph(QueryEngine queryEngine, JoinGraph joinGraph, Path path) {
        if (queryEngine == null) {
            throw new IllegalArgumentException();
        }
        if (joinGraph == null) {
            throw new IllegalArgumentException();
        }
        if (path == null) {
            throw new IllegalArgumentException();
        }
        IPredicate<?>[] predicates = path.getPredicates();
        IConstraint[] constraints = joinGraph.getConstraints();
        LinkedHashSet doneSet = new LinkedHashSet(joinGraph.getDoneSet());
        JoinGroupNode rtoJoinGroup = (JoinGroupNode)joinGraph.getRequiredProperty(JoinGraph.Annotations.JOIN_GROUP);
        Map<Integer, StatementPatternNode> index = AST2BOpRTO.getIndex(rtoJoinGroup);
        BOpIdFactory idFactory = new BOpIdFactory();
        idFactory.reserveIds(predicates);
        idFactory.reserveIds(constraints);
        IConstraint[][] constraintAttachmentArray = PartitionedJoinGroup.getJoinGraphConstraints(predicates, constraints, null, true);
        AST2BOpContext ctx = AST2BOpRTO.getExecutionContext(queryEngine, (NT)joinGraph.getRequiredProperty(JoinGraph.Annotations.NT));
        PipelineOp left = null;
        for (int i = 0; i < predicates.length; ++i) {
            Predicate pred = (Predicate)predicates[i];
            IConstraint[] attachedJoinConstraints = constraintAttachmentArray[i];
            boolean optional = pred.isOptional();
            StatementPatternNode sp = index.get(pred.getId());
            left = AST2BOpRTO.join(left, pred, optional ? new LinkedHashSet(doneSet) : doneSet, attachedJoinConstraints == null ? null : Arrays.asList(attachedJoinConstraints), null, sp.getQueryHints(), ctx);
        }
        return left;
    }

    private static AST2BOpContext getExecutionContext(QueryEngine queryEngine, NT nt) {
        IBigdataFederation<?> indexManager = queryEngine.getFederation() == null ? queryEngine.getIndexManager() : queryEngine.getFederation();
        AbstractTripleStore db = (AbstractTripleStore)indexManager.getResourceLocator().locate(nt.getName(), nt.getTimestamp());
        if (db == null) {
            throw new RuntimeException("No such KB? " + nt);
        }
        ASTContainer astContainer = new ASTContainer(BOp.NOARGS, BOp.NOANNS);
        return new AST2BOpContext(astContainer, db);
    }

    private static Map<Integer, StatementPatternNode> getIndex(JoinGroupNode op) {
        if (op == null) {
            throw new IllegalArgumentException();
        }
        LinkedHashMap<Integer, StatementPatternNode> map = new LinkedHashMap<Integer, StatementPatternNode>();
        for (BOp t : op) {
            if (!(t instanceof StatementPatternNode)) continue;
            StatementPatternNode sp = (StatementPatternNode)t;
            Object x = t.getProperty("PredicateId");
            if (x == null) {
                throw new NoBOpIdException(t.toString());
            }
            if (!(x instanceof Integer)) {
                throw new BadBOpIdTypeException("Must be Integer, not: " + x.getClass() + ": " + "PredicateId");
            }
            Integer id = (Integer)x;
            BOp conflict = map.put(id, sp);
            if (conflict == null) continue;
            throw new DuplicateBOpIdException("duplicate id=" + id + " for " + conflict + " and " + t);
        }
        return Collections.unmodifiableMap(map);
    }

    public static EdgeSample cutoffJoin(QueryEngine queryEngine, JoinGraph joinGraph, int limit, IPredicate<?>[] predicates, IConstraint[] constraints, boolean pathIsComplete, SampleBase sourceSample) throws Exception {
        if (predicates == null) {
            throw new IllegalArgumentException();
        }
        if (limit <= 0) {
            throw new IllegalArgumentException();
        }
        IPredicate<?> pred = predicates[predicates.length - 1];
        if (pred == null) {
            throw new IllegalArgumentException();
        }
        if (sourceSample == null) {
            throw new IllegalArgumentException();
        }
        if (sourceSample.getSample() == null) {
            throw new IllegalArgumentException();
        }
        PipelineOp query = null;
        try {
            query = AST2BOpRTO.getCutoffJoinQuery(queryEngine, joinGraph, limit, predicates, constraints, pathIsComplete, sourceSample);
            if (query instanceof PipelineJoin && query.arity() == 0) {
                return AST2BOpRTO.runSimpleJoin(queryEngine, sourceSample, limit, (PipelineJoin)query);
            }
            return AST2BOpRTO.runComplexJoin(queryEngine, sourceSample, limit, query);
        }
        catch (Throwable ex) {
            throw new RuntimeException("cause=" + ex + "\npred=" + BOpUtility.toString(pred) + "\nconstraints=" + Arrays.toString(constraints) + (query == null ? "" : "\nquery=" + BOpUtility.toString(query)), ex);
        }
    }

    private static PipelineOp getCutoffJoinQuery(QueryEngine queryEngine, JoinGraph joinGraph, int limit, IPredicate<?>[] predicates, IConstraint[] constraints, boolean pathIsComplete, SampleBase sourceSample) throws Exception {
        AST2BOpContext ctx = AST2BOpRTO.getExecutionContext(queryEngine, (NT)joinGraph.getRequiredProperty(JoinGraph.Annotations.NT));
        IConstraint[][] constraintAttachmentArray = PartitionedJoinGroup.getJoinGraphConstraints(predicates, constraints, null, pathIsComplete);
        IConstraint[] c = constraintAttachmentArray[predicates.length - 1];
        Predicate pred = (Predicate)predicates[predicates.length - 1];
        IConstraint[] attachedJoinConstraints = constraintAttachmentArray[predicates.length - 1];
        JoinGroupNode rtoJoinGroup = (JoinGroupNode)joinGraph.getRequiredProperty(JoinGraph.Annotations.JOIN_GROUP);
        Map<Integer, StatementPatternNode> index = AST2BOpRTO.getIndex(rtoJoinGroup);
        StatementPatternNode sp = index.get(pred.getId());
        BOpIdFactory idFactory = new BOpIdFactory();
        idFactory.reserve(pred.getId());
        idFactory.reserveIds(c);
        boolean optional = pred.isOptional();
        LinkedHashSet doneSet = new LinkedHashSet(joinGraph.getDoneSet());
        PipelineOp left = null;
        left = AST2BOpRTO.join(left, pred, optional ? new LinkedHashSet(doneSet) : doneSet, attachedJoinConstraints == null ? null : Arrays.asList(attachedJoinConstraints), Long.valueOf(limit), sp.getQueryHints(), ctx);
        if (!(left instanceof PipelineJoin) || left.arity() != 0) {
            left = AST2BOpRTO.applyQueryHints((PipelineOp)new SliceOp(AST2BOpRTO.leftOrEmpty(left), new NV(SliceOp.Annotations.BOP_ID, ctx.nextId()), new NV(SliceOp.Annotations.OFFSET, "0"), new NV(SliceOp.Annotations.LIMIT, Integer.toString(limit)), new NV(SliceOp.Annotations.EVALUATION_CONTEXT, (Object)BOpEvaluationContext.CONTROLLER), new NV(SliceOp.Annotations.PIPELINED, true), new NV(SliceOp.Annotations.MAX_PARALLEL, 1), new NV(SliceOp.Annotations.REORDER_SOLUTIONS, false), new NV(SliceOp.Annotations.SHARED_STATE, true)), rtoJoinGroup, ctx);
        }
        if (log.isDebugEnabled()) {
            log.debug("RTO cutoff join query::\n" + BOpUtility.toString(left) + "\npred::" + pred);
        }
        return left;
    }

    private static void checkQueryPlan(PipelineOp left) {
        Iterator<PipelineOp> itr = BOpUtility.visitAll(left, PipelineOp.class);
        while (itr.hasNext()) {
            PipelineOp tmp = itr.next();
            if (tmp.getProperty(PipelineOp.Annotations.ALT_SINK_REF) != null) {
                throw new RuntimeException("Query plan uses altSink: op=" + tmp.toShortString());
            }
            if (tmp.getMaxParallel() != 1) {
                throw new RuntimeException("RTO " + PipelineOp.Annotations.MAX_PARALLEL + ": expected=1, actual=" + tmp.getMaxParallel() + ", op=" + tmp.toShortString());
            }
            if (tmp.isReorderSolutions()) {
                throw new RuntimeException("RTO " + PipelineOp.Annotations.REORDER_SOLUTIONS + ": expected=false, actual=" + tmp.isReorderSolutions() + ", op=" + tmp.toShortString());
            }
            if (!(tmp instanceof PipelineJoin)) continue;
            PipelineJoin t = (PipelineJoin)tmp;
            int maxParallelChunks = t.getMaxParallelChunks();
            if (maxParallelChunks != 0) {
                throw new RuntimeException("PipelineJoin: " + PipelineJoin.Annotations.MAX_PARALLEL_CHUNKS + "=" + maxParallelChunks + " but must be ZERO (0):: op=" + t.toShortString());
            }
            boolean coalesceDuplicateAccessPaths = t.getProperty(PipelineJoin.Annotations.COALESCE_DUPLICATE_ACCESS_PATHS, true);
            if (!coalesceDuplicateAccessPaths) continue;
            throw new RuntimeException("PipelineJoin: " + PipelineJoin.Annotations.COALESCE_DUPLICATE_ACCESS_PATHS + "=" + coalesceDuplicateAccessPaths + " but must be false:: op=" + t.toShortString());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static EdgeSample runSimpleJoin(QueryEngine queryEngine, SampleBase sourceSample, int limit, PipelineJoin<?> joinOp) throws Exception {
        if (log.isInfoEnabled()) {
            log.info("limit=" + limit + ", sourceSample=" + sourceSample + ", query=" + joinOp.toShortString());
        }
        if (limit != ((Long)joinOp.getRequiredProperty(JoinAnnotations.LIMIT)).intValue()) {
            throw new AssertionError();
        }
        int joinId = joinOp.getId();
        PipelineJoin<?> queryOp = joinOp;
        UUID queryId = UUID.randomUUID();
        AbstractRunningQuery runningQuery = queryEngine.eval(queryId, queryOp, null, sourceSample.getSample());
        LinkedList<IBindingSet> result = new LinkedList<IBindingSet>();
        try {
            int nresults = 0;
            try {
                IBindingSet bset = null;
                Dechunkerator itr = new Dechunkerator(runningQuery.iterator());
                while (itr.hasNext()) {
                    bset = (IBindingSet)itr.next();
                    result.add(bset);
                    if (nresults++ < limit) continue;
                    break;
                }
            }
            finally {
                runningQuery.cancel(true);
            }
        }
        finally {
            if (runningQuery.getCause() != null) {
                throw new RuntimeException(runningQuery.getCause());
            }
        }
        PipelineJoinStats joinStats = (PipelineJoinStats)runningQuery.getStats().get(joinId);
        if (log.isTraceEnabled()) {
            log.trace(joinStats.toString());
        }
        int inputCount = (int)joinStats.inputSolutions.get();
        long outputCount = joinStats.outputSolutions.get();
        long sumRangeCount = joinStats.accessPathRangeCount.get();
        long tuplesRead = joinStats.accessPathUnitsIn.get();
        return AST2BOpRTO.newEdgeSample(limit, inputCount, outputCount, sumRangeCount, tuplesRead, sourceSample, result);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static EdgeSample runComplexJoin(QueryEngine queryEngine, SampleBase sourceSample, int limit, PipelineOp query) throws Exception {
        long outputCount;
        int inputCount;
        if (log.isInfoEnabled()) {
            log.info("limit=" + limit + ", sourceSample=" + sourceSample + ", query=" + query.toShortString());
        }
        Var<?> rtoVar = Var.var();
        IBindingSet[] in = AST2BOpRTO.injectRowIdColumn(rtoVar, 1, sourceSample.getSample());
        UUID queryId = UUID.randomUUID();
        AbstractRunningQuery runningQuery = queryEngine.eval(queryId, (BOp)query, null, in);
        LinkedList<IBindingSet> result = new LinkedList<IBindingSet>();
        try {
            long nout = 0L;
            try {
                IBindingSet bset = null;
                Dechunkerator itr = new Dechunkerator(runningQuery.iterator());
                int lastRowId = 0;
                while (itr.hasNext()) {
                    bset = (IBindingSet)itr.next();
                    int rowid = ((XSDNumericIV)bset.get(rtoVar).get()).intValue();
                    if (rowid < lastRowId) {
                        throw new OutOfOrderEvaluationException();
                    }
                    lastRowId = rowid;
                    bset.clear(rtoVar);
                    result.add(bset);
                    if (nout++ < (long)limit) continue;
                    break;
                }
                inputCount = lastRowId;
                outputCount = nout;
            }
            finally {
                runningQuery.cancel(true);
            }
        }
        finally {
            if (runningQuery.getCause() != null) {
                throw new RuntimeException(runningQuery.getCause());
            }
        }
        PipelineJoin joinOp = BOpUtility.getOnly(query, PipelineJoin.class);
        PipelineJoinStats joinStats = (PipelineJoinStats)runningQuery.getStats().get(joinOp.getId());
        if (log.isTraceEnabled()) {
            log.trace("join::" + joinStats);
        }
        long sumRangeCount = joinStats.accessPathRangeCount.get();
        long tuplesRead = joinStats.accessPathUnitsIn.get();
        return AST2BOpRTO.newEdgeSample(limit, inputCount, outputCount, sumRangeCount, tuplesRead, sourceSample, result);
    }

    private static EdgeSample newEdgeSample(int limit, int inputCount, long outputCount, long sumRangeCount, long tuplesRead, SampleBase sourceSample, List<IBindingSet> result) {
        long adjustedCard;
        EstimateEnum estimateEnum;
        if (log.isInfoEnabled()) {
            log.info("inputCount=" + inputCount + ", outputCount=" + outputCount + ", sumRangeCount=" + sumRangeCount + ", tuplesRead=" + tuplesRead + ", sourceSample=" + sourceSample);
        }
        if (sourceSample.estimateEnum == EstimateEnum.Exact && outputCount < (long)limit) {
            estimateEnum = EstimateEnum.Exact;
            adjustedCard = outputCount;
        } else if (inputCount == 1 && outputCount == (long)limit) {
            adjustedCard = sumRangeCount;
            estimateEnum = EstimateEnum.LowerBound;
        } else if (sourceSample.estimateEnum != EstimateEnum.Exact && outputCount == 0L) {
            estimateEnum = EstimateEnum.Underflow;
            adjustedCard = outputCount;
        } else {
            estimateEnum = EstimateEnum.Normal;
            adjustedCard = outputCount;
        }
        double f = adjustedCard == 0L ? 0.0 : (double)adjustedCard / (double)inputCount;
        long estCard = (long)((double)sourceSample.estCard * f);
        long estRead = (long)((double)sumRangeCount * f);
        EdgeSample edgeSample = new EdgeSample(sourceSample, inputCount, tuplesRead, sumRangeCount, outputCount, adjustedCard, f, estCard, estRead, limit, estimateEnum, result.toArray(new IBindingSet[result.size()]));
        if (log.isDebugEnabled()) {
            log.debug("newSample=" + edgeSample);
        }
        return edgeSample;
    }

    private static IBindingSet[] injectRowIdColumn(IVariable<?> var, int start, IBindingSet[] in) {
        if (in == null) {
            throw new IllegalArgumentException();
        }
        IBindingSet[] out = new IBindingSet[in.length];
        for (int i = 0; i < out.length; ++i) {
            IBindingSet bset = in[i].clone();
            bset.set(var, new Constant(new XSDNumericIV(start + i)));
            out[i] = bset;
        }
        return out;
    }

    public static interface Annotations
    extends AST2BOpBase.Annotations {
        public static final String PREDICATE_ID = "PredicateId";
    }
}

