/*
 * Decompiled with CFR 0.152.
 */
package com.bigdata.rdf.sparql.ast.eval;

import com.bigdata.bop.BOp;
import com.bigdata.bop.BOpBase;
import com.bigdata.bop.Constant;
import com.bigdata.bop.IBindingSet;
import com.bigdata.bop.IConstant;
import com.bigdata.bop.IValueExpression;
import com.bigdata.bop.IVariable;
import com.bigdata.rdf.internal.DTE;
import com.bigdata.rdf.internal.IV;
import com.bigdata.rdf.internal.VTE;
import com.bigdata.rdf.internal.constraints.IVValueExpression;
import com.bigdata.rdf.internal.impl.AbstractIV;
import com.bigdata.rdf.internal.impl.TermId;
import com.bigdata.rdf.model.BigdataLiteral;
import com.bigdata.rdf.model.BigdataStatement;
import com.bigdata.rdf.model.BigdataURI;
import com.bigdata.rdf.model.BigdataValue;
import com.bigdata.rdf.model.BigdataValueFactory;
import com.bigdata.rdf.sail.sparql.ast.ASTDatasetClause;
import com.bigdata.rdf.sail.sparql.ast.ASTIRI;
import com.bigdata.rdf.sail.sparql.ast.ASTQueryContainer;
import com.bigdata.rdf.sparql.ast.ASTContainer;
import com.bigdata.rdf.sparql.ast.AbstractFromToGraphManagement;
import com.bigdata.rdf.sparql.ast.AbstractGraphDataUpdate;
import com.bigdata.rdf.sparql.ast.AbstractOneGraphManagement;
import com.bigdata.rdf.sparql.ast.BindingsClause;
import com.bigdata.rdf.sparql.ast.ConstantNode;
import com.bigdata.rdf.sparql.ast.ConstructNode;
import com.bigdata.rdf.sparql.ast.DatasetNode;
import com.bigdata.rdf.sparql.ast.DeleteInsertGraph;
import com.bigdata.rdf.sparql.ast.FilterNode;
import com.bigdata.rdf.sparql.ast.FunctionNode;
import com.bigdata.rdf.sparql.ast.GraphPatternGroup;
import com.bigdata.rdf.sparql.ast.GroupByNode;
import com.bigdata.rdf.sparql.ast.GroupNodeBase;
import com.bigdata.rdf.sparql.ast.HavingNode;
import com.bigdata.rdf.sparql.ast.IDataSetNode;
import com.bigdata.rdf.sparql.ast.NamedSubqueriesNode;
import com.bigdata.rdf.sparql.ast.NamedSubqueryRoot;
import com.bigdata.rdf.sparql.ast.PathNode;
import com.bigdata.rdf.sparql.ast.ProjectionNode;
import com.bigdata.rdf.sparql.ast.QuadsDataOrNamedSolutionSet;
import com.bigdata.rdf.sparql.ast.QuadsOperationInTriplesModeException;
import com.bigdata.rdf.sparql.ast.QueryBase;
import com.bigdata.rdf.sparql.ast.QueryNodeBase;
import com.bigdata.rdf.sparql.ast.QueryNodeWithBindingSet;
import com.bigdata.rdf.sparql.ast.QueryRoot;
import com.bigdata.rdf.sparql.ast.StatementPatternNode;
import com.bigdata.rdf.sparql.ast.SubqueryFunctionNodeBase;
import com.bigdata.rdf.sparql.ast.TermNode;
import com.bigdata.rdf.sparql.ast.Update;
import com.bigdata.rdf.sparql.ast.UpdateRoot;
import com.bigdata.rdf.sparql.ast.ValueExpressionNode;
import com.bigdata.rdf.sparql.ast.eval.AST2BOpContext;
import com.bigdata.rdf.sparql.ast.eval.DataSetSummary;
import com.bigdata.rdf.sparql.ast.optimizers.ASTSetValueExpressionsOptimizer;
import com.bigdata.rdf.sparql.ast.service.ServiceNode;
import com.bigdata.rdf.spo.ISPO;
import com.bigdata.rdf.store.AbstractTripleStore;
import com.bigdata.rdf.store.BD;
import com.bigdata.relation.accesspath.IAccessPath;
import com.bigdata.striterator.IChunkedOrderedIterator;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;
import org.openrdf.model.Literal;
import org.openrdf.model.URI;
import org.openrdf.model.Value;
import org.openrdf.model.vocabulary.RDF;
import org.openrdf.query.Binding;
import org.openrdf.query.BindingSet;
import org.openrdf.query.Dataset;
import org.openrdf.query.MalformedQueryException;
import org.openrdf.query.algebra.StatementPattern;
import org.openrdf.query.algebra.evaluation.QueryBindingSet;
import org.openrdf.query.impl.DatasetImpl;
import org.openrdf.query.impl.MapBindingSet;

public class ASTDeferredIVResolution {
    private static final Logger log = Logger.getLogger(ASTDeferredIVResolution.class);
    private final BigdataValueFactory vf;
    private final Map<BigdataValue, List<Handler>> deferred = new LinkedHashMap<BigdataValue, List<Handler>>();
    private final List<Runnable> deferredRunnables = new ArrayList<Runnable>();
    private final Map<Value, IV> resolvedValues = new HashMap<Value, IV>();

    private ASTDeferredIVResolution(AbstractTripleStore store) {
        if (store == null) {
            throw new IllegalArgumentException();
        }
        this.vf = store.getValueFactory();
    }

    public static DeferredResolutionResult resolveQuery(AbstractTripleStore store, ASTContainer ast) throws MalformedQueryException {
        return ASTDeferredIVResolution.resolveQuery(store, ast, null, null, null);
    }

    public static DeferredResolutionResult resolveQuery(AbstractTripleStore store, ASTContainer ast, BindingSet bs, Dataset dataset, AST2BOpContext ctxIn) throws MalformedQueryException {
        AST2BOpContext ctx = ctxIn == null ? new AST2BOpContext(ast, store) : ctxIn;
        ASTDeferredIVResolution termsResolver = new ASTDeferredIVResolution(store);
        BindingSet resolvedBindingset = termsResolver.handleBindingSet(store, bs);
        Dataset resolvedDataset = termsResolver.handleDataset(store, dataset);
        if (Boolean.TRUE.equals(ast.getProperty("resolved"))) {
            if (!termsResolver.deferred.isEmpty()) {
                termsResolver.resolveIVs(store);
            }
            return new DeferredResolutionResult(resolvedBindingset, resolvedDataset);
        }
        long beginNanos = System.nanoTime();
        QueryRoot queryRoot = (QueryRoot)ast.getProperty("originalAST");
        LinkedHashMap<IDataSetNode, List<ASTDatasetClause>> dcLists = new LinkedHashMap<IDataSetNode, List<ASTDatasetClause>>();
        ASTQueryContainer qc = (ASTQueryContainer)ast.getProperty("parseTree");
        if (qc != null && qc.getOperation() != null) {
            ArrayList<ASTDatasetClause> dcList = new ArrayList<ASTDatasetClause>();
            dcList.addAll(qc.getOperation().getDatasetClauseList());
            dcLists.put(queryRoot, dcList);
        }
        ASTSetValueExpressionsOptimizer opt = new ASTSetValueExpressionsOptimizer();
        QueryRoot queryRoot2 = (QueryRoot)opt.optimize(ctx, new QueryNodeWithBindingSet(queryRoot, null)).getQueryNode();
        termsResolver.resolve(store, queryRoot2, dcLists, bs);
        queryRoot2.setPrefixDecls(ast.getOriginalAST().getPrefixDecls());
        ast.setOriginalAST(queryRoot2);
        ast.setResolveValuesTime(System.nanoTime() - beginNanos);
        ast.setProperty("resolved", Boolean.TRUE);
        return new DeferredResolutionResult(resolvedBindingset, resolvedDataset);
    }

    public static DeferredResolutionResult resolveUpdate(AbstractTripleStore store, ASTContainer ast) throws MalformedQueryException {
        return ASTDeferredIVResolution.resolveUpdate(store, ast, null, null);
    }

    public static DeferredResolutionResult resolveUpdate(AbstractTripleStore store, ASTContainer ast, BindingSet bs, Dataset dataset) throws MalformedQueryException {
        ASTDeferredIVResolution termsResolver = new ASTDeferredIVResolution(store);
        BindingSet resolvedBindingSet = termsResolver.handleBindingSet(store, bs);
        Dataset resolvedDataset = termsResolver.handleDataset(store, dataset);
        if (Boolean.TRUE.equals(ast.getProperty("resolved"))) {
            if (!termsResolver.deferred.isEmpty()) {
                termsResolver.resolveIVs(store);
            }
            return new DeferredResolutionResult(resolvedBindingSet, resolvedDataset);
        }
        long beginNanos = System.nanoTime();
        UpdateRoot qc = (UpdateRoot)ast.getProperty("originalAST");
        LinkedHashMap<IDataSetNode, List<ASTDatasetClause>> dcLists = new LinkedHashMap<IDataSetNode, List<ASTDatasetClause>>();
        for (Update update : qc.getChildren()) {
            if (!(update instanceof IDataSetNode)) continue;
            ArrayList<ASTDatasetClause> dcList = new ArrayList<ASTDatasetClause>();
            dcList.addAll(update.getDatasetClauses());
            dcLists.put((IDataSetNode)((Object)update), dcList);
        }
        termsResolver.resolve(store, qc, dcLists, bs);
        if (ast.getOriginalUpdateAST().getPrefixDecls() != null && !ast.getOriginalUpdateAST().getPrefixDecls().isEmpty()) {
            qc.setPrefixDecls(ast.getOriginalUpdateAST().getPrefixDecls());
        }
        ast.setOriginalUpdateAST(qc);
        ast.setResolveValuesTime(System.nanoTime() - beginNanos);
        ast.setProperty("resolved", Boolean.TRUE);
        return new DeferredResolutionResult(resolvedBindingSet, resolvedDataset);
    }

    public static DeferredResolutionResult resolveUpdate(AbstractTripleStore store, Update update, BindingSet bs, Dataset dataset) throws MalformedQueryException {
        ASTDeferredIVResolution termsResolver = new ASTDeferredIVResolution(store);
        BindingSet resolvedBindingSet = termsResolver.handleBindingSet(store, bs);
        Dataset resolvedDataset = termsResolver.handleDataset(store, dataset);
        termsResolver.resolve(store, update, null, bs);
        return new DeferredResolutionResult(resolvedBindingSet, resolvedDataset);
    }

    private void defer(BigdataValue value, Handler handler) {
        if (value == null) {
            return;
        }
        if (value.getValueFactory() == this.vf && value.isRealIV()) {
            if (value.getIV().needsMaterialization()) {
                value.getIV().setValue(value);
            }
            handler.handle(value.getIV());
            return;
        }
        List<Handler> handlers = this.deferred.get(value);
        if (handlers == null) {
            handlers = new ArrayList<Handler>();
            this.deferred.put(value, handlers);
        }
        handlers.add(handler);
    }

    private void deferRunnable(Runnable runnable) {
        this.deferredRunnables.add(runnable);
    }

    private void resolve(AbstractTripleStore store, QueryNodeBase queryNode, Map<IDataSetNode, List<ASTDatasetClause>> dcLists, BindingSet bs) throws MalformedQueryException {
        this.prepare(store, queryNode);
        this.resolveDataset(store, dcLists);
        this.resolveIVs(store);
    }

    private void resolveDataset(final AbstractTripleStore store, Map<IDataSetNode, List<ASTDatasetClause>> dcLists) throws MalformedQueryException {
        if (dcLists == null) {
            return;
        }
        for (final Map.Entry<IDataSetNode, List<ASTDatasetClause>> dcList : dcLists.entrySet()) {
            final boolean update = dcList.getKey() instanceof Update;
            List<ASTDatasetClause> datasetClauses = dcList.getValue();
            if (datasetClauses == null || datasetClauses.isEmpty()) continue;
            if (!store.isQuads()) {
                throw new QuadsOperationInTriplesModeException("NAMED clauses in queries are not supported in triples mode.");
            }
            final LinkedHashSet defaultGraphs = new LinkedHashSet();
            final LinkedHashSet namedGraphs = new LinkedHashSet();
            for (final ASTDatasetClause dc : datasetClauses) {
                ASTIRI astIri = dc.jjtGetChild(ASTIRI.class);
                this.defer((BigdataURI)astIri.getRDFValue(), new Handler(){

                    @Override
                    public void handle(IV newIV) {
                        Object uri = newIV.getValue();
                        if (dc.isVirtual()) {
                            if (uri.getIV().isNullIV()) {
                                throw new RuntimeException("Not declared: " + uri);
                            }
                            IV virtualGraph = (IV)ASTDeferredIVResolution.this.resolvedValues.get(BD.VIRTUAL_GRAPH);
                            if (virtualGraph == null) {
                                throw new RuntimeException("Not declared: " + BD.VIRTUAL_GRAPH);
                            }
                            IAccessPath<ISPO> ap = store.getSPORelation().getAccessPath(uri.getIV(), virtualGraph, null, null);
                            IChunkedOrderedIterator<ISPO> itr = ap.iterator();
                            while (itr.hasNext()) {
                                IV memberGraph = ((ISPO)itr.next()).o();
                                BigdataValue value = store.getLexiconRelation().getTerm(memberGraph);
                                memberGraph.setValue(value);
                                if (dc.isNamed()) {
                                    namedGraphs.add(memberGraph);
                                    continue;
                                }
                                defaultGraphs.add(memberGraph);
                            }
                        } else if (uri.getIV() != null) {
                            if (dc.isNamed()) {
                                namedGraphs.add(uri.getIV());
                            } else {
                                defaultGraphs.add(uri.getIV());
                            }
                        }
                    }
                });
                this.deferRunnable(new Runnable(){

                    @Override
                    public void run() {
                        if (!defaultGraphs.isEmpty() || !namedGraphs.isEmpty()) {
                            DatasetNode datasetNode = new DatasetNode(defaultGraphs, namedGraphs, update);
                            ((IDataSetNode)dcList.getKey()).setDataset(datasetNode);
                        }
                    }
                });
            }
        }
    }

    private void prepare(AbstractTripleStore store, QueryNodeBase queryNode) {
        if (queryNode instanceof QueryRoot) {
            this.fillInIV(store, ((QueryRoot)queryNode).getDataset());
        }
        if (queryNode instanceof UpdateRoot) {
            UpdateRoot updateRoot = (UpdateRoot)queryNode;
            this.fillInIV(store, updateRoot);
        } else if (queryNode instanceof Update) {
            Update update = (Update)queryNode;
            this.fillInIV(store, update);
        } else if (queryNode instanceof QueryBase) {
            BindingsClause bc;
            HavingNode having;
            GroupByNode groupBy;
            GraphPatternGroup whereClause;
            ConstructNode constructClause;
            QueryBase queryRoot = (QueryBase)queryNode;
            ProjectionNode projection = queryRoot.getProjection();
            if (projection != null) {
                this.fillInIV(store, projection);
            }
            if ((constructClause = queryRoot.getConstruct()) != null) {
                this.fillInIV(store, constructClause);
            }
            if ((whereClause = queryRoot.getWhereClause()) != null) {
                this.fillInIV(store, whereClause);
            }
            if ((groupBy = queryRoot.getGroupBy()) != null) {
                this.fillInIV(store, groupBy);
            }
            if ((having = queryRoot.getHaving()) != null) {
                this.fillInIV(store, having);
            }
            if ((bc = queryRoot.getBindingsClause()) != null) {
                for (IBindingSet bs : bc.getBindingSets()) {
                    this.handleBindingSet(store, bs);
                }
            }
            if (queryRoot instanceof QueryRoot && ((QueryRoot)queryRoot).getNamedSubqueries() != null) {
                NamedSubqueriesNode namedSubqueries = ((QueryRoot)queryRoot).getNamedSubqueries();
                for (int i = 0; i < namedSubqueries.size(); ++i) {
                    NamedSubqueryRoot namedSubquery = (NamedSubqueryRoot)namedSubqueries.get(i);
                    this.prepare(store, namedSubquery);
                }
            }
        }
    }

    private void handleBindingSet(AbstractTripleStore store, IBindingSet s) {
        Iterator<Map.Entry<IVariable, IConstant>> itr = s.iterator();
        while (itr.hasNext()) {
            final Map.Entry<IVariable, IConstant> entry = itr.next();
            Object value = entry.getValue().get();
            if (value instanceof BigdataValue) {
                this.defer((BigdataValue)value, new Handler(){

                    @Override
                    public void handle(IV newIV) {
                        entry.setValue(new Constant<IV>(newIV));
                    }
                });
                continue;
            }
            if (!(value instanceof AbstractIV)) continue;
            this.defer((BigdataValue)((AbstractIV)value).getValue(), new Handler(){

                @Override
                public void handle(IV newIV) {
                    entry.setValue(new Constant<IV>(newIV));
                }
            });
        }
    }

    private BindingSet handleBindingSet(AbstractTripleStore store, BindingSet bs) {
        if (bs != null) {
            MapBindingSet newBs = new MapBindingSet();
            for (Binding entry : bs) {
                BigdataValue bValue;
                Value value = entry.getValue();
                if (!(value instanceof BigdataValue) && bs instanceof QueryBindingSet) {
                    bValue = store.getValueFactory().asValue(value);
                    value = bValue;
                }
                if (value instanceof BigdataValue && !((BigdataValue)value).isRealIV()) {
                    bValue = (BigdataValue)value;
                    this.defer((BigdataValue)value, new Handler(){

                        @Override
                        public void handle(IV newIV) {
                            bValue.setIV(newIV);
                        }
                    });
                }
                newBs.addBinding(entry.getName(), value);
            }
            return newBs;
        }
        return bs;
    }

    private Dataset handleDataset(AbstractTripleStore store, Dataset dataset) {
        if (dataset != null) {
            URI value;
            DatasetImpl newDataset = new DatasetImpl();
            for (URI uri : dataset.getDefaultGraphs()) {
                value = this.handleDatasetGraph(store, uri);
                newDataset.addDefaultGraph(value);
            }
            for (URI uri : dataset.getDefaultRemoveGraphs()) {
                value = this.handleDatasetGraph(store, uri);
                newDataset.addDefaultRemoveGraph(value);
            }
            for (URI uri : dataset.getNamedGraphs()) {
                value = this.handleDatasetGraph(store, uri);
                newDataset.addNamedGraph(value);
            }
            URI value2 = this.handleDatasetGraph(store, dataset.getDefaultInsertGraph());
            newDataset.setDefaultInsertGraph(value2);
            return newDataset;
        }
        return dataset;
    }

    private URI handleDatasetGraph(AbstractTripleStore store, URI uri) {
        URI value = uri;
        if (value != null && !(value instanceof BigdataValue)) {
            value = store.getValueFactory().asValue(value);
        }
        if (value instanceof BigdataValue) {
            final BigdataValue bValue = (BigdataValue)((Object)value);
            this.defer((BigdataValue)((Object)value), new Handler(){

                @Override
                public void handle(IV newIV) {
                    bValue.setIV(newIV);
                }
            });
        }
        return value;
    }

    private void fillInIV(AbstractTripleStore store, final BOp bop) {
        if (bop == null) {
            return;
        }
        if (bop instanceof ConstantNode) {
            BigdataValue value = ((ConstantNode)bop).getValue();
            if (value != null) {
                this.defer(value, new Handler(){

                    @Override
                    public void handle(IV newIV) {
                        ((ConstantNode)bop).setArg(0, new Constant<IV>(newIV));
                    }
                });
            }
            return;
        }
        for (int k = 0; k < bop.arity(); ++k) {
            BOp pathBop = bop.get(k);
            if (pathBop instanceof Constant) {
                Object v = ((Constant)pathBop).get();
                final int fk = k;
                if (v instanceof BigdataValue) {
                    this.defer((BigdataValue)v, new Handler(){

                        @Override
                        public void handle(IV newIV) {
                            bop.args().set(fk, new Constant<IV>(newIV));
                        }
                    });
                    continue;
                }
                if (!(v instanceof TermId)) continue;
                this.defer((BigdataValue)((TermId)v).getValue(), new Handler(){

                    @Override
                    public void handle(IV newIV) {
                        if (bop instanceof BOpBase) {
                            ((BOpBase)bop).__replaceArg(fk, new Constant<IV>(newIV));
                        } else {
                            List<BOp> args = bop.args();
                            if (args instanceof ArrayList) {
                                args.set(fk, new Constant<IV>(newIV));
                            } else {
                                log.warn("bop.args() class " + args.getClass() + " or " + bop.getClass() + " does not allow updates");
                            }
                        }
                    }
                });
                continue;
            }
            this.fillInIV(store, pathBop);
        }
        if (bop instanceof AbstractOneGraphManagement) {
            this.fillInIV(store, ((AbstractOneGraphManagement)bop).getTargetGraph());
        }
        if (bop instanceof AbstractFromToGraphManagement) {
            this.fillInIV(store, ((AbstractFromToGraphManagement)bop).getSourceGraph());
            this.fillInIV(store, ((AbstractFromToGraphManagement)bop).getTargetGraph());
        }
        if (bop instanceof AbstractGraphDataUpdate) {
            AbstractGraphDataUpdate update = (AbstractGraphDataUpdate)bop;
            if (!store.isQuads()) {
                for (BigdataStatement sp : update.getData()) {
                    if (sp.getContext() == null) continue;
                    throw new QuadsOperationInTriplesModeException("Quads in SPARQL update data block are not supported in triples mode.");
                }
            }
        }
        if (bop instanceof DeleteInsertGraph) {
            this.fillInIV(store, ((DeleteInsertGraph)bop).getDataset());
            this.fillInIV(store, ((DeleteInsertGraph)bop).getDeleteClause());
            this.fillInIV(store, ((DeleteInsertGraph)bop).getInsertClause());
            this.fillInIV(store, ((DeleteInsertGraph)bop).getWhereClause());
        } else if (bop instanceof QuadsDataOrNamedSolutionSet) {
            this.fillInIV(store, ((QuadsDataOrNamedSolutionSet)bop).getQuadData());
        } else if (bop instanceof DatasetNode) {
            final DatasetNode dataset = (DatasetNode)bop;
            final LinkedHashSet newDefaultGraphs = new LinkedHashSet();
            for (IV iv : dataset.getDefaultGraphs().getGraphs()) {
                this.defer((BigdataValue)iv.getValue(), new Handler(){

                    @Override
                    public void handle(IV newIV) {
                        newDefaultGraphs.add(newIV);
                    }
                });
            }
            this.deferRunnable(new Runnable(){

                @Override
                public void run() {
                    dataset.setDefaultGraphs(new DataSetSummary(newDefaultGraphs, true));
                }
            });
            final LinkedHashSet newNamedGraphs = new LinkedHashSet();
            for (IV iv : dataset.getNamedGraphs().getGraphs()) {
                this.defer((BigdataValue)iv.getValue(), new Handler(){

                    @Override
                    public void handle(IV newIV) {
                        newNamedGraphs.add(newIV);
                    }
                });
            }
            this.deferRunnable(new Runnable(){

                @Override
                public void run() {
                    dataset.setNamedGraphs(new DataSetSummary(newNamedGraphs, true));
                }
            });
        } else if (bop instanceof PathNode) {
            PathNode.PathAlternative path = ((PathNode)bop).getPathAlternative();
            for (int k = 0; k < path.arity(); ++k) {
                BOp pathBop = path.get(k);
                this.fillInIV(store, pathBop);
            }
        } else if (bop instanceof FunctionNode) {
            Object value;
            IValueExpression<? extends IV> fve;
            if (bop instanceof SubqueryFunctionNodeBase) {
                this.fillInIV(store, ((SubqueryFunctionNodeBase)bop).getGraphPattern());
            }
            if ((fve = ((FunctionNode)bop).getValueExpression()) instanceof IVValueExpression) {
                for (int k = 0; k < fve.arity(); ++k) {
                    BOp veBop = fve.get(k);
                    if (veBop instanceof Constant && ((Constant)veBop).get() instanceof IV && ((IV)((Constant)veBop).get()).hasValue()) {
                        Object v = ((IV)((Constant)veBop).get()).getValue();
                        int fk = k;
                        this.defer((BigdataValue)v, new Handler((BigdataValue)v, bop, fk){
                            final /* synthetic */ BigdataValue val$v;
                            final /* synthetic */ BOp val$bop;
                            final /* synthetic */ int val$fk;
                            {
                                this.val$v = bigdataValue;
                                this.val$bop = bOp;
                                this.val$fk = n;
                            }

                            @Override
                            public void handle(IV newIV) {
                                BigdataValue resolved = ASTDeferredIVResolution.this.vf.asValue(this.val$v);
                                if (resolved.getIV() == null && newIV != null) {
                                    resolved.setIV(newIV);
                                    newIV.setValue(resolved);
                                    Constant<IV> newConstant = new Constant<IV>(newIV);
                                    IValueExpression<? extends IV> fve = ((ValueExpressionNode)this.val$bop).getValueExpression();
                                    IValueExpression newVe = (IValueExpression)((Object)((IVValueExpression)fve).setArg(this.val$fk, newConstant));
                                    ((ValueExpressionNode)this.val$bop).setValueExpression(newVe);
                                    ((ValueExpressionNode)this.val$bop).setArg(this.val$fk, new ConstantNode((IConstant<IV>)newConstant));
                                }
                            }
                        });
                        continue;
                    }
                    if (!(veBop instanceof IVValueExpression)) continue;
                    this.fillInIV(store, veBop);
                }
            } else if (fve instanceof Constant && (value = ((Constant)fve).get()) instanceof BigdataValue) {
                this.defer((BigdataValue)value, new Handler(){

                    @Override
                    public void handle(IV newIV) {
                        ((FunctionNode)bop).setValueExpression(new Constant<IV>(newIV));
                    }
                });
            }
        } else if (bop instanceof ValueExpressionNode) {
            IValueExpression<? extends IV> ve = ((ValueExpressionNode)bop).getValueExpression();
            for (int k = 0; k < ve.arity(); ++k) {
                BOp pathBop = ve.get(k);
                this.fillInIV(store, pathBop);
            }
        } else if (bop instanceof GroupNodeBase) {
            this.fillInIV(store, ((GroupNodeBase)bop).getContext());
        } else if (bop instanceof StatementPatternNode) {
            StatementPatternNode sp = (StatementPatternNode)bop;
            if (!store.isQuads() && sp.getScope() != null && !StatementPattern.Scope.DEFAULT_CONTEXTS.equals((Object)sp.getScope())) {
                throw new QuadsOperationInTriplesModeException("Use of WITH and GRAPH constructs in query body is not supported in triples mode.");
            }
        } else if (bop instanceof ServiceNode) {
            final ServiceNode node = (ServiceNode)bop;
            TermNode serviceRef = node.getServiceRef();
            this.defer(serviceRef.getValue(), new Handler(){

                @Override
                public void handle(IV newIV) {
                    node.setServiceRef(new ConstantNode((IConstant<IV>)new Constant<IV>(newIV)));
                }
            });
            this.fillInIV(store, node.getGraphPattern());
        } else if (bop instanceof QueryBase) {
            QueryBase subquery = (QueryBase)bop;
            this.prepare(store, subquery);
        } else if (bop instanceof BindingsClause) {
            List<IBindingSet> bsList = ((BindingsClause)bop).getBindingSets();
            if (bsList != null) {
                for (IBindingSet bs : bsList) {
                    this.handleBindingSet(store, bs);
                }
            }
        } else if (bop instanceof FilterNode) {
            FilterNode node = (FilterNode)bop;
            this.fillInIV(store, node.getValueExpression());
        }
    }

    private void resolveIVs(AbstractTripleStore store) {
        BigdataValue toBeResolved;
        LinkedList<BigdataURI> vocab = new LinkedList<BigdataURI>();
        vocab.add(this.vf.asValue(RDF.FIRST));
        vocab.add(this.vf.asValue(RDF.REST));
        vocab.add(this.vf.asValue(RDF.NIL));
        vocab.add(this.vf.asValue(BD.VIRTUAL_GRAPH));
        int nvalues = this.deferred.size() + vocab.size();
        IV[] ivs = new IV[nvalues];
        Object[] values = new BigdataValue[nvalues];
        int i = 0;
        Iterator<Object> i$ = vocab.iterator();
        while (i$.hasNext()) {
            BigdataValue v;
            toBeResolved = v = (BigdataValue)i$.next();
            ivs[i] = TermId.mockIV(VTE.valueOf(v));
            if (!toBeResolved.isRealIV()) {
                toBeResolved.clearInternalValue();
            }
            values[i++] = toBeResolved;
        }
        for (BigdataValue v : this.deferred.keySet()) {
            toBeResolved = this.vf.asValue(v);
            ivs[i] = v.getIV();
            if (!toBeResolved.isRealIV()) {
                toBeResolved.clearInternalValue();
            }
            values[i++] = toBeResolved;
        }
        if (log.isDebugEnabled()) {
            log.debug("UNKNOWNS: " + Arrays.toString(values));
        }
        store.getLexiconRelation().addTerms((BigdataValue[])values, values.length, true);
        for (i = 0; i < values.length; ++i) {
            IV iv;
            Object v = values[i];
            if (v.isRealIV()) {
                if (log.isDebugEnabled()) {
                    log.debug("RESOLVED: " + v + " => " + v.getIV());
                }
                iv = v.getIV();
            } else if (v instanceof Literal) {
                String label = ((Literal)v).getLabel();
                URI dataType = ((Literal)v).getDatatype();
                String language = ((Literal)v).getLanguage();
                BigdataLiteral resolved = language != null ? this.vf.createLiteral(label, language) : this.vf.createLiteral(label, dataType);
                DTE dte = DTE.valueOf(dataType);
                iv = dte != null ? (label.isEmpty() ? ivs[i] : TermId.mockIV(VTE.valueOf((Value)v))) : TermId.mockIV(VTE.valueOf((Value)v));
                iv.setValue(resolved);
                resolved.setIV(iv);
            } else {
                iv = ivs[i] != null ? ivs[i] : TermId.mockIV(VTE.valueOf((Value)v));
            }
            if (iv == null) continue;
            iv.setValue(v);
            v.setIV(iv);
            List<Handler> deferredHandlers = this.deferred.get(v);
            if (deferredHandlers != null) {
                for (Handler handler : deferredHandlers) {
                    handler.handle(iv);
                }
            }
            this.resolvedValues.put((Value)v, iv);
        }
        for (Runnable r : this.deferredRunnables) {
            r.run();
        }
    }

    static class DeferredResolutionResult {
        BindingSet bindingSet;
        Dataset dataset;

        public DeferredResolutionResult(BindingSet bindingSet, Dataset dataset) {
            this.bindingSet = bindingSet;
            this.dataset = dataset;
        }
    }

    private static interface Handler {
        public void handle(IV var1);
    }
}

