/*
 * Decompiled with CFR 0.152.
 */
package com.bigdata.rdf.sparql.ast.eval;

import com.bigdata.bop.IBindingSet;
import com.bigdata.bop.bindingSet.ListBindingSet;
import com.bigdata.rdf.internal.IV;
import com.bigdata.rdf.model.BigdataBNode;
import com.bigdata.rdf.model.BigdataStatement;
import com.bigdata.rdf.model.BigdataValue;
import com.bigdata.rdf.sparql.ast.ASTContainer;
import com.bigdata.rdf.sparql.ast.AssignmentNode;
import com.bigdata.rdf.sparql.ast.ConstantNode;
import com.bigdata.rdf.sparql.ast.DescribeModeEnum;
import com.bigdata.rdf.sparql.ast.ProjectionNode;
import com.bigdata.rdf.sparql.ast.QueryRoot;
import com.bigdata.rdf.sparql.ast.QueryType;
import com.bigdata.rdf.sparql.ast.VarNode;
import com.bigdata.rdf.sparql.ast.eval.AST2BOpContext;
import com.bigdata.rdf.sparql.ast.eval.AST2BOpUtility;
import com.bigdata.rdf.sparql.ast.eval.ASTConstructIterator;
import com.bigdata.rdf.sparql.ast.eval.ASTEvalHelper;
import com.bigdata.rdf.store.AbstractTripleStore;
import info.aduna.iteration.CloseableIteration;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;
import org.openrdf.query.BindingSet;
import org.openrdf.query.QueryEvaluationException;
import org.openrdf.query.algebra.evaluation.iterator.CollectionIteration;

public class CBD {
    private static final Logger log = Logger.getLogger(CBD.class);
    private final AbstractTripleStore store;
    private final DescribeModeEnum describeMode;
    private final int describeIterationLimit;
    private final int describeStatementLimit;
    private final DescribeModeEnum describeExpansionMode;
    private final Map<String, BigdataBNode> bnodes;

    public CBD(AbstractTripleStore store, DescribeModeEnum describeMode, int describeIterationLimit, int describeStatementLimit, Map<String, BigdataBNode> bnodes) {
        if (store == null) {
            throw new IllegalArgumentException();
        }
        if (describeMode == null) {
            throw new IllegalArgumentException();
        }
        if (describeIterationLimit < 0) {
            throw new IllegalArgumentException();
        }
        if (describeStatementLimit < 0) {
            throw new IllegalArgumentException();
        }
        if (bnodes == null) {
            throw new IllegalArgumentException();
        }
        this.store = store;
        this.describeMode = describeMode;
        this.describeIterationLimit = describeIterationLimit;
        this.describeStatementLimit = describeStatementLimit;
        this.bnodes = bnodes;
        switch (describeMode) {
            case CBD: {
                this.describeExpansionMode = DescribeModeEnum.ForwardOneStep;
                break;
            }
            case SCBD: {
                this.describeExpansionMode = DescribeModeEnum.SymmetricOneStep;
                break;
            }
            case ForwardOneStep: 
            case SymmetricOneStep: {
                throw new UnsupportedOperationException();
            }
            default: {
                throw new AssertionError();
            }
        }
    }

    CloseableIteration<BigdataStatement, QueryEvaluationException> computeClosure(CloseableIteration<BigdataStatement, QueryEvaluationException> src) throws QueryEvaluationException {
        int nrounds = 0;
        LinkedHashSet bnodes_tm1 = new LinkedHashSet();
        LinkedHashSet<BigdataStatement> stmts = new LinkedHashSet<BigdataStatement>();
        while (true) {
            int nstmts;
            if (this.cutoffQuery(++nrounds - 1, nstmts = stmts.size())) {
                src.close();
                throw new QueryEvaluationException("CBD cutoff: nrounds=" + nrounds + ", nstatements=" + nstmts + ".");
            }
            Set<IV<?, ?>> newBnodes = CBD.consumeStatements(src, stmts, bnodes_tm1);
            if (newBnodes.isEmpty()) break;
            if (log.isInfoEnabled()) {
                log.info("#rounds=" + nrounds + ", describeMode=" + (Object)((Object)this.describeMode) + ", #stmts(in)=" + stmts.size() + ", #bnodes(in)=" + bnodes_tm1.size() + ", #bnodes(new)=" + newBnodes.size() + " : " + newBnodes);
                this.logState(stmts, bnodes_tm1, newBnodes);
            }
            src = this.doRound(newBnodes);
            bnodes_tm1.addAll(newBnodes);
        }
        if (log.isInfoEnabled()) {
            log.info("#rounds=" + nrounds + " (done), describeMode=" + (Object)((Object)this.describeMode) + ", #stmts(in)=" + stmts.size() + ", #bnodes(in)=" + bnodes_tm1.size());
            this.logState(stmts, bnodes_tm1, null);
        }
        return new CollectionIteration<BigdataStatement, QueryEvaluationException>(stmts);
    }

    private boolean cutoffQuery(int nrounds, int nstmts) {
        int describeIterationLimit = this.describeIterationLimit == 0 ? Integer.MAX_VALUE : this.describeIterationLimit;
        int describeStatementLimit = this.describeStatementLimit == 0 ? Integer.MAX_VALUE : this.describeStatementLimit;
        boolean cutoffRounds = nrounds >= describeIterationLimit;
        boolean cutoffStatements = nstmts >= describeStatementLimit;
        return cutoffRounds && cutoffStatements;
    }

    private void logState(Set<BigdataStatement> stmts, Set<IV<?, ?>> bnodes_tm1, Set<IV<?, ?>> newBnodes) {
        if (!log.isDebugEnabled()) {
            return;
        }
        StringBuilder sb = new StringBuilder(stmts.size() * 100);
        sb.append("Statements: (" + stmts.size() + ")\n");
        for (BigdataStatement bigdataStatement : stmts) {
            sb.append(bigdataStatement.toString());
            sb.append("\n");
        }
        log.debug(sb.toString());
        sb.setLength(0);
        sb.append("BNodes(t-1): (" + bnodes_tm1.size() + ")\n");
        for (IV iV : bnodes_tm1) {
            sb.append(iV.toString());
            sb.append("\n");
        }
        log.debug(sb.toString());
        if (newBnodes != null) {
            sb.setLength(0);
            sb.append("BNodes(new): (" + newBnodes.size() + ")\n");
            for (IV iV : newBnodes) {
                sb.append(iV.toString());
                sb.append("\n");
            }
            log.debug(sb.toString());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Set<IV<?, ?>> consumeStatements(CloseableIteration<BigdataStatement, QueryEvaluationException> src, Set<BigdataStatement> stmts, Set<IV<?, ?>> bnodes_tm1) throws QueryEvaluationException {
        LinkedHashSet newBnodes = new LinkedHashSet();
        try {
            while (src.hasNext()) {
                BigdataStatement stmt = (BigdataStatement)src.next();
                if (!stmts.add(stmt)) continue;
                CBD.collectBNodeIVs(bnodes_tm1, newBnodes, CBD.getBNodeIV(stmt.getSubject()));
                CBD.collectBNodeIVs(bnodes_tm1, newBnodes, CBD.getBNodeIV(stmt.getObject()));
                CBD.collectBNodeIVs(bnodes_tm1, newBnodes, CBD.getBNodeIV(stmt.getContext()));
            }
            LinkedHashSet linkedHashSet = newBnodes;
            return linkedHashSet;
        }
        finally {
            src.close();
        }
    }

    private CloseableIteration<BigdataStatement, QueryEvaluationException> doRound(Set<IV<?, ?>> bnodeIVs) throws QueryEvaluationException {
        ASTContainer astContainer = this.getDescribeQuery(bnodeIVs);
        AST2BOpContext context = new AST2BOpContext(astContainer, this.store);
        astContainer.clearOptimizedAST();
        IBindingSet[] bindingSets = new IBindingSet[]{new ListBindingSet()};
        AST2BOpUtility.convert(context, bindingSets);
        QueryRoot optimizedQuery = astContainer.getOptimizedAST();
        if (log.isDebugEnabled()) {
            log.debug("describeMode=" + (Object)((Object)this.describeMode) + ", expansionMode=" + (Object)((Object)this.describeExpansionMode));
            log.debug("OriginalAST: " + astContainer.getOriginalAST());
            log.debug("OptimizedAST: " + optimizedQuery);
        }
        boolean materializeProjectionInQuery = context.materializeProjectionInQuery && !optimizedQuery.hasSlice();
        CloseableIteration<BindingSet, QueryEvaluationException> solutions = ASTEvalHelper.evaluateQuery(astContainer, context, materializeProjectionInQuery, optimizedQuery.getProjection().getProjectionVars());
        ASTConstructIterator src = new ASTConstructIterator(context, this.store, optimizedQuery.getConstruct(), optimizedQuery.getWhereClause(), this.bnodes, solutions);
        return src;
    }

    private ASTContainer getDescribeQuery(Set<IV<?, ?>> bnodeIVs) {
        Map<IV<?, ?>, BigdataValue> terms = this.store.getLexiconRelation().getTerms(bnodeIVs);
        for (Map.Entry<IV<?, ?>, BigdataValue> e : terms.entrySet()) {
            e.getKey().setValue(e.getValue());
        }
        QueryRoot queryRoot = new QueryRoot(QueryType.DESCRIBE);
        ProjectionNode projection = new ProjectionNode();
        queryRoot.setProjection(projection);
        projection.setDescribeMode(this.describeExpansionMode);
        int i = 1;
        for (IV<?, ?> iv : bnodeIVs) {
            if (!iv.hasValue()) {
                throw new AssertionError((Object)("valueCache not set : " + iv));
            }
            VarNode anonvar = new VarNode("-cbd-bnode-" + i++);
            anonvar.setAnonymous(true);
            projection.addProjectionExpression(new AssignmentNode(anonvar, new ConstantNode(iv)));
        }
        return new ASTContainer(queryRoot);
    }

    private static void collectBNodeIVs(Set<IV<?, ?>> bnodes_tm1, Set<IV<?, ?>> newBnodes, IV<?, ?> bNodeIV) {
        if (bNodeIV == null) {
            return;
        }
        if (bnodes_tm1.contains(bNodeIV)) {
            return;
        }
        newBnodes.add(bNodeIV);
    }

    private static IV<?, ?> getBNodeIV(BigdataValue v) {
        if (v == null) {
            return null;
        }
        BigdataBNode bnode = (BigdataBNode)(v instanceof BigdataBNode ? v : null);
        if (bnode == null) {
            return null;
        }
        IV iv = bnode.getIV();
        return iv;
    }
}

