/*
 * Decompiled with CFR 0.152.
 */
package com.bigdata.rdf.sparql.ast.eval;

import com.bigdata.bop.BOp;
import com.bigdata.bop.BOpContextBase;
import com.bigdata.bop.Constant;
import com.bigdata.bop.IBindingSet;
import com.bigdata.bop.IPredicate;
import com.bigdata.bop.IVariable;
import com.bigdata.bop.NV;
import com.bigdata.bop.ap.SampleIndex;
import com.bigdata.bop.bindingSet.EmptyBindingSet;
import com.bigdata.bop.bindingSet.ListBindingSet;
import com.bigdata.bop.fed.QueryEngineFactory;
import com.bigdata.rdf.internal.IV;
import com.bigdata.rdf.sparql.ast.GroupNodeBase;
import com.bigdata.rdf.sparql.ast.IGroupMemberNode;
import com.bigdata.rdf.sparql.ast.StatementPatternNode;
import com.bigdata.rdf.sparql.ast.TermNode;
import com.bigdata.rdf.sparql.ast.eval.AbstractServiceFactory;
import com.bigdata.rdf.sparql.ast.eval.ServiceParams;
import com.bigdata.rdf.sparql.ast.service.BigdataNativeServiceOptions;
import com.bigdata.rdf.sparql.ast.service.BigdataServiceCall;
import com.bigdata.rdf.sparql.ast.service.IServiceOptions;
import com.bigdata.rdf.sparql.ast.service.ServiceCallCreateParams;
import com.bigdata.rdf.sparql.ast.service.ServiceFactory;
import com.bigdata.rdf.sparql.ast.service.ServiceNode;
import com.bigdata.rdf.spo.ISPO;
import com.bigdata.rdf.store.AbstractTripleStore;
import com.bigdata.rdf.store.BD;
import com.bigdata.relation.accesspath.EmptyCloseableIterator;
import com.bigdata.relation.accesspath.ThickCloseableIterator;
import cutthecrap.utils.striterators.ICloseableIterator;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;
import org.openrdf.model.Resource;
import org.openrdf.model.URI;
import org.openrdf.model.impl.URIImpl;

public class SampleServiceFactory
extends AbstractServiceFactory
implements ServiceFactory {
    private static final Logger log = Logger.getLogger(SampleServiceFactory.class);
    public static final URI SERVICE_KEY = new URIImpl("http://www.bigdata.com/rdf#sample");
    private final BigdataNativeServiceOptions serviceOptions = new BigdataNativeServiceOptions();

    public SampleServiceFactory() {
        this.serviceOptions.setRunFirst(true);
    }

    @Override
    public BigdataNativeServiceOptions getServiceOptions() {
        return this.serviceOptions;
    }

    @Override
    public BigdataServiceCall create(ServiceCallCreateParams params, ServiceParams serviceParams) {
        AbstractTripleStore store = params.getTripleStore();
        ServiceNode serviceNode = params.getServiceNode();
        StatementPatternNode sp = this.verifyGraphPattern(store, serviceNode.getGraphPattern(), serviceParams);
        return new SampleCall(store, sp, this.getServiceOptions(), serviceParams);
    }

    private StatementPatternNode verifyGraphPattern(AbstractTripleStore database, GroupNodeBase<IGroupMemberNode> group, ServiceParams serviceParams) {
        Iterator<Map.Entry<URI, List<TermNode>>> it = serviceParams.iterator();
        while (it.hasNext()) {
            URI param = it.next().getKey();
            if (SampleParams.LIMIT.equals(param)) {
                if (serviceParams.getAsInt(param, null) != null) continue;
                throw new RuntimeException("must provide a value for: " + param);
            }
            if (SampleParams.SEED.equals(param)) {
                if (serviceParams.getAsLong(param, null) != null) continue;
                throw new RuntimeException("must provide a value for: " + param);
            }
            if (SampleParams.SAMPLE_TYPE.equals(param)) {
                if (serviceParams.getAsString(param, null) != null) continue;
                throw new RuntimeException("must provide a value for: " + param);
            }
            throw new RuntimeException("unrecognized param: " + param);
        }
        StatementPatternNode sp = null;
        for (IGroupMemberNode node : group) {
            if (!(node instanceof StatementPatternNode)) {
                throw new RuntimeException("only statement patterns allowed");
            }
            StatementPatternNode tmp = (StatementPatternNode)node;
            if (tmp.s().isConstant() && BD.SERVICE_PARAM.equals(tmp.s().getValue())) continue;
            if (sp != null) {
                throw new RuntimeException("group must contain a single statement pattern");
            }
            sp = tmp;
        }
        return sp;
    }

    private static class SampleCall
    implements BigdataServiceCall {
        private final AbstractTripleStore db;
        private final StatementPatternNode sp;
        private final IServiceOptions serviceOptions;
        private final ServiceParams serviceParams;

        public SampleCall(AbstractTripleStore db, StatementPatternNode sp, IServiceOptions serviceOptions, ServiceParams serviceParams) {
            if (db == null) {
                throw new IllegalArgumentException();
            }
            if (sp == null) {
                throw new IllegalArgumentException();
            }
            if (serviceOptions == null) {
                throw new IllegalArgumentException();
            }
            if (serviceParams == null) {
                throw new IllegalArgumentException();
            }
            this.db = db;
            this.sp = sp;
            this.serviceOptions = serviceOptions;
            this.serviceParams = serviceParams;
        }

        public ICloseableIterator<IBindingSet> call(IBindingSet[] bc) {
            if (log.isInfoEnabled()) {
                log.info(bc.length);
                log.info(Arrays.toString(bc));
                log.info(this.serviceParams);
            }
            if (bc != null && bc.length > 0 && !bc[0].equals(EmptyBindingSet.INSTANCE)) {
                throw new RuntimeException("cannot run with incoming bindings");
            }
            IPredicate pred = this.db.getPredicate(this.sp.s() != null && this.sp.s().isConstant() ? (Resource)((Object)this.sp.s().getValue()) : null, this.sp.p() != null && this.sp.p().isConstant() ? (URI)((Object)this.sp.p().getValue()) : null, this.sp.o() != null && this.sp.o().isConstant() ? this.sp.o().getValue() : null, this.sp.c() != null && this.sp.c().isConstant() ? (Resource)((Object)this.sp.c().getValue()) : null);
            if (pred == null) {
                return new EmptyCloseableIterator<IBindingSet>();
            }
            pred = (IPredicate)pred.setProperty(IPredicate.Annotations.TIMESTAMP, this.db.getSPORelation().getTimestamp());
            int limit = this.serviceParams.getAsInt(SampleParams.LIMIT, 100);
            long seed = this.serviceParams.getAsLong(SampleParams.SEED, 0L);
            String type = this.serviceParams.getAsString(SampleParams.SAMPLE_TYPE, SampleParams.DEFAULT_SAMPLE_TYPE);
            SampleIndex sampleOp = new SampleIndex(new BOp[0], NV.asMap(new NV(SampleIndex.Annotations.PREDICATE, pred), new NV(SampleIndex.Annotations.LIMIT, limit), new NV(SampleIndex.Annotations.SEED, seed), new NV(SampleIndex.Annotations.SAMPLE_TYPE, type)));
            BOpContextBase context = new BOpContextBase(QueryEngineFactory.getInstance().getQueryController(this.db.getIndexManager()));
            ISPO[] elements = (ISPO[])sampleOp.eval(context);
            IBindingSet[] bSets = new IBindingSet[elements.length];
            for (int i = 0; i < elements.length; ++i) {
                bSets[i] = new ListBindingSet();
                if (this.sp.s() != null && this.sp.s().isVariable()) {
                    bSets[i].set((IVariable)this.sp.s().getValueExpression(), new Constant<IV>(elements[i].s()));
                }
                if (this.sp.p() != null && this.sp.p().isVariable()) {
                    bSets[i].set((IVariable)this.sp.p().getValueExpression(), new Constant<IV>(elements[i].p()));
                }
                if (this.sp.o() != null && this.sp.o().isVariable()) {
                    bSets[i].set((IVariable)this.sp.o().getValueExpression(), new Constant<IV>(elements[i].o()));
                }
                if (this.sp.c() == null || !this.sp.c().isVariable()) continue;
                bSets[i].set((IVariable)this.sp.c().getValueExpression(), new Constant<IV>(elements[i].c()));
            }
            return new ThickCloseableIterator<IBindingSet>(bSets, bSets.length);
        }

        @Override
        public IServiceOptions getServiceOptions() {
            return this.serviceOptions;
        }
    }

    public static interface SampleParams {
        public static final URI LIMIT = new URIImpl(SERVICE_KEY.stringValue() + ".limit");
        public static final int DEFAULT_LIMIT = 100;
        public static final URI SEED = new URIImpl(SERVICE_KEY.stringValue() + ".seed");
        public static final long DEFAULT_SEED = 0L;
        public static final URI SAMPLE_TYPE = new URIImpl(SERVICE_KEY.stringValue() + ".sampleType");
        public static final String DEFAULT_SAMPLE_TYPE = SampleIndex.Annotations.DEFAULT_SAMPLE_TYPE;
    }
}

