/*
 * Decompiled with CFR 0.152.
 */
package com.bigdata.rdf.sparql.ast.eval;

import com.bigdata.bop.BOp;
import com.bigdata.bop.IBindingSet;
import com.bigdata.bop.IVariable;
import com.bigdata.bop.IVariableOrConstant;
import com.bigdata.bop.Var;
import com.bigdata.btree.IIndex;
import com.bigdata.cache.ConcurrentWeakValueCacheWithTimeout;
import com.bigdata.rdf.internal.IV;
import com.bigdata.rdf.lexicon.ITextIndexer;
import com.bigdata.rdf.lexicon.IValueCentricTextIndexer;
import com.bigdata.rdf.sparql.ast.ConstantNode;
import com.bigdata.rdf.sparql.ast.GroupNodeBase;
import com.bigdata.rdf.sparql.ast.IGroupMemberNode;
import com.bigdata.rdf.sparql.ast.StatementPatternNode;
import com.bigdata.rdf.sparql.ast.TermNode;
import com.bigdata.rdf.sparql.ast.VarNode;
import com.bigdata.rdf.sparql.ast.eval.ASTSearchOptimizer;
import com.bigdata.rdf.sparql.ast.eval.AbstractServiceFactoryBase;
import com.bigdata.rdf.sparql.ast.service.BigdataNativeServiceOptions;
import com.bigdata.rdf.sparql.ast.service.BigdataServiceCall;
import com.bigdata.rdf.sparql.ast.service.IServiceOptions;
import com.bigdata.rdf.sparql.ast.service.ServiceCallCreateParams;
import com.bigdata.rdf.sparql.ast.service.ServiceNode;
import com.bigdata.rdf.spo.ISPO;
import com.bigdata.rdf.spo.SPOKeyOrder;
import com.bigdata.rdf.store.AbstractTripleStore;
import com.bigdata.rdf.store.BDS;
import com.bigdata.relation.accesspath.EmptyCloseableIterator;
import com.bigdata.relation.accesspath.ThickCloseableIterator;
import com.bigdata.search.Hiterator;
import com.bigdata.search.IHit;
import com.bigdata.striterator.IChunkedOrderedIterator;
import cutthecrap.utils.striterators.ICloseableIterator;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import org.apache.log4j.Logger;
import org.openrdf.model.Literal;
import org.openrdf.model.URI;

public class SearchInSearchServiceFactory
extends AbstractServiceFactoryBase {
    private static final Logger log = Logger.getLogger(SearchInSearchServiceFactory.class);
    private final BigdataNativeServiceOptions serviceOptions = new BigdataNativeServiceOptions();

    @Override
    public BigdataNativeServiceOptions getServiceOptions() {
        return this.serviceOptions;
    }

    public BigdataServiceCall create(ServiceCallCreateParams params) {
        if (params == null) {
            throw new IllegalArgumentException();
        }
        AbstractTripleStore store = params.getTripleStore();
        if (store == null) {
            throw new IllegalArgumentException();
        }
        ServiceNode serviceNode = params.getServiceNode();
        if (serviceNode == null) {
            throw new IllegalArgumentException();
        }
        Map<IVariable<?>, Map<URI, StatementPatternNode>> map = this.verifyGraphPattern(store, serviceNode.getGraphPattern());
        if (map == null) {
            throw new RuntimeException("Not a search request.");
        }
        if (map.size() != 1) {
            throw new RuntimeException("Multiple search requests may not be combined.");
        }
        Map.Entry<IVariable<?>, Map<URI, StatementPatternNode>> e = map.entrySet().iterator().next();
        IVariable<?> searchVar = e.getKey();
        Map<URI, StatementPatternNode> statementPatterns = e.getValue();
        this.validateSearch(searchVar, statementPatterns);
        return new SearchCall(store, searchVar, statementPatterns, this.getServiceOptions());
    }

    private Map<IVariable<?>, Map<URI, StatementPatternNode>> verifyGraphPattern(AbstractTripleStore database, GroupNodeBase<IGroupMemberNode> group) {
        LinkedHashMap<IVariableOrConstant, LinkedHashMap<URI, StatementPatternNode>> tmp = null;
        int arity = group.arity();
        for (int i = 0; i < arity; ++i) {
            LinkedHashMap<URI, StatementPatternNode> statementPatterns;
            BOp child = group.get(i);
            if (child instanceof GroupNodeBase) {
                throw new RuntimeException("Nested groups are not allowed.");
            }
            if (!(child instanceof StatementPatternNode)) continue;
            StatementPatternNode sp = (StatementPatternNode)child;
            TermNode p = sp.p();
            if (!p.isConstant()) {
                throw new RuntimeException("Expecting search predicate: " + sp);
            }
            URI uri = (URI)((Object)((ConstantNode)p).getValue());
            if (!uri.stringValue().startsWith("http://www.bigdata.com/rdf/search#")) {
                throw new RuntimeException("Expecting search predicate: " + sp);
            }
            if (!ASTSearchOptimizer.searchUris.contains(uri) && !BDS.SEARCH_IN_SEARCH.equals(uri)) {
                throw new RuntimeException("Unknown search predicate: " + uri);
            }
            TermNode s = sp.s();
            if (!s.isVariable()) {
                throw new RuntimeException("Subject of search predicate is constant: " + sp);
            }
            IVariableOrConstant searchVar = ((VarNode)s).getValueExpression();
            if (tmp == null) {
                tmp = new LinkedHashMap<IVariableOrConstant, LinkedHashMap<URI, StatementPatternNode>>();
            }
            if ((statementPatterns = (LinkedHashMap<URI, StatementPatternNode>)tmp.get(searchVar)) == null) {
                statementPatterns = new LinkedHashMap<URI, StatementPatternNode>();
                tmp.put(searchVar, statementPatterns);
            }
            statementPatterns.put(uri, sp);
        }
        return tmp;
    }

    private void validateSearch(IVariable<?> searchVar, Map<URI, StatementPatternNode> statementPatterns) {
        LinkedHashSet<URI> uris = new LinkedHashSet<URI>();
        for (StatementPatternNode sp : statementPatterns.values()) {
            URI uri = (URI)((Object)sp.p().getValue());
            if (!uris.add(uri)) {
                throw new RuntimeException("Search predicate appears multiple times for same search variable: predicate=" + uri + ", searchVar=" + searchVar);
            }
            if (uri.equals(BDS.SEARCH_IN_SEARCH)) {
                this.assertObjectIsLiteral(sp);
                continue;
            }
            if (uri.equals(BDS.RELEVANCE) || uri.equals(BDS.RANK)) {
                this.assertObjectIsVariable(sp);
                continue;
            }
            if (uri.equals(BDS.MIN_RANK) || uri.equals(BDS.MAX_RANK)) {
                this.assertObjectIsLiteral(sp);
                continue;
            }
            if (uri.equals(BDS.MIN_RELEVANCE) || uri.equals(BDS.MAX_RELEVANCE)) {
                this.assertObjectIsLiteral(sp);
                continue;
            }
            if (uri.equals(BDS.MATCH_ALL_TERMS)) {
                this.assertObjectIsLiteral(sp);
                continue;
            }
            if (uri.equals(BDS.MATCH_EXACT)) {
                this.assertObjectIsLiteral(sp);
                continue;
            }
            if (uri.equals(BDS.SEARCH_TIMEOUT)) {
                this.assertObjectIsLiteral(sp);
                continue;
            }
            if (!uri.equals(BDS.MATCH_REGEX)) {
                throw new AssertionError((Object)("Unverified search predicate: " + sp));
            }
        }
        if (!uris.contains(BDS.SEARCH_IN_SEARCH)) {
            throw new RuntimeException("Required search predicate not found: " + BDS.SUBJECT_SEARCH + " for searchVar=" + searchVar);
        }
    }

    private void assertObjectIsLiteral(StatementPatternNode sp) {
        TermNode o = sp.o();
        if (!o.isConstant() || !(((ConstantNode)o).getValue() instanceof Literal)) {
            throw new IllegalArgumentException("Object is not literal: " + sp);
        }
    }

    private void assertObjectIsVariable(StatementPatternNode sp) {
        TermNode o = sp.o();
        if (!o.isVariable()) {
            throw new IllegalArgumentException("Object must be variable: " + sp);
        }
    }

    private static class SearchCall
    implements BigdataServiceCall {
        private final AbstractTripleStore store;
        private final IIndex osp;
        private final IServiceOptions serviceOptions;
        private final Literal query;
        private final IVariable<?>[] vars;
        private final Literal minRank;
        private final Literal maxRank;
        private final Literal minRelevance;
        private final Literal maxRelevance;
        private final boolean matchAllTerms;
        private final boolean matchExact;
        private final Literal searchTimeout;
        private final Literal matchRegex;
        private static final ConcurrentWeakValueCacheWithTimeout<String, Set<IV>> cache = new ConcurrentWeakValueCacheWithTimeout(10, 60000L);

        public SearchCall(AbstractTripleStore store, IVariable<?> searchVar, Map<URI, StatementPatternNode> statementPatterns, IServiceOptions serviceOptions) {
            if (store == null) {
                throw new IllegalArgumentException();
            }
            if (searchVar == null) {
                throw new IllegalArgumentException();
            }
            if (statementPatterns == null) {
                throw new IllegalArgumentException();
            }
            if (serviceOptions == null) {
                throw new IllegalArgumentException();
            }
            this.store = store;
            this.osp = store.getSPORelation().getIndex(SPOKeyOrder.OSP);
            this.serviceOptions = serviceOptions;
            StatementPatternNode sp = statementPatterns.get(BDS.SEARCH_IN_SEARCH);
            this.query = (Literal)((Object)sp.o().getValue());
            IVariable relVar = null;
            IVariable rankVar = null;
            Literal minRank = null;
            Literal maxRank = null;
            Literal minRelevance = null;
            Literal maxRelevance = null;
            boolean matchAllTerms = false;
            boolean matchExact = false;
            Literal searchTimeout = null;
            Literal matchRegex = null;
            for (StatementPatternNode meta : statementPatterns.values()) {
                IVariable oVar;
                URI p = (URI)((Object)meta.p().getValue());
                Literal oVal = meta.o().isConstant() ? (Literal)((Object)meta.o().getValue()) : null;
                IVariable iVariable = oVar = meta.o().isVariable() ? (IVariable)meta.o().getValueExpression() : null;
                if (BDS.RELEVANCE.equals(p)) {
                    relVar = oVar;
                    continue;
                }
                if (BDS.RANK.equals(p)) {
                    rankVar = oVar;
                    continue;
                }
                if (BDS.MIN_RANK.equals(p)) {
                    minRank = oVal;
                    continue;
                }
                if (BDS.MAX_RANK.equals(p)) {
                    maxRank = oVal;
                    continue;
                }
                if (BDS.MIN_RELEVANCE.equals(p)) {
                    minRelevance = oVal;
                    continue;
                }
                if (BDS.MAX_RELEVANCE.equals(p)) {
                    maxRelevance = oVal;
                    continue;
                }
                if (BDS.MATCH_ALL_TERMS.equals(p)) {
                    matchAllTerms = oVal.booleanValue();
                    continue;
                }
                if (BDS.MATCH_EXACT.equals(p)) {
                    matchExact = oVal.booleanValue();
                    continue;
                }
                if (BDS.SEARCH_TIMEOUT.equals(p)) {
                    searchTimeout = oVal;
                    continue;
                }
                if (!BDS.MATCH_REGEX.equals(p)) continue;
                matchRegex = oVal;
            }
            this.vars = new IVariable[]{searchVar, relVar == null ? Var.var() : relVar, rankVar == null ? Var.var() : rankVar};
            this.minRank = minRank;
            this.maxRank = maxRank;
            this.minRelevance = minRelevance;
            this.maxRelevance = maxRelevance;
            this.matchAllTerms = matchAllTerms;
            this.matchExact = matchExact;
            this.searchTimeout = searchTimeout;
            this.matchRegex = matchRegex;
        }

        private Hiterator<IHit<?>> getHiterator() {
            boolean prefixMatch;
            IValueCentricTextIndexer<?> textIndex = this.store.getLexiconRelation().getSearchEngine();
            if (textIndex == null) {
                throw new UnsupportedOperationException("No free text index?");
            }
            String s = this.query.getLabel();
            if (s.indexOf(42) >= 0) {
                prefixMatch = true;
                s = s.replaceAll("\\*", "");
            } else {
                prefixMatch = false;
            }
            return textIndex.search(new ITextIndexer.FullTextQuery(s, this.query.getLanguage(), prefixMatch, this.matchRegex == null ? null : this.matchRegex.stringValue(), this.matchAllTerms, this.matchExact, this.minRelevance == null ? 0.0 : this.minRelevance.doubleValue(), this.maxRelevance == null ? 1.0 : this.maxRelevance.doubleValue(), this.minRank == null ? 1 : this.minRank.intValue(), this.maxRank == null ? Integer.MAX_VALUE : this.maxRank.intValue(), this.searchTimeout == null ? Long.MAX_VALUE : this.searchTimeout.longValue(), TimeUnit.MILLISECONDS));
        }

        private Set<IV> getSubjects() {
            String s = this.query.getLabel();
            if (cache.containsKey(s)) {
                return (Set)cache.get(s);
            }
            if (log.isInfoEnabled()) {
                log.info("entering full text search...");
            }
            Hiterator<IHit<?>> src = this.getHiterator();
            if (log.isInfoEnabled()) {
                log.info("done with full text search.");
            }
            if (log.isInfoEnabled()) {
                log.info("starting subject collection...");
            }
            LinkedHashSet<IV> subjects = new LinkedHashSet<IV>();
            while (src.hasNext()) {
                IV o = (IV)src.next().getDocId();
                IChunkedOrderedIterator<ISPO> it = this.store.getAccessPath((IV)null, (IV)null, o).iterator();
                while (it.hasNext()) {
                    subjects.add(((ISPO)it.next()).s());
                }
            }
            if (log.isInfoEnabled()) {
                log.info("done with subject collection: " + subjects.size());
            }
            cache.put(s, subjects);
            return subjects;
        }

        public ICloseableIterator<IBindingSet> call(IBindingSet[] bindingsClause) {
            if (log.isInfoEnabled()) {
                log.info(bindingsClause.length);
                log.info(Arrays.toString(bindingsClause));
            }
            IVariable<?> searchVar = this.vars[0];
            boolean foundOne = false;
            for (int i = 0; i < bindingsClause.length; ++i) {
                IBindingSet bs = bindingsClause[i];
                if (!bs.isBound(searchVar)) continue;
                foundOne = true;
            }
            if (!foundOne) {
                return new EmptyCloseableIterator<IBindingSet>();
            }
            IBindingSet[] out = new IBindingSet[bindingsClause.length];
            int numAccepted = 0;
            Set<IV> subjects = this.getSubjects();
            for (int i = 0; i < bindingsClause.length; ++i) {
                IV s = (IV)bindingsClause[i].get(searchVar).get();
                if (!subjects.contains(s)) continue;
                out[numAccepted++] = bindingsClause[i];
            }
            if (log.isInfoEnabled()) {
                log.info("finished search in search.");
            }
            return new ThickCloseableIterator<IBindingSet>(out, numAccepted);
        }

        @Override
        public IServiceOptions getServiceOptions() {
            return this.serviceOptions;
        }
    }
}

