/*
 * Decompiled with CFR 0.152.
 */
package com.bigdata.rdf.sparql.ast.eval;

import com.bigdata.bop.IBindingSet;
import com.bigdata.bop.IConstant;
import com.bigdata.bop.IVariable;
import com.bigdata.bop.bindingSet.EmptyBindingSet;
import com.bigdata.bop.bindingSet.ListBindingSet;
import com.bigdata.rdf.internal.IV;
import com.bigdata.rdf.sparql.ast.GroupNodeBase;
import com.bigdata.rdf.sparql.ast.IGroupMemberNode;
import com.bigdata.rdf.sparql.ast.TermNode;
import com.bigdata.rdf.sparql.ast.eval.AbstractServiceFactory;
import com.bigdata.rdf.sparql.ast.eval.ServiceParams;
import com.bigdata.rdf.sparql.ast.service.BigdataNativeServiceOptions;
import com.bigdata.rdf.sparql.ast.service.BigdataServiceCall;
import com.bigdata.rdf.sparql.ast.service.IServiceOptions;
import com.bigdata.rdf.sparql.ast.service.ServiceCallCreateParams;
import com.bigdata.rdf.sparql.ast.service.ServiceNode;
import com.bigdata.rdf.store.AbstractTripleStore;
import com.bigdata.relation.accesspath.ThickCloseableIterator;
import cutthecrap.utils.striterators.ICloseableIterator;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;
import org.openrdf.model.URI;
import org.openrdf.model.impl.URIImpl;

public class ValuesServiceFactory
extends AbstractServiceFactory {
    private static final Logger log = Logger.getLogger(ValuesServiceFactory.class);
    public static final URI SERVICE_KEY = new URIImpl("http://www.bigdata.com/rdf#values");
    private final BigdataNativeServiceOptions serviceOptions = new BigdataNativeServiceOptions();

    public ValuesServiceFactory() {
        this.serviceOptions.setRunFirst(true);
    }

    @Override
    public BigdataNativeServiceOptions getServiceOptions() {
        return this.serviceOptions;
    }

    @Override
    public BigdataServiceCall create(ServiceCallCreateParams params, ServiceParams serviceParams) {
        AbstractTripleStore store = params.getTripleStore();
        ServiceNode serviceNode = params.getServiceNode();
        this.verifyGraphPattern(store, serviceNode.getGraphPattern(), serviceParams);
        return new ValuesCall(store, this.getServiceOptions(), serviceParams);
    }

    private void verifyGraphPattern(AbstractTripleStore database, GroupNodeBase<IGroupMemberNode> group, ServiceParams serviceParams) {
        Iterator<Map.Entry<URI, List<TermNode>>> it = serviceParams.iterator();
        if (!serviceParams.contains(ValuesParams.VAR)) {
            throw new RuntimeException("must provide a variable for: " + ValuesParams.VAR);
        }
        if (!serviceParams.contains(ValuesParams.VAL)) {
            throw new RuntimeException("must provide at least one value for: " + ValuesParams.VAL);
        }
        while (it.hasNext()) {
            URI param = it.next().getKey();
            if (ValuesParams.VAR.equals(param)) {
                List<TermNode> vars = serviceParams.get(param);
                if (vars != null && vars.size() == 1 && !vars.get(0).isConstant()) continue;
                throw new RuntimeException("must provide exactly one variable for: " + param);
            }
            if (ValuesParams.VAL.equals(param)) {
                List<TermNode> vals = serviceParams.get(param);
                if (vals == null || vals.size() == 0) {
                    throw new RuntimeException("must provide at least one value for: " + param);
                }
                for (TermNode val : vals) {
                    if (!val.isVariable()) continue;
                    throw new RuntimeException("must provide constant values for: " + param);
                }
                continue;
            }
            throw new RuntimeException("unrecognized param: " + param);
        }
    }

    private static class ValuesCall
    implements BigdataServiceCall {
        private final AbstractTripleStore db;
        private final IServiceOptions serviceOptions;
        private final ServiceParams serviceParams;

        public ValuesCall(AbstractTripleStore db, IServiceOptions serviceOptions, ServiceParams serviceParams) {
            if (db == null) {
                throw new IllegalArgumentException();
            }
            if (serviceOptions == null) {
                throw new IllegalArgumentException();
            }
            if (serviceParams == null) {
                throw new IllegalArgumentException();
            }
            this.db = db;
            this.serviceOptions = serviceOptions;
            this.serviceParams = serviceParams;
        }

        public ICloseableIterator<IBindingSet> call(IBindingSet[] bc) {
            if (log.isInfoEnabled()) {
                log.info(bc.length);
                log.info(Arrays.toString(bc));
                log.info(this.serviceParams);
            }
            if (bc != null && bc.length > 0 && !bc[0].equals(EmptyBindingSet.INSTANCE)) {
                throw new RuntimeException("cannot run with incoming bindings");
            }
            IVariable<IV> var = this.serviceParams.getAsVar(ValuesParams.VAR);
            List<TermNode> vals = this.serviceParams.get(ValuesParams.VAL);
            IBindingSet[] bSets = new IBindingSet[vals.size()];
            for (int i = 0; i < bSets.length; ++i) {
                bSets[i] = new ListBindingSet();
                bSets[i].set(var, (IConstant)vals.get(i).getValueExpression());
            }
            return new ThickCloseableIterator<IBindingSet>(bSets, bSets.length);
        }

        @Override
        public IServiceOptions getServiceOptions() {
            return this.serviceOptions;
        }
    }

    public static interface ValuesParams {
        public static final URI VAR = new URIImpl(SERVICE_KEY.stringValue() + ".var");
        public static final URI VAL = new URIImpl(SERVICE_KEY.stringValue() + ".val");
    }
}

