/*
 * Decompiled with CFR 0.152.
 */
package com.bigdata.rdf.sparql.ast.explainhints;

import com.bigdata.bop.BOp;
import com.bigdata.bop.BOpUtility;
import com.bigdata.rdf.sparql.ast.explainhints.IExplainHint;
import cutthecrap.utils.striterators.Expander;
import cutthecrap.utils.striterators.Filter;
import cutthecrap.utils.striterators.SingleValueIterator;
import cutthecrap.utils.striterators.Striterator;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;

public class ExplainHints
implements Iterable<IExplainHint> {
    private final Set<IExplainHint> explainHints = new HashSet<IExplainHint>();

    public ExplainHints(IExplainHint explainHint) {
        this.explainHints.add(explainHint);
    }

    public void addExplainHint(IExplainHint explainHint) {
        this.explainHints.add(explainHint);
    }

    public static void removeExplainHintAnnotationsFromBOp(BOp bop) {
        Iterator<BOp> explainHintAnnotatedBOps = ExplainHints.explainHintAnnotatedBOpIterator(bop);
        ArrayList<BOp> nodesWithExplainHints = new ArrayList<BOp>();
        while (explainHintAnnotatedBOps.hasNext()) {
            nodesWithExplainHints.add(explainHintAnnotatedBOps.next());
        }
        for (BOp nodeWithExplainHint : nodesWithExplainHints) {
            nodeWithExplainHint.setProperty("explainHints", null);
        }
    }

    public static Iterator<BOp> explainHintAnnotatedBOpIterator(BOp astBase) {
        return new Striterator(BOpUtility.preOrderIterator(astBase)).addFilter(new Expander(){
            private static final long serialVersionUID = 1L;

            @Override
            protected Iterator expand(Object arg0) {
                BOp op = (BOp)arg0;
                Striterator itr = new Striterator(new SingleValueIterator<BOp>(op));
                Striterator itr2 = new Striterator(BOpUtility.annotationOpIterator(op));
                itr2.addFilter(new Expander(){
                    private static final long serialVersionUID = 1L;

                    @Override
                    protected Iterator expand(Object ann) {
                        return ExplainHints.explainHintAnnotatedBOpIterator((BOp)ann);
                    }
                });
                itr.append(itr2);
                return itr;
            }
        }).addFilter(new Filter(){
            private static final long serialVersionUID = -6488014508516304898L;

            @Override
            public boolean isValid(Object obj) {
                if (obj instanceof BOp) {
                    BOp bop = (BOp)obj;
                    return bop.getProperty("explainHints") != null;
                }
                return false;
            }
        });
    }

    public String toString() {
        return this.explainHints.toString();
    }

    @Override
    public Iterator<IExplainHint> iterator() {
        return this.explainHints.iterator();
    }
}

