/*
 * Decompiled with CFR 0.152.
 */
package com.bigdata.rdf.sparql.ast.hints;

import org.openrdf.model.URI;
import org.openrdf.model.impl.URIImpl;

public enum QueryHintScope {
    Query(new URIImpl("http://www.bigdata.com/queryHints#Query")),
    SubQuery(new URIImpl("http://www.bigdata.com/queryHints#SubQuery")),
    Group(new URIImpl("http://www.bigdata.com/queryHints#Group")),
    GroupAndSubGroups(new URIImpl("http://www.bigdata.com/queryHints#GroupAndSubGroups")),
    Prior(new URIImpl("http://www.bigdata.com/queryHints#Prior"));

    private final URI uri;

    private QueryHintScope(URI uri) {
        this.uri = uri;
    }

    public URI getURI() {
        return this.uri;
    }

    public static QueryHintScope valueOf(URI uri) {
        if (uri == null) {
            throw new IllegalArgumentException();
        }
        if (!"http://www.bigdata.com/queryHints#".equals(uri.getNamespace())) {
            throw new IllegalArgumentException("Wrong namespace: expected=http://www.bigdata.com/queryHints#, actual=" + uri.getNamespace());
        }
        String localName = uri.getLocalName();
        if (Query.name().equals(localName)) {
            return Query;
        }
        if (SubQuery.name().equals(localName)) {
            return SubQuery;
        }
        if (Group.name().equals(localName)) {
            return Group;
        }
        if (GroupAndSubGroups.name().equals(localName)) {
            return GroupAndSubGroups;
        }
        if (Prior.name().equals(localName)) {
            return Prior;
        }
        throw new IllegalArgumentException("Unknown scope: " + localName);
    }
}

