/*
 * Decompiled with CFR 0.152.
 */
package com.bigdata.rdf.sparql.ast.optimizers;

import com.bigdata.bop.BOp;
import com.bigdata.bop.BOpUtility;
import com.bigdata.bop.IBindingSet;
import com.bigdata.bop.IVariableOrConstant;
import com.bigdata.rdf.sparql.ast.ArbitraryLengthPathNode;
import com.bigdata.rdf.sparql.ast.FilterNode;
import com.bigdata.rdf.sparql.ast.GlobalAnnotations;
import com.bigdata.rdf.sparql.ast.GroupMemberNodeBase;
import com.bigdata.rdf.sparql.ast.IGroupMemberNode;
import com.bigdata.rdf.sparql.ast.IValueExpressionNode;
import com.bigdata.rdf.sparql.ast.JoinGroupNode;
import com.bigdata.rdf.sparql.ast.StatementPatternNode;
import com.bigdata.rdf.sparql.ast.StaticAnalysis;
import com.bigdata.rdf.sparql.ast.TermNode;
import com.bigdata.rdf.sparql.ast.UnionNode;
import com.bigdata.rdf.sparql.ast.VarNode;
import com.bigdata.rdf.sparql.ast.eval.AST2BOpContext;
import com.bigdata.rdf.sparql.ast.eval.AST2BOpUtility;
import com.bigdata.rdf.sparql.ast.hints.BasicBooleanQueryHint;
import com.bigdata.rdf.sparql.ast.hints.BasicIntQueryHint;
import com.bigdata.rdf.sparql.ast.hints.BasicStringQueryHint;
import com.bigdata.rdf.sparql.ast.hints.QueryHintRegistry;
import com.bigdata.rdf.sparql.ast.optimizers.AbstractJoinGroupOptimizer;
import com.bigdata.rdf.sparql.ast.optimizers.IASTOptimizer;
import com.bigdata.rdf.sparql.ast.service.ServiceNode;
import com.bigdata.rdf.store.BD;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Properties;
import java.util.UUID;
import org.apache.log4j.Logger;
import org.openrdf.model.URI;

public class ASTALPServiceOptimizer
extends AbstractJoinGroupOptimizer
implements IASTOptimizer {
    private static final transient Logger log = Logger.getLogger(ASTALPServiceOptimizer.class);
    public static final URI ALP = BD.ALP_SERVICE;
    public static final String PATH_EXPR = "alp.pathExpr";
    public static final String LOWER_BOUND = "alp.lowerBound";
    public static final String UPPER_BOUND = "alp.upperBound";
    public static final String BIDIRECTIONAL = "alp.bidirectional";
    public static final String EDGE_VAR = "alp.edgeVar";

    @Override
    protected void optimizeJoinGroup(AST2BOpContext ctx, StaticAnalysis sa, IBindingSet[] bSets, JoinGroupNode group) {
        GlobalAnnotations globals = new GlobalAnnotations(ctx.getLexiconNamespace(), ctx.getTimestamp());
        for (ServiceNode node : group.getChildren(ServiceNode.class)) {
            VarNode v;
            BOp bop;
            Properties hints;
            TermNode serviceRef;
            if (log.isDebugEnabled()) {
                log.debug(node);
            }
            if (!(serviceRef = node.getServiceRef()).isConstant() || !serviceRef.getValue().equals(ALP)) continue;
            JoinGroupNode subgroup = (JoinGroupNode)node.getGraphPattern();
            if (log.isDebugEnabled()) {
                log.debug("found an alp service to optimize:\n" + subgroup);
            }
            if (!(hints = subgroup.getQueryHints()).containsKey(LOWER_BOUND)) {
                throw new RuntimeException("missing: alp.lowerBound");
            }
            if (!hints.containsKey(UPPER_BOUND)) {
                throw new RuntimeException("missing: alp.upperBound");
            }
            for (IGroupMemberNode child : subgroup.getChildren()) {
                if (child instanceof StatementPatternNode || child instanceof FilterNode) continue;
                throw new RuntimeException("Complex groups not allowed in alp service");
            }
            LinkedHashSet<VarNode> dropVars = new LinkedHashSet<VarNode>();
            int lowerBound = Integer.valueOf(subgroup.getQueryHint(LOWER_BOUND));
            int upperBound = Integer.valueOf(subgroup.getQueryHint(UPPER_BOUND));
            VarNode tVarLeft = new VarNode("-tVarLeft-" + UUID.randomUUID().toString());
            tVarLeft.setAnonymous(true);
            VarNode tVarRight = new VarNode("-tVarRight-" + UUID.randomUUID().toString());
            tVarRight.setAnonymous(true);
            dropVars.add(tVarLeft);
            dropVars.add(tVarRight);
            boolean bidirectional = subgroup.getQueryHintAsBoolean(BIDIRECTIONAL, false);
            String evHint = subgroup.getQueryHint(EDGE_VAR);
            VarNode edgeVar = null;
            if (evHint != null) {
                if (evHint.length() <= 1 || evHint.charAt(0) != '?') {
                    throw new IllegalArgumentException("Illegal hint for alp.edgeVar: " + evHint);
                }
                edgeVar = new VarNode(evHint.substring(1));
            }
            TermNode left = null;
            TermNode right = null;
            GroupMemberNodeBase pathExpr = null;
            JoinGroupNode group1 = null;
            JoinGroupNode group2 = null;
            TermNode middle = null;
            for (StatementPatternNode child : subgroup.getStatementPatterns()) {
                if (!child.getQueryHintAsBoolean(PATH_EXPR, false)) continue;
                if (pathExpr != null) {
                    throw new RuntimeException("Only one alp.pathExpr allowed");
                }
                left = child.s();
                right = child.o();
                middle = child.p();
                if (child.p() instanceof VarNode) {
                    VarNode v2 = (VarNode)child.p();
                    v2.setAnonymous(true);
                    dropVars.add(v2);
                }
                if (bidirectional) {
                    StatementPatternNode forward = new StatementPatternNode(tVarLeft, child.p(), tVarRight, child.c(), child.getScope());
                    forward.setQueryHint(PATH_EXPR, "true");
                    group1 = new JoinGroupNode();
                    group1.addChild(forward);
                    StatementPatternNode reverse = new StatementPatternNode(tVarRight, child.p(), tVarLeft, child.c(), child.getScope());
                    reverse.setQueryHint(PATH_EXPR, "true");
                    group2 = new JoinGroupNode();
                    group2.addChild(reverse);
                    UnionNode union = new UnionNode();
                    union.addArg(group1);
                    union.addArg(group2);
                    pathExpr = union;
                } else {
                    StatementPatternNode sp = new StatementPatternNode(tVarLeft, child.p(), tVarRight, child.c(), child.getScope());
                    sp.setQueryHint(PATH_EXPR, "true");
                    pathExpr = sp;
                }
                subgroup.removeChild(child);
            }
            IVariableOrConstant leftVar = null;
            if (left instanceof VarNode) {
                leftVar = ((VarNode)left).getValueExpression();
            }
            IVariableOrConstant rightVar = null;
            if (right instanceof VarNode) {
                rightVar = ((VarNode)right).getValueExpression();
            }
            for (FilterNode f : subgroup.getChildren(FilterNode.class)) {
                Iterator<BOp> it = BOpUtility.preOrderIteratorWithAnnotations(f);
                boolean swap = false;
                while (it.hasNext()) {
                    bop = it.next();
                    if (!(bop instanceof VarNode)) continue;
                    v = (VarNode)bop;
                    IVariableOrConstant ve = v.getValueExpression();
                    if (leftVar != null && leftVar.equals((Object)ve)) {
                        v.setValueExpression(tVarLeft.getValueExpression());
                        swap = true;
                        continue;
                    }
                    if (rightVar == null || !rightVar.equals((Object)ve)) continue;
                    v.setValueExpression(tVarRight.getValueExpression());
                    swap = true;
                }
                if (!swap) continue;
                IValueExpressionNode veNode = f.getValueExpressionNode();
                veNode.setValueExpression(null);
                AST2BOpUtility.toVE(ctx.context, globals, veNode);
            }
            ArbitraryLengthPathNode alpNode = new ArbitraryLengthPathNode(left, right, tVarLeft, tVarRight, lowerBound, upperBound);
            if (edgeVar != null) {
                alpNode.setEdgeVar(edgeVar, middle);
            }
            alpNode.subgroup().addChild(pathExpr);
            for (GroupMemberNodeBase child : subgroup.getChildren(GroupMemberNodeBase.class)) {
                if (child.getQueryHintAsBoolean(PATH_EXPR, false)) continue;
                Iterator<BOp> it = BOpUtility.preOrderIteratorWithAnnotations(child);
                while (it.hasNext()) {
                    bop = it.next();
                    if (!(bop instanceof VarNode)) continue;
                    v = (VarNode)bop;
                    v.setAnonymous(true);
                    dropVars.add(v);
                }
                child.setQueryHints(new Properties());
                subgroup.removeChild(child);
                if (bidirectional) {
                    group1.addChild((IGroupMemberNode)((Object)child.clone()));
                    group2.addChild((IGroupMemberNode)((Object)child.clone()));
                    continue;
                }
                alpNode.subgroup().addChild(child);
            }
            alpNode.setDropVars(dropVars);
            if (log.isDebugEnabled()) {
                log.debug("optimized alpNode:\n" + alpNode);
            }
            group.removeChild(node);
            group.addChild(alpNode);
        }
    }

    static {
        QueryHintRegistry.add(new BasicBooleanQueryHint(PATH_EXPR, false));
        QueryHintRegistry.add(new BasicIntQueryHint(LOWER_BOUND, 1));
        QueryHintRegistry.add(new BasicIntQueryHint(UPPER_BOUND, Integer.MAX_VALUE));
        QueryHintRegistry.add(new BasicBooleanQueryHint(BIDIRECTIONAL, false));
        QueryHintRegistry.add(new BasicStringQueryHint(EDGE_VAR, null));
    }
}

