/*
 * Decompiled with CFR 0.152.
 */
package com.bigdata.rdf.sparql.ast.optimizers;

import com.bigdata.bop.IBindingSet;
import com.bigdata.bop.IVariable;
import com.bigdata.rdf.sparql.ast.ArbitraryLengthPathNode;
import com.bigdata.rdf.sparql.ast.FilterNode;
import com.bigdata.rdf.sparql.ast.GraphPatternGroup;
import com.bigdata.rdf.sparql.ast.IGroupMemberNode;
import com.bigdata.rdf.sparql.ast.IJoinNode;
import com.bigdata.rdf.sparql.ast.IQueryNode;
import com.bigdata.rdf.sparql.ast.JoinGroupNode;
import com.bigdata.rdf.sparql.ast.NamedSubqueriesNode;
import com.bigdata.rdf.sparql.ast.NamedSubqueryRoot;
import com.bigdata.rdf.sparql.ast.QueryNodeWithBindingSet;
import com.bigdata.rdf.sparql.ast.QueryRoot;
import com.bigdata.rdf.sparql.ast.QueryType;
import com.bigdata.rdf.sparql.ast.StaticAnalysis;
import com.bigdata.rdf.sparql.ast.SubqueryRoot;
import com.bigdata.rdf.sparql.ast.UnionNode;
import com.bigdata.rdf.sparql.ast.eval.AST2BOpContext;
import com.bigdata.rdf.sparql.ast.eval.IEvaluationContext;
import com.bigdata.rdf.sparql.ast.optimizers.IASTOptimizer;
import java.util.Arrays;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;

public class ASTAttachJoinFiltersOptimizer
implements IASTOptimizer {
    @Override
    public QueryNodeWithBindingSet optimize(AST2BOpContext context, QueryNodeWithBindingSet input) {
        IQueryNode queryNode = input.getQueryNode();
        IBindingSet[] bindingSets = input.getBindingSets();
        QueryRoot queryRoot = (QueryRoot)queryNode;
        StaticAnalysis sa = new StaticAnalysis(queryRoot, context);
        NamedSubqueriesNode namedSubqueries = queryRoot.getNamedSubqueries();
        if (namedSubqueries != null) {
            for (NamedSubqueryRoot namedSubquery : namedSubqueries) {
                this.attachJoinFilters(context, sa, namedSubquery.getWhereClause());
            }
        }
        this.attachJoinFilters(context, sa, queryRoot.getWhereClause());
        return new QueryNodeWithBindingSet(queryRoot, bindingSets);
    }

    private void attachJoinFilters(IEvaluationContext context, StaticAnalysis sa, GraphPatternGroup<IGroupMemberNode> group) {
        for (IGroupMemberNode child : group) {
            if (child instanceof GraphPatternGroup) {
                this.attachJoinFilters(context, sa, (GraphPatternGroup)child);
                continue;
            }
            if (child instanceof SubqueryRoot) {
                this.attachJoinFilters(context, sa, ((SubqueryRoot)child).getWhereClause());
                continue;
            }
            if (!(child instanceof ArbitraryLengthPathNode)) continue;
            this.attachJoinFilters(context, sa, ((ArbitraryLengthPathNode)child).subgroup());
        }
        if (group instanceof JoinGroupNode) {
            this.attachJoinFilters2(context, sa, (JoinGroupNode)group);
        }
    }

    private void attachJoinFilters2(IEvaluationContext context, StaticAnalysis sa, JoinGroupNode group) {
        LinkedList<IJoinNode> requiredJoins = new LinkedList<IJoinNode>();
        LinkedList<FilterNode> joinFilters = new LinkedList<FilterNode>(sa.getJoinFilters(group));
        for (IGroupMemberNode child : group) {
            IJoinNode aJoinNode;
            if (!(child instanceof IJoinNode) || (aJoinNode = (IJoinNode)((Object)child)).isOptional() || aJoinNode.isMinus() || aJoinNode instanceof SubqueryRoot && ((SubqueryRoot)aJoinNode).getQueryType().equals((Object)QueryType.ASK) || aJoinNode instanceof UnionNode) continue;
            requiredJoins.add(aJoinNode);
            List<FilterNode> ownJoinFilters = aJoinNode.getAttachedJoinFilters();
            if (ownJoinFilters == null) continue;
            joinFilters.addAll(ownJoinFilters);
            aJoinNode.setAttachedJoinFilters(null);
        }
        if (requiredJoins.isEmpty()) {
            return;
        }
        LinkedList<FilterNode> attachedFilters = new LinkedList<FilterNode>();
        int requiredJoinCount = requiredJoins.size();
        IJoinNode[] path = requiredJoins.toArray(new IJoinNode[requiredJoinCount]);
        Set<IVariable<?>> knownBound = sa.getDefinitelyIncomingBindings(group, new LinkedHashSet());
        FilterNode[][] assignedConstraints = sa.getJoinGraphConstraints(path, joinFilters.toArray(new FilterNode[joinFilters.size()]), knownBound, false);
        for (int i = 0; i < requiredJoinCount; ++i) {
            IJoinNode tmp = path[i];
            FilterNode[] filters = assignedConstraints[i];
            if (filters.length <= 0) continue;
            tmp.setAttachedJoinFilters(Arrays.asList(filters));
            attachedFilters.addAll(Arrays.asList(filters));
        }
        for (FilterNode joinFilter : attachedFilters) {
            boolean checkNext = true;
            while (checkNext) {
                checkNext = group.removeArg(joinFilter);
            }
        }
    }
}

