/*
 * Decompiled with CFR 0.152.
 */
package com.bigdata.rdf.sparql.ast.optimizers;

import com.bigdata.bop.IBindingSet;
import com.bigdata.rdf.sparql.ast.ArbitraryLengthPathNode;
import com.bigdata.rdf.sparql.ast.IBindingProducerNode;
import com.bigdata.rdf.sparql.ast.IGroupMemberNode;
import com.bigdata.rdf.sparql.ast.JoinGroupNode;
import com.bigdata.rdf.sparql.ast.StaticAnalysis;
import com.bigdata.rdf.sparql.ast.UnionNode;
import com.bigdata.rdf.sparql.ast.eval.AST2BOpContext;
import com.bigdata.rdf.sparql.ast.optimizers.ASTStaticJoinOptimizer;
import com.bigdata.rdf.sparql.ast.optimizers.AbstractJoinGroupOptimizer;
import com.bigdata.rdf.sparql.ast.optimizers.IASTOptimizer;
import java.util.List;
import org.apache.log4j.Logger;

public class ASTCardinalityOptimizer
extends AbstractJoinGroupOptimizer
implements IASTOptimizer {
    private static final transient Logger log = Logger.getLogger(ASTCardinalityOptimizer.class);

    public ASTCardinalityOptimizer() {
        super(true, false);
    }

    @Override
    protected void optimizeJoinGroup(AST2BOpContext ctx, StaticAnalysis sa, IBindingSet[] bSets, JoinGroupNode group) {
        IBindingProducerNode node;
        for (IGroupMemberNode child : group.getChildren()) {
            ArbitraryLengthPathNode alp;
            long cardinality;
            if (child instanceof UnionNode) {
                UnionNode union = (UnionNode)child;
                boolean canEstimate = true;
                for (JoinGroupNode join : union.getChildren()) {
                    canEstimate &= join.getProperty(ASTStaticJoinOptimizer.Annotations.ESTIMATED_CARDINALITY) != null;
                }
                if (!canEstimate) continue;
                long cardinality2 = 0L;
                for (JoinGroupNode join : union.getChildren()) {
                    cardinality2 += ((Long)join.getProperty(ASTStaticJoinOptimizer.Annotations.ESTIMATED_CARDINALITY)).longValue();
                }
                if (log.isDebugEnabled()) {
                    log.debug("able to estimate the cardinality for a union: " + cardinality2);
                }
                union.setProperty(ASTStaticJoinOptimizer.Annotations.ESTIMATED_CARDINALITY, cardinality2);
                continue;
            }
            if (!(child instanceof ArbitraryLengthPathNode) || (cardinality = (alp = (ArbitraryLengthPathNode)child).getEstimatedCardinality(null)) >= Long.MAX_VALUE) continue;
            alp.setProperty(ASTStaticJoinOptimizer.Annotations.ESTIMATED_CARDINALITY, cardinality);
        }
        List<IBindingProducerNode> nodes = group.getChildren(IBindingProducerNode.class);
        if (nodes.size() == 1 && (node = nodes.get(0)).getProperty(ASTStaticJoinOptimizer.Annotations.ESTIMATED_CARDINALITY) != null) {
            long cardinality = (Long)node.getProperty(ASTStaticJoinOptimizer.Annotations.ESTIMATED_CARDINALITY);
            if (log.isDebugEnabled()) {
                log.debug("setting cardinality on a singleton group: " + cardinality);
            }
            group.setProperty(ASTStaticJoinOptimizer.Annotations.ESTIMATED_CARDINALITY, cardinality);
        }
    }
}

