/*
 * Decompiled with CFR 0.152.
 */
package com.bigdata.rdf.sparql.ast.optimizers;

import com.bigdata.bop.BOp;
import com.bigdata.bop.IBindingSet;
import com.bigdata.rdf.sparql.ast.GraphPatternGroup;
import com.bigdata.rdf.sparql.ast.GroupNodeBase;
import com.bigdata.rdf.sparql.ast.IBindingProducerNode;
import com.bigdata.rdf.sparql.ast.IGroupNode;
import com.bigdata.rdf.sparql.ast.IJoinNode;
import com.bigdata.rdf.sparql.ast.IQueryNode;
import com.bigdata.rdf.sparql.ast.JoinGroupNode;
import com.bigdata.rdf.sparql.ast.NamedSubqueriesNode;
import com.bigdata.rdf.sparql.ast.NamedSubqueryRoot;
import com.bigdata.rdf.sparql.ast.QueryBase;
import com.bigdata.rdf.sparql.ast.QueryNodeBase;
import com.bigdata.rdf.sparql.ast.QueryNodeWithBindingSet;
import com.bigdata.rdf.sparql.ast.QueryRoot;
import com.bigdata.rdf.sparql.ast.UnionNode;
import com.bigdata.rdf.sparql.ast.eval.AST2BOpContext;
import com.bigdata.rdf.sparql.ast.optimizers.IASTOptimizer;
import java.util.Enumeration;
import java.util.Map;
import java.util.Properties;

public class ASTEmptyGroupOptimizer
implements IASTOptimizer {
    @Override
    public QueryNodeWithBindingSet optimize(AST2BOpContext context, QueryNodeWithBindingSet input) {
        IQueryNode queryNode = input.getQueryNode();
        IBindingSet[] bindingSets = input.getBindingSets();
        if (!(queryNode instanceof QueryRoot)) {
            return new QueryNodeWithBindingSet(queryNode, bindingSets);
        }
        QueryRoot queryRoot = (QueryRoot)queryNode;
        GraphPatternGroup whereClause = queryRoot.getWhereClause();
        if (whereClause != null) {
            ASTEmptyGroupOptimizer.eliminateEmptyGroups(queryRoot, whereClause);
        }
        if (queryRoot.getNamedSubqueries() != null) {
            NamedSubqueriesNode namedSubqueries = queryRoot.getNamedSubqueries();
            for (int i = 0; i < namedSubqueries.size(); ++i) {
                NamedSubqueryRoot namedSubquery = (NamedSubqueryRoot)namedSubqueries.get(i);
                GraphPatternGroup whereClause2 = namedSubquery.getWhereClause();
                if (whereClause2 == null) continue;
                ASTEmptyGroupOptimizer.eliminateEmptyGroups(namedSubquery, whereClause2);
            }
        }
        return new QueryNodeWithBindingSet(queryNode, bindingSets);
    }

    private static void eliminateEmptyGroups(QueryBase queryBase, GraphPatternGroup<?> op) {
        GraphPatternGroup child;
        GraphPatternGroup parent;
        for (int i = 0; i < op.arity(); ++i) {
            BOp child2 = op.get(i);
            if (child2 instanceof GraphPatternGroup) {
                GraphPatternGroup childGroup = (GraphPatternGroup)child2;
                ASTEmptyGroupOptimizer.eliminateEmptyGroups(queryBase, childGroup);
                if (i >= op.arity() || op.get(i) == child2) continue;
                --i;
                continue;
            }
            if (!(child2 instanceof QueryBase)) continue;
            QueryBase subquery = (QueryBase)child2;
            GraphPatternGroup childGroup = subquery.getWhereClause();
            ASTEmptyGroupOptimizer.eliminateEmptyGroups(subquery, childGroup);
            if (i >= op.arity() || op.get(i) == child2) continue;
            --i;
        }
        int arity = op.arity();
        if (arity == 0 && op.getContext() == null && op.getParent() != null && !ASTEmptyGroupOptimizer.isUnion(op.getParent())) {
            parent = op.getParent();
            parent.removeChild(op);
            op.setParent(null);
        } else if (arity == 1 && op instanceof JoinGroupNode && op.get(0) instanceof JoinGroupNode) {
            parent = (JoinGroupNode)op;
            child = (JoinGroupNode)op.get(0);
            if (!(((JoinGroupNode)parent).isMinus() || ((JoinGroupNode)child).isMinus() || !((JoinGroupNode)parent).isOptional() && ((JoinGroupNode)child).isOptional())) {
                if (((JoinGroupNode)parent).isOptional() && !((JoinGroupNode)child).isOptional()) {
                    ((JoinGroupNode)child).setOptional(true);
                }
                ASTEmptyGroupOptimizer.swap(queryBase, parent, child);
            }
        } else if (arity == 1 && op instanceof UnionNode && op.get(0) instanceof JoinGroupNode) {
            parent = (UnionNode)op;
            child = (JoinGroupNode)op.get(0);
            ASTEmptyGroupOptimizer.swap(queryBase, parent, child);
        } else if (arity == 1 && op instanceof JoinGroupNode && !op.isOptional() && !op.isMinus() && op.get(0) instanceof UnionNode) {
            parent = (JoinGroupNode)op;
            child = (UnionNode)op.get(0);
            ASTEmptyGroupOptimizer.swap(queryBase, parent, child);
        } else if (!(arity != 1 || !(op.get(0) instanceof IBindingProducerNode) || op.getParent() == null || op.isOptional() || op.isMinus() || ASTEmptyGroupOptimizer.isUnion(op.getParent()) || ASTEmptyGroupOptimizer.isMinus(op.getParent()) || op.getContext() != op.getParent().getContext())) {
            ASTEmptyGroupOptimizer.copyQueryHintsAndRequiredAnnotations(op.get(0), op.getQueryHints(), op.annotations());
            ((GroupNodeBase)op.getParent()).replaceWith(op, op.get(0));
        }
    }

    private static boolean isUnion(IGroupNode<?> op) {
        return op instanceof UnionNode;
    }

    private static boolean isMinus(IGroupNode<?> op) {
        IJoinNode g;
        return op instanceof IJoinNode && (g = (IJoinNode)((Object)op)).isMinus();
    }

    private static void swap(QueryBase queryBase, GraphPatternGroup<?> parent, GraphPatternGroup<?> child) {
        if (parent.getParent() == null) {
            queryBase.setWhereClause(child);
        } else {
            GroupNodeBase grandparent = (GroupNodeBase)parent.getParent();
            ASTEmptyGroupOptimizer.copyQueryHintsAndRequiredAnnotations(child, parent.getQueryHints(), parent.annotations());
            grandparent.replaceWith(parent, child);
        }
        parent.setParent(null);
    }

    private static void copyQueryHintsAndRequiredAnnotations(BOp node, Properties queryHints, Map<String, Object> annotations) {
        ASTEmptyGroupOptimizer.copyQueryHints(node, queryHints);
        ASTEmptyGroupOptimizer.copyRequiredAnnotations(node, annotations);
    }

    private static void copyQueryHints(BOp node, Properties queryHints) {
        if (queryHints == null) {
            return;
        }
        if (!(node instanceof QueryNodeBase)) {
            return;
        }
        QueryNodeBase nodeAsQN = (QueryNodeBase)node;
        Enumeration<?> pnames = queryHints.propertyNames();
        while (pnames.hasMoreElements()) {
            String name = (String)pnames.nextElement();
            String value = queryHints.getProperty(name);
            String curHint = nodeAsQN.getQueryHint(name);
            if (curHint != null) continue;
            nodeAsQN.setQueryHint(name, value);
        }
    }

    private static void copyRequiredAnnotations(BOp node, Map<String, Object> annotations) {
        if (annotations != null) {
            if (annotations.containsKey("runFirst") && !node.annotations().containsKey("runFirst")) {
                node.annotations().put("runFirst", annotations.get("runFirst"));
            }
            if (annotations.containsKey("runLast") && !node.annotations().containsKey("runLast")) {
                node.annotations().put("runLast", annotations.get("runLast"));
            }
        }
    }
}

