/*
 * Decompiled with CFR 0.152.
 */
package com.bigdata.rdf.sparql.ast.optimizers;

import com.bigdata.bop.BOp;
import com.bigdata.bop.IBindingSet;
import com.bigdata.bop.IVariable;
import com.bigdata.rdf.sparql.ast.FilterNode;
import com.bigdata.rdf.sparql.ast.FunctionNode;
import com.bigdata.rdf.sparql.ast.FunctionRegistry;
import com.bigdata.rdf.sparql.ast.IBindingProducerNode;
import com.bigdata.rdf.sparql.ast.IGroupMemberNode;
import com.bigdata.rdf.sparql.ast.IValueExpressionNode;
import com.bigdata.rdf.sparql.ast.JoinGroupNode;
import com.bigdata.rdf.sparql.ast.QueryHints;
import com.bigdata.rdf.sparql.ast.StaticAnalysis;
import com.bigdata.rdf.sparql.ast.ValueExpressionNode;
import com.bigdata.rdf.sparql.ast.VarNode;
import com.bigdata.rdf.sparql.ast.eval.AST2BOpContext;
import com.bigdata.rdf.sparql.ast.optimizers.AbstractJoinGroupOptimizer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.openrdf.model.URI;

public class ASTFilterNormalizationOptimizer
extends AbstractJoinGroupOptimizer {
    @Override
    protected void optimizeJoinGroup(AST2BOpContext ctx, StaticAnalysis sa, IBindingSet[] bSets, JoinGroupNode group) {
        if (!group.getProperty("normalizeFilterExpressions", QueryHints.DEFAULT_NORMALIZE_FILTER_EXPRESSIONS).booleanValue()) {
            return;
        }
        this.normalizeAndDecomposeFilters(ctx, sa, bSets, group);
        this.removeDuplicatesAndTautologies(ctx, sa, bSets, group);
    }

    protected void normalizeAndDecomposeFilters(AST2BOpContext ctx, StaticAnalysis sa, IBindingSet[] bSets, JoinGroupNode group) {
        HashMap subst = new HashMap();
        for (IGroupMemberNode child : group) {
            List<FilterNode> splittedFilterNodes;
            IValueExpressionNode filterAsCNF;
            FilterNode filterNode;
            IValueExpressionNode vexprNode;
            if (!(child instanceof FilterNode) || !this.isDecomposable(vexprNode = (filterNode = (FilterNode)child).getValueExpressionNode()) || (filterAsCNF = StaticAnalysis.isCNF(vexprNode) ? vexprNode : StaticAnalysis.toCNF(vexprNode)) == null || (splittedFilterNodes = this.constructFiltersForValueExpressionNode(filterAsCNF, new ArrayList<FilterNode>())) == null) continue;
            if (!subst.containsKey(filterNode)) {
                subst.put(filterNode, new ArrayList());
            }
            List values = (List)subst.get(filterNode);
            values.add(splittedFilterNodes);
        }
        for (FilterNode filterNode : subst.keySet()) {
            for (int i = 0; i < ((List)subst.get(filterNode)).size(); ++i) {
                group.removeChild(filterNode);
            }
        }
        for (List filterNodeListList : subst.values()) {
            for (List filterNodeList : filterNodeListList) {
                for (FilterNode filterNode : filterNodeList) {
                    group.addChild(filterNode);
                }
            }
        }
    }

    protected void removeDuplicatesAndTautologies(AST2BOpContext ctx, StaticAnalysis sa, IBindingSet[] bSets, JoinGroupNode group) {
        int i;
        HashSet definitelyProd = new HashSet();
        sa.getDefinitelyIncomingBindings(group, definitelyProd);
        sa.getDefinitelyProducedBindings((IBindingProducerNode)group, definitelyProd, true);
        HashSet maybeProd = new HashSet();
        sa.getMaybeIncomingBindings(group, maybeProd);
        sa.getMaybeProducedBindings((IBindingProducerNode)group, maybeProd, true);
        HashSet<FilterNode> alreadySeen = new HashSet<FilterNode>();
        ArrayList<FilterNode> filtersToRemove = new ArrayList<FilterNode>();
        for (i = group.size() - 1; i >= 0; --i) {
            BOp child = group.get(i);
            if (!(child instanceof FilterNode)) continue;
            FilterNode filterNode = (FilterNode)child;
            if (this.filterAlwaysSatisifed(filterNode, definitelyProd, maybeProd) || alreadySeen.contains(filterNode)) {
                filtersToRemove.add(filterNode);
            }
            alreadySeen.add(filterNode);
        }
        for (i = filtersToRemove.size() - 1; i >= 0; --i) {
            FilterNode filterNode = (FilterNode)filtersToRemove.get(i);
            group.removeChild(filterNode);
        }
    }

    boolean filterAlwaysSatisifed(FilterNode filterNode, Set<IVariable<?>> definiteVars, Set<IVariable<?>> maybeVars) {
        boolean alwaysSatisifed = false;
        alwaysSatisifed |= this.boundAlwaysSatisifed(filterNode.getValueExpressionNode(), definiteVars);
        return alwaysSatisifed |= this.notBoundAlwaysSatisifed(filterNode.getValueExpressionNode(), maybeVars);
    }

    private boolean boundAlwaysSatisifed(IValueExpressionNode vexp, Set<IVariable<?>> definiteVars) {
        BOp varBop;
        if (!(vexp instanceof FunctionNode)) {
            return false;
        }
        FunctionNode functionNode = (FunctionNode)vexp;
        URI functionURI = functionNode.getFunctionURI();
        if (functionURI.equals(FunctionRegistry.BOUND) && functionNode.arity() == 1 && (varBop = functionNode.get(0)) instanceof VarNode) {
            VarNode varNode = (VarNode)varBop;
            return definiteVars.contains(varNode.getValueExpression());
        }
        return false;
    }

    private boolean notBoundAlwaysSatisifed(IValueExpressionNode vexp, Set<IVariable<?>> maybeVars) {
        if (!(vexp instanceof FunctionNode)) {
            return false;
        }
        FunctionNode functionNode = (FunctionNode)vexp;
        URI functionURI = functionNode.getFunctionURI();
        if (functionURI.equals(FunctionRegistry.NOT)) {
            BOp varBop;
            ValueExpressionNode innerVexp = (ValueExpressionNode)functionNode.get(0);
            if (!(innerVexp instanceof FunctionNode)) {
                return false;
            }
            FunctionNode innerFunctionNode = (FunctionNode)innerVexp;
            URI innerFunctionURI = innerFunctionNode.getFunctionURI();
            if (innerFunctionURI.equals(FunctionRegistry.BOUND) && innerFunctionNode.arity() == 1 && (varBop = innerFunctionNode.get(0)) instanceof VarNode) {
                VarNode varNode = (VarNode)varBop;
                return !maybeVars.contains(varNode.getValueExpression());
            }
        }
        return false;
    }

    public boolean isDecomposable(IValueExpressionNode vexpr) {
        BOp bop;
        if (!(vexpr instanceof FunctionNode)) {
            return false;
        }
        FunctionNode functionNode = (FunctionNode)vexpr;
        URI functionURI = functionNode.getFunctionURI();
        if (functionURI.equals(FunctionRegistry.AND) || functionURI.equals(FunctionRegistry.OR)) {
            return true;
        }
        if (functionURI.equals(FunctionRegistry.NOT) && (bop = functionNode.get(0)) instanceof FunctionNode) {
            return this.isDecomposable((FunctionNode)bop);
        }
        return false;
    }

    public List<FilterNode> constructFiltersForValueExpressionNode(IValueExpressionNode vexp, List<FilterNode> filters) {
        List<IValueExpressionNode> topLevelConjuncts = StaticAnalysis.extractToplevelConjuncts(vexp, new ArrayList<IValueExpressionNode>());
        for (IValueExpressionNode toplevelConjunct : topLevelConjuncts) {
            filters.add(new FilterNode(toplevelConjunct));
        }
        return filters;
    }
}

