/*
 * Decompiled with CFR 0.152.
 */
package com.bigdata.rdf.sparql.ast.optimizers;

import com.bigdata.bop.BOp;
import com.bigdata.bop.IVariable;
import com.bigdata.bop.IVariableOrConstant;
import com.bigdata.rdf.sparql.ast.ExistsNode;
import com.bigdata.rdf.sparql.ast.FilterNode;
import com.bigdata.rdf.sparql.ast.IGroupMemberNode;
import com.bigdata.rdf.sparql.ast.IValueExpressionNode;
import com.bigdata.rdf.sparql.ast.NotExistsNode;
import com.bigdata.rdf.sparql.ast.QueryType;
import com.bigdata.rdf.sparql.ast.SubqueryFunctionNodeBase;
import com.bigdata.rdf.sparql.ast.SubqueryRoot;
import com.bigdata.rdf.sparql.ast.VarNode;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;

public class ASTJoinGroupFilterExistsInfo {
    final Map<SubqueryRoot, FilterNode> filterMap = new HashMap<SubqueryRoot, FilterNode>();

    public ASTJoinGroupFilterExistsInfo(Iterable<IGroupMemberNode> nodeList) {
        HashMap<IVariableOrConstant, FilterNode> filters = new HashMap<IVariableOrConstant, FilterNode>();
        HashSet<SubqueryRoot> askSubqueries = new HashSet<SubqueryRoot>();
        for (IGroupMemberNode node : nodeList) {
            SubqueryRoot sqr;
            if (node instanceof FilterNode) {
                VarNode varNode;
                BOp varAsBop;
                SubqueryFunctionNodeBase existsOrNotExists;
                FilterNode filter = (FilterNode)node;
                IValueExpressionNode inner = filter.getValueExpressionNode();
                if (!(inner instanceof ExistsNode) && !(inner instanceof NotExistsNode) || (existsOrNotExists = (SubqueryFunctionNodeBase)inner).arity() != 1 || !((varAsBop = existsOrNotExists.get(0)) instanceof VarNode) || (varNode = (VarNode)varAsBop).getValueExpression() == null) continue;
                filters.put(varNode.getValueExpression(), filter);
                continue;
            }
            if (!(node instanceof SubqueryRoot) || !(sqr = (SubqueryRoot)node).getQueryType().equals((Object)QueryType.ASK)) continue;
            askSubqueries.add(sqr);
        }
        for (SubqueryRoot sqr : askSubqueries) {
            IVariable<?> askVar = sqr.getAskVar();
            if (!filters.containsKey(askVar)) continue;
            this.filterMap.put(sqr, (FilterNode)filters.get(askVar));
        }
    }

    public boolean containsSubqueryRoot(SubqueryRoot sqr) {
        return this.filterMap.keySet().contains(sqr);
    }

    public boolean containsFilter(FilterNode filter) {
        return this.filterMap.values().contains(filter);
    }
}

