/*
 * Decompiled with CFR 0.152.
 */
package com.bigdata.rdf.sparql.ast.optimizers;

import com.bigdata.bop.BOp;
import com.bigdata.bop.BOpUtility;
import com.bigdata.bop.IBindingSet;
import com.bigdata.bop.IValueExpression;
import com.bigdata.rdf.model.BigdataURI;
import com.bigdata.rdf.model.BigdataValue;
import com.bigdata.rdf.sparql.ast.ASTBase;
import com.bigdata.rdf.sparql.ast.ConstantNode;
import com.bigdata.rdf.sparql.ast.FilterNode;
import com.bigdata.rdf.sparql.ast.GraphPatternGroup;
import com.bigdata.rdf.sparql.ast.IGroupMemberNode;
import com.bigdata.rdf.sparql.ast.IQueryNode;
import com.bigdata.rdf.sparql.ast.IValueExpressionNode;
import com.bigdata.rdf.sparql.ast.NamedSubqueriesNode;
import com.bigdata.rdf.sparql.ast.NamedSubqueryRoot;
import com.bigdata.rdf.sparql.ast.QueryBase;
import com.bigdata.rdf.sparql.ast.QueryNodeWithBindingSet;
import com.bigdata.rdf.sparql.ast.QueryRoot;
import com.bigdata.rdf.sparql.ast.StatementPatternNode;
import com.bigdata.rdf.sparql.ast.SubqueryFunctionNodeBase;
import com.bigdata.rdf.sparql.ast.SubqueryRoot;
import com.bigdata.rdf.sparql.ast.TermNode;
import com.bigdata.rdf.sparql.ast.VarNode;
import com.bigdata.rdf.sparql.ast.eval.AST2BOpContext;
import com.bigdata.rdf.sparql.ast.hints.IQueryHint;
import com.bigdata.rdf.sparql.ast.hints.QueryHintException;
import com.bigdata.rdf.sparql.ast.hints.QueryHintRegistry;
import com.bigdata.rdf.sparql.ast.hints.QueryHintScope;
import com.bigdata.rdf.sparql.ast.optimizers.IASTOptimizer;
import com.bigdata.rdf.sparql.ast.service.ServiceNode;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Properties;
import org.apache.log4j.Logger;
import org.openrdf.model.Literal;
import org.openrdf.model.URI;

public class ASTQueryHintOptimizer
implements IASTOptimizer {
    private static final Logger log = Logger.getLogger(ASTQueryHintOptimizer.class);

    @Override
    public QueryNodeWithBindingSet optimize(AST2BOpContext context, QueryNodeWithBindingSet input) {
        NamedSubqueriesNode namedSubqueries;
        IQueryNode queryNode = input.getQueryNode();
        IBindingSet[] bindingSets = input.getBindingSets();
        QueryRoot queryRoot = (QueryRoot)queryNode;
        if (context.queryHints != null && !context.queryHints.isEmpty()) {
            this.applyGlobalQueryHints(context, queryRoot, context.queryHints);
        }
        if ((namedSubqueries = queryRoot.getNamedSubqueries()) != null) {
            for (NamedSubqueryRoot namedSubquery : namedSubqueries) {
                this.processGroup(context, queryRoot, namedSubquery, namedSubquery.getWhereClause());
            }
        }
        this.processGroup(context, queryRoot, queryRoot, queryRoot.getWhereClause());
        return new QueryNodeWithBindingSet(queryNode, bindingSets);
    }

    private boolean isNodeAcceptingQueryHints(BOp op) {
        if (op instanceof IValueExpressionNode) {
            return false;
        }
        return !(op instanceof IValueExpression);
    }

    private void applyGlobalQueryHints(AST2BOpContext context, QueryRoot queryRoot, Properties queryHints) {
        if (queryHints == null || queryHints.isEmpty()) {
            return;
        }
        Iterator<BOp> itr = BOpUtility.preOrderIteratorWithAnnotations(queryRoot);
        LinkedList<ASTBase> list = new LinkedList<ASTBase>();
        while (itr.hasNext()) {
            BOp op = itr.next();
            if (!this.isNodeAcceptingQueryHints(op)) continue;
            ASTBase t = (ASTBase)op;
            list.add(t);
        }
        for (ASTBase t : list) {
            this.applyQueryHints(context, queryRoot, QueryHintScope.Query, t, queryHints);
        }
    }

    private void applyQueryHints(AST2BOpContext context, QueryRoot queryRoot, QueryHintScope scope, ASTBase t, Properties queryHints) {
        Enumeration<?> e = queryHints.propertyNames();
        while (e.hasMoreElements()) {
            String name = (String)e.nextElement();
            String value = queryHints.getProperty(name);
            this._applyQueryHint(context, queryRoot, scope, t, name, value);
        }
    }

    private void _applyQueryHint(AST2BOpContext context, QueryRoot queryRoot, QueryHintScope scope, ASTBase t, String name, String value) {
        IQueryHint<?> queryHint = QueryHintRegistry.get(name);
        if (queryHint == null) {
            throw new QueryHintException(scope, t, name, value);
        }
        Object value2 = queryHint.validate(value);
        if (log.isTraceEnabled()) {
            log.trace("Applying hint: hint=" + queryHint.getName() + ", value=" + value2 + ", node=" + t.getClass().getName());
        }
        queryHint.handle(context, queryRoot, scope, t, value2);
    }

    private void processGroup(AST2BOpContext context, QueryRoot queryRoot, QueryBase queryBase, GraphPatternGroup<IGroupMemberNode> group) {
        if (group == null) {
            return;
        }
        int nfound = 0;
        int arity = group.arity();
        ASTBase prior = null;
        for (int i = 0; i < arity; ++i) {
            IGroupMemberNode child = (IGroupMemberNode)group.get(i);
            if (child instanceof StatementPatternNode) {
                StatementPatternNode sp = (StatementPatternNode)child;
                if (!this.isQueryHint(sp)) {
                    prior = sp;
                    continue;
                }
                this.applyQueryHint(context, queryRoot, queryBase, group, prior, sp);
                ++nfound;
                continue;
            }
            if (child instanceof GraphPatternGroup) {
                this.processGroup(context, queryRoot, queryBase, (GraphPatternGroup)child);
            } else if (child instanceof SubqueryRoot) {
                this.processGroup(context, queryRoot, (SubqueryRoot)child, ((SubqueryRoot)child).getWhereClause());
            } else if (child instanceof ServiceNode) {
                this.processGroup(context, queryRoot, queryBase, ((ServiceNode)child).getGraphPattern());
            } else if (child instanceof FilterNode && ((FilterNode)child).getValueExpressionNode() instanceof SubqueryFunctionNodeBase) {
                GraphPatternGroup<IGroupMemberNode> filterGraphPattern = ((SubqueryFunctionNodeBase)((FilterNode)child).getValueExpressionNode()).getGraphPattern();
                this.processGroup(context, queryRoot, queryBase, filterGraphPattern);
            }
            prior = (ASTBase)((Object)child);
        }
        if (nfound > 0) {
            int i = 0;
            while (i < group.arity()) {
                IGroupMemberNode child = (IGroupMemberNode)group.get(i);
                if (!(child instanceof StatementPatternNode)) {
                    ++i;
                    continue;
                }
                StatementPatternNode sp = (StatementPatternNode)child;
                if (this.isQueryHint(sp)) {
                    group.removeArg(sp);
                    continue;
                }
                ++i;
            }
        }
    }

    private boolean isQueryHint(StatementPatternNode sp) {
        if (!(sp.p() instanceof ConstantNode)) {
            return false;
        }
        BigdataValue p = ((ConstantNode)sp.p()).getValue();
        if (!(p instanceof URI)) {
            return false;
        }
        BigdataURI u = (BigdataURI)p;
        String str = u.stringValue();
        return str.startsWith("http://www.bigdata.com/queryHints#");
    }

    private QueryHintScope getScope(TermNode t) {
        if (!(t instanceof ConstantNode)) {
            throw new RuntimeException("Subject position of query hint must be a constant.");
        }
        BigdataValue v = ((ConstantNode)t).getValue();
        if (!(v instanceof BigdataURI)) {
            throw new RuntimeException("Query hint scope is not a URI.");
        }
        BigdataURI u = (BigdataURI)v;
        return QueryHintScope.valueOf(u);
    }

    private String getName(TermNode t) {
        if (!(t instanceof ConstantNode)) {
            throw new RuntimeException("Predicate position of query hint must be a constant.");
        }
        BigdataValue v = ((ConstantNode)t).getValue();
        if (!(v instanceof BigdataURI)) {
            throw new RuntimeException("Predicate position of query hint is not a URI.");
        }
        BigdataURI u = (BigdataURI)v;
        String name = u.getLocalName();
        return name;
    }

    private String getValue(TermNode t) {
        if (t instanceof VarNode) {
            return '?' + ((VarNode)t).getValueExpression().getName();
        }
        BigdataValue v = ((ConstantNode)t).getValue();
        if (!(v instanceof Literal)) {
            throw new RuntimeException("Object position of query hint is not a Literal.");
        }
        Literal lit = (Literal)((Object)v);
        return lit.stringValue();
    }

    private void applyQueryHint(AST2BOpContext context, QueryRoot queryRoot, QueryBase queryBase, GraphPatternGroup<IGroupMemberNode> group, ASTBase prior, StatementPatternNode hint) {
        if (context == null) {
            throw new IllegalArgumentException();
        }
        if (queryRoot == null) {
            throw new IllegalArgumentException();
        }
        if (group == null) {
            throw new IllegalArgumentException();
        }
        if (hint == null) {
            throw new IllegalArgumentException();
        }
        QueryHintScope scope = this.getScope(hint.s());
        String name = this.getName(hint.p());
        String value = this.getValue(hint.o());
        if (log.isInfoEnabled()) {
            log.info("name=" + name + ", scope=" + (Object)((Object)scope) + ", value=" + value);
        }
        switch (scope) {
            case Query: {
                this.applyToQuery(context, queryRoot, scope, name, value);
                break;
            }
            case SubQuery: {
                this.applyToSubQuery(context, queryRoot, scope, queryBase, group, name, value);
                break;
            }
            case Group: {
                this.applyToGroup(context, queryRoot, scope, group, name, value);
                break;
            }
            case GroupAndSubGroups: {
                this.applyToGroupAndSubGroups(context, queryRoot, scope, group, name, value);
                break;
            }
            case Prior: {
                if (scope == QueryHintScope.Prior && prior == null) {
                    throw new RuntimeException("Query hint with Prior scope must follow the AST node to which it will bind.");
                }
                this._applyQueryHint(context, queryRoot, scope, prior, name, value);
                break;
            }
            default: {
                throw new UnsupportedOperationException("Unknown scope: " + (Object)((Object)scope));
            }
        }
    }

    private void applyToSubQuery(AST2BOpContext context, QueryRoot queryRoot, QueryHintScope scope, QueryBase queryBase, GraphPatternGroup<IGroupMemberNode> group, String name, String value) {
        for (GraphPatternGroup<IGroupMemberNode> parent = group; parent != null; parent = parent.getParentGraphPatternGroup()) {
            group = parent;
        }
        this.applyToGroupAndSubGroups(context, queryRoot, scope, group, name, value);
        this._applyQueryHint(context, queryRoot, scope, queryBase, name, value);
    }

    private void applyToQuery(AST2BOpContext context, QueryRoot queryRoot, QueryHintScope scope, String name, String value) {
        Iterator<BOp> itr = BOpUtility.preOrderIteratorWithAnnotations(queryRoot);
        LinkedList<ASTBase> list = new LinkedList<ASTBase>();
        while (itr.hasNext()) {
            BOp op = itr.next();
            if (!this.isNodeAcceptingQueryHints(op)) continue;
            ASTBase t = (ASTBase)op;
            list.add(t);
        }
        for (ASTBase t : list) {
            this._applyQueryHint(context, queryRoot, scope, t, name, value);
        }
    }

    private void applyToGroupAndSubGroups(AST2BOpContext context, QueryRoot queryRoot, QueryHintScope scope, GraphPatternGroup<IGroupMemberNode> group, String name, String value) {
        for (IGroupMemberNode child : group) {
            this._applyQueryHint(context, queryRoot, scope, (ASTBase)((Object)child), name, value);
            if (!(child instanceof GraphPatternGroup)) continue;
            this.applyToGroupAndSubGroups(context, queryRoot, scope, (GraphPatternGroup)child, name, value);
        }
        this._applyQueryHint(context, queryRoot, scope, group, name, value);
    }

    private void applyToGroup(AST2BOpContext context, QueryRoot queryRoot, QueryHintScope scope, GraphPatternGroup<IGroupMemberNode> group, String name, String value) {
        for (IGroupMemberNode child : group) {
            this._applyQueryHint(context, queryRoot, scope, (ASTBase)((Object)child), name, value);
        }
        this._applyQueryHint(context, queryRoot, scope, group, name, value);
    }
}

