/*
 * Decompiled with CFR 0.152.
 */
package com.bigdata.rdf.sparql.ast.optimizers;

import com.bigdata.bop.BOp;
import com.bigdata.bop.IBindingSet;
import com.bigdata.bop.IVariable;
import com.bigdata.rdf.sparql.ast.GraphPatternGroup;
import com.bigdata.rdf.sparql.ast.GroupNodeBase;
import com.bigdata.rdf.sparql.ast.IGroupMemberNode;
import com.bigdata.rdf.sparql.ast.IQueryNode;
import com.bigdata.rdf.sparql.ast.JoinGroupNode;
import com.bigdata.rdf.sparql.ast.NamedSubqueriesNode;
import com.bigdata.rdf.sparql.ast.NamedSubqueryInclude;
import com.bigdata.rdf.sparql.ast.NamedSubqueryRoot;
import com.bigdata.rdf.sparql.ast.ProjectionNode;
import com.bigdata.rdf.sparql.ast.QueryNodeWithBindingSet;
import com.bigdata.rdf.sparql.ast.QueryRoot;
import com.bigdata.rdf.sparql.ast.QueryType;
import com.bigdata.rdf.sparql.ast.StaticAnalysis;
import com.bigdata.rdf.sparql.ast.TermNode;
import com.bigdata.rdf.sparql.ast.VarNode;
import com.bigdata.rdf.sparql.ast.eval.AST2BOpContext;
import com.bigdata.rdf.sparql.ast.optimizers.IASTOptimizer;
import com.bigdata.rdf.sparql.ast.service.ServiceNode;
import com.bigdata.rdf.store.BDS;
import java.util.LinkedHashSet;
import java.util.Set;
import org.apache.log4j.Logger;

public class ASTServiceNodeOptimizer
implements IASTOptimizer {
    private static final Logger log = Logger.getLogger(ASTServiceNodeOptimizer.class);
    private int nrewrites = 0;

    @Override
    public QueryNodeWithBindingSet optimize(AST2BOpContext context, QueryNodeWithBindingSet input) {
        IQueryNode queryNode = input.getQueryNode();
        IBindingSet[] bindingSets = input.getBindingSets();
        if (!(queryNode instanceof QueryRoot)) {
            return new QueryNodeWithBindingSet(queryNode, bindingSets);
        }
        QueryRoot queryRoot = (QueryRoot)queryNode;
        GraphPatternGroup whereClause = queryRoot.getWhereClause();
        if (whereClause != null) {
            this.liftOutServiceNodes(queryRoot, context, whereClause, true);
        }
        if (queryRoot.getNamedSubqueries() != null) {
            NamedSubqueriesNode namedSubqueries = queryRoot.getNamedSubqueries();
            for (int i = 0; i < namedSubqueries.size(); ++i) {
                NamedSubqueryRoot namedSubquery = (NamedSubqueryRoot)namedSubqueries.get(i);
                GraphPatternGroup whereClause2 = namedSubquery.getWhereClause();
                if (whereClause2 == null) continue;
                this.liftOutServiceNodes(queryRoot, context, whereClause2, false);
            }
        }
        return new QueryNodeWithBindingSet(queryNode, bindingSets);
    }

    private void liftOutServiceNodes(QueryRoot queryRoot, AST2BOpContext context, GroupNodeBase<IGroupMemberNode> parent, boolean all) {
        boolean first = true;
        int arity = parent.arity();
        for (int i = 0; i < arity; ++i) {
            ServiceNode serviceNode;
            TermNode serviceRef;
            BOp child = parent.get(i);
            if (child instanceof ServiceNode && (serviceRef = (serviceNode = (ServiceNode)child).getServiceRef()).isConstant() && serviceRef.getValue().equals(BDS.SEARCH)) {
                if (all || !first) {
                    this.liftOutServiceNode(queryRoot, context, parent, serviceNode);
                }
                first = false;
            }
            if (!(child instanceof GroupNodeBase)) continue;
            GroupNodeBase childGroup = (GroupNodeBase)child;
            this.liftOutServiceNodes(queryRoot, context, childGroup, true);
        }
    }

    private void liftOutServiceNode(QueryRoot queryRoot, AST2BOpContext context, GroupNodeBase<IGroupMemberNode> parent, ServiceNode serviceNode) {
        StaticAnalysis sa = new StaticAnalysis(queryRoot, context);
        String namedSolutionSet = "%-anon-service-call-" + this.nrewrites++;
        NamedSubqueryRoot namedSubqueryRoot = new NamedSubqueryRoot(QueryType.SELECT, namedSolutionSet);
        ProjectionNode projection = new ProjectionNode();
        namedSubqueryRoot.setProjection(projection);
        Set<IVariable<?>> varSet = sa.getSpannedVariables(serviceNode.getGraphPattern(), new LinkedHashSet());
        for (IVariable<?> var : varSet) {
            projection.addProjectionVar(new VarNode(var.getName()));
        }
        JoinGroupNode whereClause = new JoinGroupNode((IGroupMemberNode)serviceNode);
        namedSubqueryRoot.setWhereClause(whereClause);
        queryRoot.getNamedSubqueriesNotNull().add(namedSubqueryRoot);
        NamedSubqueryInclude namedSubqueryInclude = new NamedSubqueryInclude(namedSolutionSet);
        parent.replaceWith(serviceNode, namedSubqueryInclude);
        if (log.isInfoEnabled()) {
            log.info("\nLifted: " + serviceNode);
            log.info("\nFrom parentGroup:" + parent);
            log.info("\nInto namedSubquery: " + namedSubqueryRoot);
        }
    }
}

