/*
 * Decompiled with CFR 0.152.
 */
package com.bigdata.rdf.sparql.ast.optimizers;

import com.bigdata.bop.BOp;
import com.bigdata.bop.BOpUtility;
import com.bigdata.bop.IBindingSet;
import com.bigdata.bop.aggregate.AggregateBase;
import com.bigdata.rdf.sparql.ast.AssignmentNode;
import com.bigdata.rdf.sparql.ast.DatasetNode;
import com.bigdata.rdf.sparql.ast.FunctionNode;
import com.bigdata.rdf.sparql.ast.FunctionRegistry;
import com.bigdata.rdf.sparql.ast.GraphPatternGroup;
import com.bigdata.rdf.sparql.ast.GroupByNode;
import com.bigdata.rdf.sparql.ast.IGroupMemberNode;
import com.bigdata.rdf.sparql.ast.IQueryNode;
import com.bigdata.rdf.sparql.ast.IValueExpressionNode;
import com.bigdata.rdf.sparql.ast.JoinGroupNode;
import com.bigdata.rdf.sparql.ast.NamedSubqueriesNode;
import com.bigdata.rdf.sparql.ast.NamedSubqueryRoot;
import com.bigdata.rdf.sparql.ast.ProjectionNode;
import com.bigdata.rdf.sparql.ast.QueryBase;
import com.bigdata.rdf.sparql.ast.QueryNodeWithBindingSet;
import com.bigdata.rdf.sparql.ast.QueryRoot;
import com.bigdata.rdf.sparql.ast.QueryType;
import com.bigdata.rdf.sparql.ast.StatementPatternNode;
import com.bigdata.rdf.sparql.ast.StaticAnalysis;
import com.bigdata.rdf.sparql.ast.SubqueryRoot;
import com.bigdata.rdf.sparql.ast.TermNode;
import com.bigdata.rdf.sparql.ast.VarNode;
import com.bigdata.rdf.sparql.ast.eval.AST2BOpContext;
import com.bigdata.rdf.sparql.ast.optimizers.IASTOptimizer;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;

public class ASTSimpleGroupByAndCountOptimizer
implements IASTOptimizer {
    private static final transient Logger log = Logger.getLogger(ASTSimpleGroupByAndCountOptimizer.class);

    @Override
    public QueryNodeWithBindingSet optimize(AST2BOpContext context, QueryNodeWithBindingSet input) {
        QueryRoot qr;
        NamedSubqueriesNode namedSubqueries;
        IQueryNode queryNode = input.getQueryNode();
        IBindingSet[] bindingSets = input.getBindingSets();
        if (context.getAbstractTripleStore().getSPORelation().indicesHaveDeleteMarkers()) {
            return new QueryNodeWithBindingSet(queryNode, bindingSets);
        }
        QueryRoot queryRoot = (QueryRoot)queryNode;
        StaticAnalysis sa = new StaticAnalysis(queryRoot, context);
        DatasetNode dataset = queryRoot.getDataset();
        if (context.getAbstractTripleStore().isQuads()) {
            boolean ok = false;
            if (dataset == null || dataset.getNamedGraphs() == null) {
                ok = true;
            }
            if (!ok) {
                return new QueryNodeWithBindingSet(queryNode, bindingSets);
            }
        }
        if ((namedSubqueries = queryRoot.getNamedSubqueries()) != null) {
            List<NamedSubqueryRoot> list = BOpUtility.toList(namedSubqueries, NamedSubqueryRoot.class);
            for (NamedSubqueryRoot namedSubquery : list) {
                this.doSelectQuery(context, sa, (QueryRoot)queryNode, namedSubquery);
            }
        }
        if ((qr = (QueryRoot)queryNode).getHaving() == null) {
            this.doSelectQuery(context, sa, (QueryRoot)queryNode, (QueryBase)queryNode);
        }
        return new QueryNodeWithBindingSet(queryNode, bindingSets);
    }

    private void doSelectQuery(AST2BOpContext context, StaticAnalysis sa, QueryRoot queryRoot, QueryBase queryBase) {
        int i;
        ProjectionNode projectionNode = null;
        Integer indexOfVarNode = null;
        Integer indexOfCountNode = null;
        VarNode countNodeVar = null;
        StatementPatternNode stmtPattern = null;
        VarNode groupingVar = null;
        GroupByNode groupByNode = queryBase.getGroupBy();
        if (groupByNode == null || groupByNode.arity() != 1 || !(groupByNode.get(0) instanceof AssignmentNode)) {
            return;
        }
        AssignmentNode assignmentNodeInGroupBy = (AssignmentNode)groupByNode.get(0);
        if (assignmentNodeInGroupBy.arity() != 2 || !(assignmentNodeInGroupBy.get(0) instanceof VarNode) || !(assignmentNodeInGroupBy.get(1) instanceof VarNode)) {
            return;
        }
        groupingVar = (VarNode)assignmentNodeInGroupBy.get(1);
        VarNode groupingVarRenamed = (VarNode)assignmentNodeInGroupBy.get(0);
        QueryType queryType = queryBase.getQueryType();
        if (!QueryType.SELECT.equals((Object)queryType)) {
            return;
        }
        GraphPatternGroup<IGroupMemberNode> graphPattern = queryBase.getGraphPattern();
        if (graphPattern.args().size() != 1) {
            return;
        }
        BOp potentialStmtPattern = graphPattern.get(0);
        if (!(potentialStmtPattern instanceof StatementPatternNode)) {
            return;
        }
        stmtPattern = (StatementPatternNode)potentialStmtPattern;
        if (context.getAbstractTripleStore().isRDRHistory() && !stmtPattern.getQueryHintAsBoolean("history", false)) {
            if (log.isDebugEnabled()) {
                log.debug("nope");
            }
            return;
        }
        if (log.isDebugEnabled()) {
            log.debug("yep");
        }
        HashSet<VarNode> varNodesInStmtPattern = new HashSet<VarNode>();
        VarNode graphVarNode = null;
        for (i = 0; i < stmtPattern.arity(); ++i) {
            TermNode arg = stmtPattern.get(i);
            if (!(arg instanceof VarNode)) continue;
            varNodesInStmtPattern.add((VarNode)arg);
            if (i != 3) continue;
            graphVarNode = (VarNode)arg;
        }
        if (!varNodesInStmtPattern.contains(groupingVar)) {
            return;
        }
        projectionNode = queryBase.getProjection();
        if (projectionNode.size() != 2) {
            return;
        }
        indexOfVarNode = null;
        indexOfCountNode = null;
        for (i = 0; i < 2; ++i) {
            AssignmentNode curNode = (AssignmentNode)projectionNode.getExpr(i);
            IValueExpressionNode valNode = curNode.getValueExpressionNode();
            if (valNode instanceof FunctionNode && indexOfCountNode == null) {
                FunctionNode fNode = (FunctionNode)curNode.getValueExpressionNode();
                if (!fNode.getFunctionURI().equals(FunctionRegistry.COUNT)) {
                    return;
                }
                Map<String, Object> scalarVals = fNode.getScalarValues();
                Object isDistinct = scalarVals.get(AggregateBase.Annotations.DISTINCT);
                if (isDistinct != null && isDistinct instanceof Boolean && ((Boolean)isDistinct).booleanValue()) {
                    return;
                }
                if (fNode.args().size() != 1) {
                    return;
                }
                BOp inner = fNode.args().get(0);
                if (!(inner instanceof VarNode)) {
                    return;
                }
                VarNode innerVarNode = (VarNode)inner;
                boolean countOnPotentiallyUnboundVariable = varNodesInStmtPattern.contains(innerVarNode) && !innerVarNode.equals(graphVarNode);
                boolean isWildcard = innerVarNode.isWildcard();
                if (!countOnPotentiallyUnboundVariable && !isWildcard) {
                    return;
                }
                if (!(curNode.get(0) instanceof VarNode)) {
                    return;
                }
                countNodeVar = (VarNode)curNode.get(0);
                indexOfCountNode = i;
                continue;
            }
            if (valNode instanceof VarNode && indexOfVarNode == null) {
                VarNode valNodeAsVarNode = (VarNode)valNode;
                if (!valNodeAsVarNode.equals(groupingVarRenamed)) {
                    return;
                }
                indexOfVarNode = i;
                continue;
            }
            return;
        }
        SubqueryRoot selectDistinct = new SubqueryRoot(QueryType.SELECT);
        ProjectionNode projection = new ProjectionNode();
        AssignmentNode assignemntNode = new AssignmentNode(groupingVar, groupingVar);
        projection.addArg(assignemntNode);
        projection.setDistinct(true);
        selectDistinct.setProjection(projection);
        JoinGroupNode join = new JoinGroupNode();
        join.addArg(stmtPattern);
        selectDistinct.setWhereClause(join);
        graphPattern.setArg(0, selectDistinct);
        StatementPatternNode stmtPatternClone = new StatementPatternNode(stmtPattern);
        stmtPatternClone.setFastRangeCount(countNodeVar);
        graphPattern.addArg(stmtPatternClone);
        projectionNode.setArg(indexOfCountNode, new AssignmentNode(new VarNode(countNodeVar), new VarNode(countNodeVar)));
        queryBase.setGroupBy(null);
    }
}

