/*
 * Decompiled with CFR 0.152.
 */
package com.bigdata.rdf.sparql.ast.optimizers;

import com.bigdata.bop.IVariable;
import com.bigdata.rdf.sparql.ast.IBindingProducerNode;
import com.bigdata.rdf.sparql.ast.IReorderableNode;
import com.bigdata.rdf.sparql.ast.QueryRoot;
import com.bigdata.rdf.sparql.ast.StatementPatternNode;
import com.bigdata.rdf.sparql.ast.StaticAnalysis;
import com.bigdata.rdf.sparql.ast.VarNode;
import com.bigdata.rdf.sparql.ast.eval.AST2BOpContext;
import com.bigdata.rdf.sparql.ast.optimizers.ASTStaticJoinOptimizer;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.apache.log4j.Logger;

public final class StaticOptimizer {
    private static final transient Logger log = ASTStaticJoinOptimizer.log;
    private final StaticAnalysis sa;
    private final IBindingProducerNode[] ancestry;
    private final Set<IVariable<?>> ancestryVars;
    private final List<IReorderableNode> nodes;
    private final int arity;
    private final long cardinality;
    private static final long NO_SHARED_VARS = 0x7FFFFFFFFFFFFFFCL;
    private int[] order;
    private long[] rangeCount;
    private Tail[] tail;
    private boolean[] used;
    private final double optimistic;

    public int[] getOrder() {
        if (this.order == null) {
            throw new IllegalStateException();
        }
        return this.order;
    }

    public StaticOptimizer(StaticOptimizer parent, List<IReorderableNode> nodes) {
        this(parent.sa, parent.ancestry, nodes, parent.optimistic);
    }

    StaticOptimizer(QueryRoot queryRoot, AST2BOpContext context, IBindingProducerNode[] ancestry, List<IReorderableNode> nodes, double optimistic) {
        this(new StaticAnalysis(queryRoot, context), ancestry, nodes, optimistic);
    }

    private StaticOptimizer(StaticAnalysis sa, IBindingProducerNode[] ancestry, List<IReorderableNode> nodes, double optimistic) {
        int i;
        if (ancestry == null) {
            throw new IllegalArgumentException();
        }
        if (nodes == null) {
            throw new IllegalArgumentException();
        }
        this.sa = sa;
        this.ancestry = ancestry;
        this.ancestryVars = new LinkedHashSet();
        this.nodes = nodes;
        this.arity = nodes.size();
        if (log.isDebugEnabled()) {
            log.debug("arity: " + this.arity);
            for (i = 0; i < this.arity; ++i) {
                IReorderableNode node = nodes.get(i);
                log.debug(node.getClass() + ", reorderable: " + node.isReorderable() + ", estcard: " + node.getEstimatedCardinality(this) + ", vars: " + this.getVars(i));
                log.debug(node.getEstimatedCardinality(this));
                log.debug(node.isReorderable());
            }
        }
        this.optimistic = optimistic;
        this.cardinality = this.calc();
        if (ASTStaticJoinOptimizer.log.isDebugEnabled()) {
            for (i = 0; i < this.arity; ++i) {
                ASTStaticJoinOptimizer.log.debug(this.order[i]);
            }
        }
    }

    private long calc() {
        int i;
        if (this.order != null) {
            throw new IllegalStateException("calc should only be called from the constructor");
        }
        this.order = new int[this.arity];
        this.rangeCount = new long[this.arity];
        this.used = new boolean[this.arity];
        this.tail = new Tail[this.arity];
        for (int i2 = 0; i2 < this.arity; ++i2) {
            this.order[i2] = -1;
            this.rangeCount[i2] = -1L;
            this.used[i2] = false;
        }
        if (this.arity == 0) {
            return 1L;
        }
        if (this.arity == 1) {
            this.order[0] = 0;
            return this.cardinality(0);
        }
        for (IBindingProducerNode join : this.ancestry) {
            if (ASTStaticJoinOptimizer.log.isDebugEnabled()) {
                ASTStaticJoinOptimizer.log.debug("considering join node from ancestry: " + join);
            }
            this.sa.getDefinitelyProducedBindings(join, this.ancestryVars, true);
        }
        if (ASTStaticJoinOptimizer.log.isDebugEnabled()) {
            ASTStaticJoinOptimizer.log.debug("bindings from ancestry: " + Arrays.toString(this.ancestryVars.toArray()));
        }
        int preferredFirstTail = -1;
        for (i = 0; i < this.arity; ++i) {
            if (!this.nodes.get(i).getProperty("runFirst", false).booleanValue()) continue;
            preferredFirstTail = i;
            break;
        }
        for (i = 0; i < this.arity; ++i) {
            if (this.cardinality(i) != 0L) continue;
            preferredFirstTail = i;
            break;
        }
        if (preferredFirstTail == -1) {
            preferredFirstTail = this.getNextTailThatSharesVarsWithAncestry();
        }
        if (ASTStaticJoinOptimizer.log.isDebugEnabled()) {
            ASTStaticJoinOptimizer.log.debug("preferred first tail: " + preferredFirstTail);
        }
        if (this.arity == 2) {
            if (ASTStaticJoinOptimizer.log.isDebugEnabled()) {
                ASTStaticJoinOptimizer.log.debug("two tails left");
            }
            if (preferredFirstTail != -1) {
                this.order[0] = preferredFirstTail;
                this.order[1] = preferredFirstTail == 0 ? 1 : 0;
            } else {
                if (this.cardinality(0) == this.cardinality(1) && this.nodes.get(0) instanceof StatementPatternNode && this.nodes.get(1) instanceof StatementPatternNode) {
                    VarNode sid0 = ((StatementPatternNode)this.nodes.get(0)).sid();
                    VarNode sid1 = ((StatementPatternNode)this.nodes.get(1)).sid();
                    if (sid0 != null && sid1 == null) {
                        this.order[0] = 1;
                        this.order[1] = 0;
                    }
                }
                if (this.order[0] == -1) {
                    this.order[0] = this.cardinality(0) <= this.cardinality(1) ? 0 : 1;
                    this.order[1] = this.cardinality(0) <= this.cardinality(1) ? 1 : 0;
                }
            }
            return this.computeJoinCardinality(this.getTail(0), this.getTail(1));
        }
        Join join = preferredFirstTail == -1 ? this.getFirstJoin() : this.getFirstJoin(preferredFirstTail);
        long cardinality = join.cardinality;
        int t1 = ((Tail)join.getD1()).getTailIndex();
        int t2 = ((Tail)join.getD2()).getTailIndex();
        if (preferredFirstTail == -1) {
            this.order[0] = this.cardinality(t1) <= this.cardinality(t2) ? t1 : t2;
            this.order[1] = this.cardinality(t1) <= this.cardinality(t2) ? t2 : t1;
        } else {
            this.order[0] = t1;
            this.order[1] = t2;
        }
        this.used[this.order[0]] = true;
        this.used[this.order[1]] = true;
        for (int i3 = 2; i3 < this.arity; ++i3) {
            join = this.getNextJoin(join);
            this.order[i3] = ((Tail)join.getD2()).getTailIndex();
            this.used[this.order[i3]] = true;
        }
        return cardinality;
    }

    private Join getFirstJoin() {
        if (ASTStaticJoinOptimizer.log.isDebugEnabled()) {
            ASTStaticJoinOptimizer.log.debug("evaluating first join");
        }
        long minJoinCardinality = Long.MAX_VALUE;
        long minTailCardinality = Long.MAX_VALUE;
        long minOtherTailCardinality = Long.MAX_VALUE;
        Tail minT1 = null;
        Tail minT2 = null;
        for (int i = 0; i < this.arity; ++i) {
            if (this.used[i]) continue;
            Tail t1 = this.getTail(i);
            long t1Cardinality = this.cardinality(i);
            for (int j = 0; j < this.arity; ++j) {
                if (i == j || this.used[j]) continue;
                Tail t2 = this.getTail(j);
                long t2Cardinality = this.cardinality(j);
                long joinCardinality = this.computeJoinCardinality(t1, t2);
                long tailCardinality = Math.min(t1Cardinality, t2Cardinality);
                long otherTailCardinality = Math.max(t1Cardinality, t2Cardinality);
                if (ASTStaticJoinOptimizer.log.isDebugEnabled()) {
                    ASTStaticJoinOptimizer.log.debug("evaluating " + i + " X " + j + ": cardinality= " + joinCardinality);
                }
                if (joinCardinality < minJoinCardinality) {
                    if (ASTStaticJoinOptimizer.log.isDebugEnabled()) {
                        ASTStaticJoinOptimizer.log.debug("found a new min: " + joinCardinality);
                    }
                    minJoinCardinality = joinCardinality;
                    minTailCardinality = tailCardinality;
                    minOtherTailCardinality = otherTailCardinality;
                    minT1 = t1;
                    minT2 = t2;
                    continue;
                }
                if (joinCardinality != minJoinCardinality) continue;
                if (tailCardinality < minTailCardinality) {
                    if (ASTStaticJoinOptimizer.log.isDebugEnabled()) {
                        ASTStaticJoinOptimizer.log.debug("found a new min: " + joinCardinality);
                    }
                    minJoinCardinality = joinCardinality;
                    minTailCardinality = tailCardinality;
                    minOtherTailCardinality = otherTailCardinality;
                    minT1 = t1;
                    minT2 = t2;
                    continue;
                }
                if (tailCardinality != minTailCardinality || otherTailCardinality >= minOtherTailCardinality) continue;
                if (ASTStaticJoinOptimizer.log.isDebugEnabled()) {
                    ASTStaticJoinOptimizer.log.debug("found a new min: " + joinCardinality);
                }
                minJoinCardinality = joinCardinality;
                minTailCardinality = tailCardinality;
                minOtherTailCardinality = otherTailCardinality;
                minT1 = t1;
                minT2 = t2;
            }
        }
        HashSet<String> vars = new HashSet<String>();
        vars.addAll(minT1.getVars());
        vars.addAll(minT2.getVars());
        return new Join(minT1, minT2, minJoinCardinality, vars);
    }

    private Join getFirstJoin(int preferredFirstTail) {
        if (ASTStaticJoinOptimizer.log.isDebugEnabled()) {
            ASTStaticJoinOptimizer.log.debug("evaluating first join");
        }
        long minJoinCardinality = Long.MAX_VALUE;
        long minOtherTailCardinality = Long.MAX_VALUE;
        Tail minT2 = null;
        int i = preferredFirstTail;
        Tail t1 = this.getTail(i);
        for (int j = 0; j < this.arity; ++j) {
            if (i == j || this.used[j]) continue;
            Tail t2 = this.getTail(j);
            long t2Cardinality = this.cardinality(j);
            long joinCardinality = this.computeJoinCardinality(t1, t2);
            if (ASTStaticJoinOptimizer.log.isDebugEnabled()) {
                ASTStaticJoinOptimizer.log.debug("evaluating " + i + " X " + j + ": cardinality= " + joinCardinality);
            }
            if (joinCardinality < minJoinCardinality) {
                if (ASTStaticJoinOptimizer.log.isDebugEnabled()) {
                    ASTStaticJoinOptimizer.log.debug("found a new min: " + joinCardinality);
                }
                minJoinCardinality = joinCardinality;
                minOtherTailCardinality = t2Cardinality;
                minT2 = t2;
                continue;
            }
            if (joinCardinality != minJoinCardinality || t2Cardinality >= minOtherTailCardinality) continue;
            if (ASTStaticJoinOptimizer.log.isDebugEnabled()) {
                ASTStaticJoinOptimizer.log.debug("found a new min: " + joinCardinality);
            }
            minJoinCardinality = joinCardinality;
            minOtherTailCardinality = t2Cardinality;
            minT2 = t2;
        }
        HashSet<String> vars = new HashSet<String>();
        vars.addAll(t1.getVars());
        vars.addAll(minT2.getVars());
        return new Join(t1, minT2, minJoinCardinality, vars);
    }

    private Tail getTail(int tailIndex) {
        if (this.tail[tailIndex] == null) {
            this.tail[tailIndex] = new Tail(tailIndex, this.rangeCount(tailIndex), this.getVars(tailIndex));
        }
        return this.tail[tailIndex];
    }

    private Join getNextJoin(IJoinDimension d1) {
        long tailCardinality;
        int i;
        if (ASTStaticJoinOptimizer.log.isDebugEnabled()) {
            ASTStaticJoinOptimizer.log.debug("evaluating next join");
        }
        long minJoinCardinality = Long.MAX_VALUE;
        long minTailCardinality = Long.MAX_VALUE;
        Tail minTail = null;
        for (i = 0; i < this.arity; ++i) {
            if (this.used[i]) continue;
            Tail tail = this.getTail(i);
            tailCardinality = this.cardinality(i);
            long joinCardinality = this.computeJoinCardinality(d1, tail);
            if (ASTStaticJoinOptimizer.log.isDebugEnabled()) {
                ASTStaticJoinOptimizer.log.debug("evaluating " + d1.toJoinString() + " X " + i + ": cardinality= " + joinCardinality);
            }
            if (joinCardinality < minJoinCardinality) {
                if (ASTStaticJoinOptimizer.log.isDebugEnabled()) {
                    ASTStaticJoinOptimizer.log.debug("found a new min: " + joinCardinality);
                }
                minJoinCardinality = joinCardinality;
                minTailCardinality = tailCardinality;
                minTail = tail;
                continue;
            }
            if (joinCardinality != minJoinCardinality || tailCardinality >= minTailCardinality) continue;
            if (ASTStaticJoinOptimizer.log.isDebugEnabled()) {
                ASTStaticJoinOptimizer.log.debug("found a new min: " + joinCardinality);
            }
            minJoinCardinality = joinCardinality;
            minTailCardinality = tailCardinality;
            minTail = tail;
        }
        if (minJoinCardinality == 0x7FFFFFFFFFFFFFFCL && (i = this.getNextTailThatSharesVarsWithAncestry()) >= 0) {
            long tailCardinality2;
            minJoinCardinality = tailCardinality2 = this.cardinality(i);
            minTail = this.getTail(i);
            if (ASTStaticJoinOptimizer.log.isDebugEnabled()) {
                ASTStaticJoinOptimizer.log.debug("found a new min: " + tailCardinality2);
            }
        }
        if (minJoinCardinality == 0x7FFFFFFFFFFFFFFCL) {
            minJoinCardinality = Long.MAX_VALUE;
            for (i = 0; i < this.arity; ++i) {
                if (this.used[i]) continue;
                Tail tail = this.getTail(i);
                tailCardinality = this.cardinality(i);
                if (tailCardinality >= minJoinCardinality) continue;
                if (ASTStaticJoinOptimizer.log.isDebugEnabled()) {
                    ASTStaticJoinOptimizer.log.debug("found a new min: " + tailCardinality);
                }
                minJoinCardinality = tailCardinality;
                minTail = tail;
            }
        }
        HashSet<String> vars = new HashSet<String>();
        vars.addAll(d1.getVars());
        vars.addAll(minTail.getVars());
        return new Join(d1, minTail, minJoinCardinality, vars);
    }

    public long rangeCount(int tailIndex) {
        if (this.rangeCount[tailIndex] == -1L) {
            long rangeCount;
            this.rangeCount[tailIndex] = rangeCount = this.nodes.get(tailIndex).getEstimatedCardinality(this);
        }
        return this.rangeCount[tailIndex];
    }

    public long cardinality(int tailIndex) {
        return this.rangeCount(tailIndex);
    }

    public String toString() {
        return Arrays.toString(this.getOrder());
    }

    protected long computeJoinCardinality(IJoinDimension d1, IJoinDimension d2) {
        boolean sharedVars = this.hasSharedVars(d1, d2);
        boolean unsharedVars = this.hasUnsharedVars(d1, d2);
        long joinCardinality = !sharedVars ? 0x7FFFFFFFFFFFFFFCL : (!unsharedVars ? Math.min(d1.getCardinality(), d2.getCardinality()) : (long)((double)((long)(this.optimistic * (double)Math.min(d1.getCardinality(), d2.getCardinality()))) + (1.0 - this.optimistic) * (double)Math.max(d1.getCardinality(), d2.getCardinality())));
        return joinCardinality;
    }

    protected Set<String> getVars(int tail) {
        IReorderableNode node = this.nodes.get(tail);
        LinkedHashSet vars = new LinkedHashSet();
        this.sa.getDefinitelyProducedBindings(node, vars, true);
        LinkedHashSet<String> varNames = new LinkedHashSet<String>();
        for (IVariable iVariable : vars) {
            varNames.add(iVariable.getName());
        }
        return varNames;
    }

    protected boolean hasSharedVars(IJoinDimension d1, IJoinDimension d2) {
        for (String var : d1.getVars()) {
            if (!d2.getVars().contains(var)) continue;
            return true;
        }
        return false;
    }

    protected boolean sharesVarsWithAncestry(int tail) {
        Set<IVariable<?>> tailVars = this.sa.getDefinitelyProducedBindings(this.nodes.get(tail), new LinkedHashSet(), true);
        return !Collections.disjoint(this.ancestryVars, tailVars);
    }

    protected int getNextTailThatSharesVarsWithAncestry() {
        int nextTail = -1;
        long minCardinality = Long.MAX_VALUE;
        for (int i = 0; i < this.arity; ++i) {
            long tailCardinality;
            if (this.used[i]) continue;
            if (ASTStaticJoinOptimizer.log.isDebugEnabled()) {
                ASTStaticJoinOptimizer.log.debug("considering tail: " + this.nodes.get(i));
            }
            if (ASTStaticJoinOptimizer.log.isDebugEnabled()) {
                ASTStaticJoinOptimizer.log.debug("vars: " + Arrays.toString(this.getVars(i).toArray()));
            }
            if (!this.sharesVarsWithAncestry(i) || (tailCardinality = this.cardinality(i)) >= minCardinality) continue;
            nextTail = i;
            minCardinality = tailCardinality;
        }
        return nextTail;
    }

    protected boolean hasUnsharedVars(IJoinDimension d1, IJoinDimension d2) {
        for (String var : d1.getVars()) {
            if (d2.getVars().contains(var)) continue;
            return true;
        }
        for (String var : d2.getVars()) {
            if (d1.getVars().contains(var)) continue;
            return true;
        }
        return false;
    }

    public long getCardinality() {
        return this.cardinality;
    }

    private class Tail
    implements IJoinDimension {
        private final int tailIndex;
        private final long cardinality;
        private final Set<String> vars;

        public Tail(int tail, long cardinality, Set<String> vars) {
            this.tailIndex = tail;
            this.cardinality = cardinality;
            this.vars = vars;
        }

        public int getTailIndex() {
            return this.tailIndex;
        }

        @Override
        public long getCardinality() {
            return this.cardinality;
        }

        @Override
        public Set<String> getVars() {
            return this.vars;
        }

        @Override
        public String toJoinString() {
            return String.valueOf(this.tailIndex);
        }
    }

    private static class Join
    implements IJoinDimension {
        private final IJoinDimension d1;
        private final IJoinDimension d2;
        private final long cardinality;
        private final Set<String> vars;

        public Join(IJoinDimension d1, IJoinDimension d2, long cardinality, Set<String> vars) {
            this.d1 = d1;
            this.d2 = d2;
            this.cardinality = cardinality;
            this.vars = vars;
        }

        public IJoinDimension getD1() {
            return this.d1;
        }

        public IJoinDimension getD2() {
            return this.d2;
        }

        @Override
        public Set<String> getVars() {
            return this.vars;
        }

        @Override
        public long getCardinality() {
            return this.cardinality;
        }

        @Override
        public String toJoinString() {
            return this.d1.toJoinString() + " X " + this.d2.toJoinString();
        }
    }

    private static interface IJoinDimension {
        public long getCardinality();

        public Set<String> getVars();

        public String toJoinString();
    }
}

