/*
 * Decompiled with CFR 0.152.
 */
package com.bigdata.rdf.sparql.ast.service;

import com.bigdata.bop.IVariable;
import com.bigdata.rdf.sparql.ast.service.RemoteSparql10QueryBuilder;
import com.bigdata.rdf.sparql.ast.service.RemoteSparql11QueryBuilder;
import com.bigdata.rdf.sparql.ast.service.ServiceNode;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;
import org.openrdf.model.BNode;
import org.openrdf.model.Value;
import org.openrdf.query.Binding;
import org.openrdf.query.BindingSet;

public class RemoteSparql11DraftQueryBuilder
extends RemoteSparql11QueryBuilder {
    private static final Logger log = Logger.getLogger(RemoteSparql10QueryBuilder.class);

    public RemoteSparql11DraftQueryBuilder(ServiceNode serviceNode) {
        super(serviceNode);
    }

    @Override
    public String getSparqlQuery(BindingSet[] bindingSets) {
        int beginIndex;
        StringBuilder sb = new StringBuilder();
        if (this.prefixDecls != null) {
            for (Map.Entry e : this.prefixDecls.entrySet()) {
                sb.append("\n");
                sb.append("prefix ");
                sb.append((String)e.getKey());
                sb.append(":");
                sb.append(" <");
                sb.append((String)e.getValue());
                sb.append(">");
                sb.append("\n");
            }
        }
        sb.append("SELECT ");
        if (this.projectedVars.isEmpty()) {
            sb.append("*");
        } else {
            for (IVariable v : this.projectedVars) {
                sb.append(" ?");
                sb.append(v.getName());
            }
        }
        sb.append("\n");
        boolean singleEmptyBindingSet = bindingSets.length == 0 || bindingSets.length == 1 && bindingSets[0].size() == 0;
        Map<BNode, Set<String>> bnodes = null;
        if (!singleEmptyBindingSet) {
            bnodes = RemoteSparql11DraftQueryBuilder.getCorrelatedVariables(bindingSets);
        }
        if ((beginIndex = this.exprImage.indexOf("{") + 1) < 0) {
            throw new RuntimeException();
        }
        int endIndex = this.exprImage.lastIndexOf("}");
        if (endIndex < beginIndex) {
            throw new RuntimeException();
        }
        String tmp = this.exprImage.substring(beginIndex, endIndex);
        sb.append("WHERE {\n");
        if (bnodes != null) {
            for (Set<String> sameTermVars : bnodes.values()) {
                int nSameTerm = sameTermVars.size();
                if (nSameTerm < 2) continue;
                String[] names = sameTermVars.toArray(new String[nSameTerm]);
                sb.append("FILTER (");
                for (int i = 1; i < names.length; ++i) {
                    if (i > 1) {
                        sb.append(" &&");
                    }
                    sb.append(" sameTerm( ?" + names[0] + ", ?" + names[i] + ")");
                }
                sb.append(" ).\n");
            }
        }
        sb.append(tmp);
        sb.append("\n}\n");
        if (!singleEmptyBindingSet) {
            LinkedHashSet<String> vars = this.getDistinctVars(bindingSets);
            sb.append("BINDINGS");
            for (String v : vars) {
                sb.append(" ?");
                sb.append(v);
            }
            sb.append(" {\n");
            for (BindingSet bindingSet : bindingSets) {
                sb.append("(");
                for (String v : vars) {
                    sb.append(" ");
                    Binding b = bindingSet.getBinding(v);
                    if (b == null) {
                        sb.append("UNDEF");
                        continue;
                    }
                    Value val = b.getValue();
                    String ext = this.util.toExternal(val);
                    sb.append(ext);
                }
                sb.append(" )");
                sb.append("\n");
            }
            sb.append("}\n");
        }
        String q = sb.toString();
        if (log.isInfoEnabled()) {
            log.info("\n" + q);
        }
        return q;
    }
}

