/*
 * Decompiled with CFR 0.152.
 */
package com.bigdata.rdf.sparql.ast.service;

import com.bigdata.bop.BOp;
import com.bigdata.bop.IConstant;
import com.bigdata.bop.IValueExpression;
import com.bigdata.bop.IVariable;
import com.bigdata.rdf.internal.impl.TermId;
import com.bigdata.rdf.sparql.ast.FilterNode;
import com.bigdata.rdf.sparql.ast.GraphPatternGroup;
import com.bigdata.rdf.sparql.ast.GroupMemberNodeBase;
import com.bigdata.rdf.sparql.ast.IGraphPatternContainer;
import com.bigdata.rdf.sparql.ast.IGroupMemberNode;
import com.bigdata.rdf.sparql.ast.IJoinNode;
import com.bigdata.rdf.sparql.ast.StaticAnalysis;
import com.bigdata.rdf.sparql.ast.TermNode;
import com.bigdata.rdf.sparql.ast.service.ServiceFactory;
import com.bigdata.rdf.sparql.ast.service.ServiceRegistry;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.openrdf.model.URI;

public class ServiceNode
extends GroupMemberNodeBase<IGroupMemberNode>
implements IJoinNode,
IGraphPatternContainer {
    private static final long serialVersionUID = 1L;

    public ServiceNode(ServiceNode op) {
        super(op);
    }

    public ServiceNode(BOp[] args, Map<String, Object> anns) {
        super(args, anns);
    }

    public ServiceNode(TermNode serviceRef, GraphPatternGroup<IGroupMemberNode> groupNode) {
        super(new BOp[0], null);
        this.setServiceRef(serviceRef);
        this.setGraphPattern(groupNode);
    }

    public TermNode getServiceRef() {
        return (TermNode)this.getRequiredProperty("serviceRef");
    }

    public void setServiceRef(TermNode serviceRef) {
        if (serviceRef == null) {
            throw new IllegalArgumentException();
        }
        this.setProperty("serviceRef", serviceRef);
    }

    @Override
    public GraphPatternGroup<IGroupMemberNode> getGraphPattern() {
        return (GraphPatternGroup)this.getRequiredProperty("graphPattern");
    }

    @Override
    public void setGraphPattern(GraphPatternGroup<IGroupMemberNode> graphPattern) {
        if (graphPattern == null) {
            throw new IllegalArgumentException();
        }
        graphPattern.setParent(null);
        super.setProperty("graphPattern", graphPattern);
    }

    @Override
    public final boolean isOptional() {
        return false;
    }

    @Override
    public final boolean isMinus() {
        return false;
    }

    public final boolean isSilent() {
        return this.getProperty("silent", false);
    }

    public final void setSilent(boolean silent) {
        this.setProperty("silent", silent);
    }

    public String getExprImage() {
        return (String)this.getProperty("exprImage");
    }

    public void setExprImage(String serviceExpressionString) {
        this.setProperty("exprImage", serviceExpressionString);
    }

    public Map<String, String> getPrefixDecls() {
        return (Map)this.getProperty("prefixDecls");
    }

    public void setPrefixDecls(Map<String, String> prefixDecls) {
        this.setProperty("prefixDecls", prefixDecls);
    }

    public void setProjectedVars(Set<IVariable<?>> projectedVars) {
        this.setProperty("projectedVars", projectedVars);
    }

    public Set<IVariable<?>> getProjectedVars() {
        return (Set)this.getProperty("projectedVars");
    }

    public void setTimeout(Long timeout) {
        this.setProperty("timeout", timeout);
    }

    public long getTimeout() {
        return this.getProperty("timeout", Long.MAX_VALUE);
    }

    @Override
    public final List<FilterNode> getAttachedJoinFilters() {
        List filters = (List)this.getProperty("filters");
        if (filters == null) {
            return Collections.emptyList();
        }
        return Collections.unmodifiableList(filters);
    }

    @Override
    public final void setAttachedJoinFilters(List<FilterNode> filters) {
        this.setProperty("filters", filters);
    }

    @Override
    public String toString(int indent) {
        List<FilterNode> filters;
        StringBuilder sb = new StringBuilder();
        TermNode serviceRef = this.getServiceRef();
        long timeout = this.getTimeout();
        sb.append("\n");
        sb.append(ServiceNode.indent(indent));
        sb.append("SERVICE");
        if (this.isSilent()) {
            sb.append(" SILENT");
        }
        if (serviceRef.isConstant()) {
            sb.append(" <");
            sb.append(serviceRef);
            sb.append(">");
        } else {
            sb.append(" ?");
            sb.append(serviceRef);
        }
        if (timeout != Long.MAX_VALUE) {
            sb.append(" [timeout=" + timeout + "ms]");
        }
        if (this.getGraphPattern() != null) {
            sb.append(" {");
            sb.append(this.getGraphPattern().toString(indent + 1));
            sb.append("\n").append(ServiceNode.indent(indent)).append("}");
        }
        if (!(filters = this.getAttachedJoinFilters()).isEmpty()) {
            for (FilterNode filter : filters) {
                sb.append(filter.toString(indent + 1));
            }
        }
        if (this.getQueryHints() != null && !this.getQueryHints().isEmpty()) {
            sb.append("\n");
            sb.append(ServiceNode.indent(indent + 1));
            sb.append("queryHints");
            sb.append("=");
            sb.append(this.getQueryHints().toString());
        }
        return sb.toString();
    }

    @Override
    public Set<IVariable<?>> getRequiredBound(StaticAnalysis sa) {
        try {
            return this.getResponsibleServiceFactory().getRequiredBound(this);
        }
        catch (IllegalArgumentException ex) {
            if (!this.isSilent()) {
                throw ex;
            }
            return new HashSet();
        }
    }

    @Override
    public Set<IVariable<?>> getDesiredBound(StaticAnalysis sa) {
        try {
            return this.getResponsibleServiceFactory().getDesiredBound(this);
        }
        catch (IllegalArgumentException ex) {
            if (!this.isSilent()) {
                throw ex;
            }
            return new HashSet();
        }
    }

    public ServiceFactory getResponsibleServiceFactory() {
        TermId valTerm;
        Object bdVal;
        IConstant serviceRefConst;
        Object val;
        ServiceRegistry serviceRegistry = ServiceRegistry.getInstance();
        IValueExpression serviceRef = this.getServiceRef().getValueExpression();
        URI serviceUri = null;
        if (serviceRef != null && serviceRef instanceof IConstant && (val = (serviceRefConst = (IConstant)serviceRef).get()) instanceof TermId && (bdVal = (valTerm = (TermId)val).getValue()) != null && bdVal instanceof URI) {
            serviceUri = (URI)bdVal;
        }
        if (this.isSilent()) {
            try {
                return serviceRegistry.getServiceFactoryByServiceURI(serviceUri);
            }
            catch (IllegalArgumentException ex) {
                return serviceRegistry.getNullServiceFactory();
            }
        }
        return serviceRegistry.getServiceFactoryByServiceURI(serviceUri);
    }

    static interface Annotations
    extends GroupMemberNodeBase.Annotations,
    IJoinNode.Annotations,
    IGraphPatternContainer.Annotations {
        public static final String SERVICE_REF = "serviceRef";
        public static final String NAMESPACE = "namespace";
        public static final String SILENT = "silent";
        public static final boolean DEFAULT_SILENT = false;
        public static final String TIMEOUT = "timeout";
        public static final long DEFAULT_TIMEOUT = Long.MAX_VALUE;
        public static final String EXPR_IMAGE = "exprImage";
        public static final String PREFIX_DECLS = "prefixDecls";
        public static final String PROJECTED_VARS = "projectedVars";
    }
}

