/*
 * Decompiled with CFR 0.152.
 */
package com.bigdata.rdf.sparql.ast.service.history;

import com.bigdata.btree.IIndex;
import com.bigdata.btree.ITupleIterator;
import com.bigdata.btree.keys.IKeyBuilder;
import com.bigdata.btree.keys.KVO;
import com.bigdata.journal.IIndexManager;
import com.bigdata.rdf.changesets.IChangeLog;
import com.bigdata.rdf.changesets.IChangeRecord;
import com.bigdata.rdf.sail.BigdataSail;
import com.bigdata.rdf.sparql.ast.eval.CustomServiceFactoryBase;
import com.bigdata.rdf.sparql.ast.service.BigdataNativeServiceOptions;
import com.bigdata.rdf.sparql.ast.service.IServiceOptions;
import com.bigdata.rdf.sparql.ast.service.ServiceCall;
import com.bigdata.rdf.sparql.ast.service.ServiceCallCreateParams;
import com.bigdata.rdf.sparql.ast.service.history.HistoryChangeRecord;
import com.bigdata.rdf.sparql.ast.service.history.HistoryIndexTupleSerializer;
import com.bigdata.rdf.spo.ISPO;
import com.bigdata.rdf.spo.SPORelation;
import com.bigdata.rdf.store.AbstractTripleStore;
import com.bigdata.relation.AbstractRelation;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import org.apache.log4j.Logger;

public class HistoryServiceFactory
extends CustomServiceFactoryBase {
    private static final transient Logger log = Logger.getLogger(HistoryServiceFactory.class);
    private final BigdataNativeServiceOptions serviceOptions = new BigdataNativeServiceOptions();

    public HistoryServiceFactory() {
        this.serviceOptions.setRunFirst(true);
    }

    @Override
    public IServiceOptions getServiceOptions() {
        return this.serviceOptions;
    }

    @Override
    public ServiceCall<?> create(ServiceCallCreateParams params) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void startConnection(BigdataSail.BigdataSailConnection conn) {
        AbstractTripleStore tripleStore = conn.getTripleStore();
        if (Boolean.valueOf(tripleStore.getProperty(BigdataSail.Options.HISTORY_SERVICE, "false")).booleanValue()) {
            conn.addChangeLog(new HistoryChangeLogListener(conn));
        }
    }

    private static class HistoryChangeLogListener
    implements IChangeLog {
        private static final int threshold = 10000;
        private final BigdataSail.BigdataSailConnection conn;
        private final AbstractTripleStore tripleStore;
        private final long minReleaseAge;
        private final long releaseTime;
        private volatile long revisionTimestamp;
        private Map<ISPO, IChangeRecord> changeSet;
        private IIndex ndx = null;

        HistoryChangeLogListener(BigdataSail.BigdataSailConnection conn) {
            this.conn = conn;
            this.tripleStore = conn.getTripleStore();
            this.revisionTimestamp = HistoryChangeLogListener.getRevisionTimestamp(this.tripleStore);
            this.minReleaseAge = Long.valueOf(this.tripleStore.getProperty(BigdataSail.Options.HISTORY_SERVICE_MIN_RELEASE_AGE, BigdataSail.Options.DEFAULT_HISTORY_SERVICE_MIN_RELEASE_AGE));
            this.releaseTime = System.currentTimeMillis() - this.minReleaseAge + 1L;
            if (log.isInfoEnabled()) {
                log.info("minReleaseAge=" + this.minReleaseAge + ", releaseTime=" + this.releaseTime);
            }
        }

        private static long getRevisionTimestamp(AbstractTripleStore tripleStore) {
            IIndexManager indexManager = tripleStore.getIndexManager();
            long revisionTimestamp = indexManager.getLastCommitTime() + 1L;
            return revisionTimestamp;
        }

        @Override
        public void transactionBegin() {
            this.revisionTimestamp = HistoryChangeLogListener.getRevisionTimestamp(this.tripleStore);
        }

        @Override
        public void transactionPrepare() {
            this.flush();
        }

        @Override
        public void changeEvent(IChangeRecord record) {
            if (this.changeSet == null) {
                this.changeSet = new HashMap<ISPO, IChangeRecord>();
                this.ndx = this.getHistoryIndex(this.tripleStore);
                if (this.minReleaseAge > 0L) {
                    this.pruneHistory();
                }
            }
            ISPO spo = record.getStatement();
            this.changeSet.put(spo, record);
            if (this.changeSet.size() > 10000) {
                this.flush();
            }
        }

        private IIndex getHistoryIndex(AbstractTripleStore tripleStore) {
            SPORelation spoRelation = tripleStore.getSPORelation();
            String fqn = AbstractRelation.getFQN(spoRelation, "HIST");
            this.ndx = spoRelation.getIndex(fqn);
            if (this.ndx == null) {
                throw new IllegalStateException("Index not found: " + fqn);
            }
            return this.ndx;
        }

        private void pruneHistory() {
            IKeyBuilder keyBuilder = this.ndx.getIndexMetadata().getKeyBuilder().reset();
            keyBuilder.append(this.releaseTime);
            byte[] toKey = keyBuilder.getKey();
            long n = 0L;
            ITupleIterator itr = this.ndx.rangeIterator(null, toKey, 0, 16, null);
            while (itr.hasNext()) {
                itr.next();
                ++n;
            }
            if (n > 0L && log.isInfoEnabled()) {
                log.info("pruned history: nremoved=" + n + ", minReleaseAge=" + this.minReleaseAge + ", releaseTime=" + this.releaseTime);
            }
        }

        @Override
        public void transactionCommited(long commitTime) {
            this.flush();
        }

        @Override
        public void transactionAborted() {
            this.reset();
        }

        @Override
        public void close() {
            this.reset();
        }

        private void reset() {
            this.changeSet = null;
        }

        private void flush() {
            if (this.changeSet != null) {
                int size = this.changeSet.size();
                Object[] b = new KVO[size];
                IChangeRecord[] a = this.changeSet.values().toArray(new IChangeRecord[size]);
                HistoryIndexTupleSerializer tupSer = (HistoryIndexTupleSerializer)this.ndx.getIndexMetadata().getTupleSerializer();
                for (int i = 0; i < size; ++i) {
                    IChangeRecord r = a[i];
                    HistoryChangeRecord s = new HistoryChangeRecord(r, this.revisionTimestamp);
                    byte[] key = tupSer.serializeKey(s);
                    byte[] val = tupSer.serializeVal(s);
                    b[i] = new KVO<HistoryChangeRecord>(key, val, s);
                }
                Arrays.sort(b);
                for (int i = 0; i < size; ++i) {
                    Object r = b[i];
                    this.ndx.insert(((KVO)r).key, ((KVO)r).val);
                }
                this.reset();
            }
        }
    }
}

