/*
 * Decompiled with CFR 0.152.
 */
package com.bigdata.rdf.sparql.ast.service.storedquery;

import com.bigdata.rdf.sail.BigdataSailRepositoryConnection;
import com.bigdata.rdf.sail.Sesame2BigdataIterator;
import com.bigdata.rdf.sparql.ast.eval.AbstractServiceFactoryBase;
import com.bigdata.rdf.sparql.ast.eval.ServiceParams;
import com.bigdata.rdf.sparql.ast.service.ExternalServiceCall;
import com.bigdata.rdf.sparql.ast.service.IServiceOptions;
import com.bigdata.rdf.sparql.ast.service.OpenrdfNativeServiceOptions;
import com.bigdata.rdf.sparql.ast.service.ServiceCallCreateParams;
import com.bigdata.rdf.sparql.ast.service.ServiceNode;
import com.bigdata.rdf.store.AbstractTripleStore;
import com.bigdata.rdf.task.AbstractApiTask;
import cutthecrap.utils.striterators.ICloseableIterator;
import java.util.Arrays;
import java.util.concurrent.FutureTask;
import org.apache.log4j.Logger;
import org.openrdf.query.BindingSet;
import org.openrdf.query.QueryEvaluationException;
import org.openrdf.query.TupleQueryResult;

public abstract class StoredQueryService
extends AbstractServiceFactoryBase {
    private static final transient Logger log = Logger.getLogger(StoredQueryService.class);
    private final OpenrdfNativeServiceOptions serviceOptions = new OpenrdfNativeServiceOptions();

    @Override
    public IServiceOptions getServiceOptions() {
        return this.serviceOptions;
    }

    public final ExternalServiceCall create(ServiceCallCreateParams params) {
        if (params == null) {
            throw new IllegalArgumentException();
        }
        AbstractTripleStore store = params.getTripleStore();
        if (store == null) {
            throw new IllegalArgumentException();
        }
        ServiceNode serviceNode = params.getServiceNode();
        if (serviceNode == null) {
            throw new IllegalArgumentException();
        }
        ServiceParams serviceParams = ServiceParams.gatherServiceParams(params);
        return this.create(params, serviceParams);
    }

    public ExternalServiceCall create(ServiceCallCreateParams createParams, ServiceParams serviceParams) {
        return new StoredQueryServiceCall(createParams, serviceParams);
    }

    protected abstract TupleQueryResult doQuery(BigdataSailRepositoryConnection var1, ServiceCallCreateParams var2, ServiceParams var3) throws Exception;

    private class StoredQueryServiceCall
    implements ExternalServiceCall {
        private final ServiceCallCreateParams createParams;
        private final ServiceParams serviceParams;

        public StoredQueryServiceCall(ServiceCallCreateParams createParams, ServiceParams serviceParams) {
            if (createParams == null) {
                throw new IllegalArgumentException();
            }
            if (serviceParams == null) {
                throw new IllegalArgumentException();
            }
            this.createParams = createParams;
            this.serviceParams = serviceParams;
        }

        @Override
        public IServiceOptions getServiceOptions() {
            return this.createParams.getServiceOptions();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public ICloseableIterator<BindingSet> call(BindingSet[] bindingSets) throws Exception {
            if (log.isInfoEnabled()) {
                log.info(bindingSets.length);
                log.info(Arrays.toString(bindingSets));
                log.info(this.serviceParams);
            }
            AbstractTripleStore tripleStore = this.createParams.getTripleStore();
            FutureTask<TupleQueryResult> ft = AbstractApiTask.submitApiTask(tripleStore.getIndexManager(), new StoredQueryTask(tripleStore.getNamespace(), tripleStore.getTimestamp(), bindingSets));
            try {
                TupleQueryResult tupleQueryResult = (TupleQueryResult)ft.get();
                Sesame2BigdataIterator<BindingSet, QueryEvaluationException> sesame2BigdataIterator = new Sesame2BigdataIterator<BindingSet, QueryEvaluationException>(tupleQueryResult);
                return sesame2BigdataIterator;
            }
            finally {
                ft.cancel(true);
            }
        }

        private class StoredQueryTask
        extends AbstractApiTask<TupleQueryResult> {
            private final BindingSet[] bindingSets;

            public StoredQueryTask(String namespace, long timestamp, BindingSet[] bindingSets) {
                super(namespace, timestamp);
                this.bindingSets = bindingSets;
            }

            @Override
            public boolean isReadOnly() {
                return true;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public TupleQueryResult call() throws Exception {
                BigdataSailRepositoryConnection cxn = null;
                boolean success = false;
                try {
                    cxn = this.getQueryConnection();
                    if (log.isTraceEnabled()) {
                        log.trace("Query running...");
                    }
                    TupleQueryResult ret = StoredQueryService.this.doQuery(cxn, StoredQueryServiceCall.this.createParams, StoredQueryServiceCall.this.serviceParams);
                    success = true;
                    if (log.isTraceEnabled()) {
                        log.trace("Query done.");
                    }
                    TupleQueryResult tupleQueryResult = ret;
                    return tupleQueryResult;
                }
                finally {
                    if (cxn != null) {
                        if (!success && !cxn.isReadOnly()) {
                            try {
                                cxn.rollback();
                            }
                            catch (Throwable t) {
                                log.error(t, t);
                            }
                        }
                        try {
                            cxn.close();
                        }
                        catch (Throwable t) {
                            log.error(t, t);
                        }
                    }
                }
            }
        }
    }

    public static interface Options {
    }
}

