/*
 * Decompiled with CFR 0.152.
 */
package com.bigdata.rdf.sparql.ast.ssets;

import com.bigdata.bop.IBindingSet;
import com.bigdata.bop.IVariable;
import com.bigdata.bop.NamedSolutionSetRefUtility;
import com.bigdata.bop.solutions.SolutionSetStream;
import com.bigdata.journal.IBTreeManager;
import com.bigdata.journal.IJournal;
import com.bigdata.journal.TimestampUtility;
import com.bigdata.rdf.sparql.ast.ISolutionSetStats;
import com.bigdata.rdf.sparql.ast.ssets.ISolutionSetManager;
import com.bigdata.rdf.spo.ISPO;
import com.bigdata.stream.Stream;
import com.bigdata.striterator.CloseableIteratorWrapper;
import cutthecrap.utils.striterators.ICloseableIterator;
import java.util.Arrays;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.UUID;
import org.apache.log4j.Logger;

public class SolutionSetManager
implements ISolutionSetManager {
    private static final transient Logger log = Logger.getLogger(SolutionSetManager.class);
    private final IBTreeManager store;
    private final String namespace;
    private final long timestamp;

    private IBTreeManager getStore() {
        return this.store;
    }

    public String toString() {
        return super.toString() + "{namespace=" + this.namespace + ",timestamp=" + TimestampUtility.toString(this.timestamp) + "}";
    }

    public SolutionSetManager(IBTreeManager store, String namespace, long timestamp) {
        if (store == null) {
            throw new IllegalArgumentException();
        }
        if (namespace == null) {
            throw new IllegalArgumentException();
        }
        this.store = store;
        this.namespace = namespace;
        this.timestamp = timestamp;
    }

    @Override
    public void init() {
    }

    @Override
    public void close() {
    }

    private String getFQN(String localName) {
        return NamedSolutionSetRefUtility.getFQN(this.namespace, localName, IVariable.EMPTY);
    }

    private void assertNotReadOnly() {
        if (TimestampUtility.isReadOnly(this.timestamp)) {
            throw new UnsupportedOperationException("Read Only");
        }
    }

    @Override
    public void clearAllSolutions() {
        this.assertNotReadOnly();
        String prefix = NamedSolutionSetRefUtility.getPrefix(this.namespace).toString();
        if (log.isInfoEnabled()) {
            log.info("Scanning: prefix=" + prefix);
        }
        Iterator<String> itr = this.getStore().indexNameScan(prefix, this.timestamp);
        while (itr.hasNext()) {
            String name = itr.next();
            this.getStore().dropIndex(name);
            if (!log.isInfoEnabled()) continue;
            log.info("Dropping: " + name);
        }
    }

    private SolutionSetStream getSolutionSet(String fqn) {
        if (this.timestamp == -1L) {
            return (SolutionSetStream)this.getStore().getIndexLocal(fqn, this.getStore().getLastCommitTime());
        }
        if (this.timestamp == 0L) {
            return (SolutionSetStream)this.getStore().getUnisolatedIndex(fqn);
        }
        if (TimestampUtility.isReadWriteTx(this.timestamp)) {
            long ts = this.getStore() instanceof IJournal ? ((IJournal)this.getStore()).getLocalTransactionManager().getTx(this.timestamp).getReadsOnCommitTime() : this.timestamp;
            return (SolutionSetStream)this.getStore().getIndexLocal(fqn, ts);
        }
        return (SolutionSetStream)this.getStore().getIndexLocal(fqn, this.timestamp);
    }

    @Override
    public boolean existsSolutions(String solutionSet) {
        if (solutionSet == null) {
            throw new IllegalArgumentException();
        }
        SolutionSetStream sset = this.getSolutionSet(this.getFQN(solutionSet));
        return sset != null;
    }

    @Override
    public boolean clearSolutions(String solutionSet) {
        if (log.isInfoEnabled()) {
            log.info("solutionSet: " + solutionSet);
        }
        if (this.existsSolutions(solutionSet)) {
            String fqn = this.getFQN(solutionSet);
            this.getStore().dropIndex(fqn);
            return true;
        }
        return false;
    }

    @Override
    public void putSolutions(String solutionSet, ICloseableIterator<IBindingSet[]> src) {
        if (src == null) {
            throw new IllegalArgumentException();
        }
        String fqn = this.getFQN(solutionSet);
        SolutionSetStream sset = this.getSolutionSet(fqn);
        if (sset == null) {
            sset = this._create(fqn, this.getDefaultMetadata());
        }
        this.writeSolutions(sset, src);
    }

    private SolutionSetStream _create(String fqn, ISPO[] params) {
        SolutionSetStream sset = this.getSolutionSet(fqn);
        if (sset != null) {
            throw new RuntimeException("Exists: " + fqn);
        }
        if (log.isInfoEnabled()) {
            log.info("Create: fqn=" + fqn + ", params=" + Arrays.toString(params));
        }
        Stream.StreamIndexMetadata md = new Stream.StreamIndexMetadata(fqn, UUID.randomUUID());
        md.setStreamClassName(SolutionSetStream.class.getName());
        sset = (SolutionSetStream)this.getStore().register(fqn, md);
        return sset;
    }

    @Override
    public void createSolutions(String solutionSet, ISPO[] params) {
        String fqn = this.getFQN(solutionSet);
        SolutionSetStream sset = this._create(fqn, params);
        LinkedList emptySolutionSet = new LinkedList();
        CloseableIteratorWrapper<IBindingSet[]> src = new CloseableIteratorWrapper<IBindingSet[]>(emptySolutionSet.iterator());
        this.writeSolutions(sset, src);
    }

    private void writeSolutions(SolutionSetStream sset, ICloseableIterator<IBindingSet[]> src) {
        sset.put(src);
    }

    @Override
    public ISolutionSetStats getSolutionSetStats(String solutionSet) {
        String fqn = this.getFQN(solutionSet);
        SolutionSetStream sset = this.getSolutionSet(fqn);
        if (sset != null) {
            ISolutionSetStats stats = sset.getStats();
            if (stats == null) {
                throw new RuntimeException("No statistics? solutionSet=" + solutionSet);
            }
            return stats;
        }
        return null;
    }

    @Override
    public ICloseableIterator<IBindingSet[]> getSolutions(String solutionSet) {
        String fqn = this.getFQN(solutionSet);
        SolutionSetStream sset = this.getSolutionSet(fqn);
        if (sset == null) {
            throw new IllegalStateException("Not found: " + solutionSet);
        }
        return sset.get();
    }

    protected ISPO[] getDefaultMetadata() {
        return new ISPO[0];
    }
}

