/*
 * Decompiled with CFR 0.152.
 */
package com.bigdata.rdf.spo;

import com.bigdata.btree.IIndex;
import com.bigdata.btree.proc.AbstractKeyArrayIndexProcedure;
import com.bigdata.btree.proc.BatchRemove;
import com.bigdata.btree.proc.IResultHandler;
import com.bigdata.btree.proc.LongAggregator;
import com.bigdata.rdf.spo.ISPO;
import com.bigdata.rdf.spo.ModifiedEnum;
import com.bigdata.rdf.spo.SPOKeyOrder;
import com.bigdata.rdf.spo.SPORelation;
import com.bigdata.rdf.spo.SPOTupleSerializer;
import java.util.Arrays;
import java.util.concurrent.Callable;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.log4j.Logger;

public class SPOIndexRemover
implements Callable<Long> {
    protected static final Logger log = Logger.getLogger(SPOIndexRemover.class);
    protected static final boolean INFO = log.isInfoEnabled();
    protected static final boolean DEBUG = log.isDebugEnabled();
    private final SPORelation spoRelation;
    private final SPOKeyOrder keyOrder;
    private final boolean primaryIndex;
    private final ISPO[] a;
    private final int numStmts;
    private final AtomicLong sortTime;
    private final AtomicLong writeTime;
    private final AtomicLong mutationCount;
    private final boolean reportMutations;

    public SPOIndexRemover(SPORelation spoRelation, ISPO[] stmts, int numStmts, SPOKeyOrder keyOrder, boolean primaryIndex, boolean clone, AtomicLong sortTime, AtomicLong writeTime, AtomicLong mutationCount, boolean reportMutations) {
        if (spoRelation == null) {
            throw new IllegalArgumentException();
        }
        if (stmts == null) {
            throw new IllegalArgumentException();
        }
        if (numStmts <= 0) {
            throw new IllegalArgumentException();
        }
        if (keyOrder == null) {
            throw new IllegalArgumentException();
        }
        this.spoRelation = spoRelation;
        this.keyOrder = keyOrder;
        this.primaryIndex = primaryIndex;
        if (clone) {
            this.a = new ISPO[numStmts];
            System.arraycopy(stmts, 0, this.a, 0, numStmts);
        } else {
            this.a = stmts;
        }
        this.numStmts = numStmts;
        this.sortTime = sortTime;
        this.writeTime = writeTime;
        this.mutationCount = mutationCount;
        this.reportMutations = reportMutations;
    }

    @Override
    public Long call() throws Exception {
        long writeCount;
        IResultHandler<Long, Long> aggregator;
        long begin = System.currentTimeMillis();
        IIndex ndx = this.spoRelation.getIndex(this.keyOrder);
        SPOTupleSerializer tupleSer = (SPOTupleSerializer)ndx.getIndexMetadata().getTupleSerializer();
        Arrays.sort(this.a, 0, this.numStmts, this.keyOrder.getComparator());
        long beginWrite = System.currentTimeMillis();
        this.sortTime.addAndGet(beginWrite - begin);
        byte[][] keys = new byte[this.numStmts][];
        for (int i = 0; i < this.numStmts; ++i) {
            ISPO spo = this.a[i];
            if (DEBUG) {
                log.debug("Removing " + spo.toString() + " from " + this.keyOrder);
            }
            keys[i] = tupleSer.serializeKey(spo);
        }
        if (this.reportMutations) {
            aggregator = new AbstractKeyArrayIndexProcedure.ResultBitBufferHandler(this.numStmts);
            ndx.submit(0, this.numStmts, keys, null, BatchRemove.BatchRemoveConstructor.RETURN_BIT_MASK, aggregator);
            AbstractKeyArrayIndexProcedure.ResultBitBuffer modified = ((AbstractKeyArrayIndexProcedure.ResultBitBufferHandler)aggregator).getResult();
            boolean[] bits = modified.getResult();
            writeCount = modified.getOnCount();
            for (int i = 0; i < this.numStmts; ++i) {
                if (!bits[i]) continue;
                this.a[i].setModified(ModifiedEnum.REMOVED);
            }
        } else {
            aggregator = new LongAggregator();
            ndx.submit(0, this.numStmts, keys, null, BatchRemove.BatchRemoveConstructor.RETURN_MUTATION_COUNT, aggregator);
            writeCount = ((LongAggregator)aggregator).getResult();
        }
        if (this.primaryIndex) {
            this.mutationCount.addAndGet(writeCount);
        }
        long elapsed = System.currentTimeMillis() - beginWrite;
        this.writeTime.addAndGet(elapsed);
        return elapsed;
    }
}

