/*
 * Decompiled with CFR 0.152.
 */
package com.bigdata.rdf.spo;

import com.bigdata.bop.IConstant;
import com.bigdata.bop.IPredicate;
import com.bigdata.bop.IVariableOrConstant;
import com.bigdata.btree.keys.IKeyBuilder;
import com.bigdata.btree.keys.SuccessorUtil;
import com.bigdata.rdf.internal.IV;
import com.bigdata.rdf.internal.IVUtility;
import com.bigdata.rdf.internal.constraints.RangeBOp;
import com.bigdata.rdf.spo.ISPO;
import com.bigdata.rdf.spo.OSPComparator;
import com.bigdata.rdf.spo.POSComparator;
import com.bigdata.rdf.spo.SPO;
import com.bigdata.rdf.spo.SPOComparator;
import com.bigdata.striterator.AbstractKeyOrder;
import java.io.ObjectStreamException;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Iterator;
import java.util.NoSuchElementException;
import org.apache.log4j.Logger;

public class SPOKeyOrder
extends AbstractKeyOrder<ISPO>
implements Serializable {
    private static final long serialVersionUID = 87501920529732159L;
    private static final transient Logger log = Logger.getLogger(SPOKeyOrder.class);
    private static final boolean DEBUG = log.isDebugEnabled();
    private static final transient boolean LOCALITY_OPTIMIZATION = false;
    public static final transient int _SPO = 0;
    public static final transient int _OSP = 1;
    public static final transient int _POS = 2;
    public static final transient int _SPOC = 3;
    public static final transient int _POCS = 4;
    public static final transient int _OCSP = 5;
    public static final transient int _CSPO = 6;
    public static final transient int _PCSO = 7;
    public static final transient int _SOPC = 8;
    public static final transient int FIRST_TRIPLE_INDEX = 0;
    public static final transient int LAST_TRIPLE_INDEX = 2;
    public static final transient int FIRST_QUAD_INDEX = 3;
    public static final transient int LAST_QUAD_INDEX = 8;
    public static final transient int MAX_INDEX_COUNT = 9;
    public static final transient SPOKeyOrder SPO = new SPOKeyOrder(0);
    public static final transient SPOKeyOrder POS = new SPOKeyOrder(2);
    public static final transient SPOKeyOrder OSP = new SPOKeyOrder(1);
    public static final transient SPOKeyOrder SPOC = new SPOKeyOrder(3);
    public static final transient SPOKeyOrder POCS = new SPOKeyOrder(4);
    public static final transient SPOKeyOrder OCSP = new SPOKeyOrder(5);
    public static final transient SPOKeyOrder CSPO = new SPOKeyOrder(6);
    public static final transient SPOKeyOrder PCSO = new SPOKeyOrder(7);
    public static final transient SPOKeyOrder SOPC = new SPOKeyOrder(8);
    static final transient String[] names = new String[]{"SPO", "OSP", "POS", "SPOC", "POCS", "OCSP", "CSPO", "PCSO", "SOPC"};
    static final transient SPOKeyOrder[] values = new SPOKeyOrder[]{SPO, OSP, POS, SPOC, POCS, OCSP, CSPO, PCSO, SOPC};
    static final transient GeneralComparator[] comparators = new GeneralComparator[]{new GeneralComparator(0), new GeneralComparator(1), new GeneralComparator(2), new GeneralComparator(3), new GeneralComparator(4), new GeneralComparator(5), new GeneralComparator(6), new GeneralComparator(7), new GeneralComparator(8)};
    public static final transient int S = 0;
    public static final transient int P = 1;
    public static final transient int O = 2;
    public static final transient int C = 3;
    static final transient int[][] orders = new int[][]{{0, 1, 2}, {2, 0, 1}, {1, 2, 0}, {0, 1, 2, 3}, {1, 2, 3, 0}, {2, 3, 0, 1}, {3, 0, 1, 2}, {1, 3, 0, 2}, {0, 2, 1, 3}};
    private final byte index;
    private static final transient SPOKeyOrder[] tripleStoreIndices = new SPOKeyOrder[]{SPO, POS, OSP};
    private static final transient SPOKeyOrder[] quadStoreIndices = new SPOKeyOrder[]{SPOC, POCS, OCSP, CSPO, PCSO, SOPC};

    private SPOKeyOrder(int index) {
        this.index = (byte)index;
    }

    public final boolean isPrimaryIndex() {
        return this == SPO || this == SPOC;
    }

    public static SPOKeyOrder valueOf(int index) {
        return values[index];
    }

    public static SPOKeyOrder fromString(String name) {
        for (int i = 0; i < names.length; ++i) {
            if (!names[i].equals(name)) continue;
            return SPOKeyOrder.valueOf(i);
        }
        throw new IllegalArgumentException("name=" + name);
    }

    @Override
    public final String getIndexName() {
        return names[this.index];
    }

    public String toString() {
        return names[this.index];
    }

    @Override
    public final int getKeyArity() {
        switch (this.index) {
            case 0: 
            case 1: 
            case 2: {
                return 3;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                return 4;
            }
        }
        throw new AssertionError();
    }

    @Override
    public final int getKeyOrder(int keyPos) {
        return orders[this.index][keyPos];
    }

    public final int getPositionInIndex(int spoIdentifier) {
        int[] keyOrder = orders[this.index];
        for (int i = 0; i < keyOrder.length; ++i) {
            if (keyOrder[i] != spoIdentifier) continue;
            return i;
        }
        return -1;
    }

    public final int index() {
        return this.index;
    }

    @Override
    public final Comparator<ISPO> getComparator() {
        switch (this.index) {
            case 0: {
                return SPOComparator.INSTANCE;
            }
            case 2: {
                return POSComparator.INSTANCE;
            }
            case 1: {
                return OSPComparator.INSTANCE;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                return comparators[this.index];
            }
        }
        throw new AssertionError();
    }

    @Override
    public byte[] getFromKey(IKeyBuilder keyBuilder, IPredicate<ISPO> predicate) {
        keyBuilder.reset();
        int keyArity = this.getKeyArity();
        boolean noneBound = true;
        RangeBOp range = this.getRange(predicate);
        for (int i = 0; i < keyArity; ++i) {
            int index = this.getKeyOrder(i);
            IVariableOrConstant term = predicate.get(index);
            if (term == null || term.isVar()) {
                if (index != 2 || range == null || !range.isFromBound()) break;
                IConstant c = (IConstant)range.from();
                this.appendKeyComponent(keyBuilder, i, c.get());
                noneBound = false;
                if (!log.isInfoEnabled()) continue;
                log.info("used range to build to key: " + c);
                log.info(predicate);
                continue;
            }
            this.appendKeyComponent(keyBuilder, i, term.get());
            noneBound = false;
        }
        byte[] key = noneBound ? null : keyBuilder.getKey();
        return key;
    }

    private RangeBOp getRange(IPredicate<ISPO> predicate) {
        RangeBOp range = (RangeBOp)predicate.getProperty(IPredicate.Annotations.RANGE);
        if (range == null) {
            return null;
        }
        IVariableOrConstant p = predicate.get(1);
        IVariableOrConstant o = predicate.get(2);
        if ((o == null || o.isVar()) && p != null && p.isConstant()) {
            return range;
        }
        return null;
    }

    @Override
    public byte[] getToKey(IKeyBuilder keyBuilder, IPredicate<ISPO> predicate) {
        keyBuilder.reset();
        int keyArity = this.getKeyArity();
        boolean noneBound = true;
        RangeBOp range = this.getRange(predicate);
        for (int i = 0; i < keyArity; ++i) {
            int index = this.getKeyOrder(i);
            IVariableOrConstant term = predicate.get(index);
            if (term == null || term.isVar()) {
                if (index != 2 || range == null || !range.isToBound()) break;
                IConstant c = (IConstant)range.to();
                this.appendKeyComponent(keyBuilder, i, c.get());
                noneBound = false;
                if (!log.isInfoEnabled()) continue;
                log.info("used range to build to key: " + c);
                log.info(predicate);
                continue;
            }
            this.appendKeyComponent(keyBuilder, i, term.get());
            noneBound = false;
        }
        byte[] key = noneBound ? null : keyBuilder.getKey();
        return key == null ? null : SuccessorUtil.successor(key);
    }

    @Override
    protected void appendKeyComponent(IKeyBuilder keyBuilder, int index, Object keyComponent) {
        ((IV)keyComponent).encode(keyBuilder);
    }

    public final byte[] encodeKey(IKeyBuilder keyBuilder, ISPO spo) {
        keyBuilder.reset();
        this.appendKey(keyBuilder, spo);
        return keyBuilder.getKey();
    }

    public final IKeyBuilder appendKey(IKeyBuilder keyBuilder, ISPO spo) {
        int[] a = orders[this.index];
        for (int i = 0; i < a.length; ++i) {
            IVUtility.encode(keyBuilder, spo.get(a[i]));
        }
        return keyBuilder;
    }

    public final SPO decodeKey(byte[] key) {
        return this.decodeKey(key, 0);
    }

    public final SPO decodeKey(byte[] key, int offset) {
        IV c;
        IV o;
        IV p;
        IV s;
        int keyArity = this.getKeyArity();
        Object[] ivs = IVUtility.decode(key, offset, keyArity);
        if (DEBUG) {
            log.debug("key: " + Arrays.toString(key));
            log.debug("keyArity: " + keyArity);
            log.debug(Arrays.toString(ivs));
        }
        IV _0 = ivs[0];
        IV _1 = ivs[1];
        IV _2 = ivs[2];
        IV _3 = keyArity == 4 ? ivs[3] : null;
        switch (this.index) {
            case 0: {
                s = _0;
                p = _1;
                o = _2;
                c = null;
                break;
            }
            case 2: {
                p = _0;
                o = _1;
                s = _2;
                c = null;
                break;
            }
            case 1: {
                o = _0;
                s = _1;
                p = _2;
                c = null;
                break;
            }
            case 3: {
                s = _0;
                p = _1;
                o = _2;
                c = _3;
                break;
            }
            case 4: {
                p = _0;
                o = _1;
                c = _2;
                s = _3;
                break;
            }
            case 5: {
                o = _0;
                c = _1;
                s = _2;
                p = _3;
                break;
            }
            case 6: {
                c = _0;
                s = _1;
                p = _2;
                o = _3;
                break;
            }
            case 7: {
                p = _0;
                c = _1;
                s = _2;
                o = _3;
                break;
            }
            case 8: {
                s = _0;
                o = _1;
                p = _2;
                c = _3;
                break;
            }
            default: {
                throw new UnsupportedOperationException();
            }
        }
        return new SPO(s, p, o, c);
    }

    private Object readResolve() throws ObjectStreamException {
        return SPOKeyOrder.valueOf(this.index);
    }

    public static SPOKeyOrder getKeyOrder(IPredicate<ISPO> predicate, int keyArity) {
        boolean c;
        boolean o;
        SPOKeyOrder keyOrder = (SPOKeyOrder)predicate.getKeyOrder();
        if (keyOrder != null) {
            return keyOrder;
        }
        boolean s = !predicate.get(0).isVar();
        boolean p = !predicate.get(1).isVar();
        boolean bl = o = !predicate.get(2).isVar();
        if (keyArity == 3) {
            if (s && p && o) {
                return SPO;
            }
            if (s && p) {
                return SPO;
            }
            if (s && o) {
                return OSP;
            }
            if (p && o) {
                return POS;
            }
            if (s) {
                return SPO;
            }
            if (p) {
                return POS;
            }
            if (o) {
                return OSP;
            }
            return SPO;
        }
        IVariableOrConstant t = predicate.get(3);
        boolean bl2 = c = t != null && !t.isVar();
        if (!s && p && !o && !c || !s && p && o && !c || !s && p && o && c) {
            return POCS;
        }
        if (!s && !p && o && !c || !s && !p && o && c || s && !p && o && c) {
            return OCSP;
        }
        if (!s && !p && !o && c || s && !p && !o && c || s && p && !o && c) {
            return CSPO;
        }
        if (!s && p && !o && c) {
            return PCSO;
        }
        if (s && !p && o && !c) {
            return SOPC;
        }
        return SPOC;
    }

    public static Iterator<SPOKeyOrder> tripleStoreKeyOrderIterator() {
        return Arrays.asList(tripleStoreIndices).iterator();
    }

    public static Iterator<SPOKeyOrder> quadStoreKeyOrderIterator() {
        return Arrays.asList(quadStoreIndices).iterator();
    }

    public static Iterator<SPOKeyOrder> spoOnlyKeyOrderIterator() {
        return new SPOOnlyKeyOrderIterator();
    }

    public static Iterator<SPOKeyOrder> spocOnlyKeyOrderIterator() {
        return new SPOCOnlyKeyOrderIterator();
    }

    private static class SPOCOnlyKeyOrderIterator
    implements Iterator<SPOKeyOrder> {
        boolean exhausted = false;

        private SPOCOnlyKeyOrderIterator() {
        }

        @Override
        public boolean hasNext() {
            return !this.exhausted;
        }

        @Override
        public SPOKeyOrder next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            this.exhausted = true;
            return SPOC;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }

    private static class SPOOnlyKeyOrderIterator
    implements Iterator<SPOKeyOrder> {
        boolean exhausted = false;

        private SPOOnlyKeyOrderIterator() {
        }

        @Override
        public boolean hasNext() {
            return !this.exhausted;
        }

        @Override
        public SPOKeyOrder next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            this.exhausted = true;
            return SPO;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }

    private static class GeneralComparator
    implements Comparator<ISPO> {
        private final byte index;

        public GeneralComparator(int index) {
            this.index = (byte)index;
        }

        @Override
        public int compare(ISPO o1, ISPO o2) {
            if (o1 == o2) {
                return 0;
            }
            int[] keyMap = orders[this.index];
            for (int i = 0; i < keyMap.length; ++i) {
                IV t2;
                IV t1 = o1.get(keyMap[i]);
                int ret = IVUtility.compare(t1, t2 = o2.get(keyMap[i]));
                if (ret == 0) continue;
                return ret;
            }
            return 0;
        }
    }
}

