/*
 * Decompiled with CFR 0.152.
 */
package com.bigdata.rdf.store;

import com.bigdata.Banner;
import com.bigdata.btree.IndexMetadata;
import com.bigdata.counters.CounterSet;
import com.bigdata.io.DirectBufferPool;
import com.bigdata.journal.AbstractJournal;
import com.bigdata.journal.DumpJournal;
import com.bigdata.journal.HttpPlugin;
import com.bigdata.journal.IIndexManager;
import com.bigdata.journal.Journal;
import com.bigdata.journal.RWStrategy;
import com.bigdata.rdf.ServiceProviderHook;
import com.bigdata.rdf.inf.ClosureStats;
import com.bigdata.rdf.inf.TruthMaintenance;
import com.bigdata.rdf.rio.LoadStats;
import com.bigdata.rdf.rio.PresortRioLoader;
import com.bigdata.rdf.rio.RDFParserOptions;
import com.bigdata.rdf.rio.RioLoaderEvent;
import com.bigdata.rdf.rio.RioLoaderListener;
import com.bigdata.rdf.rio.StatementBuffer;
import com.bigdata.rdf.rules.InferenceEngine;
import com.bigdata.rdf.store.AbstractLocalTripleStore;
import com.bigdata.rdf.store.AbstractTripleStore;
import com.bigdata.rdf.store.LocalTripleStore;
import com.bigdata.rdf.store.TempTripleStore;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.io.Reader;
import java.net.URL;
import java.util.Arrays;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.Properties;
import java.util.Set;
import org.apache.log4j.Logger;
import org.openrdf.rio.RDFFormat;
import org.openrdf.rio.RDFParseException;

public class DataLoader {
    protected static final transient Logger log = Logger.getLogger(DataLoader.class);
    private final RDFParserOptions parserOptions;
    private final int bufferCapacity;
    private final int queueCapacity;
    private PrintStream output;
    private final AbstractTripleStore database;
    private final InferenceEngine inferenceEngine;
    private final TruthMaintenance tm;
    private StatementBuffer<?> buffer;
    private final boolean durableQueues;
    private final int verbose;
    private final boolean dumpJournal;
    private final CommitEnum commitEnum;
    private final ClosureEnum closureEnum;
    private final boolean flush;
    private final boolean ignoreInvalidFiles;
    private static final FilenameFilter filter = new FilenameFilter(){

        @Override
        public boolean accept(File dir, String name) {
            boolean isRDF;
            if (new File(dir, name).isDirectory()) {
                return !dir.isHidden();
            }
            boolean bl = isRDF = RDFFormat.forFileName(name) != null || name.endsWith(".zip") && RDFFormat.forFileName(name.substring(0, name.length() - 4)) != null || name.endsWith(".gz") && RDFFormat.forFileName(name.substring(0, name.length() - 3)) != null;
            if (log.isDebugEnabled()) {
                log.debug("dir=" + dir + ", name=" + name + " : isRDF=" + isRDF);
            }
            return isRDF;
        }
    };

    public AbstractTripleStore getDatabase() {
        return this.database;
    }

    public InferenceEngine getInferenceEngine() {
        return this.inferenceEngine;
    }

    protected synchronized StatementBuffer<?> getAssertionBuffer() {
        if (this.buffer == null) {
            this.buffer = this.tm != null ? new StatementBuffer(this.tm.newTempTripleStore(), this.database, this.bufferCapacity, this.queueCapacity) : new StatementBuffer(this.database, this.bufferCapacity, this.queueCapacity);
        }
        return this.buffer;
    }

    public boolean getFlush() {
        return this.flush;
    }

    public void endSource() {
        if (this.buffer != null) {
            if (log.isDebugEnabled()) {
                log.debug("Flushing the buffer.");
            }
            this.buffer.flush();
        }
    }

    public ClosureEnum getClosureEnum() {
        return this.closureEnum;
    }

    public CommitEnum getCommitEnum() {
        return this.commitEnum;
    }

    public DataLoader(AbstractTripleStore database) {
        this(database.getProperties(), database, System.out);
    }

    public DataLoader(Properties properties, AbstractTripleStore database) {
        this(properties, database, System.out);
    }

    public DataLoader(Properties properties, AbstractTripleStore database, PrintStream os) {
        this.output = os;
        if (properties == null) {
            throw new IllegalArgumentException();
        }
        if (database == null) {
            throw new IllegalArgumentException();
        }
        this.parserOptions = new RDFParserOptions(properties);
        if (properties.getProperty(Options.PRESERVE_BNODE_IDS) == null && database.getLexiconRelation().isStoreBlankNodes()) {
            this.parserOptions.setPreserveBNodeIDs(true);
        }
        this.durableQueues = Boolean.parseBoolean(properties.getProperty(Options.DURABLE_QUEUES, "false"));
        if (this.durableQueues) {
            properties.setProperty(Options.IGNORE_INVALID_FILES, "true");
            properties.setProperty(RDFParserOptions.Options.STOP_AT_FIRST_ERROR, "false");
        }
        if (log.isInfoEnabled()) {
            log.info(Options.DURABLE_QUEUES + "=" + this.durableQueues);
        }
        this.commitEnum = CommitEnum.valueOf(properties.getProperty(Options.COMMIT, Options.DEFAULT_COMMIT));
        if (log.isInfoEnabled()) {
            log.info(Options.COMMIT + "=" + (Object)((Object)this.commitEnum));
        }
        ClosureEnum closureEnum = this.closureEnum = database.getAxioms().isNone() ? ClosureEnum.None : ClosureEnum.valueOf(properties.getProperty(Options.CLOSURE, Options.DEFAULT_CLOSURE));
        if (log.isInfoEnabled()) {
            log.info(Options.CLOSURE + "=" + (Object)((Object)this.closureEnum));
        }
        this.bufferCapacity = Integer.parseInt(properties.getProperty(Options.BUFFER_CAPACITY, "100000"));
        if (log.isInfoEnabled()) {
            log.info(Options.BUFFER_CAPACITY + "=" + this.bufferCapacity);
        }
        this.queueCapacity = Integer.parseInt(properties.getProperty(Options.QUEUE_CAPACITY, "10"));
        if (log.isInfoEnabled()) {
            log.info(Options.QUEUE_CAPACITY + "=" + this.queueCapacity);
        }
        this.database = database;
        this.inferenceEngine = database.getInferenceEngine();
        this.tm = this.closureEnum != ClosureEnum.None ? new TruthMaintenance(this.inferenceEngine) : null;
        this.flush = Boolean.parseBoolean(properties.getProperty(Options.FLUSH, "true"));
        if (log.isInfoEnabled()) {
            log.info(Options.FLUSH + "=" + this.flush);
        }
        this.ignoreInvalidFiles = Boolean.parseBoolean(properties.getProperty(Options.IGNORE_INVALID_FILES, "false"));
        if (log.isInfoEnabled()) {
            log.info(Options.IGNORE_INVALID_FILES + "=" + this.ignoreInvalidFiles);
        }
        this.verbose = Integer.parseInt(properties.getProperty(Options.VERBOSE, "0"));
        if (log.isInfoEnabled()) {
            log.info(Options.VERBOSE + "=" + this.verbose);
        }
        this.dumpJournal = Boolean.parseBoolean(properties.getProperty(Options.DUMP_JOURNAL, "false"));
        if (log.isInfoEnabled()) {
            log.info(Options.DUMP_JOURNAL + "=" + this.dumpJournal);
        }
    }

    public MyLoadStats newLoadStats() {
        return new MyLoadStats();
    }

    public final LoadStats loadData(String resource, String baseURL, RDFFormat rdfFormat) throws IOException {
        if (resource == null) {
            throw new IllegalArgumentException();
        }
        if (baseURL == null) {
            throw new IllegalArgumentException();
        }
        if (rdfFormat == null) {
            throw new IllegalArgumentException();
        }
        return this.loadData(new String[]{resource}, new String[]{baseURL}, new RDFFormat[]{rdfFormat});
    }

    public final LoadStats loadData(String[] resource, String[] baseURL, RDFFormat[] rdfFormat) throws IOException {
        if (resource.length != baseURL.length) {
            throw new IllegalArgumentException();
        }
        if (resource.length != rdfFormat.length) {
            throw new IllegalArgumentException();
        }
        if (log.isInfoEnabled()) {
            log.info("commit=" + (Object)((Object)this.commitEnum) + ", closure=" + (Object)((Object)this.closureEnum) + ", resource=" + Arrays.toString(resource));
        }
        MyLoadStats totals = this.newLoadStats();
        for (int i = 0; i < resource.length; ++i) {
            boolean endOfBatch = i + 1 == resource.length;
            this.loadData2(totals, resource[i], baseURL[i], rdfFormat[i], endOfBatch);
        }
        this.doCommit(totals);
        if (log.isInfoEnabled()) {
            log.info("Loaded " + resource.length + " resources: " + totals);
        }
        return totals;
    }

    private void doCommit(MyLoadStats totals) {
        if (this.flush && this.buffer != null) {
            this.buffer.flush();
        }
        if (this.commitEnum == CommitEnum.Batch) {
            if (log.isInfoEnabled()) {
                log.info("Commit after batch");
            }
            long beginCommit = System.currentTimeMillis();
            this.database.commit();
            totals.commit();
            totals.commitTime.add(System.currentTimeMillis() - beginCommit);
            if (log.isInfoEnabled()) {
                log.info("commit: latency=" + totals.commitTime + "ms");
            }
            if (this.verbose > 1) {
                this.logCounters(this.database);
            }
        }
    }

    public LoadStats loadData(Reader reader, String baseURL, RDFFormat rdfFormat) throws IOException {
        MyLoadStats totals = this.newLoadStats();
        this.loadData4_ParserErrors_Trapped(totals, reader, baseURL, baseURL, rdfFormat, null, true);
        this.doCommit(totals);
        return totals;
    }

    public LoadStats loadData(InputStream is, String baseURL, RDFFormat rdfFormat) throws IOException {
        MyLoadStats totals = this.newLoadStats();
        this.loadData4_ParserErrors_Trapped(totals, is, baseURL, baseURL, rdfFormat, null, true);
        this.doCommit(totals);
        return totals;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public LoadStats loadData(URL url, String baseURL, RDFFormat rdfFormat) throws IOException {
        if (url == null) {
            throw new IllegalArgumentException();
        }
        if (log.isInfoEnabled()) {
            log.info("loading: " + url);
        }
        MyLoadStats totals = this.newLoadStats();
        try (InputStream is = url.openStream();){
            this.loadData4_ParserErrors_Trapped(totals, is, url.toString(), baseURL, rdfFormat, url.toString(), true);
        }
        this.doCommit(totals);
        return totals;
    }

    protected void loadData2(MyLoadStats totals, String resource, String baseURL, RDFFormat rdfFormat, boolean endOfBatch) throws IOException {
        if (log.isInfoEnabled()) {
            log.info("loading: " + resource);
        }
        String defaultGraph = null;
        InputStream rdfStream = this.getClass().getResourceAsStream(resource);
        if (rdfStream != null) {
            defaultGraph = this.getClass().getResource(resource).toString();
        }
        if (rdfStream == null) {
            File file;
            rdfStream = this.getClass().getClassLoader().getResourceAsStream(resource);
            if (rdfStream != null) {
                defaultGraph = this.getClass().getClassLoader().getResource(resource).toString();
            }
            if (rdfStream == null && (file = new File(resource)).exists()) {
                defaultGraph = file.toURI().toString();
                this.loadFiles(totals, 0, file, baseURL, rdfFormat, defaultGraph, filter, endOfBatch);
                return;
            }
        }
        if (rdfStream == null) {
            throw new IOException("Could not locate resource: " + resource);
        }
        BufferedReader reader = new BufferedReader(new InputStreamReader(rdfStream));
        try {
            this.loadData4_ParserErrors_Trapped(totals, reader, resource, baseURL, rdfFormat, defaultGraph, endOfBatch);
        }
        catch (Exception ex) {
            if (ex instanceof RuntimeException) {
                throw (RuntimeException)ex;
            }
            if (ex instanceof IOException) {
                throw (IOException)ex;
            }
            throw new RuntimeException("While loading: " + resource, ex);
        }
        finally {
            ((Reader)reader).close();
            rdfStream.close();
        }
    }

    public LoadStats loadFiles(File file, String baseURI, RDFFormat rdfFormat, String defaultGraph, FilenameFilter filter) throws IOException {
        if (file == null) {
            throw new IllegalArgumentException();
        }
        MyLoadStats totals = this.newLoadStats();
        this.loadFiles(totals, 0, file, baseURI, rdfFormat, defaultGraph, filter, true);
        this.doCommit(totals);
        return totals;
    }

    /*
     * Exception decompiling
     */
    public void loadFiles(MyLoadStats totals, int depth, File file, String baseURI, RDFFormat rdfFormat, String defaultGraph, FilenameFilter filter, boolean endOfBatch) throws IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [5[CATCHBLOCK]], but top level block is 2[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    @Deprecated
    protected void loadData3(LoadStats totals, Object source, String baseURL, RDFFormat rdfFormat, String defaultGraph, boolean endOfBatch) throws IOException {
        MyLoadStats tmp = this.newLoadStats();
        this.loadData4_ParserErrors_Trapped(tmp, source, null, baseURL, rdfFormat, defaultGraph, endOfBatch);
        totals.add(tmp);
    }

    private void loadData4_ParserErrors_Trapped(MyLoadStats totals, Object source, String label, String baseURI, RDFFormat rdfFormat, String defaultGraph, boolean endOfBatch) throws IOException {
        try {
            this.loadData4_ParserErrors_Not_Trapped(totals, source, label, null, baseURI, rdfFormat, defaultGraph, endOfBatch);
        }
        catch (RDFParseException ex) {
            if (this.ignoreInvalidFiles) {
                log.error("Parser error - skipping source: source=" + label, ex);
                return;
            }
            throw new RuntimeException(ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadData4_ParserErrors_Not_Trapped(final MyLoadStats totals, Object source, String label, File fileIfSourceIsFile, final String baseURI, RDFFormat rdfFormat, String defaultGraph, boolean endOfBatch) throws IOException, RDFParseException {
        if (label == null && (label = baseURI) == null) {
            label = source.toString();
        }
        long begin = System.currentTimeMillis();
        MyLoadStats stats = new MyLoadStats();
        this.getAssertionBuffer();
        PresortRioLoader loader = new PresortRioLoader(this.buffer, this.flush);
        loader.addRioLoaderListener(new RioLoaderListener(){

            @Override
            public void processingNotification(RioLoaderEvent e) {
                StatementBuffer tmp;
                if (log.isInfoEnabled() || DataLoader.this.verbose > 1) {
                    String msg = e.getStatementsProcessed() + " stmts buffered in " + (double)e.getTimeElapsed() / 1000.0 + " secs, rate= " + e.getInsertRate() + (baseURI != null ? ", baseURL=" + baseURI : "") + ", totalStatementsSoFar=" + (e.getStatementsProcessed() + totals.toldTriples.get());
                    if (log.isInfoEnabled()) {
                        log.info(msg);
                    }
                    if (DataLoader.this.verbose > 1) {
                        DataLoader.this.output.println(msg);
                    }
                }
                if (DataLoader.this.verbose > 2 && (tmp = DataLoader.this.buffer) != null) {
                    DataLoader.this.output.println(tmp.toString());
                    DataLoader.this.output.println(tmp.getCounters().toString());
                }
            }
        });
        try {
            boolean ok = false;
            try {
                if (source instanceof Reader) {
                    loader.loadRdf((Reader)source, baseURI, rdfFormat, defaultGraph, this.parserOptions);
                } else if (source instanceof InputStream) {
                    loader.loadRdf((InputStream)source, baseURI, rdfFormat, defaultGraph, this.parserOptions);
                } else {
                    throw new AssertionError();
                }
                ok = true;
            }
            finally {
                if (fileIfSourceIsFile != null) {
                    if (ok) {
                        stats.didGood(fileIfSourceIsFile);
                    } else {
                        stats.didFail(fileIfSourceIsFile);
                    }
                }
            }
            long nstmts = loader.getStatementsAdded();
            stats.toldTriples.set(nstmts);
            stats.loadTime.set(System.currentTimeMillis() - begin);
            if (this.closureEnum == ClosureEnum.Incremental || endOfBatch && this.closureEnum == ClosureEnum.Batch) {
                if (log.isInfoEnabled()) {
                    log.info("Computing closure.");
                }
                stats.closureStats.add(this.doClosure());
            }
            if (this.commitEnum == CommitEnum.Incremental) {
                if (log.isInfoEnabled()) {
                    log.info("Commit after each resource");
                }
                long beginCommit = System.currentTimeMillis();
                this.database.commit();
                stats.commit();
                stats.commitTime.set(System.currentTimeMillis() - beginCommit);
                if (log.isInfoEnabled()) {
                    log.info("commit: latency=" + stats.commitTime + "ms");
                }
                if (this.verbose > 1) {
                    this.logCounters(this.database);
                }
            }
            stats.totalTime.set(System.currentTimeMillis() - begin);
            totals.add(stats);
            if (log.isInfoEnabled()) {
                log.info("file:: " + stats + "; totals:: " + totals + (baseURI != null ? "; baseURL=" + baseURI : ""));
                if (this.buffer != null && this.buffer.getDatabase() instanceof AbstractLocalTripleStore && log.isDebugEnabled()) {
                    log.debug(((AbstractLocalTripleStore)this.buffer.getDatabase()).getLocalBTreeBytesWritten(new StringBuilder()).toString());
                }
            }
            return;
        }
        catch (Throwable t) {
            totals.add(stats);
            if (this.buffer != null) {
                this.buffer.reset();
                if (this.tm != null) {
                    this.buffer.getStatementStore().close();
                }
                this.buffer = null;
            }
            if (t instanceof RuntimeException) {
                throw (RuntimeException)t;
            }
            if (t instanceof RDFParseException) {
                throw (RDFParseException)t;
            }
            if (t instanceof IOException) {
                throw (IOException)t;
            }
            IOException ex2 = new IOException("Problem loading data?");
            ex2.initCause(t);
            throw ex2;
        }
    }

    public void logCounters(AbstractTripleStore database) {
        IIndexManager store = database.getIndexManager();
        CounterSet counters = store.getCounters();
        StatementBuffer<?> tmp = this.buffer;
        if (tmp != null) {
            counters.makePath("assertionBuffer").attach(this.buffer.getCounters());
        }
        this.output.println(counters.toString());
        System.out.println(((AbstractLocalTripleStore)database).getLocalBTreeBytesWritten(new StringBuilder()).toString());
        if (!(store instanceof Journal)) {
            return;
        }
        if (((Journal)store).getBufferStrategy() instanceof RWStrategy && !this.dumpJournal) {
            StringBuilder sb = new StringBuilder("\n");
            ((RWStrategy)((Journal)store).getBufferStrategy()).getStore().showAllocators(sb);
            log.info(sb.toString());
        }
        if (this.dumpJournal) {
            PrintWriter out = new PrintWriter(System.out);
            new DumpJournal((Journal)store).dumpJournal(out, null, false, true, false, false);
            out.flush();
            out.close();
        }
    }

    public ClosureStats doClosure() {
        ClosureStats stats;
        switch (this.closureEnum) {
            case Incremental: 
            case Batch: {
                if (this.buffer == null) {
                    throw new IllegalStateException();
                }
                this.buffer.flush();
                stats = new TruthMaintenance(this.inferenceEngine).assertAll((TempTripleStore)this.buffer.getStatementStore());
                this.buffer = null;
                break;
            }
            case None: {
                stats = this.inferenceEngine.computeClosure(null);
                break;
            }
            default: {
                throw new AssertionError();
            }
        }
        return stats;
    }

    private static int getGzipBuffer() {
        String s = System.getProperty(Options.GZIP_BUFFER_SIZE);
        if (s == null || s.isEmpty()) {
            return 65535;
        }
        return Integer.parseInt(s);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) throws IOException {
        String arg;
        int i;
        Banner.banner();
        String namespace = "kb";
        boolean doClosure = false;
        int verbose = 0;
        boolean quiet = false;
        boolean durableQueues = false;
        RDFFormat rdfFormat = null;
        String defaultGraph = null;
        String baseURI = null;
        for (i = 0; i < args.length && (arg = args[i]).startsWith("-"); ++i) {
            if (arg.equals("-namespace")) {
                namespace = args[++i];
                continue;
            }
            if (arg.equals("-format")) {
                rdfFormat = RDFFormat.valueOf(args[++i]);
                continue;
            }
            if (arg.equals("-baseURI")) {
                baseURI = args[++i];
                continue;
            }
            if (arg.equals("-defaultGraph")) {
                if ((defaultGraph = args[++i]).length() != 0) continue;
                defaultGraph = null;
                continue;
            }
            if (arg.equals("-closure")) {
                doClosure = true;
                continue;
            }
            if (arg.equals("-durableQueues")) {
                durableQueues = true;
                continue;
            }
            if (arg.equals("-verbose")) {
                ++verbose;
                quiet = false;
                continue;
            }
            if (arg.equals("-quiet")) {
                quiet = true;
                verbose = 0;
                continue;
            }
            System.err.println("Unknown argument: " + arg);
            DataLoader.usage();
        }
        int remaining = args.length - i;
        if (remaining < 1) {
            System.err.println("Not enough arguments.");
            DataLoader.usage();
        }
        String propertyFileName = args[i++];
        LinkedList<File> files = new LinkedList<File>();
        Properties properties = DataLoader.processProperties(propertyFileName, quiet, verbose, durableQueues);
        while (i < args.length) {
            File fileOrDir;
            if (!(fileOrDir = new File(args[i++])).exists()) {
                throw new FileNotFoundException(fileOrDir.toString());
            }
            files.add(fileOrDir);
            if (quiet) continue;
            System.out.println("Will load from: " + fileOrDir);
        }
        try (AbstractJournal jnl = null;){
            AbstractTripleStore kb;
            long begin = System.currentTimeMillis();
            jnl = new Journal(properties);
            if (!quiet) {
                System.out.println("Journal file: " + jnl.getFile());
            }
            if ((kb = (AbstractTripleStore)((Journal)jnl).getResourceLocator().locate(namespace, 0L)) == null) {
                kb = new LocalTripleStore(jnl, namespace, 0L, properties);
                kb.create();
            }
            DataLoader dataLoader = new DataLoader(properties, kb, System.out);
            MyLoadStats totals = dataLoader.newLoadStats();
            for (File fileOrDir : files) {
                dataLoader.loadFiles(totals, 0, fileOrDir, baseURI, rdfFormat, defaultGraph, filter, true);
            }
            dataLoader.endSource();
            if (!quiet) {
                System.out.println("Load: " + totals);
            }
            if (dataLoader.closureEnum == ClosureEnum.None && doClosure) {
                if (verbose > 0) {
                    dataLoader.logCounters(dataLoader.database);
                }
                if (!quiet) {
                    System.out.println("Computing closure.");
                }
                log.info("Computing closure.");
                ClosureStats stats = dataLoader.doClosure();
                if (!quiet) {
                    System.out.println("Closure: " + stats.toString());
                }
                if (log.isInfoEnabled()) {
                    log.info("Closure: " + stats.toString());
                }
            }
            jnl.commit();
            totals.commit();
            if (verbose > 1) {
                dataLoader.logCounters(dataLoader.database);
            }
            long elapsedTotal = System.currentTimeMillis() - begin;
            if (!quiet) {
                System.out.println("Total elapsed=" + elapsedTotal + "ms");
            }
            if (log.isInfoEnabled()) {
                log.info("Total elapsed=" + elapsedTotal + "ms");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Properties processProperties(String propertyFileName, boolean quiet, int verbose, boolean durableQueues) throws IOException {
        String[] overrides;
        File propertyFile = new File(propertyFileName);
        if (!propertyFile.exists()) {
            throw new FileNotFoundException(propertyFile.toString());
        }
        Properties properties = new Properties();
        if (!quiet) {
            System.out.println("Reading properties: " + propertyFile);
        }
        try (FileInputStream is = new FileInputStream(propertyFile);){
            properties.load(is);
        }
        if (durableQueues) {
            properties.setProperty(Options.DURABLE_QUEUES, "true");
        }
        if (verbose > 0) {
            properties.setProperty(Options.VERBOSE, Integer.toString(verbose));
        }
        for (String s : overrides = new String[]{com.bigdata.journal.Options.FILE, RDFParserOptions.Options.DATATYPE_HANDLING, RDFParserOptions.Options.PRESERVE_BNODE_IDS, RDFParserOptions.Options.STOP_AT_FIRST_ERROR, RDFParserOptions.Options.VERIFY_DATA, Options.BUFFER_CAPACITY, Options.QUEUE_CAPACITY, Options.CLOSURE, Options.COMMIT, Options.FLUSH, Options.IGNORE_INVALID_FILES, Options.DURABLE_QUEUES, Options.DUMP_JOURNAL, Options.VERBOSE, Journal.Options.WRITE_CACHE_BUFFER_COUNT, Journal.Options.WRITE_CACHE_MIN_CLEAN_LIST_SIZE, HttpPlugin.Options.HTTPD_PORT, DirectBufferPool.Options.BUFFER_CAPACITY, IndexMetadata.Options.WRITE_RETENTION_QUEUE_CAPACITY, "com.bigdata.btree.proc.AbstractKeyArrayIndexProcedure.maxReaders", "com.bigdata.btree.proc.AbstractKeyArrayIndexProcedure.skipCount", "com.bigdata.btree.proc.AbstractKeyArrayIndexProcedure.spannedRangeMultiplier", "com.bigdata.btree.proc.AbstractKeyArrayIndexProcedure.batchSize", "com.bigdata.btree.proc.AbstractKeyArrayIndexProcedure.queueCapacity"}) {
            if (System.getProperty(s) == null) continue;
            String v = System.getProperty(s);
            if (!quiet) {
                System.out.println("Using: " + s + "=" + v);
            }
            properties.setProperty(s, v);
        }
        return properties;
    }

    private static void usage() {
        System.err.println("usage: [-closure][-verbose][-durableQueues][-namespace namespace] propertyFile (fileOrDir)+");
        System.exit(1);
    }

    public static FilenameFilter getFilenameFilter() {
        return filter;
    }

    static {
        ServiceProviderHook.forceLoad();
    }

    public class MyLoadStats
    extends LoadStats {
        private final Set<File> failSet = new LinkedHashSet<File>();
        private final Set<File> goodSet = new LinkedHashSet<File>();

        void didFail(File file) {
            this.failSet.add(file);
            if (DataLoader.this.durableQueues && !file.renameTo(new File(file.getPath() + ".fail"))) {
                log.error("File rename failed: file=" + file + " (fail)");
            }
        }

        void didGood(File file) {
            this.goodSet.add(file);
        }

        @Override
        public String toString() {
            return super.toString() + ", {failSet=" + this.failSet.size() + ",goodSet=" + this.goodSet.size() + "}";
        }

        @Override
        public void add(LoadStats stats) {
            super.add(stats);
            if (stats instanceof MyLoadStats) {
                this.failSet.addAll(((MyLoadStats)stats).failSet);
                this.goodSet.addAll(((MyLoadStats)stats).goodSet);
            }
        }

        public void commit() {
            if (DataLoader.this.durableQueues) {
                for (File file : this.goodSet) {
                    if (file.renameTo(new File(file.getPath() + ".good"))) continue;
                    log.error("File rename failed: file=" + file + " (good)");
                }
            }
            this.failSet.clear();
            this.goodSet.clear();
        }
    }

    public static interface Options
    extends RDFParserOptions.Options {
        public static final String GZIP_BUFFER_SIZE = DataLoader.class.getClass().getName() + ".gzipBufferSize";
        public static final int DEFAULT_GZIP_BUFFER_SIZE = 65535;
        public static final String COMMIT = DataLoader.class.getName() + ".commit";
        public static final String DEFAULT_COMMIT = CommitEnum.Batch.toString();
        public static final String BUFFER_CAPACITY = DataLoader.class.getName() + ".bufferCapacity";
        public static final String DEFAULT_BUFFER_CAPACITY = "100000";
        public static final String QUEUE_CAPACITY = DataLoader.class.getName() + ".queueCapacity";
        public static final String DEFAULT_QUEUE_CAPACITY = "10";
        public static final String CLOSURE = DataLoader.class.getName() + ".closure";
        public static final String DEFAULT_CLOSURE = ClosureEnum.Batch.toString();
        public static final String FLUSH = DataLoader.class.getName() + ".flush";
        public static final String DEFAULT_FLUSH = "true";
        public static final String IGNORE_INVALID_FILES = DataLoader.class.getName() + ".ignoreInvalidFiles";
        public static final String DEFAULT_IGNORE_INVALID_FILES = "false";
        public static final String DURABLE_QUEUES = DataLoader.class.getName() + ".durableQueues";
        public static final String DEFAULT_DURABLE_QUEUES = "false";
        public static final String DUMP_JOURNAL = DataLoader.class.getName() + ".dumpJournal";
        public static final String DEFAULT_DUMP_JOURNAL = "false";
        public static final String VERBOSE = DataLoader.class.getName() + ".verbose";
        public static final String DEFAULT_VERBOSE = "0";
    }

    public static enum ClosureEnum {
        Incremental,
        Batch,
        None;

    }

    public static enum CommitEnum {
        Incremental,
        Batch,
        None;

    }
}

