/*
 * Decompiled with CFR 0.152.
 */
package com.bigdata.rdf.store;

import com.bigdata.journal.AbstractJournal;
import com.bigdata.journal.Journal;
import com.bigdata.journal.Options;
import com.bigdata.journal.TimestampUtility;
import com.bigdata.rdf.axioms.NoAxioms;
import com.bigdata.rdf.internal.IV;
import com.bigdata.rdf.model.BigdataStatement;
import com.bigdata.rdf.rio.AbstractStatementBuffer;
import com.bigdata.rdf.rio.StatementBuffer;
import com.bigdata.rdf.rules.BackchainAccessPath;
import com.bigdata.rdf.spo.ISPO;
import com.bigdata.rdf.store.AbstractTripleStore;
import com.bigdata.rdf.store.BigdataStatementIterator;
import com.bigdata.rdf.store.TempTripleStore;
import com.bigdata.relation.accesspath.BlockingBuffer;
import com.bigdata.relation.accesspath.IAccessPath;
import com.bigdata.striterator.IChunkedOrderedIterator;
import cutthecrap.utils.striterators.ICloseableIterator;
import java.io.File;
import java.io.FileNotFoundException;
import java.util.Properties;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.FutureTask;
import org.apache.log4j.Logger;
import org.openrdf.model.Statement;

public class TripleStoreUtility {
    protected static final Logger log = Logger.getLogger(TripleStoreUtility.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean modelsEqual(AbstractTripleStore expected, AbstractTripleStore actual) throws Exception {
        int notExpecting = 0;
        int expecting = 0;
        boolean sameStatements1 = true;
        try (ICloseableIterator<BigdataStatement> it = TripleStoreUtility.notFoundInTarget(actual, expected);){
            while (it.hasNext()) {
                BigdataStatement stmt = (BigdataStatement)it.next();
                sameStatements1 = false;
                TripleStoreUtility.log("Not expecting: " + stmt);
                ++notExpecting;
            }
        }
        TripleStoreUtility.log("all the statements in actual in expected? " + sameStatements1);
        boolean sameStatements2 = true;
        try (ICloseableIterator<BigdataStatement> it = TripleStoreUtility.notFoundInTarget(expected, actual);){
            while (it.hasNext()) {
                BigdataStatement stmt = (BigdataStatement)it.next();
                sameStatements2 = false;
                TripleStoreUtility.log("    Expecting: " + stmt);
                ++expecting;
            }
        }
        TripleStoreUtility.log("all the statements in expected in actual? " + sameStatements2);
        TripleStoreUtility.log("# expected but not found: " + expecting);
        TripleStoreUtility.log("# not expected but found: " + notExpecting);
        return sameStatements1 && sameStatements2;
    }

    public static void log(String s) {
        if (log.isInfoEnabled()) {
            log.info(s);
        }
    }

    public static ICloseableIterator<BigdataStatement> notFoundInTarget(AbstractTripleStore expected, final AbstractTripleStore actual) throws InterruptedException, ExecutionException {
        IAccessPath<ISPO> expectedAccessPath = expected.getAccessPath((IV)null, (IV)null, null);
        final BigdataStatementIterator itr2 = expected.asStatementIterator(expectedAccessPath.iterator());
        int capacity = 100000;
        final BlockingBuffer buffer = new BlockingBuffer(100000);
        final AbstractStatementBuffer.StatementBuffer2<Statement, BigdataStatement> sb = new AbstractStatementBuffer.StatementBuffer2<Statement, BigdataStatement>(actual, true, 100000){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            protected int handleProcessedStatements(BigdataStatement[] a) {
                if (log.isInfoEnabled()) {
                    log.info("Given " + a.length + " statements");
                }
                int nnotFound = 0;
                try (IChunkedOrderedIterator<ISPO> notFoundItr = actual.bulkFilterStatements(a, a.length, false);){
                    while (notFoundItr.hasNext()) {
                        ISPO notFoundStmt = (ISPO)notFoundItr.next();
                        if (log.isInfoEnabled()) {
                            log.info("Not found: " + notFoundStmt);
                        }
                        buffer.add((BigdataStatement)notFoundStmt);
                        ++nnotFound;
                    }
                }
                if (log.isInfoEnabled()) {
                    log.info("Given " + a.length + " statements, " + nnotFound + " of them were not found");
                }
                return nnotFound;
            }
        };
        Callable<Void> myTask = new Callable<Void>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public Void call() throws Exception {
                try {
                    while (itr2.hasNext()) {
                        BigdataStatement stmt = (BigdataStatement)itr2.next();
                        ((AbstractStatementBuffer)sb).add(stmt);
                    }
                }
                finally {
                    itr2.close();
                }
                long nnotFound = sb.flush();
                if (log.isInfoEnabled()) {
                    log.info("Flushed: #notFound=" + nnotFound);
                }
                return null;
            }
        };
        FutureTask<Void> ft = new FutureTask<Void>(myTask);
        buffer.setFuture(ft);
        actual.getExecutorService().submit(ft);
        return buffer.iterator();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static TempTripleStore bulkExport(AbstractTripleStore db) {
        Properties properties = new Properties();
        properties.setProperty(AbstractTripleStore.Options.ONE_ACCESS_PATH, "true");
        properties.setProperty(AbstractTripleStore.Options.JUSTIFY, "false");
        properties.setProperty(AbstractTripleStore.Options.AXIOMS_CLASS, NoAxioms.class.getName());
        properties.setProperty(AbstractTripleStore.Options.STATEMENT_IDENTIFIERS, "" + db.isStatementIdentifiers());
        TempTripleStore tmp = new TempTripleStore(properties);
        try {
            StatementBuffer sb = new StatementBuffer(tmp, 100000, 10);
            IV NULL = null;
            IChunkedOrderedIterator<ISPO> itr1 = new BackchainAccessPath(db, db.getAccessPath(NULL, NULL, NULL)).iterator();
            try (BigdataStatementIterator itr2 = db.asStatementIterator(itr1);){
                while (itr2.hasNext()) {
                    BigdataStatement stmt = (BigdataStatement)itr2.next();
                    sb.add(stmt);
                }
            }
            sb.flush();
        }
        catch (Throwable t) {
            tmp.close();
            throw new RuntimeException(t);
        }
        return tmp;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) throws Exception {
        String namespace;
        if (args.length < 2 || args.length > 3) {
            TripleStoreUtility.usage();
        }
        File file1 = new File(args[0]);
        File file2 = new File(args[1]);
        String string = namespace = args.length == 3 ? args[2] : "kb";
        if (!file1.exists()) {
            throw new FileNotFoundException(file1.toString());
        }
        if (!file2.exists()) {
            throw new FileNotFoundException(file2.toString());
        }
        AbstractJournal j1 = null;
        AbstractJournal j2 = null;
        try {
            Properties p = new Properties();
            p.setProperty(Options.READ_ONLY, "true");
            Properties properties = new Properties(p);
            properties.setProperty(Options.FILE, file1.toString());
            j1 = new Journal(properties);
            AbstractTripleStore ts1 = (AbstractTripleStore)((Journal)j1).getResourceLocator().locate(namespace, TimestampUtility.asHistoricalRead(j1.getLastCommitTime()));
            Properties properties2 = new Properties(p);
            properties2.setProperty(Options.FILE, file2.toString());
            j2 = new Journal(properties2);
            AbstractTripleStore ts2 = (AbstractTripleStore)((Journal)j2).getResourceLocator().locate(namespace, TimestampUtility.asHistoricalRead(j2.getLastCommitTime()));
            TripleStoreUtility.modelsEqual(ts1, ts2);
        }
        finally {
            if (j1 != null) {
                j1.close();
            }
            if (j2 != null) {
                j2.close();
            }
        }
    }

    private static void usage() {
        System.err.println("usage: filename filename (namespace)");
        System.exit(1);
    }
}

