/*
 * Decompiled with CFR 0.152.
 */
package com.bigdata.relation;

import com.bigdata.bop.IPredicate;
import com.bigdata.bop.ap.Predicate;
import com.bigdata.btree.BTree;
import com.bigdata.btree.IIndex;
import com.bigdata.btree.IndexMetadata;
import com.bigdata.btree.IndexTypeEnum;
import com.bigdata.btree.UnisolatedReadWriteIndex;
import com.bigdata.journal.IIndexManager;
import com.bigdata.journal.IJournal;
import com.bigdata.journal.TemporaryStore;
import com.bigdata.relation.AbstractResource;
import com.bigdata.relation.IMutableRelation;
import com.bigdata.relation.IRelation;
import com.bigdata.relation.accesspath.AccessPath;
import com.bigdata.relation.accesspath.IAccessPath;
import com.bigdata.relation.locator.ILocatableResource;
import com.bigdata.relation.rule.IAccessPathExpander;
import com.bigdata.striterator.IKeyOrder;
import java.util.Properties;
import java.util.UUID;

public abstract class AbstractRelation<E>
extends AbstractResource<IRelation<E>>
implements IMutableRelation<E> {
    protected AbstractRelation(IIndexManager indexManager, String namespace, Long timestamp, Properties properties) {
        this(null, indexManager, namespace, timestamp, properties);
    }

    protected AbstractRelation(ILocatableResource container, IIndexManager indexManager, String namespace, Long timestamp, Properties properties) {
        super(container, indexManager, namespace, timestamp, properties);
    }

    @Override
    public String getFQN(IKeyOrder<? extends E> keyOrder) {
        return AbstractRelation.getFQN(this, keyOrder);
    }

    public static <E> String getFQN(IRelation<E> relation, IKeyOrder<? extends E> keyOrder) {
        return AbstractRelation.getFQN(relation, keyOrder.getIndexName());
    }

    public static <E> String getFQN(IRelation<E> relation, String localName) {
        return (relation.getNamespace() + "." + localName).intern();
    }

    @Override
    public IIndex getIndex(IKeyOrder<? extends E> keyOrder) {
        return this.getIndex(this.getFQN(keyOrder));
    }

    public IIndex getIndex(String fqn) {
        IIndexManager indexManager = this.getIndexManager();
        long timestamp = this.getTimestamp();
        return AbstractRelation.getIndex(indexManager, fqn, timestamp);
    }

    public static IIndex getIndex(IIndexManager indexManager, String fqn, long timestamp) {
        if (indexManager == null) {
            throw new IllegalArgumentException();
        }
        if (fqn == null) {
            throw new IllegalArgumentException();
        }
        IIndex ndx = indexManager.getIndex(fqn, timestamp);
        if (ndx != null && timestamp == 0L && (indexManager instanceof IJournal || indexManager instanceof TemporaryStore)) {
            if (log.isDebugEnabled()) {
                log.debug("Imposing read-write concurrency controls on index: name=" + fqn);
            }
            ndx = new UnisolatedReadWriteIndex((BTree)ndx);
        }
        return ndx;
    }

    protected IndexMetadata newIndexMetadata(String name) {
        IndexMetadata metadata = new IndexMetadata(this.getIndexManager(), this.getProperties(), name, UUID.randomUUID(), IndexTypeEnum.BTree);
        return metadata;
    }

    public IAccessPath<E> newAccessPath(IIndexManager localIndexManager, IPredicate<E> predicate, IKeyOrder<E> keyOrder) {
        return new AccessPath<E>(this, localIndexManager, predicate, keyOrder).init();
    }

    @Override
    public final IAccessPath<E> getAccessPath(IPredicate<E> predicate) {
        return this.getAccessPath(this.getKeyOrder(predicate), predicate);
    }

    @Override
    public final IAccessPath<E> getAccessPath(IKeyOrder<E> keyOrder, IPredicate<E> predicate) {
        return this.getAccessPath(null, keyOrder, predicate);
    }

    @Override
    public final IAccessPath<E> getAccessPath(IIndexManager localIndexManager, IKeyOrder<E> keyOrder, IPredicate<E> predicate) {
        IAccessPath<E> accessPath;
        IAccessPathExpander<E> expander = predicate.getAccessPathExpander();
        if (expander != null) {
            IPredicate predicateWithoutExpander = (IPredicate)((Object)((Predicate)predicate).clearProperty(IPredicate.Annotations.ACCESS_PATH_EXPANDER));
            accessPath = this.newAccessPath(localIndexManager, predicateWithoutExpander, keyOrder);
            accessPath = expander.getAccessPath(accessPath);
        } else {
            accessPath = this.newAccessPath(localIndexManager, predicate, keyOrder);
        }
        return accessPath;
    }
}

