/*
 * Decompiled with CFR 0.152.
 */
package com.bigdata.relation;

import com.bigdata.bop.engine.QueryEngine;
import com.bigdata.bop.fed.QueryEngineFactory;
import com.bigdata.config.Configuration;
import com.bigdata.config.IValidator;
import com.bigdata.config.IntegerValidator;
import com.bigdata.config.LongValidator;
import com.bigdata.journal.IIndexManager;
import com.bigdata.journal.IJournal;
import com.bigdata.journal.IResourceLock;
import com.bigdata.journal.NoSuchIndexException;
import com.bigdata.journal.TimestampUtility;
import com.bigdata.rdf.sparql.ast.cache.CacheConnectionFactory;
import com.bigdata.rdf.sparql.ast.cache.ICacheConnection;
import com.bigdata.relation.IMutableResource;
import com.bigdata.relation.RelationSchema;
import com.bigdata.relation.accesspath.AccessPath;
import com.bigdata.relation.accesspath.BlockingBuffer;
import com.bigdata.relation.accesspath.IBuffer;
import com.bigdata.relation.locator.DefaultResourceLocator;
import com.bigdata.relation.locator.ILocatableResource;
import com.bigdata.relation.rule.eval.ProgramTask;
import com.bigdata.service.IBigdataFederation;
import com.bigdata.sparse.GlobalRowStoreUtil;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.ExecutorService;
import org.apache.log4j.Logger;

public abstract class AbstractResource<E>
implements IMutableResource<E> {
    protected static final transient Logger log = Logger.getLogger(AbstractResource.class);
    protected final IIndexManager indexManager;
    private final String namespace;
    private final String containerNamespace;
    private final long timestamp;
    private final Long commitTime;
    private final Properties properties;
    private final int chunkOfChunksCapacity;
    private final int chunkCapacity;
    private final long chunkTimeout;
    private final int fullyBufferedReadThreshold;
    private final boolean forceSerialExecution;
    private final int maxParallelSubqueries;
    private volatile ILocatableResource container;

    public final int getChunkOfChunksCapacity() {
        return this.chunkOfChunksCapacity;
    }

    public final int getChunkCapacity() {
        return this.chunkCapacity;
    }

    public final long getChunkTimeout() {
        return this.chunkTimeout;
    }

    public int getFullyBufferedReadThreshold() {
        return this.fullyBufferedReadThreshold;
    }

    public boolean isForceSerialExecution() {
        return this.forceSerialExecution;
    }

    public int getMaxParallelSubqueries() {
        return this.maxParallelSubqueries;
    }

    protected AbstractResource(IIndexManager indexManager, String namespace, Long timestamp, Properties properties) {
        this(null, indexManager, namespace, timestamp, properties);
    }

    protected AbstractResource(ILocatableResource container, IIndexManager indexManager, String namespace, Long timestamp, Properties properties) {
        if (indexManager == null) {
            throw new IllegalArgumentException();
        }
        if (namespace == null) {
            throw new IllegalArgumentException();
        }
        if (timestamp == null) {
            throw new IllegalArgumentException();
        }
        if (properties == null) {
            throw new IllegalArgumentException();
        }
        this.container = container;
        this.indexManager = indexManager;
        this.namespace = namespace;
        this.containerNamespace = properties.getProperty(RelationSchema.CONTAINER);
        this.timestamp = timestamp;
        this.properties = properties;
        properties.setProperty(RelationSchema.NAMESPACE, namespace);
        properties.setProperty(RelationSchema.CLASS, this.getClass().getName());
        if (log.isInfoEnabled()) {
            log.info("namespace=" + namespace + ", timestamp=" + timestamp + ", container=" + this.containerNamespace + ", indexManager=" + indexManager);
        }
        this.commitTime = (Long)properties.get(RelationSchema.COMMIT_TIME);
        this.forceSerialExecution = Boolean.parseBoolean(this.getProperty(Options.FORCE_SERIAL_EXECUTION, "true"));
        this.maxParallelSubqueries = this.getProperty(Options.MAX_PARALLEL_SUBQUERIES, "5", IntegerValidator.GTE_ZERO);
        this.chunkOfChunksCapacity = this.getProperty(Options.CHUNK_OF_CHUNKS_CAPACITY, "10", IntegerValidator.GT_ZERO);
        this.chunkCapacity = this.getProperty(Options.CHUNK_CAPACITY, "100", IntegerValidator.GT_ZERO);
        this.chunkTimeout = this.getProperty(Options.CHUNK_TIMEOUT, "10", LongValidator.GTE_ZERO);
        this.fullyBufferedReadThreshold = this.getProperty(Options.FULLY_BUFFERED_READ_THRESHOLD, "200", IntegerValidator.GT_ZERO);
    }

    @Override
    public final String getNamespace() {
        return this.namespace;
    }

    @Override
    public final String getContainerNamespace() {
        return this.containerNamespace;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ILocatableResource getContainer() {
        if (this.container == null) {
            AbstractResource abstractResource = this;
            synchronized (abstractResource) {
                if (this.container == null && this.getContainerNamespace() != null) {
                    if (log.isInfoEnabled()) {
                        log.info("resolving container: " + this.getContainerNamespace());
                    }
                    this.container = this.getIndexManager().getResourceLocator().locate(this.getContainerNamespace(), this.getTimestamp());
                }
            }
        }
        return this.container;
    }

    @Override
    public final long getTimestamp() {
        return this.timestamp;
    }

    protected Long getCommitTime() {
        return this.commitTime;
    }

    public final Properties getProperties() {
        return new Properties(this.properties);
    }

    protected final Properties getBareProperties() {
        return this.properties;
    }

    public IIndexManager getIndexManager() {
        return this.indexManager;
    }

    public final ExecutorService getExecutorService() {
        return this.indexManager.getExecutorService();
    }

    public String toString() {
        return this.getClass().getSimpleName() + "{timestamp=" + this.timestamp + ", namespace=" + this.namespace + ", container=" + this.containerNamespace + ", indexManager=" + this.indexManager + "}";
    }

    @Override
    public AbstractResource<E> init() {
        if (log.isInfoEnabled()) {
            log.info(this.toString());
        }
        return this;
    }

    @Override
    public void create() {
        if (log.isInfoEnabled()) {
            log.info(this.toString());
        }
        Map<String, Object> map = GlobalRowStoreUtil.convert(this.properties);
        Map<String, Object> afterMap = this.indexManager.getGlobalRowStore().write(RelationSchema.INSTANCE, map);
        if (log.isDebugEnabled()) {
            log.debug("Properties after write: " + afterMap);
        }
        ((DefaultResourceLocator)this.getIndexManager().getResourceLocator()).putInstance(this);
    }

    @Override
    public void destroy() {
        QueryEngine queryEngine;
        ICacheConnection cacheConn;
        if (log.isInfoEnabled()) {
            log.info(this.toString());
        }
        Iterator<String> itr = this.indexManager.indexNameScan(this.namespace + ".", this.timestamp);
        while (itr.hasNext()) {
            String name = itr.next();
            try {
                this.indexManager.dropIndex(name);
            }
            catch (NoSuchIndexException ex) {
                log.warn("Ignored: " + ex);
            }
        }
        if ((this.indexManager instanceof IJournal || this.indexManager instanceof IBigdataFederation) && (cacheConn = CacheConnectionFactory.getCacheConnection(queryEngine = QueryEngineFactory.getInstance().getQueryController(this.indexManager))) != null) {
            cacheConn.destroyCaches(this.namespace, this.timestamp);
        }
        this.indexManager.getGlobalRowStore().delete(RelationSchema.INSTANCE, this.namespace);
        this.indexManager.getResourceLocator().discard(this, true);
    }

    protected IResourceLock acquireExclusiveLock() {
        return this.indexManager.getResourceLockService().acquireLock(this.getNamespace());
    }

    protected void unlock(IResourceLock resourceLock) {
        resourceLock.unlock();
    }

    public String getProperty(String localName, String defaultValue) {
        return Configuration.getProperty(this.indexManager, this.properties, this.namespace, localName, defaultValue);
    }

    public <T> T getProperty(String name, String defaultValue, IValidator<T> validator) {
        return Configuration.getProperty(this.indexManager, this.properties, this.namespace, name, defaultValue, validator);
    }

    public boolean isReadOnly() {
        return TimestampUtility.isReadOnly(this.getTimestamp());
    }

    protected final void assertWritable() {
        if (this.isReadOnly()) {
            throw new IllegalStateException("READ_ONLY");
        }
    }

    public static interface Options {
        public static final String CHUNK_OF_CHUNKS_CAPACITY = BlockingBuffer.class.getName() + ".chunkOfChunksCapacity";
        public static final String DEFAULT_CHUNK_OF_CHUNKS_CAPACITY = "10";
        public static final String CHUNK_CAPACITY = IBuffer.class.getName() + ".chunkCapacity";
        public static final String DEFAULT_CHUNK_CAPACITY = "100";
        public static final String CHUNK_TIMEOUT = BlockingBuffer.class.getName() + ".chunkTimeout";
        public static final String DEFAULT_CHUNK_TIMEOUT = "10";
        public static final String FULLY_BUFFERED_READ_THRESHOLD = AccessPath.class.getName() + ".fullyBufferedReadThreadshold";
        public static final String DEFAULT_FULLY_BUFFERED_READ_THRESHOLD = "200";
        public static final String FORCE_SERIAL_EXECUTION = ProgramTask.class.getName() + ".forceSerialExecution";
        public static final String DEFAULT_FORCE_SERIAL_EXECUTION = "true";
        public static final String MAX_PARALLEL_SUBQUERIES = ProgramTask.class.getName() + ".maxParallelSubqueries";
        public static final String DEFAULT_MAX_PARALLEL_SUBQUERIES = "5";
    }
}

