/*
 * Decompiled with CFR 0.152.
 */
package com.bigdata.relation.accesspath;

import com.bigdata.relation.accesspath.IMultiSourceCloseableIterator;
import cutthecrap.utils.striterators.ICloseableIterator;
import java.util.NoSuchElementException;
import java.util.Queue;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.log4j.Logger;

public class MultiSourceSequentialCloseableIterator<E>
implements IMultiSourceCloseableIterator<E> {
    private static final Logger log = Logger.getLogger(MultiSourceSequentialCloseableIterator.class);
    private static final boolean INFO = log.isInfoEnabled();
    private final ReentrantLock lock = new ReentrantLock();
    private final Queue<ICloseableIterator<E>> sources = new LinkedBlockingQueue<ICloseableIterator<E>>();
    private volatile ICloseableIterator<E> current;

    public MultiSourceSequentialCloseableIterator(ICloseableIterator<E> src) {
        this.current = src;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        this.lock.lock();
        try {
            ICloseableIterator<E> current = this.current;
            this.current = null;
            if (current != null) {
                if (INFO) {
                    log.info("Closing source: " + current);
                }
                current.close();
            }
            for (ICloseableIterator iCloseableIterator : this.sources) {
                if (INFO) {
                    log.info("Closing source: " + iCloseableIterator);
                }
                iCloseableIterator.close();
            }
            this.sources.clear();
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean add(ICloseableIterator<E> src) {
        if (src == null) {
            throw new IllegalArgumentException();
        }
        this.lock.lock();
        try {
            if (this.current == null) {
                boolean bl = false;
                return bl;
            }
            this.sources.add(src);
            boolean bl = true;
            return bl;
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ICloseableIterator<E> nextSource() {
        ICloseableIterator<E> tmp = this.current;
        if (tmp == null) {
            return null;
        }
        if (tmp.hasNext()) {
            return this.current;
        }
        this.lock.lock();
        try {
            ICloseableIterator<E> t = this.current;
            if (t != null) {
                if (INFO) {
                    log.info("Closing source: " + t);
                }
                t.close();
            }
            while (true) {
                this.current = this.sources.poll();
                t = this.current;
                if (this.current == null) break;
                if (t.hasNext()) {
                    ICloseableIterator<E> iCloseableIterator = t;
                    return iCloseableIterator;
                }
                t.close();
            }
            this.close();
            ICloseableIterator<E> iCloseableIterator = null;
            return iCloseableIterator;
        }
        finally {
            this.lock.unlock();
        }
    }

    @Override
    public boolean hasNext() {
        ICloseableIterator<E> tmp;
        do {
            if ((tmp = this.nextSource()) != null) continue;
            return false;
        } while (!tmp.hasNext());
        return true;
    }

    @Override
    public E next() {
        ICloseableIterator<E> tmp;
        do {
            if ((tmp = this.nextSource()) != null) continue;
            throw new NoSuchElementException();
        } while (!tmp.hasNext());
        return tmp.next();
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }
}

