/*
 * Decompiled with CFR 0.152.
 */
package com.bigdata.relation.locator;

import com.bigdata.cache.ConcurrentWeakValueCache;
import com.bigdata.cache.ConcurrentWeakValueCacheWithTimeout;
import com.bigdata.concurrent.NamedLock;
import com.bigdata.journal.ICommitRecord;
import com.bigdata.journal.IIndexManager;
import com.bigdata.journal.IJournal;
import com.bigdata.journal.ITx;
import com.bigdata.journal.TemporaryStore;
import com.bigdata.journal.TimestampUtility;
import com.bigdata.rawstore.IRawStore;
import com.bigdata.relation.AbstractResource;
import com.bigdata.relation.RelationSchema;
import com.bigdata.relation.locator.ILocatableResource;
import com.bigdata.relation.locator.IResourceLocator;
import com.bigdata.sparse.SparseRowStore;
import com.bigdata.util.NT;
import java.lang.ref.WeakReference;
import java.lang.reflect.Constructor;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import java.util.UUID;
import java.util.WeakHashMap;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import java.util.concurrent.locks.Lock;
import org.apache.log4j.Logger;

public class DefaultResourceLocator<T extends ILocatableResource<T>>
implements IResourceLocator<T> {
    protected static final transient Logger log = Logger.getLogger(DefaultResourceLocator.class);
    protected static final boolean INFO = log.isInfoEnabled();
    protected final transient IIndexManager indexManager;
    private final IResourceLocator<T> delegate;
    private final transient ConcurrentWeakValueCache<NT, T> resourceCache;
    final transient ConcurrentWeakValueCache<NT, Map<String, Object>> propertyCache;
    private final String STORE_UUID = DefaultResourceLocator.class.getName() + ".storeUUID";
    private final transient NamedLock<String> namedLock = new NamedLock();
    protected static final transient int DEFAULT_CACHE_CAPACITY = 10;
    protected static final transient long DEFAULT_CACHE_TIMEOUT = 10000L;
    private final WeakHashMap<IIndexManager, Void> seeAlso = new WeakHashMap();

    public DefaultResourceLocator(IIndexManager indexManager, IResourceLocator<T> delegate) {
        this(indexManager, delegate, 10, 10000L);
    }

    public DefaultResourceLocator(IIndexManager indexManager, IResourceLocator<T> delegate, int cacheCapacity, long cacheTimeout) {
        if (indexManager == null) {
            throw new IllegalArgumentException();
        }
        this.indexManager = indexManager;
        this.delegate = delegate;
        if (cacheCapacity <= 0) {
            throw new IllegalArgumentException();
        }
        if (cacheTimeout < 0L) {
            throw new IllegalArgumentException();
        }
        this.resourceCache = new ConcurrentWeakValueCacheWithTimeout<NT, T>(cacheCapacity, TimeUnit.MILLISECONDS.toNanos(cacheTimeout));
        int propertyCacheCapacity = Math.max(cacheCapacity, cacheCapacity * 10);
        long propertyCacheTimeout = TimeUnit.MILLISECONDS.toNanos(cacheTimeout) * 10L;
        this.propertyCache = new ConcurrentWeakValueCacheWithTimeout<NT, Map<String, Object>>(propertyCacheCapacity, propertyCacheTimeout);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public T locate(String namespace, long timestamp) {
        if (namespace == null) {
            throw new IllegalArgumentException();
        }
        if (INFO) {
            log.info("namespace=" + namespace + ", timestamp=" + timestamp);
        }
        ILocatableResource resource = null;
        NT nt = new NT(namespace, timestamp);
        resource = (ILocatableResource)this.resourceCache.get(nt);
        if (resource != null) {
            if (log.isDebugEnabled()) {
                log.debug("cache hit: " + resource);
            }
            return (T)resource;
        }
        Lock lock = this.namedLock.acquireLock(namespace);
        try {
            resource = (ILocatableResource)this.resourceCache.get(nt);
            if (resource != null) {
                if (log.isDebugEnabled()) {
                    log.debug("cache hit: " + resource);
                }
                ILocatableResource iLocatableResource = resource;
                return (T)iLocatableResource;
            }
            if (INFO) {
                log.info("cache miss: namespace=" + namespace + ", timestamp=" + timestamp);
            }
            if ((resource = this.cacheMiss(nt)) == null) {
                if (INFO) {
                    log.info("Not found: " + nt);
                }
            } else {
                if (INFO) {
                    log.info("Caching: " + nt + " as " + resource);
                }
                this.resourceCache.put(nt, resource);
            }
            ILocatableResource iLocatableResource = resource;
            return (T)iLocatableResource;
        }
        finally {
            lock.unlock();
        }
    }

    private T cacheMiss(NT nt) {
        Class<?> cls;
        String className;
        T resource = null;
        AtomicReference<IIndexManager> foundOn = new AtomicReference<IIndexManager>();
        Properties properties = this.locateResource(nt.getName(), nt.getTimestamp(), foundOn);
        if (properties == null) {
            if (this.delegate != null) {
                if (INFO) {
                    log.info("Not found - passing to delegate: " + nt);
                }
                if ((resource = (T)this.delegate.locate(nt.getName(), nt.getTimestamp())) != null) {
                    if (INFO) {
                        log.info("delegate answered: " + resource);
                    }
                    return resource;
                }
            }
            return null;
        }
        if (log.isDebugEnabled()) {
            log.debug(properties.toString());
        }
        if ((className = properties.getProperty(RelationSchema.CLASS)) == null) {
            return null;
        }
        try {
            cls = Class.forName(className);
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException(e);
        }
        if (log.isDebugEnabled()) {
            log.debug("Implementation class=" + cls.getName());
        }
        resource = (T)this.newInstance(cls, foundOn.get(), nt, properties);
        return resource;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Properties locateResource(String namespace, long timestamp, AtomicReference<IIndexManager> foundOn) {
        WeakHashMap<IIndexManager, Void> weakHashMap = this.seeAlso;
        synchronized (weakHashMap) {
            for (IIndexManager indexManager : this.seeAlso.keySet()) {
                UUID storeUUID;
                Properties properties = null;
                try {
                    properties = this.locateResourceOn(indexManager, namespace, timestamp);
                }
                catch (IllegalStateException t) {
                    if (indexManager instanceof TemporaryStore) {
                        if (!INFO) continue;
                        log.info("Closed? " + indexManager);
                        continue;
                    }
                    log.warn("Closed? " + indexManager);
                    continue;
                }
                catch (Throwable t) {
                    log.error(t, t);
                    continue;
                }
                if (properties == null || indexManager instanceof IRawStore && (storeUUID = (UUID)properties.get(this.STORE_UUID)) != null && !storeUUID.equals(((IRawStore)((Object)indexManager)).getUUID())) continue;
                if (INFO) {
                    log.info("Found: namespace=" + namespace + " on " + indexManager + ", properties=" + properties);
                }
                foundOn.set(indexManager);
                return properties;
            }
        }
        Properties properties = this.locateResourceOn(this.indexManager, namespace, timestamp);
        if (properties != null) {
            if (INFO) {
                log.info("Found: namespace=" + namespace + " on " + this.indexManager);
            }
            foundOn.set(this.indexManager);
            return properties;
        }
        return properties;
    }

    protected Properties locateResourceOn(IIndexManager indexManager, String namespace, long timestamp) {
        boolean propertyCacheHit;
        Map<String, Object> map;
        if (INFO) {
            log.info("indexManager=" + indexManager + ", namespace=" + namespace + ", timestamp=" + timestamp);
        }
        Long commitTime2 = null;
        if (TimestampUtility.isReadOnly(timestamp) && !TimestampUtility.isReadCommitted(timestamp)) {
            long readTime;
            if (indexManager instanceof IJournal) {
                IJournal journal = (IJournal)indexManager;
                ITx tx = journal.getLocalTransactionManager().getTx(timestamp);
                if (tx != null) {
                    readTime = tx.getReadsOnCommitTime();
                    commitTime2 = readTime;
                } else {
                    ICommitRecord commitRecord = journal.getCommitRecord(TimestampUtility.asHistoricalRead(timestamp));
                    if (commitRecord == null) {
                        return null;
                    }
                    readTime = commitRecord.getTimestamp();
                    commitTime2 = readTime;
                }
            } else {
                readTime = timestamp;
            }
            NT nt = new NT(namespace, readTime);
            Map<String, Object> cachedMap = this.propertyCache.get(nt);
            if (cachedMap != null) {
                map = cachedMap;
                propertyCacheHit = true;
            } else {
                propertyCacheHit = false;
                SparseRowStore rowStore = indexManager.getGlobalRowStore(readTime);
                try {
                    map = rowStore == null ? null : rowStore.read(RelationSchema.INSTANCE, namespace);
                }
                catch (RuntimeException ex) {
                    throw new RuntimeException(ex.getMessage() + "::namespace=" + namespace + ", timestamp=" + TimestampUtility.toString(timestamp) + ", readTime=" + TimestampUtility.toString(readTime), ex);
                }
                if (map != null) {
                    if (indexManager instanceof IRawStore) {
                        map.put(this.STORE_UUID, ((IRawStore)((Object)indexManager)).getUUID());
                    }
                    this.propertyCache.put(nt, map);
                }
            }
        } else {
            SparseRowStore rowStore;
            if (timestamp == 0L) {
                rowStore = indexManager.getGlobalRowStore();
            } else if (timestamp == -1L) {
                rowStore = indexManager.getGlobalRowStore(indexManager.getLastCommitTime());
            } else if (TimestampUtility.isReadWriteTx(timestamp)) {
                if (indexManager instanceof IJournal) {
                    IJournal journal = (IJournal)indexManager;
                    ITx tx = journal.getLocalTransactionManager().getTx(timestamp);
                    if (tx == null) {
                        throw new IllegalStateException("No such tx: " + timestamp);
                    }
                    rowStore = indexManager.getGlobalRowStore(tx.getReadsOnCommitTime());
                } else {
                    rowStore = indexManager.getGlobalRowStore();
                }
            } else {
                throw new AssertionError((Object)("timestamp=" + TimestampUtility.toString(timestamp)));
            }
            map = rowStore == null ? null : rowStore.read(RelationSchema.INSTANCE, namespace);
            propertyCacheHit = false;
        }
        if (map == null) {
            if (log.isDebugEnabled()) {
                log.debug("Not found: indexManager=" + indexManager + ", namespace=" + namespace + ", timestamp=" + timestamp);
            }
            return null;
        }
        Properties properties = new Properties();
        properties.putAll(map);
        if (commitTime2 != null) {
            properties.put(RelationSchema.COMMIT_TIME, commitTime2);
        }
        if (log.isTraceEnabled()) {
            log.trace("Read properties: indexManager=" + indexManager + ", namespace=" + namespace + ", timestamp=" + timestamp + ", propertyCacheHit=" + propertyCacheHit + ", properties=" + properties);
        }
        return properties;
    }

    protected T newInstance(Class<? extends T> cls, IIndexManager indexManager, NT nt, Properties properties) {
        Constructor<T> ctor;
        if (cls == null) {
            throw new IllegalArgumentException();
        }
        if (indexManager == null) {
            throw new IllegalArgumentException();
        }
        if (nt == null) {
            throw new IllegalArgumentException();
        }
        if (properties == null) {
            throw new IllegalArgumentException();
        }
        try {
            ctor = cls.getConstructor(IIndexManager.class, String.class, Long.class, Properties.class);
        }
        catch (Exception e) {
            throw new RuntimeException("No appropriate ctor?: cls=" + cls.getName() + " : " + e, e);
        }
        try {
            ILocatableResource r = (ILocatableResource)ctor.newInstance(indexManager, nt.getName(), nt.getTimestamp(), properties);
            r.init();
            if (INFO) {
                log.info("new instance: " + r);
            }
            return (T)r;
        }
        catch (Exception ex) {
            throw new RuntimeException("Could not instantiate relation: " + ex, ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public T putInstance(T instance) {
        if (instance == null) {
            throw new IllegalArgumentException();
        }
        String namespace = instance.getNamespace();
        long timestamp = instance.getTimestamp();
        if (INFO) {
            log.info("namespace=" + namespace + ", timestamp=" + timestamp);
        }
        Lock lock = this.namedLock.acquireLock(namespace);
        try {
            NT nt = new NT(namespace, timestamp);
            ILocatableResource tmp = (ILocatableResource)this.resourceCache.get(nt);
            if (tmp != null) {
                if (INFO) {
                    log.info("Existing instance already in cache: " + tmp);
                }
                ILocatableResource iLocatableResource = tmp;
                return (T)iLocatableResource;
            }
            this.resourceCache.put(nt, instance);
            if (INFO) {
                log.info("Instance added to cache: nt=" + nt + ", instance=" + instance + ", indexManager=" + (instance instanceof AbstractResource ? ((AbstractResource)instance).getIndexManager() : "n/a"));
            }
            T t = instance;
            return t;
        }
        finally {
            lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void discard(ILocatableResource<T> instance, boolean destroyed) {
        if (instance == null) {
            throw new IllegalArgumentException();
        }
        String namespace = instance.getNamespace();
        long timestamp = instance.getTimestamp();
        if (INFO) {
            log.info("namespace=" + namespace + ", timestamp=" + timestamp + ", destroyed=" + destroyed);
        }
        Lock lock = this.namedLock.acquireLock(namespace);
        try {
            boolean found;
            NT nt = new NT(namespace, timestamp);
            boolean bl = found = this.resourceCache.remove(nt) != null;
            if (INFO) {
                log.info("instance=" + instance + ", found=" + found);
            }
            if (destroyed) {
                this.resourceCache.remove(new NT(namespace, 0L));
                this.resourceCache.remove(new NT(namespace, -1L));
            }
        }
        finally {
            lock.unlock();
        }
    }

    @Override
    public void clearUnisolatedCache() {
        NT nt;
        Map.Entry<NT, WeakReference<Object>> e;
        Iterator<Map.Entry<NT, WeakReference<Object>>> itr = this.resourceCache.entryIterator();
        while (itr.hasNext()) {
            e = itr.next();
            nt = e.getKey();
            if (!TimestampUtility.isUnisolated(nt.getTimestamp())) continue;
            itr.remove();
        }
        itr = this.propertyCache.entryIterator();
        while (itr.hasNext()) {
            e = itr.next();
            nt = e.getKey();
            if (!TimestampUtility.isUnisolated(nt.getTimestamp())) continue;
            itr.remove();
        }
        if (this.delegate != null) {
            this.delegate.clearUnisolatedCache();
        }
        if (log.isInfoEnabled()) {
            log.info("Cleared resource cache");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void add(IIndexManager indexManager) {
        if (indexManager == null) {
            throw new IllegalArgumentException();
        }
        WeakHashMap<IIndexManager, Void> weakHashMap = this.seeAlso;
        synchronized (weakHashMap) {
            this.seeAlso.put(indexManager, null);
            if (INFO) {
                log.info("size=" + this.seeAlso.size() + ", added indexManager=" + indexManager);
            }
        }
    }
}

