/*
 * Decompiled with CFR 0.152.
 */
package com.bigdata.relation.rule.eval;

import com.bigdata.bop.Constant;
import com.bigdata.bop.IBindingSet;
import com.bigdata.bop.IConstant;
import com.bigdata.bop.IConstraint;
import com.bigdata.bop.IElement;
import com.bigdata.bop.IPredicate;
import com.bigdata.bop.IVariable;
import com.bigdata.bop.IVariableOrConstant;
import com.bigdata.bop.bindingSet.ListBindingSet;
import com.bigdata.bop.joinGraph.DefaultRangeCountFactory;
import com.bigdata.bop.joinGraph.IEvaluationPlanFactory;
import com.bigdata.bop.joinGraph.IRangeCountFactory;
import com.bigdata.btree.keys.DelegateSortKeyBuilder;
import com.bigdata.btree.keys.ISortKeyBuilder;
import com.bigdata.config.Configuration;
import com.bigdata.config.IValidator;
import com.bigdata.config.IntegerValidator;
import com.bigdata.config.LongValidator;
import com.bigdata.io.IStreamSerializer;
import com.bigdata.io.SerializerUtil;
import com.bigdata.journal.IIndexManager;
import com.bigdata.mdi.PartitionLocator;
import com.bigdata.relation.AbstractResource;
import com.bigdata.relation.IMutableRelation;
import com.bigdata.relation.IRelation;
import com.bigdata.relation.RelationFusedView;
import com.bigdata.relation.accesspath.AccessPath;
import com.bigdata.relation.accesspath.BlockingBuffer;
import com.bigdata.relation.accesspath.IAccessPath;
import com.bigdata.relation.accesspath.IBlockingBuffer;
import com.bigdata.relation.accesspath.IBuffer;
import com.bigdata.relation.accesspath.IElementFilter;
import com.bigdata.relation.accesspath.UnsynchronizedArrayBuffer;
import com.bigdata.relation.locator.DefaultResourceLocator;
import com.bigdata.relation.locator.IResourceLocator;
import com.bigdata.relation.rule.IProgram;
import com.bigdata.relation.rule.IRule;
import com.bigdata.relation.rule.IStep;
import com.bigdata.relation.rule.eval.AbstractSolutionBuffer;
import com.bigdata.relation.rule.eval.ActionEnum;
import com.bigdata.relation.rule.eval.EmptyProgramTask;
import com.bigdata.relation.rule.eval.IJoinNexus;
import com.bigdata.relation.rule.eval.IJoinNexusFactory;
import com.bigdata.relation.rule.eval.IRuleState;
import com.bigdata.relation.rule.eval.IRuleStatisticsFactory;
import com.bigdata.relation.rule.eval.IRuleTaskFactory;
import com.bigdata.relation.rule.eval.ISolution;
import com.bigdata.relation.rule.eval.ProgramTask;
import com.bigdata.relation.rule.eval.RuleStats;
import com.bigdata.relation.rule.eval.Solution;
import com.bigdata.relation.rule.eval.SolutionFilter;
import com.bigdata.service.AbstractScaleOutFederation;
import com.bigdata.service.IBigdataFederation;
import com.bigdata.service.ndx.IClientIndex;
import com.bigdata.striterator.ChunkedConvertingIterator;
import com.bigdata.striterator.DistinctFilter;
import com.bigdata.striterator.IChunkedOrderedIterator;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.apache.log4j.Logger;

public abstract class AbstractJoinNexus
implements IJoinNexus {
    private static final transient Logger log = Logger.getLogger(AbstractJoinNexus.class);
    private final IJoinNexusFactory joinNexusFactory;
    protected final IIndexManager indexManager;
    protected final IResourceLocator<?> resourceLocator;
    private final ActionEnum action;
    private final long writeTimestamp;
    protected final long readTimestamp;
    protected final int chunkCapacity;
    protected final int chunkOfChunksCapacity;
    private final boolean forceSerialExecution;
    private final int maxParallelSubqueries;
    private final int fullyBufferedReadThreshold;
    private final long chunkTimeout;
    private static final TimeUnit chunkTimeoutUnit = TimeUnit.MILLISECONDS;
    protected final int solutionFlags;
    protected final IElementFilter<?> filter;
    protected final IEvaluationPlanFactory planFactory;
    private final IRangeCountFactory rangeCountFactory = new DefaultRangeCountFactory(this);
    private final IRuleStatisticsFactory ruleStatisticsFactory = new IRuleStatisticsFactory(){

        @Override
        public RuleStats newInstance(IStep step) {
            return new RuleStats(step);
        }

        @Override
        public RuleStats newInstance(IRuleState ruleState) {
            return new RuleStats(ruleState);
        }
    };

    @Override
    public final int getChunkOfChunksCapacity() {
        return this.chunkOfChunksCapacity;
    }

    @Override
    public final int getChunkCapacity() {
        return this.chunkCapacity;
    }

    @Override
    public final int getFullyBufferedReadThreshold() {
        return this.fullyBufferedReadThreshold;
    }

    @Override
    public final String getProperty(String name, String defaultValue) {
        return Configuration.getProperty(this.indexManager, this.joinNexusFactory.getProperties(), null, name, defaultValue);
    }

    @Override
    public final <T> T getProperty(String name, String defaultValue, IValidator<T> validator) {
        return Configuration.getProperty(this.indexManager, this.joinNexusFactory.getProperties(), null, name, defaultValue, validator);
    }

    @Override
    public IElementFilter<ISolution> getSolutionFilter() {
        return this.filter == null ? null : new SolutionFilter(this.filter);
    }

    protected AbstractJoinNexus(IJoinNexusFactory joinNexusFactory, IIndexManager indexManager) {
        if (joinNexusFactory == null) {
            throw new IllegalArgumentException();
        }
        if (indexManager == null) {
            throw new IllegalArgumentException();
        }
        this.joinNexusFactory = joinNexusFactory;
        this.indexManager = indexManager;
        this.resourceLocator = indexManager.getResourceLocator();
        this.action = joinNexusFactory.getAction();
        this.writeTimestamp = joinNexusFactory.getWriteTimestamp();
        this.readTimestamp = joinNexusFactory.getReadTimestamp();
        this.forceSerialExecution = Boolean.parseBoolean(this.getProperty(AbstractResource.Options.FORCE_SERIAL_EXECUTION, "true"));
        this.maxParallelSubqueries = this.getProperty(AbstractResource.Options.MAX_PARALLEL_SUBQUERIES, "5", IntegerValidator.GTE_ZERO);
        this.chunkOfChunksCapacity = this.getProperty(AbstractResource.Options.CHUNK_OF_CHUNKS_CAPACITY, "10", IntegerValidator.GT_ZERO);
        this.chunkCapacity = this.getProperty(AbstractResource.Options.CHUNK_CAPACITY, "100", IntegerValidator.GT_ZERO);
        this.chunkTimeout = this.getProperty(AbstractResource.Options.CHUNK_TIMEOUT, "10", LongValidator.GTE_ZERO);
        this.fullyBufferedReadThreshold = this.getProperty(AbstractResource.Options.FULLY_BUFFERED_READ_THRESHOLD, "200", IntegerValidator.GT_ZERO);
        this.solutionFlags = joinNexusFactory.getSolutionFlags();
        this.filter = joinNexusFactory.getSolutionFilter();
        this.planFactory = joinNexusFactory.getEvaluationPlanFactory();
    }

    @Override
    public IRuleStatisticsFactory getRuleStatisticsFactory() {
        return this.ruleStatisticsFactory;
    }

    @Override
    public IJoinNexusFactory getJoinNexusFactory() {
        return this.joinNexusFactory;
    }

    @Override
    public IRangeCountFactory getRangeCountFactory() {
        return this.rangeCountFactory;
    }

    @Override
    public final boolean forceSerialExecution() {
        if (log.isInfoEnabled()) {
            log.info("forceSerialExecution=" + this.forceSerialExecution);
        }
        return this.forceSerialExecution;
    }

    @Override
    public final int getMaxParallelSubqueries() {
        return this.maxParallelSubqueries;
    }

    @Override
    public final ActionEnum getAction() {
        return this.action;
    }

    @Override
    public final long getWriteTimestamp() {
        return this.writeTimestamp;
    }

    @Override
    public final long getReadTimestamp() {
        return this.readTimestamp;
    }

    @Override
    public IRelation getHeadRelationView(IPredicate pred) {
        if (pred.getRelationCount() != 1) {
            throw new IllegalArgumentException();
        }
        String relationName = pred.getOnlyRelationName();
        long timestamp = this.getAction().isMutation() ? this.getWriteTimestamp() : this.getReadTimestamp();
        return (IRelation)this.resourceLocator.locate(relationName, timestamp);
    }

    @Override
    public IRelation getTailRelationView(IPredicate pred) {
        int nsources = pred.getRelationCount();
        if (nsources == 1) {
            return (IRelation)this.resourceLocator.locate(pred.getOnlyRelationName(), this.getReadTimestamp());
        }
        if (nsources == 2) {
            IRelation relation0 = (IRelation)this.resourceLocator.locate(pred.getRelationName(0), this.readTimestamp);
            IRelation relation1 = (IRelation)this.resourceLocator.locate(pred.getRelationName(1), this.readTimestamp);
            return new RelationFusedView(relation0, relation1).init();
        }
        throw new UnsupportedOperationException();
    }

    @Override
    public IAccessPath getTailAccessPath(IRelation relation, IPredicate predicate) {
        return relation.getAccessPath(this.indexManager, relation.getKeyOrder(predicate), predicate);
    }

    @Override
    public Iterator<PartitionLocator> locatorScan(AbstractScaleOutFederation<?> fed, IPredicate<?> predicate) {
        long timestamp = this.getReadTimestamp();
        IRelation relation = (IRelation)((DefaultResourceLocator)fed.getResourceLocator()).locate(predicate.getOnlyRelationName(), timestamp);
        AccessPath accessPath = (AccessPath)relation.getAccessPath(predicate);
        IClientIndex ndx = (IClientIndex)accessPath.getIndex();
        String name = ndx.getIndexMetadata().getName();
        return fed.locatorScan(name, timestamp, accessPath.getFromKey(), accessPath.getToKey(), false);
    }

    @Override
    public final IIndexManager getIndexManager() {
        return this.indexManager;
    }

    @Override
    public final boolean bind(IRule rule, int index, Object e, IBindingSet bindings) {
        this.copyValues((IElement)e, rule.getTail(index), bindings);
        return rule.isConsistent(bindings);
    }

    @Override
    public final boolean bind(IPredicate<?> pred, IConstraint[] constraints, Object e, IBindingSet bindings) {
        this.copyValues((IElement)e, pred, bindings);
        if (constraints != null) {
            return this.isConsistent(constraints, bindings);
        }
        return true;
    }

    private boolean isConsistent(IConstraint[] constraints, IBindingSet bindingSet) {
        for (int i = 0; i < constraints.length; ++i) {
            IConstraint constraint = constraints[i];
            if (constraint.accept(bindingSet)) continue;
            if (log.isDebugEnabled()) {
                log.debug("Rejected by " + constraint.getClass().getSimpleName() + " : " + bindingSet);
            }
            return false;
        }
        return true;
    }

    private final void copyValues(IElement e, IPredicate<?> pred, IBindingSet bindingSet) {
        for (int i = 0; i < pred.arity(); ++i) {
            IVariableOrConstant t = pred.get(i);
            if (!t.isVar()) continue;
            IVariable var = (IVariable)t;
            Constant<Object> newval = new Constant<Object>(e.get(i));
            bindingSet.set(var, newval);
        }
    }

    @Override
    public final ISolution newSolution(IRule rule, IBindingSet bindingSet) {
        Solution solution = new Solution(this, rule, bindingSet);
        if (log.isDebugEnabled()) {
            log.debug(solution.toString());
        }
        return solution;
    }

    @Override
    public final int solutionFlags() {
        return this.solutionFlags;
    }

    @Override
    public IStreamSerializer<ISolution[]> getSolutionSerializer() {
        return SerializerUtil.STREAMS;
    }

    @Override
    public IStreamSerializer<IBindingSet[]> getBindingSetSerializer() {
        return SerializerUtil.STREAMS;
    }

    @Override
    public final IBindingSet newBindingSet(IRule rule) {
        IBindingSet constants = rule.getConstants();
        int nconstants = constants.size();
        ListBindingSet bindingSet = new ListBindingSet();
        if (nconstants > 0) {
            Iterator<Map.Entry<IVariable, IConstant>> itr = constants.iterator();
            while (itr.hasNext()) {
                Map.Entry<IVariable, IConstant> entry = itr.next();
                bindingSet.set(entry.getKey(), entry.getValue());
            }
        }
        return bindingSet;
    }

    @Override
    public final IRuleTaskFactory getRuleTaskFactory(boolean parallel, IRule rule) {
        if (rule == null) {
            throw new IllegalArgumentException();
        }
        IRuleTaskFactory taskFactory = rule.getTaskFactory();
        if (taskFactory == null) {
            taskFactory = this.joinNexusFactory.getDefaultRuleTaskFactory();
        }
        return taskFactory;
    }

    @Override
    public final IEvaluationPlanFactory getPlanFactory() {
        return this.planFactory;
    }

    public final IResourceLocator getRelationLocator() {
        return this.resourceLocator;
    }

    @Override
    public final IBuffer<ISolution> newUnsynchronizedBuffer(IBuffer<ISolution[]> targetBuffer, int chunkCapacity) {
        IElementFilter<ISolution> filter = this.getSolutionFilter();
        return new UnsynchronizedArrayBuffer<ISolution>(targetBuffer, chunkCapacity, ISolution.class, filter);
    }

    @Override
    public final IBlockingBuffer<ISolution[]> newQueryBuffer() {
        if (this.getAction().isMutation()) {
            throw new IllegalStateException();
        }
        return new BlockingBuffer<ISolution[]>(this.chunkOfChunksCapacity, this.chunkCapacity, this.chunkTimeout, chunkTimeoutUnit);
    }

    @Override
    public IBuffer<ISolution[]> newInsertBuffer(IMutableRelation relation) {
        if (this.getAction() != ActionEnum.Insert) {
            throw new IllegalStateException();
        }
        if (log.isDebugEnabled()) {
            log.debug("relation=" + relation);
        }
        return new AbstractSolutionBuffer.InsertSolutionBuffer(this.chunkOfChunksCapacity, relation);
    }

    @Override
    public IBuffer<ISolution[]> newDeleteBuffer(IMutableRelation relation) {
        if (this.getAction() != ActionEnum.Delete) {
            throw new IllegalStateException();
        }
        if (log.isDebugEnabled()) {
            log.debug("relation=" + relation);
        }
        return new AbstractSolutionBuffer.DeleteSolutionBuffer(this.chunkOfChunksCapacity, relation);
    }

    protected abstract ISortKeyBuilder<?> newSortKeyBuilder(IPredicate<?> var1);

    @Override
    public IChunkedOrderedIterator<ISolution> runQuery(IStep step) throws Exception {
        if (step == null) {
            throw new IllegalArgumentException();
        }
        if (log.isInfoEnabled()) {
            log.info("program=" + step.getName());
        }
        if (this.isEmptyProgram(step)) {
            log.warn("Empty program");
            return (IChunkedOrderedIterator)new EmptyProgramTask(ActionEnum.Query, step).call();
        }
        IChunkedOrderedIterator itr = (IChunkedOrderedIterator)this.runProgram(ActionEnum.Query, step);
        if (step.isRule() && ((IRule)step).getQueryOptions().isDistinct()) {
            DelegateSortKeyBuilder sortKeyBuilder;
            if (((IRule)step).getHead() != null && (this.solutionFlags & 1) != 0) {
                sortKeyBuilder = new DelegateSortKeyBuilder(this.newSortKeyBuilder(((IRule)step).getHead())){

                    protected Object resolve(Object solution) {
                        return ((ISolution)solution).get();
                    }
                };
            } else if ((this.solutionFlags & 2) != 0) {
                sortKeyBuilder = new DelegateSortKeyBuilder<ISolution, IBindingSet>(this.newBindingSetSortKeyBuilder((IRule)step)){

                    @Override
                    protected IBindingSet resolve(ISolution solution) {
                        return solution.getBindingSet();
                    }
                };
            } else {
                throw new UnsupportedOperationException("You must specify BINDINGS since the rule does not have a head: " + step);
            }
            return new ChunkedConvertingIterator<ISolution, ISolution>(itr, new DistinctFilter<ISolution>(this.indexManager){

                @Override
                protected byte[] getSortKey(ISolution e) {
                    return sortKeyBuilder.getSortKey(e);
                }
            });
        }
        return itr;
    }

    @Override
    public final long runMutation(IStep step) throws Exception {
        if (step == null) {
            throw new IllegalArgumentException();
        }
        if (!this.action.isMutation()) {
            throw new IllegalStateException();
        }
        if (step.isRule() && ((IRule)step).getHead() == null) {
            throw new IllegalArgumentException("No head for this rule: " + step);
        }
        if (log.isInfoEnabled()) {
            log.info("action=" + (Object)((Object)this.action) + ", program=" + step.getName());
        }
        if (this.isEmptyProgram(step)) {
            log.warn("Empty program");
            return (Long)new EmptyProgramTask(this.action, step).call();
        }
        return (Long)this.runProgram(this.action, step);
    }

    protected final boolean isEmptyProgram(IStep step) {
        return !step.isRule() && ((IProgram)step).stepCount() == 0;
    }

    protected final Object runProgram(ActionEnum action, IStep step) throws Exception {
        if (action == null) {
            throw new IllegalArgumentException();
        }
        if (step == null) {
            throw new IllegalArgumentException();
        }
        IIndexManager indexManager = this.getIndexManager();
        if (indexManager instanceof IBigdataFederation) {
            return this.runDistributedProgram((IBigdataFederation)indexManager, action, step);
        }
        return this.runLocalProgram(action, step);
    }

    protected final Object runLocalProgram(ActionEnum action, IStep step) throws Exception {
        if (log.isInfoEnabled()) {
            log.info("Running local program: action=" + (Object)((Object)action) + ", program=" + step.getName());
        }
        ProgramTask innerTask = new ProgramTask(action, step, this.getJoinNexusFactory(), this.getIndexManager());
        return innerTask.call();
    }

    protected final Object runDistributedProgram(IBigdataFederation<?> fed, ActionEnum action, IStep step) throws Exception {
        if (log.isInfoEnabled()) {
            log.info("Running distributed program: action=" + (Object)((Object)action) + ", program=" + step.getName());
        }
        ProgramTask innerTask = new ProgramTask(action, step, this.getJoinNexusFactory(), this.getIndexManager());
        return innerTask.call();
    }
}

