/*
 * Decompiled with CFR 0.152.
 */
package com.bigdata.relation.rule.eval;

import com.bigdata.bop.joinGraph.IEvaluationPlanFactory;
import com.bigdata.journal.IIndexManager;
import com.bigdata.relation.accesspath.IElementFilter;
import com.bigdata.relation.rule.eval.ActionEnum;
import com.bigdata.relation.rule.eval.IJoinNexus;
import com.bigdata.relation.rule.eval.IJoinNexusFactory;
import com.bigdata.relation.rule.eval.IRuleTaskFactory;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.lang.ref.WeakReference;
import java.util.Properties;
import java.util.WeakHashMap;
import org.apache.log4j.Logger;

public abstract class AbstractJoinNexusFactory
implements IJoinNexusFactory {
    private static final long serialVersionUID = 1L;
    private static final transient Logger log = Logger.getLogger(AbstractJoinNexusFactory.class);
    private final ActionEnum action;
    private final long writeTimestamp;
    private long readTimestamp;
    private final Properties properties;
    private final int solutionFlags;
    private final IElementFilter<?> solutionFilter;
    private final IEvaluationPlanFactory evaluationPlanFactory;
    private final IRuleTaskFactory defaultRuleTaskFactory;
    private transient WeakHashMap<IIndexManager, WeakReference<IJoinNexus>> joinNexusCache;

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.getClass().getSimpleName());
        sb.append("{ action=" + (Object)((Object)this.action));
        sb.append(", writeTime=" + this.writeTimestamp);
        sb.append(", readTime=" + this.readTimestamp);
        sb.append(", properties=" + this.properties);
        sb.append(", solutionFlags=" + this.solutionFlags);
        sb.append(", solutionFilter=" + (this.solutionFilter == null ? "N/A" : this.solutionFilter.getClass().getName()));
        sb.append(", planFactory=" + this.evaluationPlanFactory.getClass().getName());
        sb.append(", defaultRuleTaskFactory=" + this.defaultRuleTaskFactory.getClass().getName());
        this.toString(sb);
        sb.append("}");
        return sb.toString();
    }

    protected void toString(StringBuilder sb) {
    }

    protected AbstractJoinNexusFactory(ActionEnum action, long writeTimestamp, long readTimestamp, Properties properties, int solutionFlags, IElementFilter<?> solutionFilter, IEvaluationPlanFactory evaluationPlanFactory, IRuleTaskFactory defaultRuleTaskFactory) {
        if (action == null) {
            throw new IllegalArgumentException();
        }
        if (evaluationPlanFactory == null) {
            throw new IllegalArgumentException();
        }
        this.action = action;
        this.writeTimestamp = writeTimestamp;
        this.readTimestamp = readTimestamp;
        this.properties = properties;
        this.solutionFlags = solutionFlags;
        this.solutionFilter = solutionFilter;
        this.evaluationPlanFactory = evaluationPlanFactory;
        this.defaultRuleTaskFactory = defaultRuleTaskFactory;
        this.joinNexusCache = new WeakHashMap();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public IJoinNexus newInstance(IIndexManager indexManager) {
        if (indexManager == null) {
            throw new IllegalArgumentException();
        }
        WeakHashMap<IIndexManager, WeakReference<IJoinNexus>> weakHashMap = this.joinNexusCache;
        synchronized (weakHashMap) {
            IJoinNexus joinNexus;
            WeakReference<IJoinNexus> ref = this.joinNexusCache.get(indexManager);
            IJoinNexus iJoinNexus = joinNexus = ref == null ? null : (IJoinNexus)ref.get();
            if (joinNexus == null) {
                joinNexus = this.newJoinNexus(indexManager);
                this.joinNexusCache.put(indexManager, new WeakReference<IJoinNexus>(joinNexus));
            }
            return joinNexus;
        }
    }

    protected abstract IJoinNexus newJoinNexus(IIndexManager var1);

    @Override
    public final ActionEnum getAction() {
        return this.action;
    }

    @Override
    public final Properties getProperties() {
        return this.properties;
    }

    @Override
    public final long getReadTimestamp() {
        return this.readTimestamp;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void setReadTimestamp(long readTimestamp) {
        if (this.readTimestamp == readTimestamp) {
            return;
        }
        WeakHashMap<IIndexManager, WeakReference<IJoinNexus>> weakHashMap = this.joinNexusCache;
        synchronized (weakHashMap) {
            this.joinNexusCache.clear();
            this.readTimestamp = readTimestamp;
            if (log.isInfoEnabled()) {
                log.info("readTimestamp: " + readTimestamp);
            }
        }
    }

    @Override
    public final long getWriteTimestamp() {
        return this.writeTimestamp;
    }

    @Override
    public final int getSolutionFlags() {
        return this.solutionFlags;
    }

    @Override
    public final IElementFilter<?> getSolutionFilter() {
        return this.solutionFilter;
    }

    @Override
    public final IEvaluationPlanFactory getEvaluationPlanFactory() {
        return this.evaluationPlanFactory;
    }

    @Override
    public final IRuleTaskFactory getDefaultRuleTaskFactory() {
        return this.defaultRuleTaskFactory;
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        this.joinNexusCache = new WeakHashMap();
        in.defaultReadObject();
    }
}

