/*
 * Decompiled with CFR 0.152.
 */
package com.bigdata.relation.rule.eval;

import com.bigdata.relation.accesspath.IBuffer;
import com.bigdata.relation.rule.eval.ISolution;
import com.bigdata.relation.rule.eval.IStepTask;
import com.bigdata.relation.rule.eval.RuleStats;
import java.io.Serializable;
import org.apache.log4j.Logger;

public class RunRuleAndFlushBufferTask
implements IStepTask,
Serializable {
    protected static final Logger log = Logger.getLogger(RunRuleAndFlushBufferTask.class);
    protected static final boolean DEBUG = log.isDebugEnabled();
    private static final long serialVersionUID = -2910127641227561854L;
    private final IStepTask stepTask;
    private final IBuffer<ISolution[]> buffer;

    public RunRuleAndFlushBufferTask(IStepTask stepTask, IBuffer<ISolution[]> buffer) {
        if (stepTask == null) {
            throw new IllegalArgumentException();
        }
        if (buffer == null) {
            throw new IllegalArgumentException();
        }
        this.stepTask = stepTask;
        this.buffer = buffer;
    }

    @Override
    public RuleStats call() throws Exception {
        RuleStats ruleStats = this.stepTask.call();
        if (DEBUG) {
            log.debug("Flushing buffer: size=" + this.buffer.size() + ", class=" + this.buffer.getClass().getName());
        }
        long mutationCount = this.buffer.flush();
        if (DEBUG) {
            log.debug("Flushed buffer: mutationCount=" + mutationCount);
        }
        return ruleStats;
    }
}

