/*
 * Decompiled with CFR 0.152.
 */
package com.bigdata.relation.rule.eval.pipeline;

import com.bigdata.bfs.BigdataFileSystem;
import com.bigdata.bop.IBindingSet;
import com.bigdata.bop.IVariable;
import com.bigdata.btree.IIndex;
import com.bigdata.btree.IndexMetadata;
import com.bigdata.counters.CounterSet;
import com.bigdata.journal.IIndexManager;
import com.bigdata.journal.IResourceLockService;
import com.bigdata.journal.TemporaryStore;
import com.bigdata.relation.accesspath.IAsynchronousIterator;
import com.bigdata.relation.locator.IResourceLocator;
import com.bigdata.relation.rule.IRule;
import com.bigdata.relation.rule.eval.IJoinNexusFactory;
import com.bigdata.relation.rule.eval.pipeline.DistributedJoinTask;
import com.bigdata.relation.rule.eval.pipeline.IJoinMaster;
import com.bigdata.service.AbstractDistributedFederation;
import com.bigdata.service.AbstractScaleOutFederation;
import com.bigdata.service.DataService;
import com.bigdata.service.DataServiceCallable;
import com.bigdata.service.Session;
import com.bigdata.service.proxy.ClientAsynchronousIterator;
import com.bigdata.sparse.SparseRowStore;
import com.bigdata.striterator.IKeyOrder;
import java.util.Iterator;
import java.util.UUID;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import org.apache.log4j.Logger;

public class JoinTaskFactoryTask
extends DataServiceCallable<Future> {
    private static final long serialVersionUID = -2637166803787195001L;
    protected static final transient Logger log = Logger.getLogger(JoinTaskFactoryTask.class);
    final String scaleOutIndexName;
    final IRule rule;
    final IJoinNexusFactory joinNexusFactory;
    final int[] order;
    final int orderIndex;
    final int partitionId;
    final UUID masterUUID;
    final IJoinMaster masterProxy;
    final IAsynchronousIterator<IBindingSet[]> sourceItrProxy;
    final IKeyOrder[] keyOrders;
    final IVariable[][] requiredVars;
    private transient AbstractScaleOutFederation fed;

    public String toString() {
        return this.getClass().getSimpleName() + "{ orderIndex=" + this.orderIndex + ", partitionId=" + this.partitionId + "}";
    }

    public JoinTaskFactoryTask(String scaleOutIndexName, IRule rule, IJoinNexusFactory joinNexusFactory, int[] order, int orderIndex, int partitionId, IJoinMaster masterProxy, UUID masterUUID, IAsynchronousIterator<IBindingSet[]> sourceItrProxy, IKeyOrder[] keyOrders, IVariable[][] requiredVars) {
        if (scaleOutIndexName == null) {
            throw new IllegalArgumentException();
        }
        if (rule == null) {
            throw new IllegalArgumentException();
        }
        int tailCount = rule.getTailCount();
        if (joinNexusFactory == null) {
            throw new IllegalArgumentException();
        }
        if (order == null) {
            throw new IllegalArgumentException();
        }
        if (order.length != tailCount) {
            throw new IllegalArgumentException();
        }
        if (orderIndex < 0 || orderIndex >= tailCount) {
            throw new IllegalArgumentException();
        }
        if (partitionId < 0) {
            throw new IllegalArgumentException();
        }
        if (masterProxy == null) {
            throw new IllegalArgumentException();
        }
        if (masterUUID == null) {
            throw new IllegalArgumentException();
        }
        if (sourceItrProxy == null) {
            throw new IllegalArgumentException();
        }
        if (keyOrders == null || keyOrders.length != order.length) {
            throw new IllegalArgumentException();
        }
        if (requiredVars == null) {
            throw new IllegalArgumentException();
        }
        this.scaleOutIndexName = scaleOutIndexName;
        this.rule = rule;
        this.joinNexusFactory = joinNexusFactory;
        this.order = order;
        this.orderIndex = orderIndex;
        this.partitionId = partitionId;
        this.masterProxy = masterProxy;
        this.masterUUID = masterUUID;
        this.sourceItrProxy = sourceItrProxy;
        this.keyOrders = keyOrders;
        this.requiredVars = requiredVars;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Future call() throws Exception {
        Future<Void> joinTaskFuture;
        Session session;
        this.fed = (AbstractScaleOutFederation)this.getFederation();
        if (this.sourceItrProxy instanceof ClientAsynchronousIterator) {
            ((ClientAsynchronousIterator)this.sourceItrProxy).start(this.fed.getExecutorService());
        }
        String namespace = JoinTaskFactoryTask.getJoinTaskNamespace(this.masterUUID, this.orderIndex, this.partitionId);
        Session session2 = session = this.getDataService().getSession();
        synchronized (session2) {
            DistributedJoinTask joinTask = (DistributedJoinTask)session.get(namespace);
            if (joinTask != null) {
                if (joinTask.addSource(this.sourceItrProxy)) {
                    joinTaskFuture = joinTask.futureProxy;
                } else {
                    joinTask = this.newJoinTask();
                    session.put(namespace, joinTask);
                    joinTaskFuture = this.submit(joinTask);
                }
            } else {
                joinTask = this.newJoinTask();
                session.put(namespace, joinTask);
                joinTaskFuture = this.submit(joinTask);
            }
        }
        return joinTaskFuture;
    }

    protected DistributedJoinTask newJoinTask() {
        DelegateIndexManager indexManager = new DelegateIndexManager(this.getDataService());
        DistributedJoinTask task = new DistributedJoinTask(this.rule, this.joinNexusFactory.newInstance(indexManager), this.order, this.orderIndex, this.partitionId, this.fed, this.masterProxy, this.masterUUID, this.sourceItrProxy, this.keyOrders, this.getDataService(), this.requiredVars);
        return task;
    }

    protected Future<Void> submit(DistributedJoinTask task) {
        if (log.isDebugEnabled()) {
            log.debug("Submitting new JoinTask: orderIndex=" + this.orderIndex + ", partitionId=" + this.partitionId + ", indexName=" + this.scaleOutIndexName);
        }
        Future<Void> joinTaskFuture = this.getFederation().getExecutorService().submit(task);
        if (this.fed.isDistributed()) {
            joinTaskFuture = ((AbstractDistributedFederation)this.fed).getProxy(joinTaskFuture);
        }
        task.futureProxy = joinTaskFuture;
        return joinTaskFuture;
    }

    public static String getJoinTaskNamespace(UUID masterUUID, int orderIndex, int partitionId) {
        return masterUUID + "/" + orderIndex + "/" + partitionId;
    }

    static class DelegateIndexManager
    implements IIndexManager {
        private final DataService dataService;

        public DelegateIndexManager(DataService dataService) {
            if (dataService == null) {
                throw new IllegalArgumentException();
            }
            this.dataService = dataService;
        }

        @Override
        public IIndex getIndex(String name, long timestamp) {
            return this.dataService.getResourceManager().getIndex(name, timestamp);
        }

        @Override
        public void dropIndex(String name) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void registerIndex(IndexMetadata indexMetadata) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void destroy() {
            throw new UnsupportedOperationException();
        }

        @Override
        public ExecutorService getExecutorService() {
            return this.dataService.getFederation().getExecutorService();
        }

        @Override
        public BigdataFileSystem getGlobalFileSystem() {
            return this.dataService.getFederation().getGlobalFileSystem();
        }

        @Override
        public SparseRowStore getGlobalRowStore() {
            return this.dataService.getFederation().getGlobalRowStore();
        }

        @Override
        public SparseRowStore getGlobalRowStore(long timestamp) {
            return this.dataService.getFederation().getGlobalRowStore(timestamp);
        }

        @Override
        public long getLastCommitTime() {
            return this.dataService.getFederation().getLastCommitTime();
        }

        @Override
        public IResourceLocator getResourceLocator() {
            return this.dataService.getFederation().getResourceLocator();
        }

        @Override
        public IResourceLockService getResourceLockService() {
            return this.dataService.getFederation().getResourceLockService();
        }

        @Override
        public TemporaryStore getTempStore() {
            return this.dataService.getFederation().getTempStore();
        }

        @Override
        public ScheduledFuture<?> addScheduledTask(Runnable task, long initialDelay, long delay, TimeUnit unit) {
            return this.dataService.getFederation().addScheduledTask(task, initialDelay, delay, unit);
        }

        @Override
        public boolean getCollectPlatformStatistics() {
            return this.dataService.getFederation().getCollectPlatformStatistics();
        }

        @Override
        public boolean getCollectQueueStatistics() {
            return this.dataService.getFederation().getCollectQueueStatistics();
        }

        @Override
        public int getHttpdPort() {
            return this.dataService.getFederation().getHttpdPort();
        }

        @Override
        public CounterSet getCounters() {
            return this.dataService.getFederation().getCounters();
        }

        @Override
        public Iterator<String> indexNameScan(String prefix, long timestamp) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean isGroupCommit() {
            return true;
        }
    }
}

