/*
 * Decompiled with CFR 0.152.
 */
package com.bigdata.relation.rule.eval.pipeline;

import com.bigdata.bop.IBindingSet;
import com.bigdata.mdi.PartitionLocator;
import com.bigdata.relation.accesspath.BlockingBuffer;
import com.bigdata.relation.accesspath.UnsynchronizedArrayBuffer;
import com.bigdata.relation.rule.eval.IJoinNexus;
import com.bigdata.relation.rule.eval.pipeline.JoinTask;
import com.bigdata.service.IBigdataFederation;
import java.util.concurrent.Future;
import org.apache.log4j.Logger;

public class JoinTaskSink {
    protected static final Logger log = Logger.getLogger(JoinTaskSink.class);
    protected static final boolean INFO = log.isInfoEnabled();
    protected static final boolean DEBUG = log.isDebugEnabled();
    private Future future;
    final int sinkOrderIndex;
    final PartitionLocator locator;
    final UnsynchronizedArrayBuffer<IBindingSet> unsyncBuffer;
    final BlockingBuffer<IBindingSet[]> blockingBuffer;

    public Future getFuture() {
        if (this.future == null) {
            throw new IllegalStateException();
        }
        return this.future;
    }

    protected void setFuture(Future f) {
        if (this.future != null) {
            throw new IllegalStateException();
        }
        this.future = f;
        if (DEBUG) {
            log.debug("sinkOrderIndex=" + this.sinkOrderIndex + ", sinkPartitionId=" + this.locator.getPartitionId());
        }
    }

    public String toString() {
        return "JoinSinkTask{ sinkOrderIndex=" + this.sinkOrderIndex + ", sinkPartitionId=" + this.locator.getPartitionId() + "}";
    }

    public JoinTaskSink(IBigdataFederation fed, PartitionLocator locator, JoinTask sourceJoinTask) {
        if (fed == null) {
            throw new IllegalArgumentException();
        }
        if (locator == null) {
            throw new IllegalArgumentException();
        }
        if (sourceJoinTask == null) {
            throw new IllegalArgumentException();
        }
        this.locator = locator;
        IJoinNexus joinNexus = sourceJoinTask.joinNexus;
        this.sinkOrderIndex = sourceJoinTask.orderIndex + 1;
        this.blockingBuffer = new BlockingBuffer(joinNexus.getChunkOfChunksCapacity());
        this.unsyncBuffer = new UnsynchronizedArrayBuffer<IBindingSet>(this.blockingBuffer, IBindingSet.class, joinNexus.getChunkCapacity());
        this.future = null;
    }
}

