/*
 * Decompiled with CFR 0.152.
 */
package com.bigdata.resources;

import com.bigdata.btree.BTree;
import com.bigdata.btree.BTreeCounters;
import com.bigdata.btree.IndexMetadata;
import com.bigdata.journal.AbstractJournal;
import com.bigdata.mdi.IResourceMetadata;
import com.bigdata.mdi.LocalPartitionMetadata;
import com.bigdata.rawstore.IRawStore;
import com.bigdata.resources.OverflowActionEnum;
import com.bigdata.resources.ResourceManager;
import java.lang.ref.SoftReference;
import java.util.concurrent.atomic.AtomicReference;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.log4j.Logger;

class BTreeMetadata {
    protected static final Logger log = Logger.getLogger(BTreeMetadata.class);
    protected final ResourceManager resourceManager;
    public final long commitTime;
    public final String name;
    private volatile SoftReference<BTree> ref;
    public final IndexMetadata indexMetadata;
    public final LocalPartitionMetadata pmd;
    public final int sourceCount;
    public final int sourceJournalCount;
    public final int sourceSegmentCount;
    public final long sumSegBytes;
    private final int A = 3;
    private final int B = 1;
    public final double buildPriority;
    public final double mergePriority;
    public final boolean mandatoryMerge;
    public final boolean compactView;
    public final long entryCount;
    public final BTreeCounters btreeCounters;
    public final double percentHeadSplits;
    public final double percentTailSplits;
    final ReentrantLock lock = new ReentrantLock();
    private final AtomicReference<OverflowActionEnum> actionRef = new AtomicReference();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final BTree getBTree() {
        BTree btree;
        BTree bTree = btree = this.ref == null ? null : this.ref.get();
        if (btree == null) {
            BTreeMetadata bTreeMetadata = this;
            synchronized (bTreeMetadata) {
                btree = this.ref == null ? null : this.ref.get();
                AbstractJournal store = this.resourceManager.getJournal(this.commitTime);
                btree = (BTree)this.resourceManager.getIndexOnStore(this.name, this.commitTime, store);
                if (btree == null) {
                    throw new IllegalArgumentException();
                }
                this.ref = new SoftReference<BTree>(btree);
            }
        }
        return btree;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearRef() {
        BTreeMetadata bTreeMetadata = this;
        synchronized (bTreeMetadata) {
            if (this.ref != null) {
                this.ref.clear();
            }
        }
    }

    public OverflowActionEnum getAction() {
        return this.actionRef.get();
    }

    public void setAction(OverflowActionEnum action) {
        if (action == null) {
            throw new IllegalArgumentException();
        }
        if (!this.lock.isHeldByCurrentThread()) {
            throw new IllegalMonitorStateException();
        }
        if (this.actionRef.get() != null) {
            throw new IllegalStateException("Already set: " + (Object)((Object)this.actionRef.get()) + ", given=" + (Object)((Object)action));
        }
        this.actionRef.set(action);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void clearCopyAction() {
        this.lock.lock();
        try {
            if (this.actionRef.get().equals((Object)OverflowActionEnum.Copy)) {
                this.actionRef.set(null);
            }
        }
        finally {
            this.lock.unlock();
        }
    }

    public BTreeMetadata(ResourceManager resourceManager, long commitTime, String name, BTreeCounters btreeCounters) {
        if (resourceManager == null) {
            throw new IllegalArgumentException();
        }
        if (name == null) {
            throw new IllegalArgumentException();
        }
        if (btreeCounters == null) {
            throw new IllegalArgumentException();
        }
        this.resourceManager = resourceManager;
        this.commitTime = commitTime;
        this.name = name;
        BTree btree = this.getBTree();
        this.indexMetadata = btree.getIndexMetadata();
        this.pmd = this.indexMetadata.getPartitionMetadata();
        if (this.pmd == null) {
            log.warn("Not an index partition: " + name);
        }
        int sourceCount = 0;
        int sourceJournalCount = 0;
        int sourceSegmentCount = 0;
        long sumSegBytes = 0L;
        boolean secondSourceIsSeg = false;
        if (this.pmd != null) {
            for (IResourceMetadata x : this.pmd.getResources()) {
                ++sourceCount;
                if (x.isJournal()) {
                    ++sourceJournalCount;
                    continue;
                }
                ++sourceSegmentCount;
                IRawStore store = resourceManager.openStore(x.getUUID());
                sumSegBytes += store.size();
                if (sourceCount != 2) continue;
                secondSourceIsSeg = true;
            }
        }
        this.sourceCount = sourceCount;
        this.sourceJournalCount = sourceJournalCount;
        this.sourceSegmentCount = sourceSegmentCount;
        this.sumSegBytes = sumSegBytes;
        boolean bl = this.compactView = sourceCount == 2 && secondSourceIsSeg;
        if (sourceJournalCount + sourceSegmentCount < 2) {
            this.mergePriority = 0.0;
            this.buildPriority = 1.0;
        } else {
            this.mergePriority = (sourceJournalCount - 1) * 3 + sourceSegmentCount * 1;
            this.buildPriority = 1.0 / this.mergePriority;
        }
        this.mandatoryMerge = sourceJournalCount >= resourceManager.maximumJournalsPerView || sourceSegmentCount >= resourceManager.maximumSegmentsPerView;
        this.entryCount = btree.getEntryCount();
        this.btreeCounters = btreeCounters;
        this.percentHeadSplits = (double)btreeCounters.headSplit / ((double)btreeCounters.leavesSplit + 1.0);
        this.percentTailSplits = (double)btreeCounters.tailSplit / ((double)btreeCounters.leavesSplit + 1.0);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("name=" + this.name);
        sb.append(", action=" + (Object)((Object)this.actionRef.get()));
        sb.append(", entryCount=" + this.entryCount);
        sb.append(", sumSegBytes=" + this.sumSegBytes);
        sb.append(", mergePriority=" + this.mergePriority);
        sb.append(", manditoryMerge=" + this.mandatoryMerge);
        sb.append(", sourceCounts={all=" + this.sourceCount + ",journals=" + this.sourceJournalCount + ",segments=" + this.sourceSegmentCount + "}");
        sb.append(", #leafSplit=" + this.btreeCounters.leavesSplit);
        sb.append(", #headSplit=" + this.btreeCounters.headSplit);
        sb.append(", #tailSplit=" + this.btreeCounters.tailSplit);
        sb.append(", percentHeadSplits=" + this.percentHeadSplits);
        sb.append(", percentTailSplits=" + this.percentTailSplits);
        this.toString(sb);
        return sb.toString();
    }

    protected void toString(StringBuilder sb) {
    }
}

