/*
 * Decompiled with CFR 0.152.
 */
package com.bigdata.resources;

import com.bigdata.btree.BTree;
import com.bigdata.btree.ILocalBTreeView;
import com.bigdata.btree.IndexMetadata;
import com.bigdata.btree.IndexSegmentStore;
import com.bigdata.journal.IConcurrencyManager;
import com.bigdata.journal.TimestampUtility;
import com.bigdata.mdi.IResourceMetadata;
import com.bigdata.mdi.LocalPartitionMetadata;
import com.bigdata.mdi.SegmentMetadata;
import com.bigdata.resources.AbstractAtomicUpdateTask;
import com.bigdata.resources.AbstractPrepareTask;
import com.bigdata.resources.BuildResult;
import com.bigdata.resources.BuildViewMetadata;
import com.bigdata.resources.OverflowActionEnum;
import com.bigdata.resources.OverflowSubtaskEnum;
import com.bigdata.resources.ResourceManager;
import com.bigdata.resources.ViewMetadata;
import com.bigdata.service.Event;
import com.bigdata.service.EventResource;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.Map;
import java.util.UUID;

public class IncrementalBuildTask
extends AbstractPrepareTask<BuildResult> {
    private final ViewMetadata vmd;

    public IncrementalBuildTask(ViewMetadata vmd) {
        super(vmd.resourceManager, TimestampUtility.asHistoricalRead(vmd.commitTime), vmd.name);
        this.vmd = vmd;
    }

    @Override
    protected void clearRefs() {
        this.vmd.clearRef();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected BuildResult doTask() throws Exception {
        Event e = new Event(this.resourceManager.getFederation(), new EventResource(this.vmd.indexMetadata), (Object)OverflowActionEnum.Build, this.vmd.getParams()).start();
        BuildResult buildResult = null;
        try {
            if (this.resourceManager.isOverflowAllowed()) {
                throw new IllegalStateException();
            }
            try {
                BuildViewMetadata buildViewMetadata = new BuildViewMetadata(this.vmd.getView(), this.resourceManager.maximumBuildSegmentBytes, e);
                e.addDetails(buildViewMetadata.getParams());
                if (INFO) {
                    log.info("acceptedView: " + buildViewMetadata);
                }
                buildResult = this.resourceManager.buildIndexSegment(this.vmd.name, buildViewMetadata.acceptedView, buildViewMetadata.compactingMerge, this.vmd.commitTime, null, null, e);
                e.addDetails(buildResult.getParams());
                if (buildResult.sourceCount != buildViewMetadata.naccepted) {
                    throw new AssertionError((Object)("Build result has " + buildResult.sourceCount + ", but expected " + buildViewMetadata.naccepted + " : acceptedView=" + buildViewMetadata + ", buildResult=" + buildResult));
                }
                if (INFO) {
                    log.info("buildResult=" + buildResult);
                }
                IndexSegmentStore segStore = (IndexSegmentStore)this.resourceManager.openStore(buildResult.segmentMetadata.getUUID());
                assert (segStore != null);
                if (INFO) {
                    log.info("indexSegmentStore=" + segStore.loadIndexSegment());
                }
            }
            finally {
                this.clearRefs();
            }
            if (!buildResult.compactingMerge || buildResult.builder.getCheckpoint().length >= this.resourceManager.nominalShardSize) {
                // empty if block
            }
            try {
                this.concurrencyManager.submit(new AtomicUpdateIncrementalBuildTask(this.resourceManager, this.concurrencyManager, this.vmd.name, this.vmd.indexMetadata.getIndexUUID(), buildResult, e)).get();
            }
            catch (Throwable t) {
                this.resourceManager.retentionSetRemove(buildResult.segmentMetadata.getUUID());
                this.resourceManager.deleteResource(buildResult.segmentMetadata.getUUID(), false);
                throw new Exception(t);
            }
            BuildResult buildResult2 = buildResult;
            return buildResult2;
        }
        finally {
            if (buildResult != null) {
                this.resourceManager.retentionSetRemove(buildResult.segmentMetadata.getUUID());
            }
            e.end();
        }
    }

    protected static class AtomicUpdateIncrementalBuildTask
    extends AbstractAtomicUpdateTask<IResourceMetadata[]> {
        protected final UUID indexUUID;
        protected final BuildResult buildResult;
        private final Event parentEvent;

        public AtomicUpdateIncrementalBuildTask(ResourceManager resourceManager, IConcurrencyManager concurrencyManager, String resource, UUID indexUUID, BuildResult buildResult, Event parentEvent) {
            super(resourceManager, 0L, resource);
            if (indexUUID == null) {
                throw new IllegalArgumentException();
            }
            if (buildResult == null) {
                throw new IllegalArgumentException();
            }
            if (!resource.equals(buildResult.name)) {
                throw new IllegalArgumentException();
            }
            if (parentEvent == null) {
                throw new IllegalArgumentException();
            }
            this.indexUUID = indexUUID;
            this.buildResult = buildResult;
            this.parentEvent = parentEvent;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        protected IResourceMetadata[] doTask() throws Exception {
            LinkedList<Object> newView = new LinkedList<Object>();
            Map<String, Object> v = this.buildResult.getParams();
            v.put("summary", (Object)((Object)OverflowActionEnum.Build) + "(" + this.buildResult.name + ")");
            Event updateEvent = this.parentEvent.newSubEvent((Object)OverflowSubtaskEnum.AtomicUpdate).start();
            try {
                int startIndex;
                IndexMetadata indexMetadata;
                LocalPartitionMetadata currentpmd;
                if (this.resourceManager.isOverflowAllowed()) {
                    throw new IllegalStateException();
                }
                SegmentMetadata segmentMetadata = this.buildResult.segmentMetadata;
                if (INFO) {
                    log.info(this.buildResult.toString());
                }
                ILocalBTreeView view = this.getIndex(this.getOnlyResource());
                BTree btree = view.getMutableBTree();
                this.assertSameIndex(this.indexUUID, btree);
                if (view instanceof BTree) {
                    throw new RuntimeException("View is only a B+Tree: name=" + this.buildResult.name + ", pmd=" + view.getIndexMetadata().getPartitionMetadata());
                }
                if (INFO) {
                    log.info("src=" + this.getOnlyResource() + ", counter=" + view.getCounter().get() + ", checkpoint=" + btree.getCheckpoint());
                }
                if ((currentpmd = (indexMetadata = btree.getIndexMetadata().clone()).getPartitionMetadata()) == null) {
                    throw new IllegalStateException("Not an index partition: " + this.getOnlyResource());
                }
                Object[] currentResources = currentpmd.getResources();
                if (currentResources.length < 2) {
                    throw new IllegalStateException("Expecting at least 2 resources in the view: " + Arrays.toString(currentResources));
                }
                if (!currentResources[0].getUUID().equals(this.getJournal().getRootBlockView().getUUID())) {
                    throw new IllegalStateException("Expecting live journal to be the first resource: " + Arrays.toString(currentResources));
                }
                if (!currentResources[1].isJournal()) {
                    throw new IllegalStateException("Expecting live journal to be the first resource: " + Arrays.toString(currentResources));
                }
                newView.add(this.getJournal().getResourceMetadata());
                newView.add(segmentMetadata);
                for (int i = startIndex = 1 + this.buildResult.sourceCount; i < currentResources.length; ++i) {
                    newView.add(currentResources[i]);
                }
                Object[] newResources = newView.toArray(new IResourceMetadata[0]);
                indexMetadata.setPartitionMetadata(new LocalPartitionMetadata(currentpmd.getPartitionId(), currentpmd.getSourcePartitionId(), currentpmd.getLeftSeparatorKey(), currentpmd.getRightSeparatorKey(), (IResourceMetadata[])newResources, currentpmd.getIndexPartitionCause()));
                btree.setIndexMetadata(indexMetadata);
                if (INFO) {
                    log.info("Updated view: name=" + this.getOnlyResource() + ", pmd=" + indexMetadata.getPartitionMetadata() + AtomicUpdateIncrementalBuildTask.toString("oldResources", currentResources) + AtomicUpdateIncrementalBuildTask.toString("newResources", newResources));
                }
                assert (btree.needsCheckpoint());
                this.resourceManager.overflowCounters.indexPartitionBuildCounter.incrementAndGet();
                updateEvent.addDetail("newView", ((Object)newView).toString());
                Object[] objectArray = newResources;
                return objectArray;
            }
            finally {
                updateEvent.end();
            }
        }
    }
}

