/*
 * Decompiled with CFR 0.152.
 */
package com.bigdata.resources;

import com.bigdata.btree.BTree;
import com.bigdata.btree.IIndex;
import com.bigdata.btree.ILocalBTreeView;
import com.bigdata.btree.IndexMetadata;
import com.bigdata.btree.proc.IIndexProcedure;
import com.bigdata.journal.AbstractTask;
import com.bigdata.journal.NoSuchIndexException;
import com.bigdata.journal.TimestampUtility;
import com.bigdata.mdi.IResourceMetadata;
import com.bigdata.mdi.IndexPartitionCause;
import com.bigdata.mdi.LocalPartitionMetadata;
import com.bigdata.mdi.PartitionLocator;
import com.bigdata.mdi.SegmentMetadata;
import com.bigdata.resources.AbstractAtomicUpdateTask;
import com.bigdata.resources.AbstractPrepareTask;
import com.bigdata.resources.AbstractResourceManagerTask;
import com.bigdata.resources.BuildResult;
import com.bigdata.resources.MoveResult;
import com.bigdata.resources.OverflowActionEnum;
import com.bigdata.resources.OverflowSubtaskEnum;
import com.bigdata.resources.ResourceManager;
import com.bigdata.resources.StaleLocatorReason;
import com.bigdata.resources.ViewMetadata;
import com.bigdata.service.DataService;
import com.bigdata.service.DataServiceCallable;
import com.bigdata.service.Event;
import com.bigdata.service.EventResource;
import com.bigdata.service.IDataService;
import com.bigdata.service.ResourceService;
import java.io.File;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ExecutionException;

public class MoveTask
extends AbstractPrepareTask<MoveResult> {
    private final ViewMetadata vmd;
    private final UUID targetDataServiceUUID;
    final int newPartitionId;
    final String targetIndexName;
    private final String summary;
    private final Event e;

    public MoveTask(ViewMetadata vmd, UUID targetDataServiceUUID) {
        super(vmd.resourceManager, TimestampUtility.asHistoricalRead(vmd.commitTime), vmd.name);
        if (targetDataServiceUUID == null) {
            throw new IllegalArgumentException();
        }
        if (this.resourceManager.getDataServiceUUID().equals(targetDataServiceUUID)) {
            throw new IllegalArgumentException("Same data service: " + targetDataServiceUUID);
        }
        this.vmd = vmd;
        this.targetDataServiceUUID = targetDataServiceUUID;
        this.newPartitionId = this.resourceManager.nextPartitionId(vmd.indexMetadata.getName());
        this.targetIndexName = DataService.getIndexPartitionName(vmd.indexMetadata.getName(), this.newPartitionId);
        this.summary = (Object)((Object)OverflowActionEnum.Move) + "(" + vmd.name + "->" + this.targetIndexName + ")";
        Map<String, Object> params = vmd.getParams();
        params.put("summary", this.summary);
        this.e = new Event(this.resourceManager.getFederation(), new EventResource(vmd.indexMetadata), (Object)OverflowActionEnum.Move, params);
    }

    @Override
    protected void clearRefs() {
        this.vmd.clearRef();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected MoveResult doTask() throws Exception {
        this.e.start();
        BuildResult historicalWritesBuildResult = null;
        try {
            if (this.resourceManager.isOverflowAllowed()) {
                throw new IllegalStateException();
            }
            try {
                ILocalBTreeView src = this.getIndex(this.vmd.name);
                historicalWritesBuildResult = this.resourceManager.buildIndexSegment(this.vmd.name, src, true, this.vmd.commitTime, null, null, this.e);
                if (INFO) {
                    log.info("Generated compact index segment from historical view: " + historicalWritesBuildResult);
                }
            }
            finally {
                this.clearRefs();
            }
            MoveResult moveResult = MoveTask.doAtomicUpdate(this.resourceManager, this.vmd.name, historicalWritesBuildResult, this.targetDataServiceUUID, this.newPartitionId, this.e);
            if (INFO) {
                log.info("Successfully moved index partition: " + this.summary);
            }
            MoveResult moveResult2 = moveResult;
            return moveResult2;
        }
        finally {
            if (historicalWritesBuildResult != null) {
                this.resourceManager.retentionSetRemove(historicalWritesBuildResult.segmentMetadata.getUUID());
                this.resourceManager.deleteResource(historicalWritesBuildResult.segmentMetadata.getUUID(), false);
            }
            this.e.end();
        }
    }

    protected static MoveResult doAtomicUpdate(ResourceManager resourceManager, String sourceIndexName, BuildResult historicalWritesBuildResult, UUID targetDataServiceUUID, int targetIndexPartitionId, Event parentEvent) throws InterruptedException, ExecutionException {
        return resourceManager.getConcurrencyManager().submit(new AtomicUpdate(resourceManager, sourceIndexName, historicalWritesBuildResult, targetDataServiceUUID, targetIndexPartitionId, parentEvent)).get();
    }

    private static class InnerReceiveIndexPartitionTask
    extends AbstractTask<Void> {
        private final ResourceManager resourceManager;
        private final String scaleOutIndexName;
        private final String sourceIndexName;
        private final String targetIndexName;
        private final IndexMetadata sourceIndexMetadata;
        private final UUID sourceDataServiceUUID;
        private final UUID targetDataServiceUUID;
        private final int sourceIndexPartitionId;
        private final int targetIndexPartitionId;
        private final SegmentMetadata sourceHistorySegmentMetadata;
        private final SegmentMetadata sourceBufferedWritesSegmentMetadata;
        private final Event parentEvent;
        private final String summary;
        final InetSocketAddress addr;

        InnerReceiveIndexPartitionTask(ResourceManager resourceManager, String targetIndexName, IndexMetadata sourceIndexMetadata, UUID sourceDataServiceUUID, int targetIndexPartitionId, SegmentMetadata historyIndexSegmentMetadata, SegmentMetadata bufferedWritesIndexSegmentMetadata, InetSocketAddress addr) {
            super(resourceManager.getConcurrencyManager(), 0L, targetIndexName);
            if (sourceIndexMetadata == null) {
                throw new IllegalArgumentException();
            }
            if (sourceDataServiceUUID == null) {
                throw new IllegalArgumentException();
            }
            if (historyIndexSegmentMetadata == null) {
                throw new IllegalArgumentException();
            }
            if (bufferedWritesIndexSegmentMetadata == null) {
                throw new IllegalArgumentException();
            }
            if (addr == null) {
                throw new IllegalArgumentException();
            }
            this.resourceManager = resourceManager;
            this.scaleOutIndexName = sourceIndexMetadata.getName();
            this.sourceIndexPartitionId = sourceIndexMetadata.getPartitionMetadata().getPartitionId();
            this.sourceIndexName = DataService.getIndexPartitionName(this.scaleOutIndexName, this.sourceIndexPartitionId);
            this.targetIndexName = targetIndexName;
            this.sourceIndexMetadata = sourceIndexMetadata;
            this.sourceDataServiceUUID = sourceDataServiceUUID;
            this.targetDataServiceUUID = resourceManager.getDataServiceUUID();
            this.targetIndexPartitionId = targetIndexPartitionId;
            this.sourceHistorySegmentMetadata = historyIndexSegmentMetadata;
            this.sourceBufferedWritesSegmentMetadata = bufferedWritesIndexSegmentMetadata;
            this.addr = addr;
            this.summary = (Object)((Object)OverflowActionEnum.Move) + "(" + this.sourceIndexName + "->" + targetIndexName + ")";
            this.parentEvent = new Event(resourceManager.getFederation(), new EventResource(sourceIndexMetadata.getName(), this.sourceIndexPartitionId), (Object)OverflowActionEnum.Move);
            this.parentEvent.addDetail("summary", this.summary);
        }

        @Override
        public Void doTask() throws Exception {
            SegmentMetadata targetHistorySegmentMetadata = null;
            SegmentMetadata targetBufferedWritesSegmentMetadata = null;
            this.parentEvent.start();
            try {
                targetHistorySegmentMetadata = this.receiveIndexSegmentStore(this.sourceHistorySegmentMetadata);
                targetBufferedWritesSegmentMetadata = this.receiveIndexSegmentStore(this.sourceBufferedWritesSegmentMetadata);
                MoveResult moveResult = this.registerIndexPartition(targetHistorySegmentMetadata, targetBufferedWritesSegmentMetadata);
                this.updateMetadataIndex(moveResult);
                Void void_ = null;
                return void_;
            }
            catch (Throwable t) {
                if (targetHistorySegmentMetadata != null) {
                    try {
                        this.resourceManager.retentionSetRemove(targetHistorySegmentMetadata.getUUID());
                        this.resourceManager.deleteResource(targetHistorySegmentMetadata.getUUID(), false);
                    }
                    catch (Throwable t2) {
                        // empty catch block
                    }
                }
                if (targetBufferedWritesSegmentMetadata != null) {
                    try {
                        this.resourceManager.retentionSetRemove(targetBufferedWritesSegmentMetadata.getUUID());
                        this.resourceManager.deleteResource(targetBufferedWritesSegmentMetadata.getUUID(), false);
                    }
                    catch (Throwable t2) {
                        // empty catch block
                    }
                }
                if (t instanceof Exception) {
                    throw (Exception)t;
                }
                throw new Exception(t);
            }
            finally {
                this.parentEvent.end();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected SegmentMetadata receiveIndexSegmentStore(SegmentMetadata sourceSegmentMetadata) throws Exception {
            Event e = this.parentEvent.newSubEvent((Object)OverflowSubtaskEnum.ReceiveIndexSegment, sourceSegmentMetadata.getParams()).start();
            try {
                if (sourceSegmentMetadata == null) {
                    throw new IllegalArgumentException();
                }
                long begin = System.currentTimeMillis();
                File file = this.resourceManager.getIndexSegmentFile(this.scaleOutIndexName, this.sourceIndexMetadata.getIndexUUID(), this.targetIndexPartitionId);
                file.getParentFile().mkdirs();
                SegmentMetadata targetSegmentMetadata = new SegmentMetadata(file, sourceSegmentMetadata.getUUID(), sourceSegmentMetadata.getCreateTime());
                try {
                    new ResourceService.ReadResourceTask(this.addr, sourceSegmentMetadata.getUUID(), file).call();
                }
                catch (Throwable t) {
                    try {
                        file.delete();
                    }
                    catch (Throwable t2) {
                        // empty catch block
                    }
                    if (t instanceof Exception) {
                        throw (Exception)t;
                    }
                    throw new Exception(t);
                }
                this.resourceManager.retentionSetAdd(sourceSegmentMetadata.getUUID());
                this.resourceManager.addResource(sourceSegmentMetadata, file);
                if (AbstractResourceManagerTask.INFO) {
                    long elapsed = System.currentTimeMillis() - begin;
                    log.info("Received index segment: " + sourceSegmentMetadata + " in " + elapsed + "ms");
                }
                SegmentMetadata segmentMetadata = targetSegmentMetadata;
                return segmentMetadata;
            }
            finally {
                e.end();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected MoveResult registerIndexPartition(SegmentMetadata historySegmentMetadata, SegmentMetadata bufferedWritesSegmentMetadata) {
            Event e = this.parentEvent.newSubEvent((Object)OverflowSubtaskEnum.RegisterIndex).addDetail("targetIndexName", this.targetIndexName).start();
            try {
                IndexMetadata newMetadata = this.sourceIndexMetadata.clone();
                LocalPartitionMetadata oldpmd = newMetadata.getPartitionMetadata();
                newMetadata.setPartitionMetadata(new LocalPartitionMetadata(this.targetIndexPartitionId, -1, oldpmd.getLeftSeparatorKey(), oldpmd.getRightSeparatorKey(), new IResourceMetadata[]{this.getJournal().getResourceMetadata(), bufferedWritesSegmentMetadata, historySegmentMetadata}, IndexPartitionCause.move(this.resourceManager)));
                BTree btree = BTree.create(this.getJournal(), newMetadata);
                this.registerIndex(this.targetIndexName, btree);
                if (AbstractResourceManagerTask.INFO) {
                    log.info("Registered new index partition on target data service: targetIndexName=" + this.targetIndexName);
                }
                LocalPartitionMetadata pmd = this.sourceIndexMetadata.getPartitionMetadata();
                PartitionLocator oldLocator = new PartitionLocator(this.sourceIndexPartitionId, this.sourceDataServiceUUID, pmd.getLeftSeparatorKey(), pmd.getRightSeparatorKey());
                PartitionLocator newLocator = new PartitionLocator(this.targetIndexPartitionId, this.targetDataServiceUUID, pmd.getLeftSeparatorKey(), pmd.getRightSeparatorKey());
                MoveResult moveResult = new MoveResult(this.sourceIndexName, this.sourceIndexMetadata, this.targetDataServiceUUID, this.targetIndexPartitionId, oldLocator, newLocator);
                return moveResult;
            }
            finally {
                e.end();
            }
        }

        protected void updateMetadataIndex(MoveResult moveResult) throws IOException, InterruptedException, ExecutionException {
            if (AbstractResourceManagerTask.INFO) {
                log.info("Updating metadata index: name=" + this.scaleOutIndexName + ", oldLocator=" + moveResult.oldLocator + ", newLocator=" + moveResult.newLocator);
            }
            this.resourceManager.getFederation().getMetadataService().moveIndexPartition(this.scaleOutIndexName, moveResult.oldLocator, moveResult.newLocator);
        }
    }

    protected static class ReceiveIndexPartitionTask
    extends DataServiceCallable<Void> {
        private static final long serialVersionUID = -4277343552510590741L;
        private final IndexMetadata sourceIndexMetadata;
        private final UUID sourceDataServiceUUID;
        private final int targetIndexPartitionId;
        private final SegmentMetadata historyIndexSegmentMetadata;
        private final SegmentMetadata bufferedWritesIndexSegmentMetadata;
        private final InetSocketAddress addr;

        ReceiveIndexPartitionTask(IndexMetadata sourceIndexMetadata, UUID sourceDataServiceUUID, int targetIndexPartitionId, SegmentMetadata historyIndexSegmentMetadata, SegmentMetadata bufferedWritesIndexSegmentMetadata, InetSocketAddress addr) {
            this.sourceIndexMetadata = sourceIndexMetadata;
            this.sourceDataServiceUUID = sourceDataServiceUUID;
            this.targetIndexPartitionId = targetIndexPartitionId;
            this.historyIndexSegmentMetadata = historyIndexSegmentMetadata;
            this.bufferedWritesIndexSegmentMetadata = bufferedWritesIndexSegmentMetadata;
            this.addr = addr;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Void call() throws Exception {
            String targetIndexName = DataService.getIndexPartitionName(this.sourceIndexMetadata.getName(), this.targetIndexPartitionId);
            ResourceManager resourceManager = this.getDataService().getResourceManager();
            try {
                this.getDataService().getConcurrencyManager().submit(new InnerReceiveIndexPartitionTask(resourceManager, targetIndexName, this.sourceIndexMetadata, this.sourceDataServiceUUID, this.targetIndexPartitionId, this.historyIndexSegmentMetadata, this.bufferedWritesIndexSegmentMetadata, this.addr)).get();
                resourceManager.overflowCounters.indexPartitionReceiveCounter.incrementAndGet();
                Void void_ = null;
                return void_;
            }
            finally {
                resourceManager.retentionSetRemove(this.historyIndexSegmentMetadata.getUUID());
                resourceManager.retentionSetRemove(this.bufferedWritesIndexSegmentMetadata.getUUID());
            }
        }
    }

    private static class IsIndexRegistered_UsingWriteService
    implements IIndexProcedure<IndexMetadata> {
        private static final long serialVersionUID = -6492979226768348981L;

        private IsIndexRegistered_UsingWriteService() {
        }

        @Override
        public IndexMetadata apply(IIndex ndx) {
            return ndx.getIndexMetadata();
        }

        @Override
        public boolean isReadOnly() {
            return false;
        }
    }

    protected static class AtomicUpdate
    extends AbstractAtomicUpdateTask<MoveResult> {
        private final ResourceManager resourceManager;
        private final String sourceIndexName;
        private final BuildResult historicalWritesBuildResult;
        private final UUID targetDataServiceUUID;
        private final int targetIndexPartitionId;
        private final Event parentEvent;

        protected AtomicUpdate(ResourceManager resourceManager, String sourceIndexName, BuildResult historicalWritesBuildResult, UUID targetDataServiceUUID, int targetIndexPartitionId, Event parentEvent) {
            super(resourceManager, 0L, sourceIndexName);
            if (historicalWritesBuildResult == null) {
                throw new IllegalArgumentException();
            }
            if (targetDataServiceUUID == null) {
                throw new IllegalArgumentException();
            }
            if (parentEvent == null) {
                throw new IllegalArgumentException();
            }
            this.resourceManager = resourceManager;
            this.sourceIndexName = sourceIndexName;
            this.historicalWritesBuildResult = historicalWritesBuildResult;
            this.targetDataServiceUUID = targetDataServiceUUID;
            this.targetIndexPartitionId = targetIndexPartitionId;
            this.parentEvent = parentEvent;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public MoveResult doTask() throws Exception {
            Event e = this.parentEvent.newSubEvent((Object)OverflowSubtaskEnum.AtomicUpdate).start();
            BuildResult bufferedWritesBuildResult = null;
            try {
                BTree src = this.getIndex(this.getOnlyResource()).getMutableBTree();
                IndexMetadata indexMetadata = src.getIndexMetadata();
                String scaleOutIndexName = indexMetadata.getName();
                String targetIndexName = DataService.getIndexPartitionName(scaleOutIndexName, this.targetIndexPartitionId);
                LocalPartitionMetadata pmd = indexMetadata.getPartitionMetadata();
                PartitionLocator oldLocator = new PartitionLocator(pmd.getPartitionId(), this.resourceManager.getDataServiceUUID(), pmd.getLeftSeparatorKey(), pmd.getRightSeparatorKey());
                PartitionLocator newLocator = new PartitionLocator(this.targetIndexPartitionId, this.targetDataServiceUUID, pmd.getLeftSeparatorKey(), pmd.getRightSeparatorKey());
                long sourceCommitTime = src.getLastCommitTime();
                bufferedWritesBuildResult = this.resourceManager.buildIndexSegment(this.sourceIndexName, src, false, sourceCommitTime, null, null, this.parentEvent);
                IDataService targetDataService = this.resourceManager.getFederation().getDataService(this.targetDataServiceUUID);
                if (targetDataService == null) {
                    throw new Exception("No such data service: " + this.targetDataServiceUUID);
                }
                Event receiveIndexPartitionEvent = this.parentEvent.newSubEvent((Object)OverflowSubtaskEnum.ReceiveIndexPartition).start();
                try {
                    targetDataService.submit(new ReceiveIndexPartitionTask(indexMetadata, this.resourceManager.getDataServiceUUID(), this.targetIndexPartitionId, this.historicalWritesBuildResult.segmentMetadata, bufferedWritesBuildResult.segmentMetadata, this.resourceManager.getResourceService().getAddr())).get();
                }
                catch (ExecutionException ex) {
                    this.rollbackMove(ex, scaleOutIndexName, targetIndexName, targetDataService, oldLocator, newLocator);
                }
                catch (InterruptedException ex) {
                    this.rollbackMove(ex, scaleOutIndexName, targetIndexName, targetDataService, oldLocator, newLocator);
                }
                catch (IOException ex) {
                    this.rollbackMove(ex, scaleOutIndexName, targetIndexName, targetDataService, oldLocator, newLocator);
                }
                finally {
                    receiveIndexPartitionEvent.end();
                }
                this.resourceManager.setIndexPartitionGone(this.getOnlyResource(), StaleLocatorReason.Move);
                this.getJournal().dropIndex(this.getOnlyResource());
                this.resourceManager.overflowCounters.indexPartitionMoveCounter.incrementAndGet();
                MoveResult moveResult = new MoveResult(scaleOutIndexName, src.getIndexMetadata(), this.targetDataServiceUUID, this.targetIndexPartitionId, oldLocator, newLocator);
                return moveResult;
            }
            finally {
                if (bufferedWritesBuildResult != null) {
                    this.resourceManager.retentionSetRemove(bufferedWritesBuildResult.segmentMetadata.getUUID());
                    this.resourceManager.deleteResource(bufferedWritesBuildResult.segmentMetadata.getUUID(), false);
                }
                e.end();
            }
        }

        private void rollbackMove(Throwable t, String scaleOutIndexName, String targetIndexName, IDataService targetDataService, PartitionLocator oldLocator, PartitionLocator newLocator) throws Exception {
            try {
                IndexMetadata tmp = targetDataService.submit(0L, targetIndexName, new IsIndexRegistered_UsingWriteService()).get();
                if (tmp == null) {
                    throw new AssertionError((Object)"Not expecting [null] return.");
                }
                log.error("Move successful - ignoring spurious exception: " + t);
                return;
            }
            catch (ExecutionException ex) {
                if (!(ex.getCause() instanceof NoSuchIndexException)) {
                    throw ex;
                }
                try {
                    boolean mdsWasUpdated;
                    PartitionLocator current = this.resourceManager.getFederation().getMetadataService().get(scaleOutIndexName, 0L, oldLocator.getLeftSeparatorKey());
                    boolean bl = mdsWasUpdated = current.getPartitionId() != oldLocator.getPartitionId();
                    if (mdsWasUpdated) {
                        try {
                            this.resourceManager.getFederation().getMetadataService().moveIndexPartition(scaleOutIndexName, newLocator, oldLocator);
                        }
                        catch (Throwable t2) {
                            log.error("Problem writing MDS? ", t2);
                        }
                    }
                }
                catch (Throwable t2) {
                    log.error("Problem reading MDS? ", t2);
                }
                if (t instanceof Exception) {
                    throw (Exception)t;
                }
                throw new RuntimeException(t);
            }
        }
    }
}

