/*
 * Decompiled with CFR 0.152.
 */
package com.bigdata.resources;

import com.bigdata.counters.CounterSet;
import com.bigdata.counters.Instrument;
import java.io.Serializable;
import java.util.concurrent.atomic.AtomicLong;

public class OverflowCounters
implements Serializable {
    private static final long serialVersionUID = -7374339581752061839L;
    public final AtomicLong synchronousOverflowCounter = new AtomicLong(0L);
    public final AtomicLong synchronousOverflowMillis = new AtomicLong(0L);
    public final AtomicLong asynchronousOverflowStartMillis = new AtomicLong(0L);
    public final AtomicLong asynchronousOverflowCounter = new AtomicLong(0L);
    public final AtomicLong asynchronousOverflowMillis = new AtomicLong(0L);
    public final AtomicLong asynchronousOverflowFailedCounter = new AtomicLong(0L);
    public final AtomicLong asynchronousOverflowTaskFailedCounter = new AtomicLong(0L);
    public final AtomicLong asynchronousOverflowTaskCancelledCounter = new AtomicLong(0L);
    public final AtomicLong indexPartitionBuildCounter = new AtomicLong(0L);
    public final AtomicLong indexPartitionMergeCounter = new AtomicLong(0L);
    public final AtomicLong indexPartitionSplitCounter = new AtomicLong(0L);
    public final AtomicLong indexPartitionTailSplitCounter = new AtomicLong(0L);
    public final AtomicLong indexPartitionJoinCounter = new AtomicLong(0L);
    public final AtomicLong indexPartitionMoveCounter = new AtomicLong(0L);
    public final AtomicLong indexPartitionReceiveCounter = new AtomicLong(0L);

    public OverflowCounters clone() {
        OverflowCounters tmp = new OverflowCounters();
        tmp.add(this);
        return tmp;
    }

    public void add(OverflowCounters c) {
        if (c == null) {
            throw new IllegalArgumentException();
        }
        this.synchronousOverflowCounter.addAndGet(c.synchronousOverflowCounter.get());
        this.synchronousOverflowMillis.addAndGet(c.synchronousOverflowMillis.get());
        this.asynchronousOverflowStartMillis.addAndGet(c.asynchronousOverflowStartMillis.get());
        this.asynchronousOverflowCounter.addAndGet(c.asynchronousOverflowCounter.get());
        this.asynchronousOverflowMillis.addAndGet(c.asynchronousOverflowMillis.get());
        this.asynchronousOverflowFailedCounter.addAndGet(c.asynchronousOverflowFailedCounter.get());
        this.asynchronousOverflowTaskFailedCounter.addAndGet(c.asynchronousOverflowTaskFailedCounter.get());
        this.asynchronousOverflowTaskCancelledCounter.addAndGet(c.asynchronousOverflowTaskCancelledCounter.get());
        this.indexPartitionBuildCounter.addAndGet(c.indexPartitionBuildCounter.get());
        this.indexPartitionMergeCounter.addAndGet(c.indexPartitionMergeCounter.get());
        this.indexPartitionSplitCounter.addAndGet(c.indexPartitionSplitCounter.get());
        this.indexPartitionTailSplitCounter.addAndGet(c.indexPartitionTailSplitCounter.get());
        this.indexPartitionJoinCounter.addAndGet(c.indexPartitionJoinCounter.get());
        this.indexPartitionMoveCounter.addAndGet(c.indexPartitionMoveCounter.get());
        this.indexPartitionReceiveCounter.addAndGet(c.indexPartitionReceiveCounter.get());
    }

    public CounterSet getCounters() {
        CounterSet tmp = new CounterSet();
        tmp.addCounter("Synchronous Overflow Millis", new Instrument<Long>(){

            @Override
            public void sample() {
                this.setValue(OverflowCounters.this.synchronousOverflowMillis.get());
            }
        });
        tmp.addCounter("Asynchronous Overflow Count", new Instrument<Long>(){

            @Override
            public void sample() {
                this.setValue(OverflowCounters.this.asynchronousOverflowCounter.get());
            }
        });
        tmp.addCounter("Asynchronous Overflow Failed Count", new Instrument<Long>(){

            @Override
            public void sample() {
                this.setValue(OverflowCounters.this.asynchronousOverflowFailedCounter.get());
            }
        });
        tmp.addCounter("Asynchronous Overflow Task Failed Count", new Instrument<Long>(){

            @Override
            public void sample() {
                this.setValue(OverflowCounters.this.asynchronousOverflowTaskFailedCounter.get());
            }
        });
        tmp.addCounter("Asynchronous Overflow Task Cancelled Count", new Instrument<Long>(){

            @Override
            public void sample() {
                this.setValue(OverflowCounters.this.asynchronousOverflowTaskCancelledCounter.get());
            }
        });
        CounterSet tmp2 = tmp.makePath("Overflow Tasks");
        tmp2.addCounter("Build Count", new Instrument<Long>(){

            @Override
            public void sample() {
                this.setValue(OverflowCounters.this.indexPartitionBuildCounter.get());
            }
        });
        tmp2.addCounter("Merge Count", new Instrument<Long>(){

            @Override
            public void sample() {
                this.setValue(OverflowCounters.this.indexPartitionMergeCounter.get());
            }
        });
        tmp2.addCounter("Split Count", new Instrument<Long>(){

            @Override
            public void sample() {
                this.setValue(OverflowCounters.this.indexPartitionSplitCounter.get());
            }
        });
        tmp2.addCounter("Tail Split Count", new Instrument<Long>(){

            @Override
            public void sample() {
                this.setValue(OverflowCounters.this.indexPartitionTailSplitCounter.get());
            }
        });
        tmp2.addCounter("Join Count", new Instrument<Long>(){

            @Override
            public void sample() {
                this.setValue(OverflowCounters.this.indexPartitionJoinCounter.get());
            }
        });
        tmp2.addCounter("Move Count", new Instrument<Long>(){

            @Override
            public void sample() {
                this.setValue(OverflowCounters.this.indexPartitionMoveCounter.get());
            }
        });
        tmp2.addCounter("Receive Count", new Instrument<Long>(){

            @Override
            public void sample() {
                this.setValue(OverflowCounters.this.indexPartitionReceiveCounter.get());
            }
        });
        return tmp;
    }
}

