/*
 * Decompiled with CFR 0.152.
 */
package com.bigdata.resources;

import com.bigdata.btree.BTree;
import com.bigdata.btree.Checkpoint;
import com.bigdata.btree.IndexMetadata;
import com.bigdata.counters.CounterSet;
import com.bigdata.counters.ICounter;
import com.bigdata.journal.AbstractJournal;
import com.bigdata.journal.TimestampUtility;
import com.bigdata.mdi.IResourceMetadata;
import com.bigdata.mdi.LocalPartitionMetadata;
import com.bigdata.resources.AsynchronousOverflowTask;
import com.bigdata.resources.IndexManager;
import com.bigdata.resources.OverflowActionEnum;
import com.bigdata.resources.OverflowCounters;
import com.bigdata.resources.OverflowMetadata;
import com.bigdata.resources.ResourceManager;
import com.bigdata.resources.StoreManager;
import com.bigdata.resources.ViewMetadata;
import com.bigdata.service.AbstractFederation;
import com.bigdata.service.Event;
import com.bigdata.service.EventResource;
import com.bigdata.service.EventType;
import com.bigdata.service.IServiceShutdown;
import com.bigdata.util.DaemonThreadFactory;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.util.Iterator;
import java.util.Properties;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.log4j.Logger;

public abstract class OverflowManager
extends IndexManager {
    protected static final Logger log = Logger.getLogger(OverflowManager.class);
    protected final boolean compactingMergeWithAfterAction = true;
    protected final int copyIndexThreshold;
    protected final int accelerateSplitThreshold;
    protected final double percentOfSplitThreshold;
    protected final double percentOfJoinThreshold = 0.4;
    protected final double tailSplitThreshold;
    protected final boolean scatterSplitEnabled;
    protected final boolean joinsEnabled;
    protected final int minimumActiveIndexPartitions;
    protected final int maximumMoves;
    protected final int maximumMovesPerTarget;
    protected final double maximumMovePercentOfSplit;
    protected final double movePercentCpuTimeThreshold;
    protected final int maximumOptionalMergesPerOverflow;
    protected final int maximumJournalsPerView;
    protected final int maximumSegmentsPerView;
    protected final long maximumBuildSegmentBytes;
    private final long shutdownTimeout;
    private final ExecutorService overflowService;
    protected final int buildServiceCorePoolSize;
    protected final int mergeServiceCorePoolSize;
    protected final String serviceName;
    private final boolean overflowEnabled;
    private final int overflowMaxCount;
    protected final double overflowThreshold;
    protected final AtomicBoolean overflowAllowed = new AtomicBoolean(true);
    protected final AtomicBoolean asyncOverflowEnabled = new AtomicBoolean(true);
    public final AtomicBoolean forceOverflow = new AtomicBoolean(false);
    public final AtomicBoolean compactingMerge = new AtomicBoolean(false);
    protected final OverflowCounters overflowCounters = new OverflowCounters();
    protected final long overflowTimeout;
    protected final int overflowTasksConcurrent;
    protected final boolean overflowCancelledWhenJournalFull;
    public final long nominalShardSize;
    public final double shardOverextensionLimit = 2.0;

    public OverflowCounters getOverflowCounters() {
        return this.overflowCounters.clone();
    }

    public long getSynchronousOverflowCount() {
        return this.overflowCounters.synchronousOverflowCounter.get();
    }

    public long getAsynchronousOverflowCount() {
        return this.overflowCounters.asynchronousOverflowCounter.get();
    }

    @Override
    public boolean isOverflowEnabled() {
        return this.overflowEnabled && (this.overflowMaxCount == 0 || this.overflowCounters.synchronousOverflowCounter.get() < (long)this.overflowMaxCount);
    }

    public boolean isOverflowAllowed() {
        return this.overflowAllowed.get();
    }

    public OverflowManager(Properties properties) {
        super(properties);
        this.overflowEnabled = Boolean.parseBoolean(properties.getProperty(Options.OVERFLOW_ENABLED, "true"));
        if (log.isInfoEnabled()) {
            log.info(Options.OVERFLOW_ENABLED + "=" + this.overflowEnabled);
        }
        this.overflowMaxCount = Integer.parseInt(properties.getProperty(Options.OVERFLOW_MAX_COUNT, "0"));
        if (log.isInfoEnabled()) {
            log.info(Options.OVERFLOW_MAX_COUNT + "=" + this.overflowMaxCount);
        }
        this.overflowThreshold = Double.parseDouble(properties.getProperty(Options.OVERFLOW_THRESHOLD, ".9"));
        if (log.isInfoEnabled()) {
            log.info(Options.OVERFLOW_THRESHOLD + "=" + this.overflowThreshold);
        }
        this.overflowTimeout = Long.parseLong(properties.getProperty(Options.OVERFLOW_TIMEOUT, "600000"));
        if (log.isInfoEnabled()) {
            log.info(Options.OVERFLOW_TIMEOUT + "=" + this.overflowTimeout);
        }
        this.overflowTasksConcurrent = Integer.parseInt(properties.getProperty(Options.OVERFLOW_TASKS_CONCURRENT, "0"));
        if (log.isInfoEnabled()) {
            log.info(Options.OVERFLOW_TASKS_CONCURRENT + "=" + this.overflowTasksConcurrent);
        }
        if (this.overflowTasksConcurrent < 0) {
            throw new IllegalArgumentException(Options.OVERFLOW_TASKS_CONCURRENT + " : must be non-negative.");
        }
        this.overflowCancelledWhenJournalFull = Boolean.parseBoolean(properties.getProperty(Options.OVERFLOW_CANCELLED_WHEN_JOURNAL_FULL, "true"));
        if (log.isInfoEnabled()) {
            log.info(Options.OVERFLOW_CANCELLED_WHEN_JOURNAL_FULL + "=" + this.overflowCancelledWhenJournalFull);
        }
        this.copyIndexThreshold = Integer.parseInt(properties.getProperty(Options.COPY_INDEX_THRESHOLD, "1000"));
        if (log.isInfoEnabled()) {
            log.info(Options.COPY_INDEX_THRESHOLD + "=" + this.copyIndexThreshold);
        }
        if (this.copyIndexThreshold < 0) {
            throw new RuntimeException(Options.COPY_INDEX_THRESHOLD + " must be non-negative");
        }
        this.accelerateSplitThreshold = Integer.parseInt(properties.getProperty(Options.ACCELERATE_SPLIT_THRESHOLD, "20"));
        if (log.isInfoEnabled()) {
            log.info(Options.ACCELERATE_SPLIT_THRESHOLD + "=" + this.accelerateSplitThreshold);
        }
        if (this.accelerateSplitThreshold < 0) {
            throw new RuntimeException(Options.ACCELERATE_SPLIT_THRESHOLD + " must be non-negative");
        }
        this.percentOfSplitThreshold = Double.parseDouble(properties.getProperty(Options.PERCENT_OF_SPLIT_THRESHOLD, ".9"));
        if (log.isInfoEnabled()) {
            log.info(Options.PERCENT_OF_SPLIT_THRESHOLD + "=" + this.percentOfSplitThreshold);
        }
        if (this.percentOfSplitThreshold < 0.0 || this.percentOfSplitThreshold > 2.0) {
            throw new RuntimeException(Options.PERCENT_OF_SPLIT_THRESHOLD + " must be in [0:2]");
        }
        this.tailSplitThreshold = Double.parseDouble(properties.getProperty(Options.TAIL_SPLIT_THRESHOLD, ".4"));
        if (log.isInfoEnabled()) {
            log.info(Options.TAIL_SPLIT_THRESHOLD + "=" + this.tailSplitThreshold);
        }
        if (this.tailSplitThreshold < 0.0 || this.tailSplitThreshold > 1.0) {
            throw new RuntimeException(Options.TAIL_SPLIT_THRESHOLD + " must be in [0:1]");
        }
        this.scatterSplitEnabled = Boolean.parseBoolean(properties.getProperty(Options.SCATTER_SPLIT_ENABLED, "true"));
        if (log.isInfoEnabled()) {
            log.info(Options.SCATTER_SPLIT_ENABLED + "=" + this.scatterSplitEnabled);
        }
        this.joinsEnabled = Boolean.parseBoolean(properties.getProperty(Options.JOINS_ENABLED, "false"));
        if (log.isInfoEnabled()) {
            log.info(Options.JOINS_ENABLED + "=" + this.joinsEnabled);
        }
        this.minimumActiveIndexPartitions = Integer.parseInt(properties.getProperty(Options.MINIMUM_ACTIVE_INDEX_PARTITIONS, "1"));
        if (log.isInfoEnabled()) {
            log.info(Options.MINIMUM_ACTIVE_INDEX_PARTITIONS + "=" + this.minimumActiveIndexPartitions);
        }
        if (this.minimumActiveIndexPartitions <= 0) {
            throw new RuntimeException(Options.MINIMUM_ACTIVE_INDEX_PARTITIONS + " must be positive");
        }
        this.maximumMoves = Integer.parseInt(properties.getProperty(Options.MAXIMUM_MOVES, "3"));
        if (log.isInfoEnabled()) {
            log.info(Options.MAXIMUM_MOVES + "=" + this.maximumMoves);
        }
        if (this.maximumMoves < 0) {
            throw new RuntimeException(Options.MAXIMUM_MOVES + " must be non-negative");
        }
        this.maximumMovesPerTarget = Integer.parseInt(properties.getProperty(Options.MAXIMUM_MOVES_PER_TARGET, "2"));
        if (log.isInfoEnabled()) {
            log.info(Options.MAXIMUM_MOVES_PER_TARGET + "=" + this.maximumMovesPerTarget);
        }
        if (this.maximumMovesPerTarget < 0) {
            throw new RuntimeException(Options.MAXIMUM_MOVES_PER_TARGET + " must be non-negative");
        }
        if (this.maximumMovesPerTarget > this.maximumMoves) {
            throw new RuntimeException(Options.MAXIMUM_MOVES_PER_TARGET + " must be less than " + Options.MAXIMUM_MOVES);
        }
        this.maximumMovePercentOfSplit = Double.parseDouble(properties.getProperty(Options.MAXIMUM_MOVE_PERCENT_OF_SPLIT, ".8"));
        if (log.isInfoEnabled()) {
            log.info(Options.MAXIMUM_MOVE_PERCENT_OF_SPLIT + "=" + this.maximumMovePercentOfSplit);
        }
        if (this.maximumMovePercentOfSplit < 0.0 || this.maximumMovePercentOfSplit > 2.0) {
            throw new RuntimeException(Options.MAXIMUM_MOVE_PERCENT_OF_SPLIT + " must be in [0:2]");
        }
        this.movePercentCpuTimeThreshold = Double.parseDouble(properties.getProperty(Options.MOVE_PERCENT_CPU_TIME_THRESHOLD, ".7"));
        if (log.isInfoEnabled()) {
            log.info(Options.MOVE_PERCENT_CPU_TIME_THRESHOLD + "=" + this.movePercentCpuTimeThreshold);
        }
        if (this.movePercentCpuTimeThreshold < 0.0 || this.movePercentCpuTimeThreshold > 1.0) {
            throw new RuntimeException(Options.MOVE_PERCENT_CPU_TIME_THRESHOLD + " must be in [0.0:1.0] ");
        }
        this.maximumOptionalMergesPerOverflow = Integer.parseInt(properties.getProperty(Options.MAXIMUM_OPTIONAL_MERGES_PER_OVERFLOW, "2"));
        if (log.isInfoEnabled()) {
            log.info(Options.MAXIMUM_OPTIONAL_MERGES_PER_OVERFLOW + "=" + this.maximumOptionalMergesPerOverflow);
        }
        if (this.maximumOptionalMergesPerOverflow < 0) {
            throw new RuntimeException(Options.MAXIMUM_OPTIONAL_MERGES_PER_OVERFLOW + " must be non-negative");
        }
        this.maximumJournalsPerView = Integer.parseInt(properties.getProperty(Options.MAXIMUM_JOURNALS_PER_VIEW, "3"));
        if (log.isInfoEnabled()) {
            log.info(Options.MAXIMUM_JOURNALS_PER_VIEW + "=" + this.maximumJournalsPerView);
        }
        if (this.maximumJournalsPerView < 2) {
            throw new RuntimeException(Options.MAXIMUM_JOURNALS_PER_VIEW + " must be GTE 2");
        }
        this.maximumSegmentsPerView = Integer.parseInt(properties.getProperty(Options.MAXIMUM_SEGMENTS_PER_VIEW, "6"));
        if (log.isInfoEnabled()) {
            log.info(Options.MAXIMUM_SEGMENTS_PER_VIEW + "=" + this.maximumSegmentsPerView);
        }
        if (this.maximumSegmentsPerView < 1) {
            throw new RuntimeException(Options.MAXIMUM_SEGMENTS_PER_VIEW + " must be GTE 1");
        }
        this.maximumBuildSegmentBytes = Long.parseLong(properties.getProperty(Options.MAXIMUM_BUILD_SEGMENT_BYTES, "20971520"));
        if (this.maximumBuildSegmentBytes < 0L) {
            throw new RuntimeException("The '" + Options.SHUTDOWN_TIMEOUT + "' must be non-negative.");
        }
        if (log.isInfoEnabled()) {
            log.info(Options.MAXIMUM_BUILD_SEGMENT_BYTES + "=" + this.maximumBuildSegmentBytes);
        }
        this.shutdownTimeout = Long.parseLong(properties.getProperty(Options.SHUTDOWN_TIMEOUT, "0"));
        if (this.shutdownTimeout < 0L) {
            throw new RuntimeException("The '" + Options.SHUTDOWN_TIMEOUT + "' must be non-negative.");
        }
        if (log.isInfoEnabled()) {
            log.info(Options.SHUTDOWN_TIMEOUT + "=" + this.shutdownTimeout);
        }
        this.nominalShardSize = Long.parseLong(properties.getProperty(Options.NOMINAL_SHARD_SIZE, "209715200"));
        long minShardSize = 1024L;
        if (this.nominalShardSize < 1024L) {
            throw new RuntimeException("The '" + Options.NOMINAL_SHARD_SIZE + "' must be GTE " + 1024L);
        }
        if (log.isInfoEnabled()) {
            log.info(Options.NOMINAL_SHARD_SIZE + "=" + this.nominalShardSize);
        }
        String serviceName = null;
        try {
            serviceName = this.getDataService().getServiceName();
        }
        catch (UnsupportedOperationException ex) {
        }
        catch (Throwable t) {
            log.warn(t.getMessage(), t);
        }
        this.serviceName = serviceName;
        if (this.overflowEnabled) {
            this.overflowService = Executors.newFixedThreadPool(1, new DaemonThreadFactory((this.serviceName == null ? "" : this.serviceName + "-") + "overflowService"));
            ((ThreadPoolExecutor)this.overflowService).prestartCoreThread();
            this.buildServiceCorePoolSize = Integer.parseInt(properties.getProperty(Options.BUILD_SERVICE_CORE_POOL_SIZE, "3"));
            if (log.isInfoEnabled()) {
                log.info(Options.BUILD_SERVICE_CORE_POOL_SIZE + "=" + this.buildServiceCorePoolSize);
            }
            this.mergeServiceCorePoolSize = Integer.parseInt(properties.getProperty(Options.MERGE_SERVICE_CORE_POOL_SIZE, "1"));
            if (log.isInfoEnabled()) {
                log.info(Options.MERGE_SERVICE_CORE_POOL_SIZE + "=" + this.mergeServiceCorePoolSize);
            }
        } else {
            this.overflowService = null;
            this.buildServiceCorePoolSize = 0;
            this.mergeServiceCorePoolSize = 0;
        }
    }

    @Override
    public synchronized void shutdown() {
        if (!this.isOpen()) {
            return;
        }
        long begin = System.currentTimeMillis();
        if (log.isInfoEnabled()) {
            log.info("Begin");
        }
        if (this.overflowService != null) {
            this.overflowService.shutdownNow();
        }
        super.shutdown();
        long elapsed = System.currentTimeMillis() - begin;
        if (log.isInfoEnabled()) {
            log.info("Done: elapsed=" + elapsed + "ms");
        }
    }

    @Override
    public synchronized void shutdownNow() {
        if (!this.isOpen()) {
            return;
        }
        long begin = System.currentTimeMillis();
        if (log.isInfoEnabled()) {
            log.info("Begin");
        }
        if (this.overflowService != null) {
            this.overflowService.shutdownNow();
        }
        super.shutdownNow();
        if (log.isInfoEnabled()) {
            long elapsed = System.currentTimeMillis() - begin;
            log.info("Done: elapsed=" + elapsed + "ms");
        }
    }

    @Override
    public boolean shouldOverflow() {
        if (this.forceOverflow.get()) {
            if (log.isInfoEnabled()) {
                log.info("Forcing overflow.");
            }
            return true;
        }
        if (this.isTransient()) {
            if (log.isDebugEnabled()) {
                log.debug("Overflow processing not allowed for transient journals");
            }
            return false;
        }
        if (!this.isOverflowEnabled()) {
            if (log.isDebugEnabled()) {
                log.debug("Overflow processing is disabled");
            }
            return false;
        }
        if (!this.overflowAllowed.get()) {
            if (log.isInfoEnabled()) {
                log.info("Asynchronous overflow still active");
            }
            return false;
        }
        StoreManager.ManagedJournal journal = this.getLiveJournal();
        long nextOffset = journal.getRootBlockView().getNextOffset();
        boolean shouldOverflow = (double)nextOffset > this.overflowThreshold * (double)journal.getMaximumExtent();
        if (!shouldOverflow && log.isDebugEnabled()) {
            log.debug("should not overflow: nextOffset=" + nextOffset + ", maximumExtent=" + journal.getMaximumExtent());
        } else if (shouldOverflow && log.isInfoEnabled()) {
            log.debug("shouldOverflow: nextOffset=" + nextOffset + ", maximumExtent=" + journal.getMaximumExtent());
        }
        return shouldOverflow;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Future<Object> overflow() {
        boolean forceOverflow = this.forceOverflow.getAndSet(false);
        Event e = new Event(this.getFederation(), new EventResource(), (Object)EventType.SynchronousOverflow).addDetail("synchronousOverflowCounter", this.overflowCounters.synchronousOverflowCounter.get()).start();
        try {
            OverflowMetadata overflowMetadata = this.doSynchronousOverflow();
            if (this.asyncOverflowEnabled.get()) {
                if (forceOverflow || overflowMetadata.postProcess) {
                    if (log.isInfoEnabled()) {
                        log.info("Will start asynchronous overflow processing.");
                    }
                    if (!this.overflowAllowed.compareAndSet(true, false)) {
                        throw new AssertionError();
                    }
                    Future<Object> future = this.overflowService.submit(new AsynchronousOverflowTask((ResourceManager)this, overflowMetadata));
                    return future;
                }
                if (log.isInfoEnabled()) {
                    log.info("Asynchronous overflow not required");
                }
                this.overflowCounters.asynchronousOverflowCounter.incrementAndGet();
                Future<Object> future = null;
                return future;
            }
            log.warn("Asynchronous overflow processing is disabled!");
            this.overflowCounters.asynchronousOverflowCounter.incrementAndGet();
            Future<Object> future = null;
            return future;
        }
        finally {
            e.end();
            this.overflowCounters.synchronousOverflowMillis.addAndGet(e.getElapsed());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected OverflowMetadata doSynchronousOverflow() {
        long firstCommitTime;
        OverflowMetadata overflowMetadata;
        StoreManager.ManagedJournal newJournal;
        block17: {
            File file;
            long createTime;
            if (log.isInfoEnabled()) {
                log.info("begin");
            }
            long closeTime = createTime = this.nextTimestamp();
            StoreManager.ManagedJournal oldJournal = this.getLiveJournal();
            try {
                file = File.createTempFile("journal", ".jnl", this.journalsDir).getCanonicalFile();
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
            Properties p = this.getProperties();
            p.setProperty(Options.FILE, file.toString());
            p.setProperty(Options.CREATE_TIME, Long.toString(createTime));
            newJournal = new StoreManager.ManagedJournal(this, p);
            assert (createTime == newJournal.getRootBlockView().getCreateTime());
            overflowMetadata = new OverflowMetadata((ResourceManager)this);
            try {
                this.propagateIndexDecls(oldJournal, newJournal, overflowMetadata);
                firstCommitTime = newJournal.commit();
            }
            catch (Throwable t) {
                newJournal.destroy();
                throw new RuntimeException(t);
            }
            this.addResource(newJournal.getResourceMetadata(), newJournal.getFile());
            this.storeCache.put(newJournal.getRootBlockView().getUUID(), newJournal);
            this.liveJournalRef.set(newJournal);
            this.bytesUnderManagement.addAndGet(oldJournal.getBufferStrategy().getExtent());
            this.bytesUnderManagement.addAndGet(-newJournal.getBufferStrategy().getExtent());
            this.journalBytesUnderManagement.addAndGet(oldJournal.getBufferStrategy().getExtent());
            this.journalBytesUnderManagement.addAndGet(-newJournal.getBufferStrategy().getExtent());
            this.lastOverflowTime = oldJournal.getRootBlockView().getLastCommitTime();
            if (log.isInfoEnabled()) {
                log.info("New live journal: " + newJournal.getFile());
            }
            oldJournal.closeForWrites(closeTime);
            if (log.isInfoEnabled()) {
                log.info("Closed old journal against further writes.");
            }
            if (this.maximumJournalSizeAtOverflow < oldJournal.size()) {
                this.maximumJournalSizeAtOverflow = oldJournal.getBufferStrategy().getExtent();
            }
            try {
                CounterSet tmp;
                CounterSet serviceRoot = this.getFederation().getServiceCounterSet();
                if (serviceRoot == null || (tmp = (CounterSet)serviceRoot.getPath("Resource Manager")) == null) break block17;
                CounterSet counterSet = tmp;
                synchronized (counterSet) {
                    ((CounterSet)tmp.getPath("Live Journal")).attach(this.getLiveJournal().getCounters(), true);
                    log.warn("Re-attached live journal counters: path=" + tmp.getPath());
                }
            }
            catch (Throwable t) {
                log.warn("Problem updating counters: " + t, t);
            }
        }
        this.overflowCounters.synchronousOverflowCounter.incrementAndGet();
        if (log.isInfoEnabled()) {
            log.info("\ndoOverflow(): firstCommitTime=" + firstCommitTime + "\nfile=" + newJournal.getFile() + "\npost-condition views: synchronousOverflowCounter=" + this.getSynchronousOverflowCount() + "\n" + this.listIndexPartitions(TimestampUtility.asHistoricalRead(firstCommitTime)));
        }
        try {
            this.purgeOldResources();
        }
        catch (Throwable t) {
            log.error("Problem purging old resources? service=" + this.getFederation().getServiceName(), t);
        }
        return overflowMetadata;
    }

    private void propagateIndexDecls(AbstractJournal oldJournal, AbstractJournal newJournal, OverflowMetadata overflowMetadata) {
        int numIndices = overflowMetadata.getIndexCount();
        int numIndicesProcessed = 0;
        int numIndicesViewRedefined = 0;
        int numIndicesNonZeroCopy = 0;
        int ncopy = 0;
        int maxNonZeroCopy = 100;
        long lastCommitTime = oldJournal.getRootBlockView().getLastCommitTime();
        if (log.isInfoEnabled()) {
            log.info("doOverflow(): lastCommitTime=" + lastCommitTime + "\nfile=" + oldJournal.getFile() + "\npre-condition views: synchronousOverflowCounter=" + this.getSynchronousOverflowCount() + "\n" + this.listIndexPartitions(TimestampUtility.asHistoricalRead(lastCommitTime)));
        }
        Iterator<ViewMetadata> itr = overflowMetadata.views();
        while (itr.hasNext()) {
            IResourceMetadata[] newResources;
            IResourceMetadata[] oldResources;
            boolean copyIndex;
            ViewMetadata bm = itr.next();
            BTree oldBTree = bm.getBTree();
            IndexMetadata indexMetadata = oldBTree.getIndexMetadata().clone();
            LocalPartitionMetadata oldpmd = indexMetadata.getPartitionMetadata();
            if (oldpmd == null) {
                throw new RuntimeException("Not a partitioned index: " + bm.name);
            }
            boolean hasOverflowHandler = indexMetadata.getOverflowHandler() != null;
            long entryCount = bm.entryCount;
            boolean bl = copyIndex = entryCount == 0L || this.copyIndexThreshold > 0 && entryCount <= (long)this.copyIndexThreshold && numIndicesNonZeroCopy < 100 && !hasOverflowHandler && !bm.mandatoryMerge;
            if (copyIndex) {
                oldResources = oldpmd.getResources();
                newResources = new IResourceMetadata[oldResources.length];
                System.arraycopy(oldResources, 0, newResources, 0, oldResources.length);
                newResources[0] = newJournal.getResourceMetadata();
                indexMetadata.setPartitionMetadata(new LocalPartitionMetadata(oldpmd.getPartitionId(), oldpmd.getSourcePartitionId(), oldpmd.getLeftSeparatorKey(), oldpmd.getRightSeparatorKey(), newResources, oldpmd.getIndexPartitionCause()));
            } else {
                oldResources = oldpmd.getResources();
                newResources = new IResourceMetadata[oldResources.length + 1];
                System.arraycopy(oldResources, 0, newResources, 1, oldResources.length);
                newResources[0] = newJournal.getResourceMetadata();
                indexMetadata.setPartitionMetadata(new LocalPartitionMetadata(oldpmd.getPartitionId(), oldpmd.getSourcePartitionId(), oldpmd.getLeftSeparatorKey(), oldpmd.getRightSeparatorKey(), newResources, oldpmd.getIndexPartitionCause()));
            }
            indexMetadata.write(newJournal);
            long oldCounter = oldBTree.getCounter().get();
            if (log.isInfoEnabled()) {
                log.info("Re-defining view on new journal: name=" + bm.name + ", copyIndex=" + copyIndex + ", entryCount=" + entryCount + ", counter=" + oldCounter + ", partitionId=" + oldpmd.getPartitionId() + ", checkpoint=" + oldBTree.getCheckpoint());
            }
            Checkpoint overflowCheckpoint = indexMetadata.overflowCheckpoint(oldBTree.getCheckpoint());
            overflowCheckpoint.write(newJournal);
            BTree newBTree = BTree.load(newJournal, overflowCheckpoint.getCheckpointAddr(), false);
            long newCounter = newBTree.getCounter().get();
            assert (newCounter == oldCounter) : "expected oldCounter=" + oldCounter + ", but found newCounter=" + newCounter;
            if (copyIndex) {
                if (log.isDebugEnabled()) {
                    log.debug("Copying data to new journal: name=" + bm.name + ", entryCount=" + entryCount + ", threshold=" + this.copyIndexThreshold);
                }
                newBTree.rangeCopy(oldBTree, null, null, true);
                overflowMetadata.setAction(bm.name, OverflowActionEnum.Copy);
                ++ncopy;
                if (entryCount > 0L) {
                    ++numIndicesNonZeroCopy;
                }
            } else {
                ++numIndicesViewRedefined;
            }
            newJournal.registerIndex(bm.name, newBTree);
            ++numIndicesProcessed;
        }
        if (log.isInfoEnabled()) {
            log.info("Processed indices: #indices=" + numIndices + ", ncopy=" + ncopy + ", ncopyNonZero=" + numIndicesNonZeroCopy + ", #viewRedefined=" + numIndicesViewRedefined);
        }
        assert (numIndices == numIndicesProcessed);
        assert (numIndices == ncopy + numIndicesViewRedefined);
        assert (ncopy == overflowMetadata.getActionCount(OverflowActionEnum.Copy));
        overflowMetadata.postProcess = numIndicesViewRedefined > 0;
    }

    ResourceScores getResourceScores() {
        return new ResourceScores(this);
    }

    protected double getHostCounter(String path, double defaultValue) {
        AbstractFederation fed = (AbstractFederation)this.getFederation();
        CounterSet hostRoot = fed.getHostCounterSet();
        if (hostRoot == null) {
            log.warn("Host counters not available?");
            return defaultValue;
        }
        ICounter c = (ICounter)hostRoot.getPath(path);
        if (c != null) {
            return ((Number)c.getInstrument().getValue()).doubleValue();
        }
        log.warn("Host counter not found? " + path);
        return defaultValue;
    }

    protected double getServiceCounter(String path, double defaultValue) {
        AbstractFederation fed = (AbstractFederation)this.getFederation();
        CounterSet serviceRoot = fed.getServiceCounterSet();
        if (serviceRoot == null) {
            log.warn("Service counters not available?");
            return defaultValue;
        }
        ICounter c = (ICounter)serviceRoot.getPath(path);
        if (c != null) {
            return ((Number)c.getInstrument().getValue()).doubleValue();
        }
        log.warn("Service counter not found? " + path);
        return defaultValue;
    }

    public static class ResourceScores
    implements Serializable {
        private static final long serialVersionUID = 3920425368315911158L;
        final double percentCPUTime;
        final double majorPageFaultsPerSec;
        final double dataDirBytesFree;
        final double tmpDirBytesFree;

        ResourceScores(OverflowManager overflowManager) {
            this.percentCPUTime = overflowManager.getHostCounter("CPU/% Processor Time", 0.5);
            this.majorPageFaultsPerSec = overflowManager.getHostCounter("Memory/Major Page Faults Per Second", 0.0);
            this.dataDirBytesFree = overflowManager.getServiceCounter("Resource Manager/Store Manager/Data Volume Bytes Available", 2.147483648E10);
            this.tmpDirBytesFree = overflowManager.getServiceCounter("Resource Manager/Store Manager/Temp Volume Bytes Available", 1.073741824E10);
        }
    }

    public static interface IIndexPartitionTaskCounters {
        public static final String BuildCount = "Build Count";
        public static final String MergeCount = "Merge Count";
        public static final String SplitCount = "Split Count";
        public static final String TailSplitCount = "Tail Split Count";
        public static final String JoinCount = "Join Count";
        public static final String MoveCount = "Move Count";
        public static final String ReceiveCount = "Receive Count";
        public static final String ConcurrentBuildCount = "Concurrent Build Count";
        public static final String ConcurrentMergeCount = "Concurrent Merge Count";
        public static final String RunningBuilds = "Active Builds";
    }

    public static interface IOverflowManagerCounters {
        public static final String OverflowEnabled = "Overflow Enabled";
        public static final String OverflowAllowed = "Overflow Allowed";
        public static final String ShouldOverflow = "Should Overflow";
        public static final String SynchronousOverflowCount = "Synchronous Overflow Count";
        public static final String SynchronousOverflowMillis = "Synchronous Overflow Millis";
        public static final String AsynchronousOverflowMillis = "Asynchronous Overflow Millis";
        public static final String AsynchronousOverflowCount = "Asynchronous Overflow Count";
        public static final String AsynchronousOverflowFailedCount = "Asynchronous Overflow Failed Count";
        public static final String AsynchronousOverflowTaskFailedCount = "Asynchronous Overflow Task Failed Count";
        public static final String AsynchronousOverflowTaskCancelledCount = "Asynchronous Overflow Task Cancelled Count";
    }

    public static interface Options
    extends IndexManager.Options,
    IServiceShutdown.Options {
        public static final String OVERFLOW_ENABLED = OverflowManager.class.getName() + ".overflowEnabled";
        public static final String DEFAULT_OVERFLOW_ENABLED = "true";
        public static final String OVERFLOW_MAX_COUNT = OverflowManager.class.getName() + ".overflowMaxCount";
        public static final String DEFAULT_OVERFLOW_MAX_COUNT = "0";
        public static final String OVERFLOW_THRESHOLD = OverflowManager.class.getName() + ".overflowThreshold";
        public static final String DEFAULT_OVERFLOW_THRESHOLD = ".9";
        public static final String COPY_INDEX_THRESHOLD = OverflowManager.class.getName() + ".copyIndexThreshold";
        public static final String DEFAULT_COPY_INDEX_THRESHOLD = "1000";
        public static final String ACCELERATE_SPLIT_THRESHOLD = OverflowManager.class.getName() + ".accelerateSplitThreshold";
        public static final String DEFAULT_ACCELERATE_SPLIT_THRESHOLD = "20";
        public static final String PERCENT_OF_SPLIT_THRESHOLD = OverflowManager.class.getName() + ".percentOfSplitThreshold";
        public static final String DEFAULT_PERCENT_OF_SPLIT_THRESHOLD = ".9";
        public static final String TAIL_SPLIT_THRESHOLD = OverflowManager.class.getName() + ".tailSplitThreshold";
        public static final String DEFAULT_TAIL_SPLIT_THRESHOLD = ".4";
        public static final String HOT_SPLIT_THRESHOLD = OverflowManager.class.getName() + ".hotSplitThreshold";
        public static final String DEFAULT_HOT_SPLIT_THRESHOLD = "2.0";
        public static final String SCATTER_SPLIT_ENABLED = OverflowManager.class.getName() + ".scatterSplitEnabled";
        public static final String DEFAULT_SCATTER_SPLIT_ENABLED = "true";
        public static final String JOINS_ENABLED = OverflowManager.class.getName() + ".joinsEnabled";
        public static final String DEFAULT_JOINS_ENABLED = "false";
        public static final String MINIMUM_ACTIVE_INDEX_PARTITIONS = OverflowManager.class.getName() + ".minimumActiveIndexPartitions";
        public static final String DEFAULT_MINIMUM_ACTIVE_INDEX_PARTITIONS = "1";
        public static final String MAXIMUM_MOVES = OverflowManager.class.getName() + ".maximumMoves";
        public static final String DEFAULT_MAXIMUM_MOVES = "3";
        public static final String MAXIMUM_MOVES_PER_TARGET = OverflowManager.class.getName() + ".maximumMovesPerTarget";
        public static final String DEFAULT_MAXIMUM_MOVES_PER_TARGET = "2";
        public static final String MAXIMUM_MOVE_PERCENT_OF_SPLIT = OverflowManager.class.getName() + ".maximumMovePercentOfSplit";
        public static final String DEFAULT_MAXIMUM_MOVE_PERCENT_OF_SPLIT = ".8";
        public static final String MOVE_PERCENT_CPU_TIME_THRESHOLD = OverflowManager.class.getName() + ".movePercentCpuTimeThreshold";
        public static final String DEFAULT_MOVE_PERCENT_CPU_TIME_THRESHOLD = ".7";
        public static final String MAXIMUM_OPTIONAL_MERGES_PER_OVERFLOW = OverflowManager.class.getName() + ".maximumOptionalMergesPerOverflow";
        public static final String DEFAULT_OPTIONAL_COMPACTING_MERGES_PER_OVERFLOW = "2";
        public static final String MAXIMUM_JOURNALS_PER_VIEW = OverflowManager.class.getName() + ".maximumJournalsPerView";
        public static final String DEFAULT_MAXIMUM_JOURNALS_PER_VIEW = "3";
        public static final String MAXIMUM_SEGMENTS_PER_VIEW = OverflowManager.class.getName() + ".maximumSegmentsPerView";
        public static final String DEFAULT_MAXIMUM_SEGMENTS_PER_VIEW = "6";
        public static final String MAXIMUM_BUILD_SEGMENT_BYTES = OverflowManager.class.getName() + ".maximumBuildSegmentsBytes";
        public static final String DEFAULT_MAXIMUM_BUILD_SEGMENTS_BYTES = "20971520";
        public static final String OVERFLOW_TIMEOUT = OverflowManager.class.getName() + ".timeout";
        public static final String DEFAULT_OVERFLOW_TIMEOUT = "600000";
        public static final String OVERFLOW_TASKS_CONCURRENT = OverflowManager.class.getName() + ".overflowTasksConcurrent";
        public static final String DEFAULT_OVERFLOW_TASKS_CONCURRENT = "0";
        public static final String OVERFLOW_CANCELLED_WHEN_JOURNAL_FULL = OverflowManager.class.getName() + ".overflowCancelledWhenJournalFull";
        public static final String DEFAULT_OVERFLOW_CANCELLED_WHEN_JOURNAL_FULL = "true";
        public static final String BUILD_SERVICE_CORE_POOL_SIZE = OverflowManager.class.getName() + ".buildService.corePoolSize";
        public static final String DEFAULT_BUILD_SERVICE_CORE_POOL_SIZE = "3";
        public static final String MERGE_SERVICE_CORE_POOL_SIZE = OverflowManager.class.getName() + ".mergeService.corePoolSize";
        public static final String DEFAULT_MERGE_SERVICE_CORE_POOL_SIZE = "1";
        public static final String NOMINAL_SHARD_SIZE = OverflowManager.class.getName() + ".nominalShardSize";
        public static final String DEFAULT_NOMINAL_SHARD_SIZE = "209715200";
    }
}

