/*
 * Decompiled with CFR 0.152.
 */
package com.bigdata.resources;

import com.bigdata.journal.BufferMode;
import com.bigdata.journal.TimestampUtility;
import java.text.NumberFormat;
import org.apache.log4j.Logger;

public class ResourceEvents {
    private static final Logger log = Logger.getLogger(ResourceEvents.class);
    static NumberFormat cf = NumberFormat.getNumberInstance();
    static NumberFormat fpf;
    static NumberFormat leadingZeros;

    public static void openUnisolatedIndex(String name) {
        if (log.isInfoEnabled()) {
            log.info("name=" + name);
        }
    }

    public static void closeUnisolatedIndex(String name) {
        if (log.isInfoEnabled()) {
            log.info("name=" + name);
        }
    }

    public static void dropUnisolatedIndex(String name) {
        if (log.isInfoEnabled()) {
            log.info("name=" + name);
        }
    }

    public static void openTx(long startTime) {
        if (log.isInfoEnabled()) {
            log.info(TimestampUtility.toString(startTime));
        }
    }

    public static void closeTx(long tx, long revisionTime, boolean aborted) {
        if (log.isInfoEnabled()) {
            log.info("tx=" + tx + ", revisionTime=" + revisionTime + ", aborted=" + aborted + ", elapsed=" + (revisionTime - tx));
        }
    }

    public static void isolateIndex(long startTime, String name) {
        if (log.isInfoEnabled()) {
            log.info("tx=" + startTime + ", name=" + name);
        }
    }

    public static void openJournal(String filename, long nbytes, BufferMode bufferMode) {
        if (log.isInfoEnabled()) {
            log.info("filename=" + filename + ", #bytes=" + nbytes + ", mode=" + (Object)((Object)bufferMode));
        }
    }

    public static void extendJournal(String filename, long nbytes) {
        if (log.isInfoEnabled()) {
            log.info("filename=" + filename + ", #bytes=" + nbytes);
        }
    }

    public static void closeJournal(String filename) {
        if (log.isInfoEnabled()) {
            log.info("filename=" + filename);
        }
    }

    public static void deleteJournal(String filename) {
        if (log.isInfoEnabled()) {
            log.info("filename=" + filename);
        }
    }

    static {
        cf.setGroupingUsed(true);
        fpf = NumberFormat.getNumberInstance();
        fpf.setGroupingUsed(false);
        fpf.setMaximumFractionDigits(2);
        leadingZeros = NumberFormat.getIntegerInstance();
        leadingZeros.setMinimumIntegerDigits(10);
        leadingZeros.setGroupingUsed(false);
    }
}

